---
title: Cicero’s Method - How to Write
---

In 44 BC, in the midst of the Great Roman Civil War, a writer named Cicero set to write what would become one of the most influential books in human history. He wrote this book in only 4 weeks, and would be assassinated by his enemies just a few months later.

This book, named “[On Duties](https://www.amazon.com/Cicero-Cambridge-History-Political-Thought/dp/0521348358/)” (_latin: de officiis_) was about the responsibilities citizens have in a society. The reasons for this books importance are varied but it’s not an exaggeration to say that it was the intellectual underwriting for the renaissance and the aspirational blueprint for the founding fathers of America (as it was known as a primary influence of humanist philosophers).

What was the trick that Cicero used to write so powerfully and influentially? Was it his intelligence and insight? Well… yes, but not in the way you think. See, Cicero might be one of the first research based writers. Most of Cicero’s ideas are simply latin articulations of ideas from ancient Greek philosophers like Aristotle, or the stoics.

> No one will ever write anything more wise -- Voltaire (about De Officiis)

Cicero established that research is the most important component in writing. Because interesting and new information is what makes writing valuable. And the goal of any good writing is to be valuable to your reader.

So how do you write well in 2020? Cicero’s research based approach works just as well today as it did back then. Here’s a few tips

## Cicero’s Method

### 60% of the time on the outline

The best writing changes the reader’s perspective of the world. It is not writing for writing sake or about demonstrating your knowledge about a subject. (this is the opposite of what is taught in school- but teacher’s only read your writing because they are paid to and care little about getting value from the writing of their students)

To change people’s perspectives you need to bring them new arguments or information, and you need to articulate it well. You do this solely through the outline you write BEFORE you write anything else. That’s why it’s safe to say that a majority of your time writing should actually be spent writing (and doing the research for) the outline.

### Start With Your Readers Problem

Your readers are looking to understand something better. They are looking for insights or context to build their understanding. Thats why its best to start articles directly or indirectly with a summary of the problem your target reader is facing.

You might lead with a story or anecdote but first, tie this back to the problem or issue that you will address later with solutions (or tips)

### Don't try a "be original".. _i.e. copy_

Aspire to bring original value, not original writing. Do this by articulating the ideas of others in new ways or formats. Don't waste time trying to invent new words or phrases.

Did you know that the Declaration of Independence wasn’t original? The [Virginia Declaration of Rights](https://en.wikipedia.org/wiki/Virginia_Declaration_of_Rights) uses much of the same language and was published only a few days before Thomas Jefferson began writing it.

So go ahead and emulate someone else. If one of the most celebrated documents in history is copied, then you don’t need to worry about it.

### 3 Non-Typical and Concrete Details

The difference between a well written blog post and a bad one, can usually be defined by the amount of concrete details mentioned in it. Ever tried Googling something and gotten a ton of low quality answers, seemingly with little to no insight? Well, writers on content farms are typically paid by the article, what they do is step 1. Google the subject 2. Regurgitate the information they find into an article. That’s why most articles are useless. It’s just the same information written and rewritten.

So I recommend you find at least 3 concrete details to add to any article you write. If you do that, you’ll have a good chance of adding something interesting that people haven’t heard before.

### Template

If you've gotten this far, I've included a link the outline I used to write this very article. You can find it here: [blog writing outline example](https://docs.google.com/document/d/1liAPiot_KVxnIOdonjzC6_vLa_uKG8qWw8k7v7oK2FQ/edit).

### Summary

![](https://fiction-com.s3.us-west-1.amazonaws.com/5df9364a982d4c002c6b4bb9.jpeg)

If you’d like to write better you should focus on your research and outline process; not the writing itself.

Some tools to help you with that are:

1. Spend 60% of the time writing on the outline. This will help you be interesting and communicate.
1. Start with a conversation around the problem of your readers. All good writing exists to solve a problem of some kind.
1. Avoid the desire to be completely “original.” There is no such thing as original writing, so to write well emulate someone else and endeavor to articulate ideas in new ways rather than write differently.
1. Find at least 3 non-typical and concrete examples. Bringing new details will make the writing more interesting and ensure readers are likely to walk away with new information if nothing else",
