---
title: Custom Blog Example
description: If you want to create a custom Factor blog, this is the example for you.
---

# Custom Blog Example

If you want to create a custom blog using Factor, then this example is for you. In this repo, we've created a custom blog and set a few basic settings in Factor to get a completely unique result.

![Screenshot](./screenshot-wide.jpg)

## Demo

Here is a [live demo of the project](https://factor-example-blog.herokuapp.com/)

## Code

You can find the [code for this project on Github](https://github.com/fiction-com/factor-example-blog).

## Features

- A fully functional, dynamic blog that can be managed on the dashboard
- Custom layout and design
- Basic lint/typescript setup
- Bonus: Dutch translation added of English text in plugin ([localization](https://factor.dev/docs/localization))

## Techniques Used

- Setting custom CSS variables. Learn about [styles](https://factor.dev/docs/styles) and [standard CSS variables](https://factor.dev/docs/css-variables).
- Adding custom routes via the index.ts [main file](https://factor.dev/docs/main-files)
- Importing the blog components directly into the route components for easy customization (single, index)
- Overriding components from the [blog plugin](https://factor.dev/plugin/standard-blog) (advanced customization)
