---
title: File Structure
description: The standard files and folders you'll find in a Factor project and their purpose
---

# Factor Files and Folders

Factor follows standard conventions for structuring modern apps. As you get started, it will be useful to understand the basic files and folders you'll encounter. As well as your options with them.

> **A Note on Flexibility**
> Factor's structure is designed to be flexible. The overview below reflects a basic Factor setup and a few preferences we have (e.g. ts vs js, less vs sass); but don't view these as limitations since they can be changed.

## Organizing Your App

Here is a basic structure for a Factor app:

```yaml
# Basic Structure
- Project Root
    package.json: Config
    .env: Secrets
    index.ts: Main File
    factor-styles.less: Styling and css variables
    factor-settings.ts: Customize
    content.vue: Application Wrapper
    icon.svg: Primary icon (200px by 200px)
    favicon.png: Favicon
    static/:
      example.jpg: statically hosted files
```

## Using a `src` folder

It is also possible to put your source files in a sub-folder. Typically this would be called `src`.

In your app's `package.json`, in the `main` property, you set your app's primary [main file](./main-files).

Factor will use this file to establish which folder is the app's source. So if you set it to `src/index` then Factor considers the `src` folder to be your source folder.

```json
// package.json
{
  "name": "myApp",
  "main": "src/index.js"
}
```

```yaml
# Basic Structure
- /: Project Root
    package.json: Config
    .env: Secrets
    src/:
      index.js: Main File
      # Other files
```

## Config (package.json)

The `package.json` file is a standard file that describes your application's configuration.

Inside this file, use the `factor` property to add config for your app.

```json
// package.json
{
  "name": "myApp",
  "main": "index.js",
  "factor": {
    // Factor configuration
  },
  "dependencies": {
    "@factor/core": "^1.0.0"
  }
}
```

## Secrets (.env)

For secret configuration keys and information, Factor uses the [dotenv](https://github.com/motdotla/dotenv) library.

This utility takes the values in this file and adds them to your application's environmental variables.

> **Note:** You should never commit this file to source control, treat it like a password.

```bash
FACTOR_AUTH_SECRET=SOME-LONG-TEXT-12345
FACTOR_DB_CONNECTION=https://my-connection-string-etc
```

[Read about .env in Factor](./dotenv)

## Main Files (index.js)

Your app's main file (or files) is the entry point for the app's code. This is where the code belongs that will control your app. For example, in the main files you can add:

- Routes and components
- Vue plugins and tools
- Server endpoints and handlers (i.e. middleware)
- Filters, callbacks and event handlers

Main files are auto-loaded by Factor based on the `load` property in `package.json` > `factor`. If needed, you can load multiple files. It is also common to separate the application and server files since some packages cannot work in both environments.

Learn more about [main files](/main-files)

## Content Wrapper (content.vue)

The content wrapper (`content.vue`) is the root component that wraps your application front-end. It allows you to add global components like your navigation and footer.

Learn more about the [content](./content-wrapper)

## Settings and Styles

Factor has a powerfully simple settings and styles system that works with `factor-settings` and `factor-styles` files found in your application as well as any plugins you have installed.

Learn more about [settings](./settings) or [styles](./styles)

## Static Assets

Place a folder named `static` in your application `src` directory and it will be handled as the static assets for your app. All files in this folder will be copied to your `dist` folder at build-time and then served under their original name.

For example, an image under `static/my-image.jpg` will be available and served at `https://your-url.com/my-image.jpg` after build.

## Icons

To make these icons work, just place them in the source folder of your app.

- `icon.svg` Is a standard application icon that is used in certain places and sometimes by plugins/themes. It should be 200px by 200px square.
- `favicon.png` Is the browser standard for app icons that appear in the bookmarks, tabs, etc.. We recommend a size of 100px by 100px.

## Generated Folders

There are two folders generated and managed by Factor when you perform various operations.

- `dist/` this is your distribution application that is generated by Webpack. It is what is hosted and optimized for serving in production.
- `.factor/` this is where generated files and information are stored by Factor.
