---
title: "Social Proof Red Pill: Fake it til you make it"
excerpt: "Solving the chicken and egg problem"
publishedAt: "2023-08-01"
category: ["Influence"]
image:
  url: "./unicorn.jpg"
author:
  name: "Andrew Powers"
  email: "arpowers@gmail.com"
---

Ever heard the saying, "everyone's doing it?" That's the power of social proof. It's like when your friends all rave about a new restaurant, and suddenly you want to try it too. But when you're just starting a business, how can you show potential customers that "everyone's doing it" when... well, they're not?

## The Newbie Dilemma

Starting a new business? Congrats! But, let's be honest, it's a bit like being the new kid at school. No one knows you, you haven't made any friends (clients) yet, and there's no one to vouch for how awesome you are.

It's a catch-22. You need reviews and testimonials to attract clients, but you need clients to give you those reviews and testimonials.

## Why? Safety In Numbers

It doesn't matter if its your best friends, family, or anyone else... people won't take action on something if they get the idea they are the "first follower."

This is because historically following people who are doing something different was dangerous.

If that person turned out to be a con artist, or a crazy person, or just plain wrong... you could ruin your reputation.

For that reason, people don't feel good about supporting things unless they truly believe other people are supporting the same thing. That makes them less afraid of "looking stupid."

<iframe width="100%" height="400" src="https://www.youtube.com/embed/fW8amMCVAJQ?si=I0UrWcwSSFzYhNrA" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>

## Social Heuristics

Another reason social proof is useful is because it simplifies decision making.

If you're a potential client, and you see a bunch of other people have already hired someone, you don't have to think as hard about whether or not you should hire them.

You can just assume they are good, and move on with your life.

## Solving The Chicken and Egg Problem

So how do you get social proof when you're just starting out?

The answer is simple: fake it til you make it.

But its harder than that, because in many platforms, you don't have complete control over your social proof.

You can try to fake reviews, but its hard to do that without getting caught.

You can buy followers, but that ruins your engagement rate.

So what do you do?

## The Smart Move: Your Own Playground

The solution is to own your own marketing platform, otherwise known as a website. That way you can control the social proof.

On your own website, it's easy to create your own reviews and "salt" the numbers.

Sites like Airbnb and Reddit, both faked their initial content to get started. They created fake users and fake reviews to make it look like there was activity on the platform.

That turned out alright for them. So you shouldn't be afraid to do the same.

A few rules:

- I don't recommend doing this forever, but it's necessary to get started.
- Don't lie about your results. If you create fake reviews, giving 5 stars, you better be able to deliver 5 star results.
- Some things shouldn't be faked. Don't say Apple is a client, if they're not. Maintain plausible deniability.
