# Ficons

## A Minimalist, Drop In Font Awesome Replacement

Ficons is a Simple, Open-Source, Drop-In Alternative for Font Awesome Icons.
Maintained by [The Fiction Team](https://www.fiction.com/).

Get started at [https://ficons.fiction.com](https://ficons.fiction.com)!

- [Installation](https://ficons.fiction.com/getting-started.html) 
- [Icons Reference](https://ficons.fiction.com/reference.html) 
- [Examples](https://ficons.fiction.com/examples.html) 

### Motive

To create a drop-in alternative to Font Awesome for people that like a little variety in their icons.

Ficons simply maintains the simple **fa-[icon-name]** class system and leaves the original Font Awesome icons as fallbacks if there is no explicit replacement.

It is a "drop-in" replacement for Font Awesome, which means you can simply replace your Font Awesome CDN link with the Ficons CDN link and you're good to go.

> **TLDR** You can just replace your Font Awesome CDN link with the one from Ficons and everything should work the same, only better.

### Features:

- Get over 200 new or replaced icons
- Minimal and more consistent redesign
- Simple, drop-in replacement for Font Awesome's 'fa-' class system
- Update your site or apps icons in 60 seconds

### Quick Start

Replace your Font Awesome CDN Link with the Ficons one as follows:

```html
<link type="text/css" href="https://cdn.jsdelivr.net/npm/ficons@1.1.53/dist/ficons/font.css" />
```

## Author

- Email: hello@fiction.com
- GitHub: https://github.com/fictiondotcom/

## License

- Full details:
  [https://ficons.fiction.com/license.html](https://ficons.fiction.com/license.html)

## Versioning

Ficons will be maintained under the Semantic Versioning guidelines as much as
possible. Releases will be numbered with the following format:

`<major>.<minor>.<patch>`

And constructed with the following guidelines:

- Breaking backward compatibility bumps the major (and resets the minor and
  patch)
- New additions, including new icons, without breaking backward compatibility
  bumps the minor (and resets the patch)
- Bug fixes, changes to brand logos, and misc changes bumps the patch
