﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<IEnumerable<MvcEnterprise.Models.DataSet1+ProductRow>>" %>
<%
	string viewType=ViewData["ViewType"].ToString();
	string viewName = ViewData["ViewName"].ToString();
	if (viewName.ToLower() == "productview") viewName = string.Empty;
	var items = Model;
	if (viewType == "OneImgAndList" || viewType == "List")
	{
		if (viewType == "OneImgAndList")
		{
			var imgItem = items.FirstOrDefault(m => !string.IsNullOrEmpty(m.SmallPic));
			if (imgItem != null)
			{
				items = items.SkipWhile(m => m == imgItem);
%>
<div class="OneImgAndList">
	<a title="<%= imgItem.ProductName %>" href='<%= Url.Action("ProductView",new {ID = imgItem.ID, viewName = viewName}) %>'>
		<img src="<%= imgItem.SmallPic %>" alt="<%= Html.Encode(imgItem.ProductName) %>" class="OneImgAndListSmallImg" /></a>
	<p style="_width: 99%; font-weight: bold" class="ellipsis"><a class="ellipsis" title="<%= imgItem.ProductName %>"
		href='<%= Url.Action("ProductView",new {ID = imgItem.ID, viewName = viewName}) %>'><%= imgItem.ProductName%></a>
	</p>
	<p style="word-wrap: break-word; word-break: break-all"><%= imgItem.Content.StripHTML().Trim().Substr(0, 70)%>...
	</p>
</div>
<%
}
		}
%>
<ul class="ListTitle">
	<%foreach (var item in items)
   {%>
	<li><a href='<%= Url.Action("ProductView",new {ID = item.ID, viewName = viewName}) %>' title='<%= item.ProductName %>'>
		<%= item.ProductName %></a>&emsp;</li>
	<%}%>
</ul>
<%
}
	else if (viewType == "Img")
	{
%>
<div style="height: 5px; overflow: hidden">
</div>
<ul class="Product">
	<%foreach (var item in items)
   {%>
	<li>
		<div class="prodImg">
			<a href="<%= Url.Action("ProductView",new {ID = item.ID, viewName = viewName}) %>" title="<%= item.ProductName %>">
				<img alt="<%= Html.Encode(item.ProductName) %>" src="<%= item.SmallPic %>" /></a>
		</div>
		<div class="prodName">
			<a href="<%= Url.Action("ProductView",new {ID = item.ID, viewName = viewName}) %>" title="<%= item.ProductName %>">
				<%= item.ProductName %> </a>
		</div>
	</li>
	<%}%>
</ul>
<br class="clearfloat" />
<%
}
%>
