﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<IEnumerable<MvcEnterprise.Models.DataSet1+MessageRow>>" %>
<%
var searchText = Request.QueryString["searchText"];
%>
<div id="requestAjaxText">
    <form action="" id="searchForm" method="get">
    <label>
        查找：</label>
    <input type="text" name="searchText" id="searchText" value="<%= searchText %>" />
    <input type="submit" value="查找" />
    <% if (!string.IsNullOrEmpty(searchText)) {%>
    <input type="submit" value="全部显示" onclick="$('#searchText').val('');" />
    <%}%>
    </form>
    <form method="post" id="MultiOperationForm" action="?action=MultiOperation">
    <table class="tablesorter">
		<thead>
			<tr>
				<th>
					审核
				</th>
				<th>
					称呼
				</th>
				<th>
					留言内容
				</th>
				<th>
					留言时间
				</th>
				<th>
					状态
				</th>
				<th>
					操作
				</th>
				<th>
					<input type="checkbox" id="cb_ReverseSelection" />
				</th>
			</tr>
		</thead>
		<%
            foreach (var item in Model)
            { %>
        <tr>
            <td>
                    <input type="checkbox" name="ViewFlag<%= item.ID %>" <%= item.ViewFlag ? "checked=\"checked\"" : "" %> />
            </td>
            <td>
                <%= Html.Encode(item.Linkman,searchText)%>
            </td>
            <td>
                <%
                    string content = item.Content.StripHTML();
                    int maxlength = 40;
                    if (string.IsNullOrEmpty(searchText))
                    {
                        if (content.Length > maxlength)
                        {
                            Response.Write(content.Substring(0, maxlength));
                            Response.Write("...");
                        }
                        else
                        {
                            Response.Write(content);
                        }
                    }
                    else
                    {
                        int pos = content.IndexOf(searchText);
                        int length = content.Length - pos;
                        if (pos>0)
                        {
                            Response.Write("...");
                        }
                        if (content.Length > maxlength)
                        {
                            Response.Write(Html.Encode(content.Substring(pos, length > maxlength ? maxlength : length), searchText));
                            if (length>maxlength) Response.Write("...");
                        }
                        else
                        {
                            Response.Write(content);
                        }
                    }
                %>
            </td>
            <td>
                    <%= Html.Encode(item.AddTime)%>
            </td>
            <td>
                <%= string.IsNullOrEmpty(item.ReplyContent) ? "<span style='color:red'>待回复</span>":"已回复" %>
            </td>
            <td>
                <%= Html.ActionLink("查看与回复", "MessageEdit", new { id=item.ID }) %>
				<a href="javascript:;" onclick="deleteModel(this,<%= item.ID %>);">删除</a>
            </td>
            <td>
                <input type="checkbox" name="cb_id" value="<%=item.ID %>" />
            </td>
        </tr>
        <% } %>
    </table>
	<div class="OpArea">
		执行
		<select name="OpType">
			<option value="1">保存</option>
			<option value="2">删除</option>
		</select>
		<input type="submit" value="操作" />
	</div>
    </form>
    <%= Html.Pager(3) %>
</div>
<br class="clearfloat" />
<script src="../../Scripts/jquery.ReverseSelection.js" type="text/javascript"></script>
<script type="text/javascript">
    $.initReverseSelection(); //初始反选功能
    $(function () {
        $("#MultiOperationForm").submit(function () {
            if ($("select[name='OpType']").val() == 2) {
                if (!confirm("确认删除？")) {
                    return false;
                }
            }
        });
    });
</script>
<link rel="stylesheet" type="text/css" href="../../Scripts/tablesorter/style.css" />
<script type="text/javascript" src="../../Scripts/jquery.tablesorter.js"></script>
<script type="text/javascript">
	$(function () {
		$(".tablesorter").tablesorter({ debug: false });
	});
</script>
