﻿<%@ Page Language="C#" %>

<%@ Register Src="~/Content/fckeditor/editor/filemanager/connectors/aspx/config.ascx"
	TagName="Config" TagPrefix="FCKeditor" %>
<FCKeditor:Config ID="Config" runat="server"></FCKeditor:Config>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
	<title>File Upload</title>
	<meta http-equiv="X-UA-Compatible" content="IE=8">
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<link href="browser.css" type="text/css" rel="stylesheet" />
	<script type="text/javascript" src="js/common.js"></script>
	<link href="css/default.css" rel="stylesheet" type="text/css" />
	<script type="text/javascript" src="swfupload/swfupload.js"></script>
	<script type="text/javascript" src="js/handlers.js"></script>
	<script type="text/javascript" src="js/jquery-1.3.2.js"></script>
	<script type="text/javascript">
		var swfu;
		$(document.body).ready(function () {
			window.top.IsLoadedUpload = true;
		});
		function SetCurrentFolder(resourceType, folderPath) {
			var sUrl = oConnector.ConnectorUrl + 'Command=FileUpload';
			sUrl += '&Type=' + resourceType;
			sUrl += '&CurrentFolder=' + encodeURIComponent(folderPath);
			var fileTypes;
			switch (resourceType) {
				case "Image":
					fileTypes = '<%= "*." + String.Join(";*.", Config.ImageExtensions) %>';
					break;
				case "Flash":
					fileTypes = '<%= "*." + String.Join(";*.", Config.FlashExtensions) %>';
					break;
				case "Media":
					fileTypes = '<%= "*." + String.Join(";*.", Config.MediaExtensions) %>';
					break;
				case "File":
					fileTypes = '<%= "*." + String.Join(";*.", Config.FileExtensions) %>';
					break;
				default:
					break;
			}
			if (swfu !== undefined) {
				swfu.setUploadURL(sUrl);
				swfu.setFileTypes(fileTypes, "");
				return;
			}
			swfu = new SWFUpload({
				// Backend Settings
				upload_url: sUrl,
				post_params: {
					"ASPSESSID": "<%=Session.SessionID %>"
				},

				// File Upload Settings
				//file_size_limit : "2 MB",
				file_types : fileTypes,
				//file_types_description : "JPG files",
				file_upload_limit: 0,    // Zero means unlimited
				file_post_name: "NewFile",

				// Event Handler Settings - these functions as defined in Handlers.js
				//  The handlers are not part of SWFUpload but are part of my website and control how
				//  my website reacts to the SWFUpload events.
				swfupload_preload_handler: preLoad,
				swfupload_load_failed_handler: loadFailed,
				file_queue_error_handler: fileQueueError,
				file_dialog_complete_handler: fileDialogComplete,
				upload_progress_handler: uploadProgress,
				upload_error_handler: uploadError,
				upload_success_handler: uploadSuccess,
				upload_complete_handler: uploadComplete,

				// Button settings
				button_image_url: "images/XPButtonNoText_160x22.png",
				button_placeholder_id: "spanButtonPlaceholder",
				button_width: 160,
				button_height: 22,
				button_text: '<span class="button">上传大文件（2G以内）</span>',
				button_text_style: '.button { text-align:center; }',
				//button_text_top_padding: 1,
				//button_text_left_padding: 5,

				// Flash Settings
				flash_url: "swfupload/swfupload.swf", // Relative to this file
				flash9_url: "swfupload/swfupload_FP9.swf", // Relative to this file

				custom_settings: {
					upload_target: "divFileProgressContainer"
				},

				// Debug Settings
				debug: false
			});
		}
	</script>
</head>
<body>
	<form id="frmUpload" action="" method="post" enctype="multipart/form-data">
	<div id="content">
		<div id="swfu_container">
			<div>
				<span id="spanButtonPlaceholder"></span>
			</div>
			<div id="divFileProgressContainer" style="height: 75px;">
			</div>
		</div>
	</div>
	</form>
</body>
</html>
