How to Contribute
-----------------

### Reporting Issues

*   Search existing issues before submitting a new one to avoid duplicates.
*   When reporting an issue, please include:
    *   A clear and descriptive title.
    *   Steps to reproduce the problem.
    *   Relevant logs, screenshots, or error messages.

### Submitting Pull Requests

*   **Fork the repository** and clone it to your local machine.
*   **Create a branch** for your work:
    ```bash
    git checkout -b feature/your-feature-name
    ```
*   **Commit your changes** with clear and concise messages:
    ```bash
    git commit -m "Add a brief and descriptive commit message"
    ```
*   **Push your branch** to your fork and open a pull request against the `main` branch:
    ```bash
    git push origin feature/your-feature-name
    ```
*   Ensure your pull request:
    *   Follows the project's coding standards and guidelines.
    *   Includes documentation updates if applicable.
    *   Links to the issue it addresses, if relevant.

* * *

Development Workflow
--------------------

Set up your environment by following the instructions in the [meshtastic-matrix-relay repository](https://github.com/geoffwhittington/meshtastic-matrix-relay).

* * *

Code of Conduct
---------------

This project adheres to the Code of Conduct. By participating, you are expected to uphold this code.

* * *

Additional Resources
--------------------

*   Project Documentation
*   meshtastic-matrix-relay [Documentation](https://github.com/geoffwhittington/meshtastic-matrix-relay/wiki) and [project](https://github.com/geoffwhittington/meshtastic-matrix-relay)
*   [GitHub Help: About Pull Requests](https://docs.github.com/pull-requests)
*   Reach out via the contact method specified in the [@fernandodpr GitHub profile](https://github.com/fernandodpr) for further questions.

* * *

Thank You!
----------

Your contributions make this project better for everyone. We appreciate your effort!
