# Examples

All tutorials can be run online on Google Colab, without the need to install
any packages locally.

## General

Getting Started tutorial. It includes training and inference of a model for
brain segmentation using a 3D U-Net.

[![Google Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/fepegar/torchio-notebooks/blob/main/notebooks/TorchIO_tutorial.ipynb)

## Transforms

This tutorial will teach everything about transforms, and how to use them for preprocessing and augmentation.

[![Google Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/fepegar/torchio-notebooks/blob/main/notebooks/Data_preprocessing_and_augmentation_using_TorchIO_a_tutorial.ipynb)

## Inference

This is an example of using a pre-trained PyTorch model (HighRes3DNet) and TorchIO to perform a full brain parcellation from a T1-weighted MRI.

[![Google Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/fepegar/torchio-notebooks/blob/main/notebooks/Brain_parcellation_with_TorchIO_and_HighRes3DNet.ipynb)

## TorchIO + MONAI + PyTorch Lightning

In this tutorial, we demonstrate how these three libraries from the
[official PyTorch Ecosystem](https://pytorch.org/ecosystem/)
can be used together to segment the hippocampus on brain MRIs from the
[Medical Segmentation Decathlon](http://medicaldecathlon.com/).

[![Google Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/fepegar/torchio-notebooks/blob/main/notebooks/TorchIO_MONAI_PyTorch_Lightning.ipynb)
