package eu.fasten.vulnerabilitystatementsprocessor;

import com.google.gson.Gson;
import eu.fasten.core.data.vulnerability.Vulnerability;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Test;

import java.io.IOException;
import java.nio.charset.StandardCharsets;

import static eu.fasten.core.utils.TestUtils.getTestResource;
import static org.junit.jupiter.api.Assertions.assertEquals;

public class JsonStatementTest {
    private final Gson gson = new Gson();

    @Test
    public void readJsonStatement() throws IOException {
        var jsonFile = getTestResource("CVE-2020-26943.json");
        var vulnerability = gson.fromJson(FileUtils.readFileToString(jsonFile, StandardCharsets.UTF_8), Vulnerability.class);
        assertEquals("CVE-2020-26943", vulnerability.getId());
        assertEquals("pkg:pypi/blazar@0", vulnerability.getPurls().toArray()[0]);
    }
}
