package eu.fasten.analyzer.vulnerabilitystatementsprocessor.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;

public class FastenApiClient {
    private final String fastenApiUrl;
    private final static Logger logger = LoggerFactory.getLogger("FastenApiClient");
    private final HttpClient httpClient = HttpClient.newBuilder()
            .followRedirects(HttpClient.Redirect.ALWAYS)
            .version(HttpClient.Version.HTTP_2)
            .build();

    public FastenApiClient() {
        this.fastenApiUrl = System.getenv("FASTEN_API_URL");
    }

    public FastenApiClient(String fastenApiUrl) {
        this.fastenApiUrl = fastenApiUrl;
    }

    public String getApiUrl() {
        return fastenApiUrl;
    }

    public HttpResponse<String> requestPackageVersion(String forge, String packageName, String version) throws URISyntaxException, IOException, InterruptedException {
        var uri = new URI(fastenApiUrl + forge + "/packages/" + packageName + "/" + version);
        return get(uri);
    }

    private HttpResponse<String> get(URI uri) throws IOException, InterruptedException {
        logger.info("Sending GET request to: " + uri);
        var builder = HttpRequest.newBuilder()
                .GET()
                .uri(uri)
                .timeout(Duration.ofSeconds(5));

        return httpClient.send(builder.build(), HttpResponse.BodyHandlers.ofString());
    }
}
