/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package eu.fasten.analyzer.vulnerabilitystatementsprocessor.utils;

import org.apache.maven.artifact.versioning.ComparableVersion;

import java.util.HashMap;

public class Cache {
    // Necessary
    // pkg_name --> pkg_forge
    public HashMap<String, String> pkgNameToForge = new HashMap<>();
    // pkg_version --> pkg_name
    public HashMap<ComparableVersion, String> pkgVsnToName = new HashMap<>();
    // callable_id --> pkg_version
    public HashMap<Long, ComparableVersion> callIdToPkgVsn = new HashMap<>();

    // Extra
    // pkg_id --> pkg_name
    public HashMap<Long, String> pkgIdToName = new HashMap<>();
    // pkg_version_id --> pkg_vsn
    public HashMap<Long, ComparableVersion> pkgVsnIdToVsn = new HashMap<>();

    public Cache() {
    }
}
