<p align="center">
    <img src="https://user-images.githubusercontent.com/45048351/90056609-d2c67900-dce7-11ea-9f66-3717998d861d.jpg">
</p>
<br/>
<p align="center">
    <a href="https://github.com/fasten-project/fasten/actions" alt="GitHub Workflow Status">
        <img src="https://img.shields.io/github/workflow/status/fasten-project/fasten/Java%20CI?logo=GitHub%20Actions&logoColor=white&style=for-the-badge" /></a>
    <!-- Here should be a link to Maven repo and version should be pulled from there. -->
    <a href="https://github.com/fasten-project/fasten/" alt="GitHub Workflow Status">
                <img src="https://img.shields.io/maven-central/v/fasten/vulnerability?label=version&logo=Apache%20Maven&style=for-the-badge" /></a>
</p>
<br/>


The FASTEN Vulnerability Updates Listener listens to messages from the [Vulnerability Producer](https://github.com/fasten-project/vulnerability-producer) and updates the [Metadata Database](https://github.com/fasten-project/fasten/wiki/Metadata-Database-Schema) accordingly.

## Arguments
- `-h` `--help` Show this help message and exit.
- `-d` `--database` Database URL for connection
- `-u` `--user` Database user name

## Usage 

### Environment variables
FASTEN_API_URL
FASTEN_DBPASS

#### Injecting vulnerability information into the KB
```shell script
FASTEN_DBPASS=pass -d jdbc:postgresql:postgres -u postgres
```
The Vulnerability Updates Listener will request the FASTEN server to ingest missing package-versions at the API specified by the environment variable `FASTEN_API_URL`. If undefined, the default `https://api.fasten.eu/api/` is used.

## Join the community

The FASTEN software package management efficiency relies on an open community contributing to open technologies. Related research projects, R&D engineers, early users and open source contributors are welcome to join the [FASTEN community](https://www.fasten-project.eu/view/Main/Community), to try the tools, to participate in physical and remote worshops and to share our efforts using the project [community page](https://www.fasten-project.eu/view/Main/Community) and the social media buttons below.  
<p>
    <a href="http://www.twitter.com/FastenProject" alt="Fasten Twitter">
        <img src="https://img.shields.io/badge/%20-Twitter-%231DA1F2?logo=Twitter&style=for-the-badge&logoColor=white" /></a>
    <a href="http://www.slideshare.net/FastenProject" alt="GitHub Workflow Status">
                <img src="https://img.shields.io/badge/%20-SlideShare-%230077B5?logo=slideshare&style=for-the-badge&logoColor=white" /></a>
    <a href="http://www.linkedin.com/groups?gid=12172959" alt="Gitter">
            <img src="https://img.shields.io/badge/%20-LinkedIn-%232867B2?logo=linkedin&style=for-the-badge&logoColor=white" /></a>
</p>
