package eu.fasten.analyzer.vulnerabilitypackageslistener;

import eu.fasten.core.utils.TestUtils;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.junit.jupiter.api.Test;

import java.io.FileReader;
import java.io.IOException;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotNull;

class VulnerabilityPackagesListenerTest {
    @Test
    void findPayloadInCallableIndexMessage() throws IOException {
        var messageFile = TestUtils.getTestResource("callable-index-message.json");
        var jsonTokener = new JSONTokener(new FileReader(messageFile));
        var json = new JSONObject(jsonTokener);
        var payload = VulnerabilityPackagesListener.VulnerabilityPackagesKafkaPlugin.findPayload(json);
        assertNotNull(payload);
        assertEquals("mvn", payload.getString("forge"));
        assertEquals("io.netty", payload.getString("groupId"));
        assertEquals("netty-codec-http2", payload.getString("artifactId"));
        assertEquals("4.1.0.Beta5", payload.getString("version"));
    }

    @Test
    void findPayloadInPOMAnalyzerMessage() throws IOException {
        var messageFile = TestUtils.getTestResource("pom-analyzer-message.json");
        var jsonTokener = new JSONTokener(new FileReader(messageFile));
        var json = new JSONObject(jsonTokener);
        var payload = VulnerabilityPackagesListener.VulnerabilityPackagesKafkaPlugin.findPayload(json);
        assertNotNull(payload);
        assertEquals("mvn", payload.getString("forge"));
        assertEquals("io.netty", payload.getString("groupId"));
        assertEquals("netty-codec-http2", payload.getString("artifactId"));
        assertEquals("4.1.0.Beta5", payload.getString("version"));
    }

    @Test
    void findPayloadInRealCallableIndexMessage() throws IOException {
        var messageFile = TestUtils.getTestResource("real-callable-index-message.json");
        var jsonTokener = new JSONTokener(new FileReader(messageFile));
        var json = new JSONObject(jsonTokener);
        var payload = VulnerabilityPackagesListener.VulnerabilityPackagesKafkaPlugin.findPayload(json);
        assertNotNull(payload);
        assertEquals("mvn", payload.getString("forge"));
        assertEquals("org.apache.pdfbox", payload.getString("groupId"));
        assertEquals("pdfbox", payload.getString("artifactId"));
        assertEquals("2.0.8", payload.getString("version"));
    }

    @Test
    void findPayloadInRealPOMAnalyzerMessage() throws IOException {
        var messageFile = TestUtils.getTestResource("real-pom-analyzer-message.json");
        var jsonTokener = new JSONTokener(new FileReader(messageFile));
        var json = new JSONObject(jsonTokener);
        var payload = VulnerabilityPackagesListener.VulnerabilityPackagesKafkaPlugin.findPayload(json);
        assertNotNull(payload);
        assertEquals("mvn", payload.getString("forge"));
        assertEquals("org.apache.pdfbox", payload.getString("groupId"));
        assertEquals("pdfbox", payload.getString("artifactId"));
        assertEquals("2.0.8", payload.getString("version"));
    }
}