We welcome contributions from external collaborators. Here we describe how you can contribute to the FASTEN project.

## Posting issues
- Make sure a similar issue is not already present on the issue board
- Open individual issues for every bug / feature you are reporting
- Make sure your issue has the following information or use our templates for different issue types:
    - Clear issue title.
    - Brief description of the issue.
    - Provide steps on how to reproduce an issue or error.
    - Provide the error message and stack trace.
    - Give some information about your system info such as OS, Java SDK version, etc.

## Sending pull requests
We highly suggest considering the following tips when sending a pull request:

- A pull request should contain a small contribution which can be a bug-fix, small improvements, or a feature.
- Provide a description of the contribution. For instance, a feature's description should contain why the added feature is important and what functionality it adds to the project.
- Make sure your pull request has the following information or use our template:
    - Descriptive pull request title.
    - Brief description of the changes you have made.
    - Provide a motivation behind the pull request. If the pull request is closes certain issues, make sure to link them.
    - Tell us about how you have tested the code you've changed or written.
    - Task list to show what has done or needs to be developed.
    - Give some information about your system info such as OS, Java SDK version, etc.

We will review pull requests as soon as possible. We will provide the feedback on the code and make sure the pull request follows our standards. In case the newly added code follows the guidelines it will be merged, and you'll become a contributor to FASTEN project. 
