export const imageDesigns = [
  "https://storage.googleapis.com/falserverless/illusion-examples/pattern.png",
  "https://storage.googleapis.com/falserverless/illusion-examples/checkers.png",
  "https://storage.googleapis.com/falserverless/illusion-examples/checkers_mid.jpg",
  "https://storage.googleapis.com/falserverless/illusion-examples/ultra_checkers.png",
  "https://storage.googleapis.com/falserverless/illusion-examples/funky.jpeg",
  "https://storage.googleapis.com/falserverless/illusion-examples/cubes.jpeg",
  "https://storage.googleapis.com/falserverless/illusion-examples/turkey-flag.png",
  "https://storage.googleapis.com/falserverless/illusion-examples/india-flag.png",
  "https://storage.googleapis.com/falserverless/illusion-examples/usa-flag.png",
];

const imagePrompts = [
  "a realistic astronaut exploring a futuristic space colony on Mars.",
  "a cyberpunk detective in a rainy, neon-lit city, with high-tech gadgets.",
  "a rebel leader giving a passionate speech in a dystopian world.",
  "a young woman wandering in a lush, bio-engineered forest.",
  "a pilot in a futuristic flight suit, standing next to a sleek space fighter.",
  "a scientist in a high-tech lab, researching advanced aI technologies.",
  "a warrior in cybernetic armor, facing a dystopian cityscape.",
  "a street vendor in a bustling, futuristic asian megacity.",
  "a teacher in a virtual reality classroom, teaching students from around the world.",
  "a young girl with robotic limbs, playing in a future urban park.",
  "a lone explorer in a post-apocalyptic world, surveying a deserted city.",
  "a musician creating music with a futuristic, holographic instrument.",
  "a journalist with augmented reality glasses, reporting in a war-torn future.",
  "a fashion model in avant-garde clothing, walking the streets of a modern city.",
  "a hacker in a dark room, surrounded by screens showing code and data.",
  "a robot mechanic working in a bustling workshop on advanced androids.",
  "a couple sharing a moment on a balcony overlooking a futuristic skyline.",
  "a space engineer in a zero-gravity environment, repairing a spaceship.",
  "a doctor performing surgery with advanced robotic medical equipment.",
  "a soldier in exoskeleton armor patrolling a dystopian landscape.",
  "a traveler riding a high-speed train through a neon-lit, futuristic city.",
  "a chef cooking with molecular gastronomy techniques in a modern kitchen.",
  "an artist painting a mural that reflects a utopian vision of the future.",
  "a child with a pet robot, playing in a high-tech, interactive playground.",
  "a farmer using advanced hydroponics systems in a vertical farm.",
  "a group of friends watching a holographic movie in a future urban apartment.",
  "a researcher studying exotic plants in a giant, futuristic greenhouse.",
  "a racer in a high-speed, levitating race car competing in a futuristic race.",
  "a gamer immersed in a full-sensory virtual reality gaming environment.",
  "a librarian organizing digital archives in a massive, futuristic library.",
  "a politician delivering a speech in a grand, technologically advanced assembly.",
  "a trader working in a fast-paced, futuristic stock exchange.",
  "a fashion designer sketching designs with a high-tech, 3D modeling pen.",
  "a construction worker operating a giant robot to build a skyscraper.",
  "a family enjoying a picnic in a park with a panoramic view of a future city.",
  "a firefighter using advanced equipment to battle a blaze in a modern city.",
  "a bodyguard with augmented reality capabilities, securing a high-profile client.",
  "a monk meditating in a peaceful, digitally-enhanced Zen garden.",
  "a biologist studying new lifeforms in a state-of-the-art research facility.",
  "a couple dancing in a club with futuristic, immersive light shows.",
  "a space tourist taking a selfie with Earth in the background from a space hotel.",
  "a graffiti artist creating interactive, digital street art in an urban alley.",
  "a professional gamer competing in a popular, futuristic e-sport.",
  "a courier delivering packages with a high-speed, autonomous drone.",
  "a teacher leading a group of students on a field trip to a space museum.",
  "a scientist analyzing samples from an alien planet in a secure lab.",
  "a historian exploring ancient ruins with holographic reconstruction technology.",
  "a detective using virtual reality to recreate crime scenes in a noir city.",
  "a journalist using drones to capture footage in a conflict zone.",
  "a spy with cybernetic enhancements on a covert mission in a hostile city.",
  "a stunt performer practicing in a virtual reality simulation.",
  "a musician playing a concert with futuristic, light-based instruments.",
  "a social media influencer streaming live from a bustling, neon-lit street.",
  "a professional athlete training with advanced, aI-powered equipment.",
  "a scientist experimenting with time travel technology in a secret lab.",
  "a group of friends exploring an abandoned, dystopian cityscape.",
  "a survivalist navigating a harsh, futuristic wilderness.",
  "a climate change activist speaking at a large, holographic rally.",
  "a tattoo artist creating intricate, animated tattoos in a modern studio.",
  "a couple enjoying a virtual reality date in an exotic, digital landscape.",
  "a street magician performing with augmented reality illusions.",
  "a pilot navigating through a storm on an alien planet.",
  "a martial artist practicing in a high-tech dojo with holographic opponents.",
  "a diplomat at an intergalactic summit, negotiating peace.",
  "a celebrity attending a red carpet event in a futuristic fashion ensemble.",
  "a soldier using a powered exosuit in a military training simulation.",
  "a cybernetic pet owner walking a robotic dog in a city park.",
  "a diver exploring a sunken city in a high-tech submersible.",
  "an architect designing sustainable, self-sufficient buildings for a new world.",
  "a young adult discovering an ancient artifact in a futuristic museum.",
  "a park ranger using drones to monitor wildlife in a large, urban park.",
  "a car mechanic working on a levitating, electric sports car.",
  "a scientist in a space station laboratory, conducting zero-gravity experiments.",
  "a police officer patrolling a bustling metropolis with advanced surveillance tech.",
  "a movie director filming a scene with a holographic camera.",
  "a CEO overlooking a futuristic city from a high-rise office tower.",
  "a mountain climber using advanced gear to scale a towering, alien peak.",
  "a paranormal investigator examining a haunted, futuristic mansion.",
  "a pilot testing a new, experimental aircraft in the stratosphere.",
  "a novelist writing a sci-fi epic on a holographic display.",
  "a VR therapist conducting a session in a serene, virtual environment.",
  "a child learning to code with a playful, aI teaching assistant.",
  "a geneticist working on creating new species in a cutting-edge lab.",
  "a criminal mastermind planning a heist in a high-security, future city.",
  "an explorer navigating through a neon jungle in search of a lost city.",
  "a couple having a romantic dinner on a balcony with a city lights view.",
  "a street performer using a high-tech, one-man band setup in a public square.",
  "a reality TV star participating in a survival show on a remote, alien planet.",
  "a software developer creating a new social network in a digital workspace.",
  "a fitness trainer leading a high-intensity workout in a virtual gym.",
  "a scientist studying the effects of anti-gravity on human physiology.",
  "a cosplayer wearing an intricate, handcrafted costume at a sci-fi convention.",
  "a tour guide leading a group through a historic, preserved part of a future city.",
  "a politician campaigning with interactive, 3D holographic presentations.",
  "an actor performing in a cutting-edge, virtual reality theater production.",
  "a martial arts master teaching students in a remote, mountain-top dojo.",
  "a street vendor selling exotic, genetically-modified fruits in a market.",
  "a young adult riding a high-speed, magnetic levitation skateboard.",
  "a hacker in a cyberwarfare battle, defending against a digital attack.",
  "a fashion photographer shooting a futuristic-themed editorial in an urban setting.",
  "a pilot and co-pilot navigating a cargo spaceship through an asteroid belt.",
  "a scientist monitoring environmental changes from a high-altitude observatory.",
  "a futuristic warrior in neon armor, standing in a cyberpunk cityscape.",
  "an anime-style astronaut exploring the surface of a distant, colorful planet.",
  "a young sorcerer casting spells in a high-tech, magical academy.",
  "a cybernetic detective solving mysteries in a futuristic urban landscape.",
  "an elegant princess in a steampunk gown, overlooking a mechanical kingdom.",
  "a space pilot navigating through an asteroid field in a sleek starship.",
  "a robot-human hybrid playing a futuristic instrument in a neon-lit club.",
  "a superhero with advanced tech gadgets, flying above a modern metropolis.",
  "a virtual reality gamer experiencing a whimsical, digital fantasy world.",
  "a fashion-forward teen with holographic accessories, walking in a future city.",
  "a medieval knight with a plasma sword, facing a high-tech dragon.",
  "an alien explorer in an anime style, discovering a lush, unknown planet.",
  "a time traveler stepping out of a portal into a bustling future marketplace.",
  "a chef cooking exotic dishes with molecular gastronomy in a futuristic kitchen.",
  "a mystical forest guardian with magical powers, in an enchanted woodland.",
  "a rebel leader giving a speech in a dystopian world, anime style.",
  "a vampire hunter in a neo-gothic city, armed with futuristic weapons.",
  "a pirate captain navigating a flying ship through stormy, cloud-filled skies.",
  "a young inventor showcasing her latest gadgets in a high-tech expo.",
  "a cybernetic surgeon performing advanced procedures in a futuristic hospital.",
  "an intergalactic diplomat in a shimmering gown, at a space station summit.",
  "a mechanic working on robotic creatures in a futuristic wildlife sanctuary.",
  "a secret agent on a hoverbike, chasing villains through a neon city.",
  "a scholar studying ancient runes in a library filled with holographic books.",
  "a cyberpunk street artist creating a vibrant mural on a skyscraper wall.",
  "a dragon rider soaring above a modern cityscape, blending fantasy and reality.",
  "a scientist experimenting with portal technology in a high-tech lab.",
  "a mystical shaman summoning spirits in a neon-lit, urban jungle.",
  "a racer in a futuristic motorsport, speeding through a digital track.",
  "a space explorer encountering new life forms on an exotic jungle planet.",
  "a fire mage battling robotic foes in a dystopian, war-torn landscape.",
  "a pop star performing a holographic concert in a bustling future city.",
  "a nomad traversing a desert wasteland with advanced survival gear.",
  "a martial artist training with holographic opponents in a high-tech dojo.",
  "a treasure hunter discovering ancient tech in a post-apocalyptic world.",
  "a diplomat navigating political intrigue in a galactic federation, anime style.",
  "a hacker infiltrating secure networks in a digital world, anime-inspired.",
  "a graffiti artist tagging virtual reality spaces in a futuristic city.",
  "a pilot commanding a battle mech in a high-stakes, futuristic war.",
  "a witch blending ancient magic and modern technology in her spells.",
  "a journalist reporting groundbreaking events in a dynamic, future society.",
  "a fashion designer creating avant-garde looks with interactive fabrics.",
  "an archaeologist uncovering alien artifacts on a deserted, ancient planet.",
  "a bounty hunter tracking down fugitives in a sprawling space colony.",
  "a ghost hunter investigating paranormal activity in a neo-Victorian city.",
  "a cybernetic athlete competing in a global, futuristic sport tournament.",
  "a rebel hacker fighting against a dystopian government, anime style.",
  "a musician composing a symphony with futuristic, aI instruments.",
  "a detective solving virtual reality crimes in a high-tech noir city.",
  "a mage casting enchantments in a bustling, magical metropolis.",
  "a space smuggler negotiating deals in the underworld of a starport.",
  "a bioengineer creating hybrid plants in a lush, futuristic greenhouse.",
  "a student attending a floating university in a utopian future city.",
  "a pilot racing through canyons in a high-speed, anti-gravity vehicle.",
  "an explorer navigating a digital landscape in a virtual reality adventure.",
  "a cybernetic monk meditating in a temple blending tradition and technology.",
  "a superheroine with psionic powers defending a futuristic city.",
  "a spelunker exploring crystal-filled caves in an alien world.",
  "a dancer performing with holographic effects in a vibrant nightclub.",
  "a park ranger protecting endangered species in a high-tech nature reserve.",
  "a linguist decoding alien languages in an interstellar embassy.",
  "a gamer competing in a virtual reality esports championship.",
  "a street performer with robotic puppets in a bustling future plaza.",
  "a climate scientist working in a geoengineering facility to restore Earth.",
  "an ambassador representing Earth in a galactic council, anime style.",
  "a survivalist braving a post-apocalyptic world overrun by nature.",
  "a mountain climber scaling a peak on an exotic, terraformed planet.",
  "a rancher herding genetically engineered animals on a distant colony.",
  "a pilot navigating a solar sailcraft through an asteroid field.",
  "a starship engineer repairing engines in the depths of space.",
  "a rogue aI seeking humanity in a world dominated by technology.",
  "a mage dueling in a high-stakes tournament in a floating arena.",
  "a wanderer exploring the ruins of an ancient civilization on Mars.",
  "a scientist developing a cure for a pandemic in a future world.",
  "an explorer charting unexplored territories in a virtual reality universe.",
  "a telepath negotiating peace in a war-torn, futuristic society.",
  "a starfighter ace engaged in a dogfight in a distant nebula.",
  "a diplomat forging alliances in a universe filled with diverse alien races.",
  "a sorcerer blending elemental magic with futuristic science.",
  "a rebel leading an uprising against a corrupt, high-tech empire.",
  "a spy infiltrating a gala in a city of flying buildings.",
  "a biologist studying exotic creatures in a bio-domed alien forest.",
  "a time traveler visiting key historical events in a futuristic suit.",
  "a thief mastering parkour to escape in a densely populated mega-city.",
  "a fighter pilot engaging in a high-altitude battle in a war-torn sky.",
  "a quantum physicist unraveling the mysteries of the multiverse.",
  "a cyborg adapting to human society in a world of advanced robotics.",
  "a guardian protecting a sacred artifact in a temple of light.",
  "a martial arts master training in an ancient temple with futuristic upgrades.",
  "a space miner extracting rare minerals from a volatile asteroid.",
  "an illusionist performing mind-bending tricks in a future metropolis.",
  "a commander leading a fleet in an interstellar battle, anime style.",
  "a scientist experimenting with merging human consciousness with aI.",
  "a rogue exploring the depths of a neon-lit, cyberpunk underworld.",
  "a healer using advanced technology to treat patients in a futuristic clinic.",
  "a smuggler navigating treacherous routes in a dystopian world.",
  "a psychic detective solving supernatural crimes in a modern city.",
  "a mercenary fighting in a corporate war over resource-rich planets.",
  "a monk preserving ancient wisdom in a world of fleeting digital memories.",
  "an architect designing sustainable habitats in a world recovering from climate change.",
  "a diviner interpreting cosmic events in a technologically advanced society.",
  "masterpiece, best quality, 1girl, solo, cherry blossoms, hanami, pink flower, white flower, spring season, wisteria, petals, flower, plum blossoms, outdoors, falling petals, white hair, black eyes",
  "masterpiece, best quality, a futuristic cityscape at dusk, with neon lights and flying cars, in the style of a detailed anime.",
  "masterpiece, best quality, an android warrior in a post-apocalyptic setting, wearing advanced armor, anime style.",
  "masterpiece, best quality, a whimsical forest filled with glowing, magical creatures, reminiscent of a fantasy anime.",
  "masterpiece, best quality, a sleek, high-speed train zooming through a futuristic metropolis, anime aesthetic.",
  "masterpiece, best quality, a group of anime-style adventurers exploring a technologically advanced dungeon.",
  "masterpiece, best quality, an underwater city with bioluminescent plants and futuristic submarines, anime-inspired.",
  "masterpiece, best quality, a space station bustling with diverse alien life, in a colorful anime style.",
  "masterpiece, best quality, a futuristic sports event with robots and humans competing, in an anime style.",
  "masterpiece, best quality, a cyberpunk street market, bustling and neon-lit, anime-style.",
  "masterpiece, best quality, an anime character piloting a high-tech, futuristic mech suit.",
  "masterpiece, best quality, a serene, futuristic Zen garden with holographic plants, anime style.",
  "masterpiece, best quality, a bustling intergalactic port with spaceships and aliens, in a vivid anime style.",
  "masterpiece, best quality, a group of anime friends having a picnic in a floating city above the clouds.",
  "masterpiece, best quality, a magical library with floating books and mystical artifacts, anime aesthetics.",
  "masterpiece, best quality, a high-tech laboratory with advanced aI assistants, in a sleek anime style.",
  "an anime-style fashion show with futuristic clothing and holographic accessories.",
  "masterpiece, best quality, a hidden village in a futuristic world, blending nature and technology, anime style.",
  "masterpiece, best quality, an anime hero standing atop a futuristic skyscraper, overlooking a neon city.",
  "masterpiece, best quality, a cybernetic forest with metallic trees and digital wildlife, anime-inspired.",
  "masterpiece, best quality, a virtual reality adventure in a fantastical anime world.",
  "masterpiece, best quality, a futuristic anime-style classroom with holographic desks and aI teachers.",
  "masterpiece, best quality, a moon base with a breathtaking view of Earth, anime aesthetics.",
  "masterpiece, best quality, a high-speed chase on hoverbikes through a neon-lit city, anime style.",
  "masterpiece, best quality, an enchanted anime garden with floating islands and mythical creatures.",
  "masterpiece, best quality, a futuristic concert with holographic performers and a vibrant anime crowd.",
  "masterpiece, best quality, a space colony on Mars, with domed habitats and advanced tech, anime style.",
  "masterpiece, best quality, a cyberpunk detective in a neon-lit city, anime aesthetic.",
  "masterpiece, best quality, a virtual paradise with surreal landscapes and whimsical elements, anime-inspired.",
  "masterpiece, best quality, a futuristic anime-style café floating in space, with cosmic views.",
  "masterpiece, best quality, an anime character discovering an ancient, high-tech civilization.",
  "masterpiece, best quality, a fantasy anime festival with lanterns, mythical beasts, and magical fireworks.",
  "masterpiece, best quality, a high-tech, anime-style amusement park with futuristic rides and attractions.",
  "masterpiece, best quality, a mythical anime forest with enchanted trees and luminous flora.",
  "masterpiece, best quality, a bustling spaceport in a distant galaxy, anime style.",
  "masterpiece, best quality, an anime-style underwater adventure with mermaids and high-tech submarines.",
  "masterpiece, best quality, a futuristic city with blending traditional Japanese architecture and cyberpunk elements, anime style.",
  "masterpiece, best quality, a cyber-enhanced anime superhero in a dynamic pose, with a futuristic city background.",
  "masterpiece, best quality, a whimsical anime candy land with colorful, imaginative treats and landscapes.",
  "masterpiece, best quality, an anime-style street race with futuristic motorcycles and neon lights.",
  "masterpiece, best quality, a magical anime academy in the clouds, with floating classrooms and mythical creatures.",
  "masterpiece, best quality, a surreal, futuristic art gallery with interactive holographic exhibits, anime style.",
  "masterpiece, best quality, an anime space adventure with colorful planets and quirky alien companions.",
  "masterpiece, best quality, a high-tech anime hospital with advanced medical robots and futuristic equipment.",
  "masterpiece, best quality, a cyberpunk bar with neon signs and diverse, futuristic clientele, anime style.",
  "masterpiece, best quality, an anime-inspired magical duel in a futuristic arena with high-tech spells.",
  "masterpiece, best quality, a whimsical anime-style theme park with futuristic fairy tale attractions.",
  "masterpiece, best quality, a cozy, futuristic anime-style bookstore with interactive, floating books.",
  "masterpiece, best quality, a cybernetic anime jungle with robotic animals and lush, digital vegetation.",
  "masterpiece, best quality, an anime-style wedding in a futuristic, enchanting garden.",
  "masterpiece, best quality, a high-speed anime space battle with sleek starfighters and epic explosions.",
  "masterpiece, best quality, a futuristic, anime-style police chase with hovercars and drones.",
  "masterpiece, best quality, an anime-inspired cooking competition with futuristic kitchen gadgets.",
  "masterpiece, best quality, a magical anime pet shop with mythical creatures and high-tech habitats.",
  "masterpiece, best quality, a futuristic anime-style fashion boutique with smart clothing and holographic mirrors.",
  "an enchanted anime forest with talking animals and magical treehouses.",
  "masterpiece, best quality, a high-tech anime spaceship exploring an unknown galaxy.",
  "masterpiece, best quality, a cyberpunk cityscape with towering skyscrapers and neon billboards, anime style.",
  "masterpiece, best quality, an anime-style underwater exploration with mythical sea monsters and futuristic gear.",
  "masterpiece, best quality, a future anime-style university campus with advanced learning technology.",
  "masterpiece, best quality, a magical anime carnival with enchanted rides and mystical performers.",
  "masterpiece, best quality, a futuristic anime concert with virtual idols and a holographic audience.",
  "masterpiece, best quality, an anime-style space colony with biodomes and futuristic agriculture.",
  "masterpiece, best quality, a high-tech anime museum with interactive historical exhibits and holographic guides.",
  "a cybernetic anime warrior in an epic battle scene, with futuristic city ruins.",
  "a whimsical anime-style ice cream parlor with imaginative flavors and magical décor.",
  "a futuristic anime-style shopping mall with floating shops and holographic displays.",
  "an enchanted anime-style castle floating in the sky, with advanced technology.",
  "a high-speed anime-style train journey through a futuristic landscape.",
  "a cyberpunk anime-style office with advanced tech and neon accents.",
  "an anime-inspired adventure in a digital world with surreal landscapes.",
  "a futuristic anime-style beach with glowing sand and bioluminescent waves.",
  "an anime-style mecha showdown in a futuristic urban setting.",
  "a magical anime greenhouse with exotic, sentient plants and high-tech care systems.",
  "a cyberpunk anime-style nightclub with a futuristic DJ and holographic dancers.",
  "an anime-style superhero team strategizing in their high-tech hideout.",
  "a whimsical, anime-style bakery in a futuristic city, with inventive pastries.",
  "a high-tech anime-style sports arena with futuristic games and neon lights.",
  "an anime-style treasure hunt in a futuristic, digital world.",
  "a cybernetic anime-style fashion designer creating futuristic outfits.",
  "an anime-inspired enchanted forest with mystical creatures and magical glows.",
  "a futuristic anime-style arcade with advanced, immersive games.",
  "an anime-style botanical garden in space, with exotic alien plants.",
  "a high-tech anime-style zoo with holographic animals and interactive exhibits.",
  "a cyberpunk anime-style street scene with diverse characters and advanced gadgets.",
  "an anime-style magical girl transformation in a futuristic setting.",
  "a whimsical anime-style floating market with flying vendors and magical goods.",
  "a futuristic anime-style police station with advanced crime-solving technology.",
  "an anime-inspired interstellar journey with colorful nebulae and exotic planets.",
  "a high-tech anime-style gym with advanced fitness equipment and virtual trainers.",
  "a cyberpunk anime-style heist with a team of futuristic thieves.",
  "an anime-style spacewalk with astronauts exploring a futuristic space station.",
  "a magical anime-style potion shop with enchanted brews and high-tech equipment.",
  "a high-tech anime-style courtroom with futuristic justice technology.",
  "a cyberpunk anime-style rooftop garden with neon lights and advanced agriculture.",
  "an anime-style battle between wizards and robots in a futuristic city.",
  "a whimsical anime-style pet café with magical creatures and high-tech amenities.",
  "a futuristic anime-style train station with holographic timetables and floating platforms.",
  "an anime-inspired intergalactic exploration with a diverse crew and advanced tech.",
  "a high-tech anime-style laboratory researching magical phenomena.",
  "a cyberpunk anime-style alleyway with graffiti and a hidden high-tech speakeasy.",
  "A futuristic cityscape with a robot street performer playing an LED-lit violin",
  "A cyborg with a transparent head revealing a miniature galaxy inside",
  "An astronaut floating in a nebula, surrounded by cosmic butterflies",
  "A medieval knight with advanced robotic armor, standing in a futuristic castle",
  "A surreal landscape with giant, colorful mushrooms and a small robot picking them",
  "A human-plant hybrid character tending to an alien garden under a purple sky",
  "An underwater city with mermaid-like robots swimming among coral skyscrapers",
  "A scene of a human and robot dancing in zero gravity inside a spaceship",
  "A post-apocalyptic world where a lone cyborg wanders a desert with techno-oasis",
  "A steampunk inventor in a Victorian-era workshop, creating a mechanical dragon",
  "A holographic fashion show with models displaying futuristic, light-based clothing",
  "A fantasy scene with elves and robots working together to forge a magical sword",
  "A cyberpunk street market bustling with diverse alien species and robotic vendors",
  "An interstellar explorer encountering a mysterious, ancient alien monolith",
  "A dystopian city skyline with flying cars and giant digital billboards",
  "A giant, sentient robot peacefully coexisting with wildlife in a lush forest",
  "A magical library in space, with books floating around and an alien librarian",
  "A virtual reality world where humans and avatars interact in an impossible city",
  "An abandoned amusement park, reclaimed by nature, with a solitary robot custodian",
  "A high-tech laboratory where scientists are building a portal to another dimension",
  "A space station garden with a human and a robot tending to zero-gravity plants",
  "A dreamlike scene of a floating island with a house and a robot gardening",
  "A post-apocalyptic survivor with a robotic arm scavenging in a deserted city",
  "A digital artist creating a holographic masterpiece in a futuristic studio",
  "A robot rebellion with cyborgs and humans fighting side by side",
  "A scene of an ancient temple with futuristic technology hidden within",
  "An ice planet with a lone explorer and a robotic sled dog team",
  "A cybernetic samurai facing off against a dragon in a neon-lit Tokyo",
  "A cyberpunk hacker with a bright mohawk hairstyle, leather jacket, and cybernetic implants, typing code on a holographic computer",
  "An astronaut in a sleek white spacesuit planting the American flag on Mars, red dust and rocks in background, Earth visible in sky",
  "A beautiful female android with long silver hair, glowing blue eyes, pale skin, standing in slick futuristic nightclub",
  "A scientist in a lab coat developing nanobots, high tech microscopes and equipment in background",
  "A pilot with an oxygen mask flying a stealth spaceship through dense asteroid field, firing lasers, cockpit visible",
  "A combat cyborg with black bionic arms playing an electric guitar during an apocalyptic thunderstorm, surrounded by rubble",
  "A classic robot butler in suit neatly serving tea to elegant lady on hovering chairs in pristine white room with view of cityscape",
  "An elf ranger with bow aimed, long hair, cloak, armor, standing amid mystical ruins overgrown with vines",
  "A fierce post-apocalyptic warrior battling mutated beasts in abandoned city streets filled with rubble and overgrown plants",
  "An engineer building a teleportation device, lab filled with computers, cables, and glowing portal",
  "A wizard with staff casting a magic spell, mystical runes surrounding, ancient ruins in misty mountains behind",
  "A pale vampire with fangs at futuristic nightclub filled with bright neon lights, dancing crowd wearing stylish outfits",
  "A soldier in futuristic armor aiming a laser rifle, muzzle flash visible, battlefield filled with smoke behind",
  "A young hacker programming holographic computer displaying complex code, warehouse with graffiti and high tech equipment around",
  "A samurai with robotic armor and laser katana fighting an enormous, fire-breathing dragon roaring",
  "A muscular mutant superhero with chainsawed arms rescuing humans from the rubble of a collapsed building",
  "A steampunk inventor wearing goggles tinkering on a mechanical robot as gears turn, pipes vent steam in workshop",
  "A Jedi Knight wielding a lightsaber leaving a trail of light, facing off against an enemy with a red lightsaber in nighttime forest",
  "A pilot controlling a large battle mech, engaging enemy robots and tanks on city streets filled with explosions",
  "A cowboy with facemask riding a galloping robotic horse with rocket boosters through the desert near pyramids and a spaceship crash site",
  "A beautiful cyborg DJ at flashy neon rave wearing LED glasses and arm implants, deadmau5-style helmet, operating glowing holographic turntables",
  "A smiling girl hugging her tall, lean four-legged robot dog with screens for eyes in a sunny green meadow dotted with flowers",
  "A classic square robot with an artist's beret carefully painting an abstract picture on canvas in art studio with paint tubes and brushes",
  "A ninja assassin clad in black with masks leaping between high tech skyscrapers at night, throwing knives at armored target",
  "An old wizard with long white beard wearing robes and pointed hat riding a sleek, colorful hoverboard through mysterious ruins",
  "A hacker jacked into virtual reality, coding on screens displaying cyberspace environment with digital rain and architectural structures",
  "A female elf ranger with bow crouching in vivid lush forest with sunlight streaming through the trees behind her",
  "A neural-linked gamer wearing a headset controlling a humanoid robot fighting in global tournament arena filled with drones and holographic crowds",
  "A diverse crew including humans, cyborgs, androids on the bridge of an exploratory starship venturing into deep space about to engage warp speed, captain in center seat",
  "An android with exposed machinery playing speed chess with a human opponent in slick room with bookshelves and trophy case",
  "A girl befriending a cute fluffy alien with large dark eyes sitting together among grass and alien mushrooms glowing under beautiful night sky",
  "A scientist injecting himself with experimental nanomachines, body merging with mechanical parts with blue glow visible through seams in skin",
  "A shiny humanoid robot with tracks instead of legs exploring Mars desert, red rocks and cliffs visible under orange sky",
  "A futuristic spaceship with glowing engines engaging warp speed, leaving stretched star trails behind approaching massive gas giant planet with rings",
  "A young hacker programming next-gen AI displaying code on multiple holographic screens inside warehouse with graffiti",
  "A battlefield depicting the aftermath of a violent robot uprising against humans, damaged machinery leaking oil and sparks among rubble",
  "A sleek cyborg assassin levitating off the ground using built-in antigravity tech, surrounded by floating holographic data streams in dark room",
  "An astronaut in advanced spacesuit taking first step onto surface of inhabitable exoplanet, expansive vista of alien landscape and sky visible ",
  "A biohacker in makeshift basement lab injecting neon glowing DNA vials, genetic engineering equipment with blinking screens around",
  "A smiling girl engaging in friendly conversation with a hovering orb-shaped AI displaying animated expressions - cityscape visible through windows behind",
  "A classic robot butler in suit neatly serving tea to masked elites seated on hovering chairs in pristine penthouse suite with expansive city views",
  "A futuristic battleship leading a small fleet against a larger mothership over earth, visible in background through cockpit window, firing bright weapons leaving glowing trails",
  "An android with exposed machinery thoroughly engrossed in playing immersive sci-fi virtual reality game, cables linking body to computer servers",
  "A hoverbike gang riding sleek colorful bikes leaving neon trails through nighttime city streets lined with holographic billboards and signs",
  "A hacker jacked into the virtual architecture of a sinister megacorporation consisting of ominous towering structures, coding on screens showing cyberspace",
  "A scientist developing neural implants and prosthetic limbs for radical new human augmentation procedures in lab filled with computers, robotic arms, and vials",
  "A fighter pilot targeting enemy attack drones during intense aerial dogfight, firing missiles while performing evasive maneuvers, wings of advanced jet visible in cockpit",
  "A shapeshifting assassin android impersonating a human to infiltrate high-security gala, preparing to draw handgun concealed under elegant evening gown",
  "A damaged explorer robot examining mysterious glowing hieroglyphs inside ancient towering alien ruins, strange structures and technologies overgrown with vines behind",
  "The crew of a sleek exploratory starship entering cryogenic pods before faster-than-light journey, automated systems visible maintaining ship operations",
  "A hooded hacker decrypting data stolen from crash-landed alien scout ship, strings of symbols on computer screens inside warehouse with graffiti and exposed brick",
  "A smiling girl affectionately hugging cute short robot companion with blinking monitor for a face, grass and blue sky in background",
  "An astronaut triumphantly planting American flag on surface of Mars, bootprints in red soil with Earth visible in orange sky above",
  "A scientist carefully monitoring array of computer servers, cables linking equipment to jar with synthetic brain inside glowing yellow liquid",
  "A female android wearing 1950s style uniform smiling while efficiently serving milkshakes to laughing customers at neon-lit diner with spaceship visible through window",
  "A pilot in advanced spacesuit ejecting from cockpit of experimental aircraft, firing built-in rocket boosters, flames and smoke trails visible behind",
  "A hacker stealing corporate secrets in virtual reality representation of office tower, coding on screens showing cyberspace architecture",
  "A menacing cyborg with half its head replaced by glowing machinery playing chess against an unbeatable AI supercomputer in sleek room",
  "A genetically engineered dinosaur with spiked tail kept on chain leash by soldier in futuristic armor, abandoned buildings visible behind rubble",
  "A classic robot butler managing smart home, efficient serving dinner to family while monitoring various devices and appliances simultaneously",
  "The crew of a Federation starship including humans, aliens, androids gathering for first contact ritual, bridge filled with slick interfaces, planet visible through window",
  "An assassin android impersonating doctor to infiltrate prison, readying lethal injection hidden in coat",
  "An affectionate girl gently embracing her dog-sized robot companion with tank treads and a single blinking eye for a head",
  "A muscular cyborg prize fighter covered in tattoos and cybernetics battling a menacing opponent in caged arena surrounded by cheering audience",
  "A wizard experimenting with combining futuristic tech like forcefields, levitation, and advanced genetics with magical essences, artifacts, and spellbooks",
  "The crew of a exploratory vessel looking shocked as their ship is flung into the outer solar system after narrowly surviving an experimental faster than light engine misjump",
  "A hacker manipulating global stock prices with orbital quantum computer running advanced AI stock trading algorithms, screens displaying dizzying data dashboards",
  "A musician directing an orchestra made up of various aliens including tall, elegant bird-like creatures playing lyrical stringed instruments",
  "A barely functioning explorer robot caked in red dust examining strange slimy liquid oozing from orifices of biomechanical structures half-buried on hellish volcanic Venusian surface",
  "A massive battlecruiser firing all weapons against reptilian capital ship in orbit over gas giant planet with swirling eyes and many moons while several smaller craft are destroyed around it",
  "An astronaut spacewalking outside slowly rotating space station near luminous nebula, performing repairs on damaged solar panel torn open by micrometeorite",
  "A scientist overseeing construction of a microscopic nanobot swarm designed for programmable biological editing, petri dishes filled with the bots visible under microscopes",
  "An alien ambassador with large head, slender body, big glossy eyes signing treaty documents as cameras flash at gathering of various press and leaders in front of United Nations building with flags out front",
  "A smiling blonde female android wearing 1950's uniform roller skating around flashing neon diner taking orders from seated customers which include aliens and robots",
  "The crew of the starship Galileo looking stunned by large creature on viewscreen rumbling deep incomprehensible noises during tense first contact event on planet with pink sky visible from hull",
  "A battered, dusty six legged scavenger robot examining wreckage of ancient human skyscrapers being reclaimed by desert sand with a storm brewing in red distance",
  "Interior view of experimental warp fighter cockpit with softly glowing controls and HUD helmet as test pilot prepares to push craft past light speed barrier",
  "A stealthy assassin android with night vision eyes infiltrating top secret research base, silently taking out armored guards with knife and garrote wire",
  "A hacker remotely infiltrating systems of Arasaka Corporation tower through virtual cyberspace of swirling data, coding on terminal displaying access nodes",
  "A ragged crew narrowly escaping from the massive beak of giant space-dwelling star kraken amid debris of destroyed ships with laser blasts visible ",
  "A futuristic armored soldier psyching up cleverly disguised, bio-engineered alternate dinosaur before releasing it onto battlefield filled with chaos",
  "An astronaut haunted by frightening tentacled entities only he can perceive, futilely struggling as they drag him toward dark pit on icy surface of moon Europa",
  "An android with perfected human mannerisms eagerly answering trivia questions on stage surrounded by cheering audience and swirling lights",
  "A neon gang member racing law enforcement hover drones through decaying skyscrapers on supersonic hover bike leaving glowing particle trails",
  "A wizard adept in both mystic arts and illegal tech spare parts channeling lightning while battling mercenaries and gun turrets",
  "Crew of experimental warpship regaining stunned senses as disabled craft tumbles out of control with streaking stars visible through cockpit window",
  "A scientist in biohazard suit carefully dissecting elongated skull and tentacled extremities of an alien corpse on operating table in underground bunker",
  "A desperate rebel freedom fighter racing across battlefield strewn with titanic mechs and wreckage toward extraction ship waiting open in the smoke-filled skies",
];

export function getRandomIdeas() {
  let numItems = 2;
  let result = new Array(numItems);
  let len = imagePrompts.length;
  let taken = new Array(len);

  if (numItems > len)
    throw new RangeError("getRandomItems: more items requested than available");

  while (numItems--) {
    let x = Math.floor(Math.random() * len);
    result[numItems] = imagePrompts[x in taken ? taken[x] : x];
    taken[x] = --len in taken ? taken[len] : len;
  }
  return result;
}
