# Copyright (c) Fairlearn contributors.
# Licensed under the MIT License.
"""
This script generates an html table of contributors, with names and avatars.
The list is generated from Fairlearn's teams on GitHub.
It's originally copied from scikit-learn and adapted for Fairlearn.
"""
from os import path
from pathlib import Path

REPO_FOLDER = Path(path.abspath(__file__)).parent.parent

MAINTAINERS = {
    "adrinjalali": "Adrin Jalali",
    "hildeweerts": "Hilde Weerts",
    "mmadaio": "Michael Madaio",
    "MiroDudik": "Miro Dudik",
    "riedgar-ms": "Richard Edgar",
    "romanlutz": "Roman Lutz",
    "alliesaizan": "Allie Saizan",
    "tamaraatanasoska": "Tamara Atanasoska",
}


def generate_table(maintainers):
    lines = [
        ".. raw :: html\n",
        "    <!-- Generated by generate_maintainers_table.py -->",
        '    <div class="maintainers-container">',
        "    <style>",
        "      img.avatar {border-radius: 10px;}",
        "    </style>",
    ]
    for alias, name in maintainers.items():
        lines.append("    <div>")
        lines.append(
            "    <a href='%s'><img src='%s' class='avatar' /></a> <br />"
            % (f"https://github.com/{alias}", f"https://github.com/{alias}.png")
        )
        lines.append("    <p>%s</p>" % (name,))
        lines.append("    </div>")
    lines.append("    </div>")
    return "\n".join(lines)


if __name__ == "__main__":
    with open(REPO_FOLDER / "docs" / "about" / "maintainers.rst", "w+") as rst_file:
        rst_file.write(generate_table(MAINTAINERS))
