"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("./util");
function callTaskParser(parser, streams) {
    return parser(streams.stdOut, streams.stdErr);
}
exports.callTaskParser = callTaskParser;
function parseStringResponse(result, parsers, text) {
    for (let lines = util_1.toLinesWithContent(text), i = 0, max = lines.length; i < max; i++) {
        const line = (offset = 0) => {
            if ((i + offset) >= max) {
                return;
            }
            return lines[i + offset];
        };
        parsers.some(({ parse }) => parse(line, result));
    }
    return result;
}
exports.parseStringResponse = parseStringResponse;
//# sourceMappingURL=task-parser.js.map