"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("./util");
function filterType(input, filter, def) {
    if (filter(input)) {
        return input;
    }
    return (arguments.length > 2) ? def : undefined;
}
exports.filterType = filterType;
exports.filterArray = (input) => {
    return Array.isArray(input);
};
function filterPrimitives(input, omit) {
    return /number|string|boolean/.test(typeof input) && (!omit || !omit.includes((typeof input)));
}
exports.filterPrimitives = filterPrimitives;
exports.filterString = (input) => {
    return typeof input === 'string';
};
function filterPlainObject(input) {
    return !!input && util_1.objectToString(input) === '[object Object]';
}
exports.filterPlainObject = filterPlainObject;
function filterFunction(input) {
    return typeof input === 'function';
}
exports.filterFunction = filterFunction;
exports.filterHasLength = (input) => {
    if (input == null || 'number|boolean|function'.includes(typeof input)) {
        return false;
    }
    return Array.isArray(input) || typeof input === 'string' || typeof input.length === 'number';
};
//# sourceMappingURL=argument-filters.js.map