/// <reference types="node" />
export declare const EMPTY_COMMANDS: [];
export declare type TaskResponseFormat = Buffer | string;
export interface TaskParser<INPUT extends TaskResponseFormat, RESPONSE> {
    (stdOut: INPUT, stdErr: INPUT): RESPONSE;
}
export interface EmptyTaskParser<RESPONSE> {
    (): RESPONSE;
}
export interface SimpleGitTaskConfiguration<RESPONSE, FORMAT, INPUT extends TaskResponseFormat> {
    commands: string[];
    format: FORMAT;
    parser: TaskParser<INPUT, RESPONSE>;
    onError?: (exitCode: number, error: string, done: (result: INPUT) => void, fail: (error: string) => void) => void;
    /**
     * @deprecated
     * Use of `concatStdErr` is now deprecated, to be removed by v2.50.0 (or on upgrading to v3).
     * Instead, use the `stdErr` argument supplied to the `parser`
     */
    concatStdErr?: boolean;
}
export declare type EmptyTask<RESPONSE = void> = SimpleGitTaskConfiguration<RESPONSE, 'utf-8', string> & {
    commands: typeof EMPTY_COMMANDS;
    parser: EmptyTaskParser<RESPONSE>;
};
export declare type StringTask<R> = SimpleGitTaskConfiguration<R, 'utf-8', string>;
export declare type BufferTask<R> = SimpleGitTaskConfiguration<R, 'buffer', Buffer>;
export declare type RunnableTask<R> = StringTask<R> | BufferTask<R>;
export declare type SimpleGitTask<R> = RunnableTask<R> | EmptyTask;
export declare function adhocExecTask<R>(parser: () => R): StringTask<R>;
export declare function configurationErrorTask(error: Error | string): EmptyTask;
export declare function straightThroughStringTask(commands: string[], trimmed?: boolean): StringTask<string>;
export declare function isBufferTask<R>(task: SimpleGitTask<R>): task is BufferTask<R>;
export declare function isEmptyTask<R>(task: SimpleGitTask<R>): task is EmptyTask;
