"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const parse_push_1 = require("../parsers/parse-push");
const utils_1 = require("../utils");
function pushTagsTask(ref = {}, customArgs) {
    utils_1.append(customArgs, '--tags');
    return pushTask(ref, customArgs);
}
exports.pushTagsTask = pushTagsTask;
function pushTask(ref = {}, customArgs) {
    const commands = ['push', ...customArgs];
    if (ref.branch) {
        commands.splice(1, 0, ref.branch);
    }
    if (ref.remote) {
        commands.splice(1, 0, ref.remote);
    }
    utils_1.remove(commands, '-v');
    utils_1.append(commands, '--verbose');
    utils_1.append(commands, '--porcelain');
    return {
        commands,
        format: 'utf-8',
        parser: parse_push_1.parsePushResult,
    };
}
exports.pushTask = pushTask;
//# sourceMappingURL=push.js.map