"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const parse_move_1 = require("../parsers/parse-move");
const utils_1 = require("../utils");
function moveTask(from, to) {
    return {
        commands: ['mv', '-v', ...utils_1.asArray(from), to],
        format: 'utf-8',
        parser(stdOut, stdErr) {
            return parse_move_1.parseMoveResult(stdOut, stdErr);
        }
    };
}
exports.moveTask = moveTask;
//# sourceMappingURL=move.js.map