"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const BranchDeleteSummary_1 = require("../responses/BranchDeleteSummary");
const utils_1 = require("../utils");
const deleteSuccessRegex = /(\S+)\s+\(\S+\s([^)]+)\)/;
const deleteErrorRegex = /^error[^']+'([^']+)'/m;
const parsers = [
    new utils_1.LineParser(deleteSuccessRegex, (result, [branch, hash]) => {
        const deletion = BranchDeleteSummary_1.branchDeletionSuccess(branch, hash);
        result.all.push(deletion);
        result.branches[branch] = deletion;
    }),
    new utils_1.LineParser(deleteErrorRegex, (result, [branch]) => {
        const deletion = BranchDeleteSummary_1.branchDeletionFailure(branch);
        result.errors.push(deletion);
        result.all.push(deletion);
        result.branches[branch] = deletion;
    }),
];
exports.parseBranchDeletions = (stdOut) => {
    return utils_1.parseStringResponse(new BranchDeleteSummary_1.BranchDeletionBatch(), parsers, stdOut);
};
function hasBranchDeletionError(data, processExitCode) {
    return processExitCode === utils_1.ExitCodes.ERROR && deleteErrorRegex.test(data);
}
exports.hasBranchDeletionError = hasBranchDeletionError;
//# sourceMappingURL=parse-branch-delete.js.map