---
title: Interviewing with Housing.com
date: 12/01/2016
description: My experience and lessons learnt from interviewing with a leading Indian tech startup.
thumbnail: housing.jpg
---

![](./housing.jpg){.full-width}

*Disclaimer: The opinions expressed in this article are my own and are, in no conceivable way, connected, correlated or inspired by those of Housing.com or its employees and representatives.*

With that verbose legalese out of the way, let's get started.

#### Motivation
I am a passionate follower :v: of the tech twitterati :sparkles:, particularly the 'web technologies' twitterati :sparkles:. Of late, the twitterverse :earth_americas: has been flooded with mentions of a new breed of experience for the web, particularly, the mobile web. [Progressive Web Applications](https://developers.google.com/web/progressive-web-apps/) (or PWAs) :zap: are the next big thing when it comes to providing fast, reliable and engaging experiences, akin to those of native apps, right from the browser.
Now, among the immediately visible players in India, who have placed their bets on PWAs, [Flipkart](http://tech-blog.flipkart.net/2015/11/progressive-web-app/) and [Housing.com](https://www.youtube.com/watch?v=dug_6lgZ7dw) are the behemoths. Given my background of fiddling with technologies that go into making said PWAs, I decided to approach the latter with the proposition of pooling our know-how and building cool stuff together.

#### First Contact
There are many ways to approach a tech company when it comes to jobs. One could ask for a reference from current employees, reach out to a hiring manager, fill in the forms on the careers webpage, or just send out a cold email precisely stating one's credentials and motivations. I decided to go with that last one. The email was as to-the-point as it gets. I mentioned a bit about my weird educational background :grimacing:, some related previous projects and genuine motivation to work at Housing.com.

#### Did It Work Though?
Yes, it did :open_mouth:. That's lesson number one right here.

>If your motivations are genuine and your credentials are sound, don't be afraid to reach out to a company you want to work with. This holds even if you think there might not be any vacancies. Make the effort to reach out and show positive interest.

The following day, I received an email from the Head of HR at Housing.com, which was followed by a call shortly thereafter. She informed me that they found my profile interesting and wanted to schedule a technical interview the very same day. I consented and started brushing up on those tricky space and time complexity questions :fearful:.

#### Technical Round 1
It's not everyday that you get an interview from a cold email, so I guess I must have been really lucky. And that luck ran out quickly indeed. At the predetermined time, I went AWOL :no_mouth:. My interviewer and the Head of HR left me a couple of calls and Skype messages which I did not return. This is a gross violation of the interviewing etiquette. I have rarely been more ashamed of my conduct. In my defense, I got caught up with an emergency at my current engagement but that doesn't cut it out. At this point, I believed I had blown the opportunity but I left a sincere apology with both the interviewer and my HR POC.

#### Technical Round 1 - Encore
Luckily, my interviewer was awesome :sunglasses: and agreed to schedule another Skype call for the next day. That's lesson number two for youngins:

>Throughout the interview process, keep your outlook absolutely positive. Face rejection with grace and acceptance with humility. Never let the outcome, be it good or bad, get to your head. This is not the last company in the world and you most certainly are not their last prospective employee.

The interview was really intensive, thought provoking and thorough. We started off discussing my weird educational background :grimacing: and followed it up with some live coding in an online collaborative IDE. I was asked a couple of questions each regarding ECMAScript standard functions, basic algorithmic complexity and tricky JS gotchas. To conclude, the panel asked me questions about front end tooling, particularly [React](https://facebook.github.io/react/), [Redux](http://redux.js.org/) and [Webpack](http://webpack.js.org/). These questions were mostly practical and involved some code that I had to reason about. To sum it up:

>Housing.com certainly knows what it's doing. This was the most comprehensive interview I have had with an Indian company.

The panel ended the interview with a neutral outlook, so I wasn't really sure if I made the cut. I did, however, receive a call next day from my HR POC to schedule another technical round for that very day itself. I immediately consented and appreciated the expediency with which everything was being facilitated.

#### Technical Round 2
The second round was again via a Skype call. The panel this time consisted of senior management. After introductions, I started off with my weird educational background :grimacing:. This round was more theoretical than the previous one. I was asked to write pseudocode for a simple JSX to JS tanspiler. This was followed by questions about the [DOM](https://developer.mozilla.org/en-US/docs/Web/API/Document_Object_Model) - how it's represented in memory and how CSS selector matching and DOM traversal work. This basically involves the [Tree ADT](https://en.wikipedia.org/wiki/Tree_(data_structure)). Fortunately, I was paying attention in [Carey Nachenberg's](http://www.bruinwalk.com/professors/carey-nachenberg/com-sci-32/) CS32 lectures (which is, hands down, the most useful CS class at UCLA). The remaining questions were about how a web browser works. This basically involved the [rendering pipeline](https://developers.google.com/web/fundamentals/performance/rendering/) and [optimizing runtime performance](https://www.youtube.com/watch?v=RCFQu0hK6bU). This round ended up on a positive note. The panel seemed really happy with my answers. We went on to discuss the culture at housing.com and life in Bombay. I was informed that HR would call me with the offer and formalities.

#### The Offer
If you skipped everything before this to see what they offered :moneybag:, I am not sorry to disappoint you. However, I can divulge that the offer was extremely competitive and in line with what giants like Amazon, Adobe, Flipkart etc. would offer. A quick check with my IIT pals confirmed the fact that it was, indeed, extremely good :scream: by IIT standards as well. Besides the monetary compensation, housing.com has great perks :open_mouth: and supposedly, a young management :arrow_up:. This factor is usually underestimated, but in my experience, goes a long way in defining your productivity at any tech company. Needless to say it was what I had expected and I did end up accepting the offer.

#### Fin
In the five months I have spent navigating the startup scene globally as a drop out, there is one thing I can't be more convinced of:

>Your degree does not matter for :poop: unless it's backed up with pragmatic, immediately applicable, real world knowledge. Analytical skills, the ability to think rationally and a solid problem solving approach take your credibility much further than a piece of paper.

Take this as a derision of educational institutions, not education itself. In my humble opinion, if going to college makes you more prepared for the kind of roles you want to take on in the future, by all means - go to college. It is still the best way to accumulate a diversity of experiences and increase your connection capital. But if you feel that restricting yourself and 'your' education to the rigidity of a college structure [kills your creativity](https://www.ted.com/talks/ken_robinson_says_schools_kill_creativity) or unduly stigmatizes failure and mistakes, just don't do it. Do your own thing.
