# Entering precomp.mk

# Entering /ade/aime_rdbms_9819/oracle/buildtools/mkfile/prefix.mk

# Entering /ade/aime_rdbms_9819/oracle/buildtools/mkfile/defs.mk

SHELL=/bin/sh

AS_EXT=s
CC_EXT=cpp
LIB_EXT=a
OBJ_EXT=o
PLB_EXT=plb
SO_EXT=so
LOCK_EXT=lk
SQL_EXT=sql
SYM_EXT=sym
JAVA_EXT=java
CLASS_EXT=class
JAR_EXT=jar
ZIP_EXT=zip
DEF_EXT=def

LIB_PREFIX=lib
LDLIBFLAG=-l
LDPATHFLAG=-L
PATHSEP= :

AR=ar
AS=as
AWK=awk
CAT=cat
CC=cc
CCC=CC
CD=cd
CHMOD=chmod
CP=cp
CPP=cpp
DATE=date
ECHO=echo
ECHON=echo -n
EXEC=exec
FIND=find
FOLLOW=-follow
NOLEAF=-noleaf
GREP=grep
KILL=kill
SLEEP=sleep
LD=ld
LMAKE=make
LN=ln
LNS=ln -s
MKDIR=mkdir
MKDIRP=mkdir -p
MV=mv
NM=nm
PERL=perl
RM=rm
RMF=rm -f
RMRF=rm -rf
SED=sed
SORT=sort
TOUCH=touch
TR=tr
XARGS=xargs
LS=ls

PERL_EXEC=$(PERL_EXEC_5_6)

ANT=ant

NULL_DEVICE=/dev/null

BINDIR=bin
LIBDIR=lib
JSRCDIR=jsrc
JLIBDIR=jlib
BINHOME=$(ORACLE_HOME)/$(BINDIR)/
LIBHOME=$(ORACLE_HOME)/$(LIBDIR)/

PRODHOME=$(ORACLE_HOME)/$(PRODUCT)/
PRODJORACLE_HOME=$(PRODHOME)$(JSRCDIR)/
PRODLIBHOME=$(PRODHOME)$(LIBDIR)/
PRODSOHOME=$(PRODLIBHOME)
PRODADMIN=$(PRODHOME)admin/
PRODDEFHOME=$(PRODADMIN)

ECHODO=$(BINHOME)echodo
GENSYSLIB=$(BINHOME)gensyslib
GENCLNTSH=$(BINHOME)genclntsh
GENCLNTST=$(BINHOME)genclntst
GENOCCISH=$(BINHOME)genoccish
GENAGTSH=$(BINHOME)genagtsh
GENNAFLG=$(BINHOME)gennaflg
GENAUTAB=$(BINHOME)genautab
MKMANIFEST=$(ORACLE_HOME)/buildtools/bin/mkjmanifest
GENORASDKBASE=$(BINHOME)genorasdksh -base
GENORASDKSH=$(BINHOME)genorasdksh

ARCHIVE_OBJ=$(AR) r $@ $*.$(OBJ_EXT)
ARCREATE=$(AR) cr$(ARLOCAL)
ARDELETE=$(AR) d$(ARLOCAL)
AREXTRACT=$(AR) x 
ARPRINT=$(AR) t
ARREPLACE=$(AR) r 
DOAR=$(ARCREATE) $@ $? 

JARCHIVE_OBJ=$(JAR) cv0f $@ $(JPKG_FILES) $(EXTRA_CLASS_FILES)
JARCREATE=$(JAR) cv0f
JARDELETE=$(ECHO) "no such thing"
JAREXTRACT=$(JAR) xf
JARPRINT=$(JAR) tvf
JARREPLACE=$(JAR) uf

CCARCREATE=$(CCC) -xar -o 

MAKE=$(LMAKE)
QUIET=>/dev/null 2>&1
QUIETE=2>/dev/null
SILENT=@

CTSCLEAN=clean
CTSCOMPTYPE=comp_ar1 _UNLOCK='$$(_unlock)' _LOCK='$$(_lock)' _RM='$$(_rm)' 
CTSDEPLIST=DEPLIST=/dev/null
CTSMAKEFLAGS=$(SILENT:@=--no-print-directory -s) $(CTSCLEAN) $(CTSCOMPTYPE) $(CTSDEPLIST)

CFLAGS=$(GFLAG) $(OPTIMIZE) $(CDEBUG) $(CCFLAGS) $(PFLAGS)\
	$(SHARED_CFLAG) $(USRFLAGS)
CFLAGSCC=$(GFLAG) $(OPTIMIZE) $(CDEBUG) $(CCFLAGSCC) $(PFLAGS)\
	$(SHARED_CFLAG) $(USRFLAGS)
PFLAGS=$(INCLUDE) $(SPFLAGS) $(LPFLAGS)

LD_SHARED_FLAG=$(SHARED_CFLAG)

LDCCOM=$(ADE_DEL_FILE_CMD) $(PURECMDS) $(CC) $(GFLAG) $(CCFLAGS) $(EXOSFLAGS) $(LDFLAGS)
LDCCOMCC=$(ADE_DEL_FILE_CMD) $(PURECMDS) $(CCC) $(GFLAG) $(CCFLAGSCC) $(EXOSFLAGS) $(LDFLAGS)
PURECMDS=$(PURELINK) $(PURIFY) $(PURECOV) $(QUANTIFY)
LINK=$(LDCCOM)
LINKCC=$(LDCCOMCC)
LDFLAGS=-o $@ $(LDPATHFLAG)$(PRODLIBHOME) $(LDPATHFLAG)$(LIBHOME)
LDLIBS=$(EXPDLIBS) $(EXOSLIBS) $(SYSLIBS) $(EXSYSLIBS) $(MATHLIB) $(USRLIBS)
MATHLIB=-lm
LINKLDLIBS=$(LDLIBS)
COBLDLIBS=$(LDLIBS)

SYSLIBLIST=$(LIBHOME)sysliblist
SYSLIBS=`$(CAT) $(SYSLIBLIST)`

NAETTOBJS=$(NAUTAB) $(NAETAB) $(NAEDHS)
TTLIBD=$(NETLIBD) $(LIBRDBMS_CLT) $(LIBMM) $(CORELIBD) $(LIBEPC) $(LIBCLNTSH)
ORACLETTLIBS1=$(NTZEOBJ) $(NETLIBS) $(LLIBRDBMS_CLT) $(LLIBMM) $(CORELIBS)\
       $(NETLIBS) $(LLIBRDBMS_CLT) $(LIBPLS_CLT) $(LLIBEPC) $(CORELIBS) \
       $(LLIBRDBMS_CLT) $(CORELIBS)
ORACLETTLIBS=$(ORACLETTLIBS1)
STATICTTLIBS=$(ORACLETTLIBS) $(LDLIBS)
TTLIBS=$(LLIBCLNTSH) $(STATICTTLIBS)
DEVTTLIBS=$(TTLIBS)
LINKTTLIBS=$(LLIBCLNTSH) $(ORACLETTLIBS) $(LINKLDLIBS)
COBTTLIBS=$(ORACLETTLIBS) $(COBLDLIBS)

STATIC_ORACLETTLIBS=$(NTZEOBJ) $(NETLIBS) $(LIBRDBMS_CLT) \
    $(LIBMM) $(CORELIBS) $(NETLIBS) $(LIBRDBMS_CLT) $(LIBPLS_CLT) \
    $(LIBEPC) $(CORELIBS) $(LIBRDBMS_CLT) $(CORELIBS)

SHARED_CLIENTLIBS=$(LLIBCLNTSH) $(LDFLAGSLIST)
STATIC_CLIENTLIBS=$(LLIBCLNTST) $(LDFLAGSLIST)
SHARED_LDCLIENTLIBS=$(SHARED_CLIENTLIBS) $(LDLIBS)
STATIC_LDCLIENTLIBS=$(STATIC_CLIENTLIBS) $(LDLIBS)

I_SYM=-I

LD_SHLIBS=$(SHLIBS)
DLOPENLIB_COMMAND=$(LD_SHLIB_COMMAND)
DLOPEN_SYM_COMMAND=$(SYM_COMMAND)
LD_SHLIB_COMMAND=$(SO_COMMAND)

# Exiting /ade/aime_rdbms_9819/oracle/buildtools/mkfile/defs.mk
# Entering /ade/aime_rdbms_9819/oracle/buildtools/mkfile/platform.mk

FAMILY=unix
PLATFORM=linux

MOTIFHOME=
OPENWINHOME=
GUILIBHOME= 

DIRSEP=/
PSEP=:

SO_EXT=so

GMAKE=make
LMAKE=make
FIND=/usr/bin/find 
PS=ps -feda

ARCHIVE=@if echo ${LIB} | grep lib > /dev/null 2>&1;then $(ECHODO) $(ARCREATE) $(LIB) $?; else echo "warning: Bad LIB: .$(LIB)."; fi
ARCHIVE2=@if echo ${LIB2} | grep lib > /dev/null 2>&1;then $(ECHODO) $(ARCREATE) $(LIB2) $?; else echo "warning: Bad LIB2: .$(LIB2)."; fi

JARCHIVE=@`if echo ${JLIB} | egrep '\.jar' > /dev/null 2>&1;then $(JARCREATE) $(JLIB) $? ; else echo ""; fi`

GROUP=/etc/group

LDFLAGS=-o $@ $(LDPATHFLAG)$(PRODLIBHOME) $(LDPATHFLAG)$(LIBHOME) $(LDPATHFLAG)$(LIBHOME)stubs/ -L$(COMPDIR)/lib -lirc
LINK=$(PURECMDS) gcc $(LDFLAGS) $(COMPSOBJS)

LLIBTHREAD=

MOTIFLIBS= -lXm -lXt -lX11 -lgen -lm -lXext -lX11 -lm
XLIBS=
EXOSFLAGS=

COMPOBJS=

SHAREDLIBPATH = -Wl,-rpath,$(ORACLE_HOME)/lib
EXSYSLIBS=-ldl

LLPPATH=$(LD_LIBRARYPATH)
LINKEXSYSLIBS= $(SHAREDLIBPATH)

LINKLDLIBS=$(EXPDLIBS) $(EXOSLIBS) $(SYSLIBS) $(LINKEXSYSLIBS) $(MATHLIB) $(USRLIBS) $(LDLIBS) $(COMPEOBJS) -L$(ORACLE_HOME)/lib

OPTIMIZE2=-O2
OPTIMIZE3=-O3
OPTIMIZE6=-O6
OPTIMIZE=$(OPTIMIZE2)
OPTIMIZE0=-O0
OPTIMIZEG=-g


ROFLAGS=-c
SPFLAGS=-DLINUX -D_GNU_SOURCE -D_LARGEFILE64_SOURCE=1 -D_LARGEFILE_SOURCE=1 -DSLTS_ENABLE -DSLMXMX_ENABLE -D_REENTRANT -DNS_THREADS

AR=/usr/bin/ar
AS=/usr/bin/as
LD=/usr/bin/gcc
NM=/usr/bin/nm
TR=/usr/bin/tr
CPP=/lib/cpp
CHMOD=/bin/chmod
CHGRP=/bin/chgrp
CHOWN=/bin/chown
ZIP=/usr/bin/zip

KPIC_OPTION=-fPIC

_UNLOCK=sleep 1; $(IGNORE)

COMPDIR=/usr
CC=$(COMPDIR)/bin/gcc
CCC=$(COMPDIR)/bin/g++
CPP=/lib/cpp
TRIGRAPHS_CCFLAGS=-trigraphs
CCFLAGSCC=-DOCCI_NO_WSTRING=1

CCARCREATE=$(AR) cr$(ARLOCAL)

ASPFLAGS=
NOKPIC_ASFLAGS=
ASFLAGS=
ASRO=$(AS) $<
ASROFLAGS=$(ASFLAGS)

ANSI=-ansi

COMPXA=$(subst -ansi,,$(COMPO))
COMPXACC=$(subst -ansi,,$(COMPOCC))


SHARED_LDFLAG=-shared -L$(ORACLE_HOME)/lib -o
SHARED_CFLAG=

NOKPIC_CCFLAGS=
LLIBIRC= -lirc

SPL_OPT_LNX=`cat $(PRODDEFHOME)$(_LIBNAME).$(DEF_EXT) | grep -E "[a-zA-Z0-9]+[;]" | awk -F";" '{printf(" -u "$$1);}'`
SPL_OPT_LNX=-Wl,--retain-symbols-file -Wl,$(PRODDEFHOME)$(_LIBNAME).$(DEF_EXT)

SHLIB_LD=gcc -o $(_FULL_LIBNAME) -shared -L$(BOOTSTRAPLIB) -L$(LIBHOME) -L$(PRODLIBHOME) -L$(LIBHOME)stubs/ -L$(COMPDIR)/lib
BOOTSTRAPLIB=/tmp/bootstraplib/
SHLIB_MAP=$(SPL_OPT_LNX)
SHLIB_NAME=-Wl,-h,$(_LIBNAME).$(SO_EXT)
SHLIB_OBJS=-Wl,--whole-archive $(PRODLIBHOME)$(_LIBNAME).$(LIB_EXT) -Wl,--no-whole-archive
SHLIB_OBJS_OLD=-Wl,--whole-archive $(PRODLIBHOME)$(_LIBNAME).$(LIB_EXT) -Wl,--no-whole-archive
SHLIB_OTHER=$(_LIBNAME_LIBS) $(_VAR_LIBS)
SHLIB_BOOTSTRAP_OTHER=$(_LIBNAME_EXTRALIBS) $(_VAR_EXTRALIBS)
SHLIB_CLOSED=-Wl,-z,defs
SHLIB_RP=-Wl,-rpath,$(LIBHOME) -Wl,-rpath,$(PRODLIBHOME)

LD_SHLIB_COMMAND=$(SHLIB_LD) $(SHLIB_MAP) $(SHLIB_OBJS_OLD) $(SHLIB_OTHER_DEP) -lirc

DLOPENLIB_COMMAND=$(LD_SHLIB_COMMAND) $(PROD_DLLIBS) $(_LIBNAME_LIBS) -lirc

NEW_LD_SHLIB_COMMAND=$(SHLIB_LD) $(SHLIB_MAP) $(SHLIB_NAME) $(SHLIB_OBJS) \
$(SHLIB_RP) $(SHLIB_OTHER) $(SHLIB_CLOSED) -lirc
NEW_DLOPENLIB_COMMAND=$(NEW_LD_SHLIB_COMMAND) -lirc
BOOTSTRAP_COMMAND=$(NEW_LD_SHLIB_COMMAND) $(SHLIB_BOOTSTRAP_OTHER) -lirc
NEW_LD_SHLIB_DEP=$(PRODDEFHOME)%.$(DEF_EXT) $(PRODLIBHOME)%.$(LIB_EXT)
NEW_DLOPENLIB_DEP=$(NEW_LD_SHLIB_DEP)
BOOTSTRAPLIB_DEP=$(NEW_LD_SHLIB_DEP)

LINKSHLIB=$(BINHOME)linkshlib
LINKSHLIB_CALL=$(LINKSHLIB) $@ $(MAKEFILE) $(SO_EXT)
CUS_NEW_SHLIB_COMMAND=$(LINKSHLIB_CALL) new_ld_shlib $(VAR)
CUS_NEW_DLOPENLIB_COMMAND=$(LINKSHLIB_CALL) new_dlopenlib $(VAR)
CUS_SHLIB_COMMAND=$(LINKSHLIB_CALL) ld_shlib $(VAR)
CUS_DLOPENLIB_COMMAND=$(LINKSHLIB_CALL) dlopenlib $(VAR)
CUS_VARLIB_COMMAND=$(LINKSHLIB_CALL) var $(PRODHOME)/admin
CUS_BOOTSTRAPLIB_COMMAND=$(LINKSHLIB_CALL) bootstrap

# Exiting /ade/aime_rdbms_9819/oracle/buildtools/mkfile/platform.mk
# Entering /ade/aime_rdbms_9819/oracle/buildtools/mkfile/rules.mk
 
# Exiting /ade/aime_rdbms_9819/oracle/buildtools/mkfile/rules.mk
# Exiting /ade/aime_rdbms_9819/oracle/buildtools/mkfile/prefix.mk
# Entering /ade/aime_rdbms_9819/oracle/ldap/exports.mk

LDAP_VERSION=10

LIBGSLSSFNAME= gslssf$(LDAP_VERSION)
LLIBGSLSSF= $(LDLIBFLAG)$(LIBGSLSSFNAME)$(LIB_SUFFIX)
LIBGSLSSF= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLSSFNAME).$(LIB_EXT)

LIBGSLSSBNAME= gslssb$(LDAP_VERSION)
LLIBGSLSSB= $(LDLIBFLAG)$(LIBGSLSSBNAME)$(LIB_SUFFIX)
LIBGSLSSB= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLSSBNAME).$(LIB_EXT)

LIBGSLBER_SNAME= gslber_s$(LDAP_VERSION)
LLIBGSLBER_S= $(LDLIBFLAG)$(LIBGSLBER_SNAME)$(LIB_SUFFIX)
LIBGSLBER_S= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLBER_SNAME).$(LIB_EXT)

LIBGSLAVLNAME= gslavl$(LDAP_VERSION)
LLIBGSLAVL= $(LDLIBFLAG)$(LIBGSLAVLNAME)$(LIB_SUFFIX)
LIBGSLAVL= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLAVLNAME).$(LIB_EXT)

LIBGSLRNAME= gslr$(LDAP_VERSION)
LLIBGSLR= $(LDLIBFLAG)$(LIBGSLRNAME)$(LIB_SUFFIX)
LIBGSLR= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLRNAME).$(LIB_EXT)

LIBGSLRTNAME= gslrt$(LDAP_VERSION)
LLIBGSLRT= $(LDLIBFLAG)$(LIBGSLRTNAME)$(LIB_SUFFIX)
LIBGSLRT= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLRTNAME).$(LIB_EXT)

LIBGSLDBNAME= gsldb$(LDAP_VERSION)
LLIBGSLDB= $(LDLIBFLAG)$(LIBGSLDBNAME)$(LIB_SUFFIX)
LIBGSLDB= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLDBNAME).$(LIB_EXT)


LIBGSLUSNAME= gslus$(LDAP_VERSION)
LLIBGSLUS= $(LDLIBFLAG)$(LIBGSLUSNAME)$(LIB_SUFFIX)
LIBGSLUS= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLUSNAME).$(LIB_EXT)

LIBGSLTNAME= gslt$(LDAP_VERSION)
LLIBGSLT= $(LDLIBFLAG)$(LIBGSLTNAME)$(LIB_SUFFIX)
LIBGSLT= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLTNAME).$(LIB_EXT)

LIBGSLSGNAME= gslsg$(LDAP_VERSION)
LLIBGSLSG= $(LDLIBFLAG)$(LIBGSLSGNAME)$(LIB_SUFFIX)
LIBGSLSG= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLSGNAME).$(LIB_EXT)

LIBGSLECNAME= gslec$(LDAP_VERSION)
LLIBGSLEC= $(LDLIBFLAG)$(LIBGSLECNAME)$(LIB_SUFFIX)
LIBGSLEC= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLECNAME).$(LIB_EXT)

LIBGSLSMNAME= gslsm$(LDAP_VERSION)
LLIBGSLSM= $(LDLIBFLAG)$(LIBGSLSMNAME)$(LIB_SUFFIX)
LIBGSLSM= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLSMNAME).$(LIB_EXT)

LIBGSLIRNAME= gslir$(LDAP_VERSION)
LLIBGSLIR= $(LDLIBFLAG)$(LIBGSLIRNAME)$(LIB_SUFFIX)
LIBGSLIR= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLIRNAME).$(LIB_EXT)

LIBGSLGRNAME= gslgr$(LDAP_VERSION)
LLIBGSLGR= $(LDLIBFLAG)$(LIBGSLGRNAME)$(LIB_SUFFIX)
LIBGSLGR= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLGRNAME).$(LIB_EXT)

LIBGSLAUDNAME= gslaud$(LDAP_VERSION)
LLIBGSLAUD= $(LDLIBFLAG)$(LIBGSLAUDNAME)$(LIB_SUFFIX)
LIBGSLAUD= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLAUDNAME).$(LIB_EXT)

LIBGSLPLNAME= gslpl$(LDAP_VERSION)
LLIBGSLPL= $(LDLIBFLAG)$(LIBGSLPLNAME)$(LIB_SUFFIX)
LIBGSLPL= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLPLNAME).$(LIB_EXT)

LIBGSLMNAME= gslm$(LDAP_VERSION)
LLIBGSLM= $(LDLIBFLAG)$(LIBGSLMNAME)$(LIB_SUFFIX)
LIBGSLM=$(LIBHOME)$(LIB_PREFIX)$(LIBGSLMNAME).$(LIB_EXT)

LIBSGSL_SNAME= sgsl_s$(LDAP_VERSION)
LLIBSGSL_S= $(LDLIBFLAG)$(LIBSGSL_SNAME)$(LIB_SUFFIX)
LIBSGSL_S= $(LIBHOME)$(LIB_PREFIX)$(LIBSGSL_SNAME).$(LIB_EXT)

LIBLDAPCLNTNAME= ldapclnt$(LDAP_VERSION)
LIBLDAPCLNT= $(LIBHOME)$(LIB_PREFIX)$(LIBLDAPCLNTNAME).$(LIB_EXT)
LLIBLDAPCLNT= $(LDLIBFLAG)$(LIBLDAPCLNTNAME)

LIBLDAPCLNTSHNAME= ldapclntsh$(LDAP_VERSION)
LIBLDAPCLNTSH= $(LIBHOME)$(LIB_PREFIX)$(LIBLDAPCLNTSHNAME).$(LIB_EXT)
LLIBLDAPCLNTSH= $(LDLIBFLAG)$(LIBLDAPCLNTSHNAME)
LIBLDAPCLNTSHLIBS= $(LIBLDAPCLNTSHNAME)LIBS

LIBLDAPJCLNTNAME= ldapjclnt$(LDAP_VERSION)
LIBLDAPJCLNT= $(LIBHOME)$(LIB_PREFIX)$(LIBLDAPJCLNTNAME).$(LIB_EXT)
LIBLDAPJCLNTSH = $(LIBHOME)$(LIB_PREFIX)$(LIBLDAPJCLNTNAME).$(SO_EXT)
LLIBLDAPJCLNT= $(LDLIBFLAG)$(LIBLDAPJCLNTNAME)
LIBLDAPJCLNTLIBS= $(LIBLDAPJCLNTNAME)LIBS

LIBIDTYSTORENAME= identitystore

LIBGSLMTNAME= gslmt$(LDAP_VERSION)
LLIBGSLMT= $(LDLIBFLAG)$(LIBGSLMTNAME)$(LIB_SUFFIX)
LIBGSLMT= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLMTNAME).$(LIB_EXT)

LIBZTK5GSSNAME= ztk5gss$(LDAP_VERSION)
LIBZTK5GSS= $(LIBHOME)$(LIB_PREFIX)$(LIBZTK5GSSNAME).$(LIB_EXT)
LLIBZTK5GSS= $(LDLIBFLAG)$(LIBZTK5GSSNAME)

LDAPHOME=    $(ORACLE_HOME)/ldap/
LDAPBIN=     $(LDAPHOME)$(BINDIR)/
LDAPLIB=     $(LDAPHOME)$(LIBDIR)/
LDAPJLIB=    $(LDAPHOME)jlib/

LDAPPUBH=    $(I_SYM)$(LDAPHOME)public $(I_SYM)$(LDAPHOME)include


# Entering /ade/aime_rdbms_9819/oracle/ldap/s_exports.mk


# Exiting /ade/aime_rdbms_9819/oracle/ldap/s_exports.mk
# Exiting /ade/aime_rdbms_9819/oracle/ldap/exports.mk
# Entering /ade/aime_rdbms_9819/oracle/encryption/exports.mk

ENCRYPTIONHOME  = $(ORACLE_HOME)/encryption/
ENCRYPTIONLIB   = $(ENCRYPTIONHOME)$(LIBDIR)/
ENCRYPTIONJLIB  = $(ENCRYPTIONHOME)jlib/
ENCRYPTIONPUBH  = $(I_SYM)$(ENCRYPTIONHOME)include

ENCRYPTION_VERSION=10
BASENAME        =n
CRYPTNAME       =${BASENAME}crypt$(ENCRYPTION_VERSION)
LIBSNS          =$(ENCRYPTIONLIB)$(LIB_PREFIX)$(CRYPTNAME).$(LIB_EXT)
LLIBNCRYPT      =$(LDLIBFLAG)$(ILIB_PREFIX)$(CRYPTNAME)$(ILIB_SUFFIX)

RSASTDNAME	=rsastd
BCERTNAME	=bcert
NZRNAME		=nzr
CRLSTATNAME	=crlstat
LIBRSASTD	=$(ENCRYPTIONLIB)$(LIB_PREFIX)$(RSASTDNAME).$(LIB_EXT)
LIBBCERT	=$(ENCRYPTIONLIB)$(LIB_PREFIX)$(BCERTNAME).$(LIB_EXT)
LIBNZR		=$(ENCRYPTIONLIB)$(LIB_PREFIX)$(NZRNAME).$(LIB_EXT)
LIBCRLSTAT	=$(ENCRYPTIONLIB)$(LIB_PREFIX)$(CRLSTATNAME).$(LIB_EXT)

PHAOSJAR=$(ENCRYPTIONJLIB)ojpse.$(JAR_EXT)
PHAOSCMSJAR=$(ENCRYPTIONJLIB)ojpcms.$(JAR_EXT)
PKI_ENCR_JAR=$(ENCRYPTIONJLIB)oraclepki103_encr.$(JAR_EXT)
CRYPTSHNAME=$(BASENAME)cryptsh$(ENCRYPTION_VERSION)
LLIBNCRYPTSH=$(LDLIBFLAG)$(CRYPTSHNAME)$(ILIB_SUFFIX)
# Entering /ade/aime_rdbms_9819/oracle/encryption/s_exports.mk

# Exiting /ade/aime_rdbms_9819/oracle/encryption/s_exports.mk
# Exiting /ade/aime_rdbms_9819/oracle/encryption/exports.mk
# Entering /ade/aime_rdbms_9819/oracle/network/exports.mk

NETWORKHOME=$(ORACLE_HOME)/network/
NETWORKADMIN=$(NETWORKHOME)admin/
NETWORKINSTALL=$(NETWORKHOME)install/
NETWORKDEMO=$(NETWORKHOME)demo/

# Entering /ade/aime_rdbms_9819/oracle/network/adapters.mk

# Entering /ade/aime_rdbms_9819/oracle/network/s_adapters.mk

# Exiting /ade/aime_rdbms_9819/oracle/network/s_adapters.mk

# Entering /ade/aime_rdbms_9819/oracle/network/libnames.mk

NETWORK_VERSION=10
BASENAME=n
NETWORKLIB=$(NETWORKHOME)$(LIBDIR)/
NETWORKJLIB=$(NETWORKHOME)$(JLIBDIR)/

COMMONNAME=${BASENAME}${NETWORK_VERSION}
NLNAME=${BASENAME}l${NETWORK_VERSION}
TCPNAME=${BASENAME}tcp${NETWORK_VERSION}
QUENAME=${BASENAME}que${NETWORK_VERSION}
DECNETNAME=${BASENAME}dec${NETWORK_VERSION}
LU62NAME=${BASENAME}lu62${NETWORK_VERSION}
MBNAME=${BASENAME}mb${NETWORK_VERSION}
DCENAME=${BASENAME}dce${NETWORK_VERSION}
BEQNAME=${BASENAME}beq${NETWORK_VERSION}
IPCNAME=${BASENAME}ipc${NETWORK_VERSION}
SPXNAME=${BASENAME}spx${NETWORK_VERSION}
TLINAME=${BASENAME}tli${NETWORK_VERSION}
TLITNAME=${BASENAME}tlit${NETWORK_VERSION}
TLISNAME=${BASENAME}tlis${NETWORK_VERSION}
TLIDNAME=${BASENAME}tlid${NETWORK_VERSION}
USNAME=${BASENAME}us${NETWORK_VERSION}
SHMNAME=${BASENAME}shm${NETWORK_VERSION}
TCPSNAME=${BASENAME}tcps${NETWORK_VERSION}
TCPAIONAME=${BASENAME}tcpaio${NETWORK_VERSION}
ENTRUSTNAME=${BASENAME}nzentr${NETWORK_VERSION}
NSGRNAME=${BASENAME}sgr${NETWORK_VERSION}
LSNRNAME=${BASENAME}lsnr${NETWORK_VERSION}
LSNRCNAME=${BASENAME}lsnrc${NETWORK_VERSION}
ONNAME=${BASENAME}on${NETWORK_VERSION}
ONDNAME=${BASENAME}ond${NETWORK_VERSION}
ONCNAME=${BASENAME}onc${NETWORK_VERSION}
ONCJNAME=${BASENAME}oncj${NETWORK_VERSION}
RONAME=${BASENAME}ro${NETWORK_VERSION}
ROCNAME=${BASENAME}roc${NETWORK_VERSION}
ROXNAME=${BASENAME}rox${NETWORK_VERSION}
ROTNAME=${BASENAME}rot${NETWORK_VERSION}
CMNAME=${BASENAME}cm${NETWORK_VERSION}
NHOSTNAME=${BASENAME}host${NETWORK_VERSION}
TNSNAME=${BASENAME}tns${NETWORK_VERSION}
ORACLENAME=${BASENAME}oname${NETWORK_VERSION}
NISNAME=${BASENAME}nis${NETWORK_VERSION}
CDSNAME=${BASENAME}cds${NETWORK_VERSION}
NDSNAME=${BASENAME}nds${NETWORK_VERSION}
LDAPNAME=${BASENAME}ldap${NETWORK_VERSION}
LDAPJNAME=${BASENAME}ldapj${NETWORK_VERSION}
SSLBNAME=${BASENAME}sslb${NETWORK_VERSION}
NUJNINAME=${BASENAME}jni${NETWORK_VERSION}
NZJSNAME=${BASENAME}zjs${NETWORK_VERSION}
JSSLNAME=${BASENAME}jssl${NETWORK_VERSION}
ZTNAME=${BASENAME}zt${NETWORK_VERSION}
OWMNAME=owm2
NZNAME=${BASENAME}nz${NETWORK_VERSION}

NMPNAME=${BASENAME}nmp${NETWORK_VERSION}

TANAME=${BASENAME}ta${NETWORK_VERSION}
TALNAME=${BASENAME}tal${NETWORK_VERSION}

NZRNAME=nzr


SNLPTDUM         =  $(NETWORKLIB)snlptdum.$(OBJ_EXT) 
OSNTABST         = $(NETWORKLIB)osntabst.$(OBJ_EXT)
NNFGT            = $(NETWORKLIB)nnfgt.$(OBJ_EXT)

LIBNETWORK	 =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBTHINNCR       =  $(NETWORKLIB)$(LIB_PREFIX)$(ROTNAME).$(LIB_EXT)

LOC_LIBNUJNI     =  $(NETWORKLIB)$(LIB_PREFIX)$(NUJNINAME).$(LIB_EXT)
LOC_LIBOWM       =  $(NETWORKLIB)$(LIB_PREFIX)$(OWMNAME).$(LIB_EXT)
LOC_LIBJSSL      =  $(NETWORKLIB)$(LIB_PREFIX)$(JSSLNAME).$(LIB_EXT)
LIBONCJ          =  $(NETWORKLIB)$(LIB_PREFIX)$(ONCJNAME).$(SO_EXT)
LIBNUJNI         =  $(NETWORKLIB)$(LIB_PREFIX)$(NUJNINAME).$(SO_EXT)
LIBJSSL          =  $(NETWORKLIB)$(LIB_PREFIX)$(JSSLNAME).$(SO_EXT)
LIBOWM           =  $(NETWORKLIB)$(LIB_PREFIX)$(OWMNAME).$(SO_EXT)
LIBLDAPJ         =  $(NETWORKLIB)$(LIB_PREFIX)$(LDAPJNAME).$(SO_EXT)
LOC_LIBONCJ      =  $(NETWORKLIB)$(LIB_PREFIX)$(ONCJNAME).$(LIB_EXT)
LOC_LIBLDAPJ     =  $(NETWORKLIB)$(LIB_PREFIX)$(LDAPJNAME).$(LIB_EXT)

LIBNCR           =  $(NETWORKLIB)$(LIB_PREFIX)$(RONAME).$(LIB_EXT)
LIBNFP           =  $(NETWORKLIB)$(LIB_PREFIX)$(CMNAME).$(LIB_EXT)
LIBNI            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNCC          =  $(NETWORKLIB)$(LIB_PREFIX)$(ONCNAME).$(LIB_EXT)
LIBNND           =  $(NETWORKLIB)$(LIB_PREFIX)$(ONDNAME).$(LIB_EXT)
LIBNNO           =  $(NETWORKLIB)$(LIB_PREFIX)$(ONNAME).$(LIB_EXT)
LIBNSGR          =  $(NETWORKLIB)$(LIB_PREFIX)$(NSGRNAME).$(LIB_EXT)
LIBNSGL          =  $(NETWORKLIB)$(LIB_PREFIX)$(LSNRNAME).$(LIB_EXT)
LIBNSGLC         =  $(NETWORKLIB)$(LIB_PREFIX)$(LSNRCNAME).$(LIB_EXT)

LLIBNCR           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(RONAME)$(ILIB_SUFFIX)
LLIBNFP           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(CMNAME)$(ILIB_SUFFIX)
LLIBNI            =  $(LDLIBFLAG)$(ILIB_PREFIX)$(COMMONNAME)$(ILIB_SUFFIX)
LLIBNNCC          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(ONCNAME)$(ILIB_SUFFIX)
LLIBNND           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(ONDNAME)$(ILIB_SUFFIX)
LLIBNNO           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(ONNAME)$(ILIB_SUFFIX)
LLIBNSGR          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NSGRNAME)$(ILIB_SUFFIX)
LLIBNSGL          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(LSNRNAME)$(ILIB_SUFFIX)
LLIBNSGLC         =  $(LDLIBFLAG)$(ILIB_PREFIX)$(LSNRCNAME)$(ILIB_SUFFIX)


LIBNTT           =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPNAME).$(LIB_EXT)
LIBNTTAIO        =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPAIONAME).$(SO_EXT)
LOC_LIBNTTAIO    =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPAIONAME).$(LIB_EXT)
LOC_LIBNTVI      =  $(NETWORKLIB)$(LIB_PREFIX)$(VINAME).$(LIB_EXT)
LIBNTVI          =  $(NETWORKLIB)$(LIB_PREFIX)$(VINAME).$(SO_EXT)
LOC_LIBNTEVQ     =  $(NETWORKLIB)$(LIB_PREFIX)$(QUENAME).$(LIB_EXT)
LIBNTEVQ         =  $(NETWORKLIB)$(LIB_PREFIX)$(QUENAME).$(SO_EXT)
LIBNTZ           =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPSNAME).$(LIB_EXT)
LIBNTZSTUB       =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPSNAME)_std.$(LIB_EXT)
LOC_LIBNZTWVE    =  $(NETWORKLIB)$(LIB_PREFIX)$(ENTRUSTNAME).$(LIB_EXT)
LIBNZTWVE        =  $(NETWORKLIB)$(LIB_PREFIX)$(ENTRUSTNAME).$(SO_EXT)
LIBNTS           =  $(NETWORKLIB)$(LIB_PREFIX)$(SPXNAME).$(LIB_EXT)
LIBNTD           =  $(NETWORKLIB)$(LIB_PREFIX)$(DECNETNAME).$(LIB_EXT)
LIBNTOD          =  $(NETWORKLIB)$(LIB_PREFIX)$(DCENAME).$(LIB_EXT)
LIBCDS           =  $(NETWORKLIB)$(LIB_PREFIX)$(CDSNAME).$(LIB_EXT)
LIBNTLU62        =  $(NETWORKLIB)$(LIB_PREFIX)$(LU62NAME).$(LIB_EXT)
LIBNTTLI	 =  $(NETWORKLIB)$(LIB_PREFIX)$(TLINAME).$(LIB_EXT)
LIBNTUS          =  $(NETWORKLIB)$(LIB_PREFIX)$(USNAME).$(LIB_EXT)
LIBNTSHM         =  $(NETWORKLIB)$(LIB_PREFIX)$(SHMNAME).$(LIB_EXT)
LIBNTP           =  $(NETWORKLIB)$(LIB_PREFIX)$(BEQNAME).$(LIB_EXT)
LIBNTNP          =  $(NETWORKLIB)$(LIB_PREFIX)$(NMPNAME).$(LIB_EXT)

LLIBNTT           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TCPNAME)$(ILIB_SUFFIX)
LLIBNTVI          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(VINAME)$(ILIB_SUFFIX)
LLIBNTEVQ         =  $(LDLIBFLAG)$(ILIB_PREFIX)$(QUENAME).$(ILIB_SUFFIX)
LLIBNTZ           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TCPSNAME)$(ILIB_SUFFIX)
LLIBNTS           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(SPXNAME)$(ILIB_SUFFIX)
LLIBNTD           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(DECNETNAME)$(ILIB_SUFFIX)
LLIBNTOD          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(DCENAME)$(ILIB_SUFFIX)
LLIBCDS           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(CDSNAME)$(ILIB_SUFFIX)
LLIBNTLU62        =  $(LDLIBFLAG)$(ILIB_PREFIX)$(LU62NAME)$(ILIB_SUFFIX)
LLIBNTTLI	 =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TLINAME)$(ILIB_SUFFIX)
LLIBNTUS          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(USNAME)$(ILIB_SUFFIX)
LLIBNTSHM        = $(NETWORKLIB)$(LIB_PREFIX)$(SHMNAME)$(ILIB_SUFFIX)
LLIBNTP           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(BEQNAME)$(ILIB_SUFFIX)
LLIBNTNP          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NMPNAME)$(ILIB_SUFFIX)

LIBNL1           =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)
LIBNL2           =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)

LIBNL            =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)
LLIBNL           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NLNAME)$(ILIB_SUFFIX)


LIBNUAPI         =  $(NETWORKLIB)$(LIB_PREFIX)$(TANAME).$(LIB_EXT)
LIBNULOCAL       =  $(NETWORKLIB)$(LIB_PREFIX)$(TALNAME).$(LIB_EXT)

LLIBNUAPI         =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TANAME)$(ILIB_SUFFIX)
LLIBNULOCAL       =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TALNAME)$(ILIB_SUFFIX)


LLIBNUAPI	 = $(LDLIBFLAG)$(ILIB_PREFIX)$(TANAME)$(ILIB_SUFFIX)
LLIBNULOCAL	 = $(LDLIBFLAG)$(ILIB_PREFIX)$(TALNAME)$(ILIB_SUFFIX)
LLIBSSL          = #$(LDLIBFLAG)$(ILIB_PREFIX)sslref-bsafe$(ILIB_SUFFIX)
LLIBSSLB         = $(LDLIBFLAG)$(ILIB_PREFIX)$(SSLBNAME)$(ILIB_SUFFIX)
LLIBNZJS 	 = $(LDLIBFLAG)$(ILIB_PREFIX)$(NZJSNAME)$(ILIB_SUFFIX)

LOC_LIBNZ        =  $(NETWORKLIB)$(LIB_PREFIX)$(NZNAME).$(LIB_EXT)
LIBNZ            =  $(NETWORKLIB)$(LIB_PREFIX)$(NZNAME).$(SO_EXT)
LLIBNZ           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NZNAME)$(ILIB_SUFFIX)


LIBNA            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNAE           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNAU           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNMP           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNCI          =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNFG          =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNG           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNPL           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNR            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNS            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNT            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNTR           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNMS0          =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBSSLREF 	 =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBZT            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)

LIBSSLB          =  $(NETWORKLIB)$(LIB_PREFIX)$(SSLBNAME).$(LIB_EXT)

LIBNZJS          =  $(NETWORKLIB)$(LIB_PREFIX)$(NZJSNAME).$(LIB_EXT)

LIBNLNV          =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)

LDAPSYSLIBD = $(LIBHOME)$(LIB_PREFIX)$(LIBLDAPCLNTNAME).$(LIB_EXT)
LDAPSYSLIBS = $(LDLIBFLAG)$(ILIB_PREFIX)$(LIBLDAPCLNTNAME)$(ILIB_SUFFIX)

COMMONSHNAME=$(BASENAME)sh$(NETWORK_VERSION)
NLSHNAME=$(BASENAME)lsh$(NETWORK_VERSION)
LDAPSHNAME=$(BASENAME)ldapsh$(NETWORK_VERSION)
ROSHNAME=$(BASENAME)rosh$(NETWORK_VERSION)
LIBNETWORKSH=$(NETWORKLIB)$(LIB_PREFIX)$(COMMONSHNAME).$(SO_EXT)
LIBNLSH=$(NETWORKLIB)$(LIB_PREFIX)$(NLSHNAME).$(SO_EXT)
LIBLDAPSH=$(NETWORKLIB)$(LIB_PREFIX)$(LDAPSHNAME).$(SO_EXT)
LIBRPCSH=$(NETWORKLIB)$(LIB_PREFIX)$(ROSHNAME).$(SO_EXT)
LLIBNETWORKSH=$(LDLIBFLAG)$(COMMONSHNAME)$(ILIB_SUFFIX)
LLIBNLSH=$(LDLIBFLAG)$(NLSHNAME)$(ILIB_SUFFIX)
LLIBLDAPSH=$(LDLIBFLAG)$(LDAPSHNAME)$(ILIB_SUFFIX)
LLIBRPCSH=$(LDLIBFLAG)$(ROSHNAME)$(ILIB_SUFFIX)
# Exiting /ade/aime_rdbms_9819/oracle/network/libnames.mk

# Exiting /ade/aime_rdbms_9819/oracle/network/adapters.mk

LIBNTTCP     = $(LIBHOME)$(LIB_PREFIX)$(TCPNAME).$(LIB_EXT)
LLIBNTTCP    = $(LDLIBFLAG)$(ILIB_PREFIX)$(TCPNAME)$(ILIB_SUFFIX)

LIBNTOD      = $(LIBHOME)$(LIB_PREFIX)$(DCENAME).$(LIB_EXT)
LLIBNTOD     = $(LDLIBFLAG)$(ILIB_PREFIX)$(DCENAME)$(ILIB_SUFFIX)

LIBCDS       = $(LIBHOME)$(LIB_PREFIX)$(CDSNAME).$(LIB_EXT)
LLIBCDS      = $(LDLIBFLAG)$(ILIB_PREFIX)$(CDSNAME)$(ILIB_SUFFIX)

LIBNTLU62    = $(LIBHOME)$(LIB_PREFIX)$(LU62NAME).$(LIB_EXT)
LLIBNTLU62   = $(LDLIBFLAG)$(ILIB_PREFIX)$(LU62NAME)$(ILIB_SUFFIX)

LIBNTS       = $(LIBHOME)$(LIB_PREFIX)$(SPXNAME).$(LIB_EXT)
LLIBNTS      = $(LDLIBFLAG)$(ILIB_PREFIX)$(SPXNAME)$(ILIB_SUFFIX)

LIBNETWORK   = $(LIBHOME)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LLIBNETWORK  = $(LDLIBFLAG)$(ILIB_PREFIX)$(COMMONNAME)$(ILIB_SUFFIX)

LIBNSGR      = $(LIBHOME)$(LIB_PREFIX)$(NSGRNAME).$(LIB_EXT)
LLIBNSGR     = $(LDLIBFLAG)$(ILIB_PREFIX)$(NSGRNAME)$(ILIB_SUFFIX)

LOC_LIBNZ    =  $(LIBHOME)$(LIB_PREFIX)$(NZNAME).$(LIB_EXT)
LIBNZ        =  $(LIBHOME)$(LIB_PREFIX)$(NZNAME).$(SO_EXT)
LLIBNZ       =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NZNAME)$(ILIB_SUFFIX)

LIBSQLNET  = $(LDFLAGSFILE) $(PROTOCOLLIBD) $(NATIVELIBD) $(NATIVESYSLIBD) $(LIBNSGR) $(LIBNZJS) $(LIBNETWORK) $(LIBNZ) $(LIBNL)
LLIBSQLNET = $(LDFLAGSLIST) $(PROTOCOLLIBS) $(NATIVELIBS) $(NATIVESYSLIBS) $(LLIBSSLB) $(LLIBNCRYPT) $(LLIBNSGR) $(LLIBNZJS) $(LLIBNETWORK) $(LLIBNZ) $(LLIBNL)

LIBRPC       = $(LIBHOME)$(LIB_PREFIX)$(RONAME).$(LIB_EXT)
LLIBRPC      = $(LDLIBFLAG)$(ILIB_PREFIX)$(RONAME)$(ILIB_SUFFIX)

TNSLSNR	     = $(BINHOME)tnslsnr$(EXE_SUFFIX)
LSNRCTL	     = $(BINHOME)lsnrctl$(EXE_SUFFIX)

NIGTAB       = $(LIBHOME)nigtab.$(OBJ_EXT)
NIGCON       = $(LIBHOME)nigcon.$(OBJ_EXT) 
NTCONTAB     = $(LIBHOME)ntcontab.$(OBJ_EXT)
MTS_NCR	     = $(LIBHOME)ncrstab.$(OBJ_EXT)

OSNTABST     = $(NETWORKLIB)osntabst.$(OBJ_EXT)
NNFGT        = $(NETWORKLIB)nnfgt.$(OBJ_EXT)

NAETAB       = $(LIBHOME)naeet.$(OBJ_EXT) $(LIBHOME)naect.$(OBJ_EXT)
NAEDHS	     = $(LIBHOME)naedhs.$(OBJ_EXT)
NAUTAB_OBJ   = nautab.$(OBJ_EXT)
NAUTAB	     = $(LIBHOME)$(NAUTAB_OBJ)

NETLIBS      = $(LLIBSQLNET) $(LLIBRPC) $(LLIBSQLNET)
NETLIBD      = $(LIBSQLNET) $(LIBRPC)

LDFLAGSFILE=$(LIBHOME)ldflags
LDFLAGSLIST=`$(CAT) $(LDFLAGSFILE)`

LIBNTP       = $(LIBHOME)$(LIB_PREFIX)$(BEQNAME).$(LIB_EXT)
LIBNL        = $(LIBHOME)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)
LIBSSLB      = $(LIBHOME)$(LIB_PREFIX)$(SSLBNAME).$(LIB_EXT)



NNZDEPDIRS=-L $(ORACLE_HOME)/rdbms/lib \
  -L $(ORACLE_HOME)/plsql/lib \
  -L $(ORACLE_HOME)/encryption/lib \
  -L $(ORACLE_HOME)/ldap/lib \
  -L $(ORACLE_HOME)/network/lib

NNZ_DEP=$(NNZDEPDIRS) \
  $(DEF_OPT) $(NAUTAB) $(NAETAB) $(LLIBNZ) $(LLIBNETWORKSH) \
  $(LLIBLDAPCLNTSH) $(LLIBCLIENTSH) $(LLIBPLSSH) $(LLIBGENERICSH) \
  $(LLIBCOMMONSH) $(LLIBNCRYPTSH) $(LLIBCLIENTSH) $(LLIBRPCSH) \
  $(LLIBNTP) $(LLIBNTT) $(LLIBNTZ) $(LLIBNTUS) \
  $(LLIBHOST) $(LLIBLDAPSH) $(LLIBONAMES) $(LLIBNIS) $(LLIBTNS) \
  $(LLIBNLSH) $(LLIBNETWORKSH) $(LLIBNLSH) $(LLIBNCRYPTSH) \
  $(LLIBNNETSH) $(LLIBXMLSH) $(LLIBNLSSH) \
  $(LLIBSNLSSH) $(LLIBUNLSSH) $(LLIBCORE_SH) \
  -lkstat -lnsl -lsocket -ldl -lm

ORACLEPKI_JAR=$(ORAJLIB)/oraclepki.$(JAR_EXT)

# Entering /ade/aime_rdbms_9819/oracle/network/s_exports.mk


NAETAB64	= $(LIBHOME)naeet.$(OBJ_EXT) $(LIBHOME)naect.$(OBJ_EXT)
NAEDHS64	= $(LIBHOME)naedhs.$(OBJ_EXT)
NAUTAB64	= $(LIBHOME)$(NAUTAB_OBJ)


# Exiting /ade/aime_rdbms_9819/oracle/network/s_exports.mk
# Exiting /ade/aime_rdbms_9819/oracle/network/exports.mk
# Entering /ade/aime_rdbms_9819/oracle/oracore/exports.mk

COREHOME    = $(ORACLE_HOME)/oracore/
ORACOREHOME = $(COREHOME)



CORE_LIB_NAME     = core
CORE_LIB_VER      = 10
CORE_LIB          = $(CORE_LIB_NAME)$(CORE_LIB_VER)

LIBCORE_STATIC    = $(LIB_PREFIX)$(CORE_LIB).$(LIB_EXT)
LIBCORE_SHARED    = $(LIB_PREFIX)$(CORE_LIB).$(SO_EXT)
LIBCORE_SH        = $(LIB_PREFIX)$(CORE_LIB_NAME)sh$(CORE_LIB_VER).$(SO_EXT)
LIBCORE_SLH       = $(LIB_PREFIX)$(CORE_LIB).$(ILIB_EXT)

LIBCORE           = $(LIBHOME)$(LIBCORE_STATIC)
LLIBCORE          = $(LDLIBFLAG)$(CORE_LIB)
LLIBCORE_SH       = $(LDLIBFLAG)$(CORE_LIB_NAME)sh$(CORE_LIB_VER)

LIBCORE_ARC_LIB   = $(LIBCORE)
LIBCORE_SHARE_LIB = $(LIBHOME)$(LIBCORE_SHARED)

















LIB816  = /oracore/sun5/8.1.6.0.0/lib
CORE816 = $(LIB816)/$(LIBCORE_STATIC)
NLS816  = $(LIB816)/$(LIB_PREFIX)$(LIBNLSRTLNAME).$(LIB_EXT)


LIB817  = /oracore/sun5/8.1.7.0.0/lib
CORE817 = $(LIB817)/$(LIBCORE_STATIC)
NLS817  = $(LIB817)/$(LIB_PREFIX)$(LIBNLSRTLNAME).$(LIB_EXT)


S0MAIN   = $(LIBHOME)s0main.$(OBJ_EXT)
S1MAIN_C = $(COREHOME)src/corehl/lpm/sosd/main/s1main.c
SCOREPT  = $(LIBHOME)scorept.$(OBJ_EXT)
SSCOREED = $(LIBHOME)sscoreed.$(OBJ_EXT)

COREPUBLIC=$(COREHOME)include $(COREHOME)public/ $(XDKPUBLIC)

ORACOREPUBH=$(I_SYM)$(COREHOME)include $(I_SYM)$(COREHOME)public $(I_SYM)$(COREHOME)port/include $(XDKPUBH)


CORELIBD = $(LIBSNLSRTL) $(LIBNLSRTL) $(LIBCV6) $(LIBCORE) $(LIBSNLSRTL) \
           $(LIBNLSRTL) $(LIBCORE) $(LIBSNLSRTL) $(LIBNLSRTL)  $(LIBUNLSRTL) \
           $(LIBSNLSRTL) $(LIBNLSRTL)
CORELIBS = $(LLIBSNLSRTL) $(LLIBNLSRTL) $(LLIBCV6) $(LLIBCORE) $(LLIBSNLSRTL) \
           $(LLIBNLSRTL) $(LLIBCORE) $(LLIBSNLSRTL) $(LLIBNLSRTL) $(LLIBXML) \
           $(LLIBCORE) $(LLIBUNLSRTL) $(LLIBSNLSRTL) $(LLIBNLSRTL) $(LLIBCORE)\
	   $(LLIBNLSRTL)


# Entering /ade/aime_rdbms_9819/oracle/oracore/s_exports.mk
 
# Exiting /ade/aime_rdbms_9819/oracle/oracore/s_exports.mk
# Exiting /ade/aime_rdbms_9819/oracle/oracore/exports.mk
# Entering /ade/aime_rdbms_9819/oracle/nlsrtl/exports.mk

NLSRTLHOME= $(ORACLE_HOME)/nlsrtl/


ORA_NLS = $(ORACLE_HOME)/ocommon/nls/admin/data/
ORA_NLS33 = $(ORACLE_HOME)/ocommon/nls/admin/data/
ORA_NLS10 = $(ORACLE_HOME)/nls/data/

NLSRTL_VERSION=10
NLSRTL_DEBUG_LIBTAG = 

LIBNLSRTLNAME = nls$(NLSRTL_VERSION)$(NLSRTL_DEBUG_LIBTAG)
LIBNLSRTL= $(LIBHOME)$(LIB_PREFIX)$(LIBNLSRTLNAME).$(LIB_EXT)
LLIBNLSRTL= $(LDLIBFLAG)$(LIBNLSRTLNAME)$(LIB_SUFFIX)

LIBUNLSRTLNAME = unls$(NLSRTL_VERSION)$(NLSRTL_DEBUG_LIBTAG)
LIBUNLSRTL= $(LIBHOME)$(LIB_PREFIX)$(LIBUNLSRTLNAME).$(LIB_EXT)
LLIBUNLSRTL= $(LDLIBFLAG)$(LIBUNLSRTLNAME)$(LIB_SUFFIX)

LIBSNLSRTLNAME = snls$(NLSRTL_VERSION)$(NLSRTL_DEBUG_LIBTAG)
LIBSNLSRTL= $(LIBHOME)$(LIB_PREFIX)$(LIBSNLSRTLNAME).$(LIB_EXT)
LLIBSNLSRTL= $(LDLIBFLAG)$(LIBSNLSRTLNAME)$(LIB_SUFFIX)

NLSRTLPUBH = $(I_SYM)$(NLSRTLHOME)include

GSSHOME = $(ORACLE_HOME)/nlsrtl3/java
GSSCLASSES11 = $(ORACLE_HOME)/jlib/orai18n.jar
GSSCLASSES12 = $(ORACLE_HOME)/jlib/orai18n.jar
GSSCHARSET11 = $(ORACLE_HOME)/jlib/orai18n.jar
GSSCHARSET12 = $(ORACLE_HOME)/jlib/orai18n.jar

GDKHOME = $(ORACLE_HOME)/nlsrtl3/java
GDKCLASSES = $(ORACLE_HOME)/jlib/orai18n.jar$(PATHSEP)$(ORACLE_HOME)/jlib/orai18n-lcsd.jar
NLSRTL_JARS = \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-mapping.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-utility.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-collation.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-translation.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-net.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-servlet.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-tools.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-lcsd.jar

NLSRTL_JARS_FOR_GENERAL = \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-mapping.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-utility.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-collation.jar

NLSRTL_JARS_FOR_DBJAVA_JAVAVM = \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-mapping.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-utility.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-collation.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-net.jar

NLSRTL_JARS_FOR_DBJAVA_CLIENT = \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n.jar

# Entering /ade/aime_rdbms_9819/oracle/nlsrtl/s_exports.mk

LIBNLSRTLSHNAME = nlssh$(NLSRTL_VERSION)$(NLSRTL_DEBUG_LIBTAG)
LIBUNLSRTLSHNAME = unlssh$(NLSRTL_VERSION)$(NLSRTL_DEBUG_LIBTAG)
LIBSNLSRTLSHNAME = snlssh$(NLSRTL_VERSION)$(NLSRTL_DEBUG_LIBTAG)

LLIBNLSSH=-lnlssh10
LLIBSNLSSH=-lsnlssh10
LLIBUNLSSH=-lunlssh10

# Exiting /ade/aime_rdbms_9819/oracle/nlsrtl/s_exports.mk
# Exiting /ade/aime_rdbms_9819/oracle/nlsrtl/exports.mk
# Entering /ade/aime_rdbms_9819/oracle/rdbms/exports.mk


RDBMS_VERSION=10
RDBMS_MINOR_VERSION=1

LIBCLNTSTNAME=clntst$(RDBMS_VERSION)
LIBCLNTST=$(LIBHOME)$(LIB_PREFIX)$(LIBCLNTSTNAME).$(LIB_EXT)
LLIBCLNTST=$(LDLIBFLAG)$(LIBCLNTSTNAME)

LIBSERVERNAME=server$(RDBMS_VERSION)
LIBSERVER=$(LIBHOME)$(LIB_PREFIX)$(LIBSERVERNAME).$(LIB_EXT)
LLIBSERVER=$(LDLIBFLAG)$(LIBSERVERNAME)$(LIB_SUFFIX)

LIBCLIENTNAME=client$(RDBMS_VERSION)
LIBCLIENT=$(LIBHOME)$(LIB_PREFIX)$(LIBCLIENTNAME).$(LIB_EXT)
LLIBCLIENT=$(LDLIBFLAG)$(LIBCLIENTNAME)

LIBGENERICNAME=generic$(RDBMS_VERSION)
LIBGENERIC=$(LIBHOME)$(LIB_PREFIX)$(LIBGENERICNAME).$(LIB_EXT)
LLIBGENERIC=$(LDLIBFLAG)$(LIBGENERICNAME)

LIBSKGXPNAME=skgxp$(RDBMS_VERSION)
LIBSKGXP=$(LIBHOME)$(LIB_PREFIX)$(LIBSKGXPNAME).$(SKGXP_EXT)
LLIBSKGXP=$(LDLIBFLAG)$(LIBSKGXPNAME)

LIBSKGTRNAME=skgtr$(RDBMS_VERSION)
LIBSKGTR_MPMT=$(LIBHOME)$(LIB_PREFIX)$(LIBSKGTRNAME).$(SKGTR_EXT)
LIBSKGTR_=
LIBSKGTR=$(LIBSKGTR_$(MPMT_SERVER))
LLIBSKGTR_MPMT=$(LDLIBFLAG)$(LIBSKGTRNAME)
LLIBSKGTR_=
LLIBSKGTR=$(LLIBSKGTR_$(MPMT_SERVER))

LIBSKGXNNAME=skgxn$(RDBMS_VERSION)
LIBSKGXN=$(LIBHOME)$(LIB_PREFIX)$(LIBSKGXNNAME).$(SKGXN_EXT)
LLIBSKGXN=$(LDLIBFLAG)$(LIBSKGXNNAME)
LIBSKGXNI=$(LIBHOME)$(LIB_PREFIX)$(LIBSKGXNNAME).$(SKGXN_EXT)

LIBOCCINAME=occi
LIBOCCI=$(LIBHOME)$(LIB_PREFIX)$(LIBOCCINAME)$(RDBMS_VERSION).$(LIB_EXT)
LLIBOCCI=$(LDLIBFLAG)$(LIBOCCINAME)$(RDBMS_VERSION)
LLIBOCCISTATIC=$(LDLIBFLAG)$(LIBOCCINAME)$(RDBMS_VERSION)

LIBWSECNAME=wsec
LIBWSEC=$(LIBHOME)$(LIB_PREFIX)wsec$(RDBMS_VERSION).$(LIB_EXT)
LLIBWSEC=$(LDLIBFLAG)$(LIB_PREFIX)$(LIBWSECNAME)$(RDBMS_VERSION)

LIBSKGXP_CLT=
LLIBSKGXP_CLT=

LIBCOMMONNAME=common$(RDBMS_VERSION)
LIBCOMMON=$(LIBHOME)$(LIB_PREFIX)$(LIBCOMMONNAME).$(LIB_EXT)
LLIBCOMMON=$(LDLIBFLAG)$(LIBCOMMONNAME)

LIBVSNNAME=vsn$(RDBMS_VERSION)
LIBVSN=$(LIBHOME)$(LIB_PREFIX)$(LIBVSNNAME).$(LIB_EXT)
LLIBVSN=$(LDLIBFLAG)$(LIBVSNNAME)

LIBAGENTNAME=agent$(RDBMS_VERSION)
LIBAGENT=$(LIBHOME)$(LIB_PREFIX)$(LIBAGENTNAME).$(LIB_EXT)
LLIBAGENT=$(LDLIBFLAG)$(LIBAGENTNAME)

LIBDBTOOLSNAME=dbtools$(RDBMS_VERSION)
LIBDBTOOLS=$(RDBMSLIB)$(LIB_PREFIX)$(LIBDBTOOLSNAME).$(LIB_EXT)
LLIBDBTOOLS=$(LDLIBFLAG)$(LIBDBTOOLSNAME)

LIBNNETNAME=nnet$(RDBMS_VERSION)
LIBNNET=$(RDBMSLIB)$(LIB_PREFIX)$(LIBNNETNAME).$(LIB_EXT)
LLIBNNET=$(LDLIBFLAG)$(LIBNNETNAME)

LIBNNETDNAME=nnetd$(RDBMS_VERSION)
LIBNNETD=$(RDBMSLIB)$(LIB_PREFIX)$(LIBNNETDNAME).$(LIB_EXT)
LLIBNNETD=$(LDLIBFLAG)$(LIBNNETDNAME)

LIBNNET_CLT=$(LIBNNETD)
LLIBNNET_CLT=$(LLIBNNETD)

DLMHOME=$(ORACLE_HOME)/odlm/

LIBMMNAME=mm
LIBMM=$(LIBHOME)$(LIB_PREFIX)$(LIBMMNAME).$(LIB_EXT)
LLIBMM=$(LDLIBFLAG)$(LIBMMNAME)


LIBRDBMS_CLT=$(LIBCLIENT) $(LIBNNET_CLT) $(LIBSKGXP_CLT) $(LIBVSN) \
	$(LIBCOMMON) $(LIBGENERIC)
LLIBRDBMS_CLT=$(LLIBCLIENT) $(LLIBNNET_CLT) $(LLIBSKGXP_CLT) $(LLIBVSN) \
	$(LLIBCOMMON) $(LLIBGENERIC)

LIBRDBMS_SERVER=$(LIBCLIENT) $(LIBSKGXP_CLT) $(LIBVSN) \
	$(LIBCOMMON) $(LIBGENERIC)
LLIBRDBMS_SERVER=$(LLIBCLIENT) $(LLIBSKGXP_CLT) $(LLIBVSN) \
	$(LLIBCOMMON) $(LLIBGENERIC)

LIBCLNTSHNAME=clntsh
LIBCLNTSH=$(LIBHOME)$(LIB_PREFIX)$(LIBCLNTSHNAME).$(SO_EXT)
LLIBCLNTSH=$(LDLIBFLAG)$(LIBCLNTSHNAME)

LIBAGTSHNAME=agtsh
LIBAGTSH=$(LIBHOME)$(LIB_PREFIX)$(LIBAGTSHNAME).$(SO_EXT)
LLIBAGTSH=$(LDLIBFLAG)$(LIBAGTSHNAME)

LIBKNLOPTNAME=knlopt
LIBKNLOPT=$(RDBMSLIB)$(LIB_PREFIX)$(LIBKNLOPTNAME).$(LIB_EXT)
LLIBKNLOPT=$(LDLIBFLAG)$(LIBKNLOPTNAME)

LIBORASDKBASENAME=orasdkbase
LIBORASDKBASE=$(LIBHOME)$(LIB_PREFIX)$(LIBORASDKBASENAME).$(SO_EXT)
LLIBORASDKBASE=$(LDLIBFLAG)$(LIBORASDKBASENAME)

LIBORASDKSHNAME=orasdk
LIBORASDKSH=$(LIBHOME)$(LIB_PREFIX)$(LIBORASDKSHNAME).$(SO_EXT)
LLIBORASDKSH=$(LDLIBFLAG)$(LIBORASDKSHNAME)

CONFIG = $(RDBMSLIB)config.$(OBJ_EXT)


LLIBORDSDO=$(LDLIBFLAG)$(LIBORDSDONAME)$(LIB_SUFFIX)
SDOLIBS = `if ${AR} tv $(LIBKNLOPT) | $(GREP) "kxmnsd.$(OBJ_EXT)" > /dev/null 2>&1 ; then echo " " ; else echo "${LLIBORDSDO}"; fi`

DEF_ON= $(RDBMSLIB)kpudfo.$(OBJ_EXT)
DEF_OFF= $(RDBMSLIB)kpundf.$(OBJ_EXT)
DEF_OPT= $(RDBMSLIB)defopt.$(OBJ_EXT)

RDBMSHOME=$(ORACLE_HOME)/rdbms/
RDBMSLIB=$(RDBMSHOME)$(LIBDIR)/
RDBMSADMIN=$(RDBMSHOME)admin/

ORAMAPLIB=$(RDBMSLIB)

LIBNIDNAME=nid
LIBNID=$(RDBMSLIB)$(LIB_PREFIX)$(LIBNIDNAME).$(LIB_EXT)
LLIBNID=$(LDLIBFLAG)$(LIBNIDNAME)

THREAD_ORALIBS_MPMT=-lthread -lpthread
THREAD_ORALIBS_=
THREAD_ORALIBS=$(THREAD_ORALIBS_$(MPMT_SERVER))

ORACLE_KERNEL_LIBS=$(LLIBSKGTR) $(LLIBPERFSRV) $(NAETTOBJS) $(CONFIG)\
	$(SPOBJS) $(LLIBSERVER) $(LLIBODM) \
	$(LLIBNNET) $(LLIBSKGXP) $(CORELIBS) $(CSSCLNTLIBS_SERVER) $(LLIBRDBMS_SERVER) \
	$(LLIBKNLOPT) $(OLAPLINKOPTS) \
	$(LLIBSLAX) $(LLIBPLSQL) $(LLIBSERVER) $(LLIBRDBMS_SERVER) \
	$(LLIBKNLOPT) $(LLIBSLAX) $(LLIBPLSQL) $(LLIBJAVAVMORJOX) \
	$(CLSRLIBS_SERVER)\
	$(LLIBOCIJDBCST) $(LLIBWWG) $(NTZEOBJ) $(NETLIBS) $(LLIBMM) $(CORELIBS)\
	$(NETLIBS) $(LIBPLS_CLT) $(LLIBEPC) $(CORELIBS) $(SDOLIBS) $(CARTLIBS) \
	$(CORELIBS) $(LLIBSNLSRTL) $(LLIBUNLSRTL) $(LLIBXSD) $(CORELIBS) \
	$(PL_ORALIBS) $(THREAD_ORALIBS)
LIBCLIENTSHNAME=clientsh$(RDBMS_VERSION)
LLIBCLIENTSH=$(LDLIBFLAG)$(LIBCLIENTSHNAME)$(LIB_SUFFIX)
LIBGENERICSHNAME=genericsh$(RDBMS_VERSION)
LLIBGENERICSH=$(LDLIBFLAG)$(LIBGENERICSHNAME)$(LIB_SUFFIX)
LIBCOMMONSHNAME=commonsh$(RDBMS_VERSION)
LLIBCOMMONSH=$(LDLIBFLAG)$(LIBCOMMONSHNAME)$(LIB_SUFFIX)
LIBMMSHNAME=mmsh
LLIBMMSH=$(LDLIBFLAG)$(LIBMMSHNAME)$(LIB_SUFFIX)
LIBVSNSHNAME=vsnsh$(RDBMS_VERSION)
LLIBVSNSH=$(LDLIBFLAG)$(LIBVSNSHNAME)$(LIB_SUFFIX)
LIBNNETSHNAME=nnetsh$(RDBMS_VERSION)
LLIBNNETSH=$(LDLIBFLAG)$(LIBNNETSHNAME)$(LIB_SUFFIX)
# Entering /ade/aime_rdbms_9819/oracle/rdbms/s_exports.mk


LIBPERFSRVNAME=perfsrv$(RDBMS_VERSION)
LIBPERFSRV=$(LIBHOME)$(LIB_PREFIX)$(LIBPERFSRVNAME).$(LIB_EXT)
LLIBPERFSRV=-Wl,--whole-archive $(LDLIBFLAG)$(LIBPERFSRVNAME)$(LIB_SUFFIX) -Wl,--no-whole-archive

SKGXP_EXT=$(SO_EXT)



SKGXN_EXT=$(SO_EXT)


SKGXN_VERSION=2
LLIBOCCI=$(LDLIBFLAG)$(LIBOCCINAME)
LIBOCCI=$(LIBHOME)$(LIB_PREFIX)$(LIBOCCINAME).$(SO_EXT).$(RDBMS_VERSION).$(RDBMS_MINOR_VERSION)


LIBSKGXNNAME=skgxn$(SKGXN_VERSION)
LIBSKGXN=$(LIBHOME)$(LIB_PREFIX)$(LIBSKGXNNAME).$(SKGXN_EXT)

# Exiting /ade/aime_rdbms_9819/oracle/rdbms/s_exports.mk
# Exiting /ade/aime_rdbms_9819/oracle/rdbms/exports.mk
# Entering /ade/aime_rdbms_9819/oracle/plsql/exports.mk

PLSQL_VERSION=10

WRAP=$(BINHOME)wrap

LIBPLSNAME=pls
LIBPLSN=$(LIBHOME)$(LIB_PREFIX)$(LIBPLSNAME)$(PLSQL_VERSION).$(LIB_EXT)
LLIBPLS=$(LDLIBFLAG)$(LIBPLSNAME)$(PLSQL_VERSION) 
LIBPLSNSHR=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLSNAME).$(SO_EXT)
ILIBPLSN=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLSNAME).$(ILIB_EXT)
LIBPLPNAME=plp
LIBPLPN=$(LIBHOME)$(LIB_PREFIX)$(LIBPLPNAME)$(PLSQL_VERSION).$(LIB_EXT)
LLIBPLP=$(LDLIBFLAG)$(LIBPLPNAME)$(PLSQL_VERSION)
LIBPLPNSHR=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLPNAME).$(SO_EXT)
ILIBPLPN=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLPNAME).$(ILIB_EXT)
LIBPLCNAME=plc
LIBPLCN=$(LIBHOME)$(LIB_PREFIX)$(LIBPLCNAME)$(PLSQL_VERSION).$(LIB_EXT)
LLIBPLC=$(LDLIBFLAG)$(LIBPLCNAME)$(PLSQL_VERSION)
LIBPLCSHR=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLCNAME).$(SO_EXT)
ILIBPLCN=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLCNAME).$(ILIB_EXT)

LIBEXTP=$(LIBHOME)$(LIB_PREFIX)$(LIBPLSNAME)$(PLSQL_VERSION).$(LIB_EXT)
LLIBEXTP=$(LDLIBFLAG)$(LIBPLSNAME)$(PLSQL_VERSION)

LIBPLSF=$(LIBHOME)$(LIB_PREFIX)$(LIBPLSNAME)$(PLSQL_VERSION).$(LIB_EXT) 
LLIBPLSF=$(LDLIBFLAG)$(LIBPLSNAME)$(PLSQL_VERSION) $(LDLIBFLAG)$(LIBPLPNAME)$(PLSQL_VERSION)

LIBPLSB=$(LIBHOME)$(LIBPLSNAME)$(PLSQL_VERSION)
LLIBPLSB=$(LDLIBFLAG)$(LIBPLSNAME)$(PLSQL_VERSION)

PLSQLLIBS=$(LIBPLSN) $(LIBPLPN)
LPLSQLLIBS=$(LLIBPLS)


LLIBPLSQL= $(LPLSQLLIBS) $(LLIBPLP)

LIBPSANAME=psa
LIBICD=$(LIBHOME)$(LIB_PREFIX)$(LIBPLPNAME)$(PLSQL_VERSION).$(LIB_EXT)
LLIBICD=$(LDLIBFLAG)$(LIBPLPNAME)$(PLSQL_VERSION)
LIBPSD=$(LIBHOME)$(LIB_PREFIX)$(LIBPLCNAME)$(PLSQL_VERSION).$(LIB_EXT)
LLIBPSD=$(LDLIBFLAG)$(LIBPLCNAME)$(PLSQL_VERSION)
LIBPSA=$(LIBHOME)$(LIB_PREFIX)$(LIBPSANAME)$(PLSQL_VERSION).$(LIB_EXT)
LLIBPSA=$(LDLIBFLAG)$(LIBPSANAME)$(PLSQL_VERSION)

PLSQLHOME=$(ORACLE_HOME)/plsql/

PLSSHNAME=plssh$(PLSQL_VERSION)
LLIBPLSSH=$(LDLIBFLAG)$(PLSSHNAME)$(LIB_SUFFIX)
PLPSHNAME=plpsh$(PLSQL_VERSION)
LLIBPLPSH=$(LDLIBFLAG)$(PLPSHNAME)$(LIB_SUFFIX)
# Entering /ade/aime_rdbms_9819/oracle/plsql/s_exports.mk
 
# Exiting /ade/aime_rdbms_9819/oracle/plsql/s_exports.mk
# Exiting /ade/aime_rdbms_9819/oracle/plsql/exports.mk
# Entering /ade/aime_rdbms_9819/oracle/slax/exports.mk

TOP = $(ORACLE_HOME)/slax

SLAX_VERSION=10
LIBSLAXNAME=slax$(SLAX_VERSION)
LLIBSLAX=$(LDLIBFLAG)$(LIBSLAXNAME)$(LIB_SUFFIX)
LIBSLAX=$(LIBHOME)$(LIB_PREFIX)$(LIBSLAXNAME).$(LIB_EXT)

SLAX_PRD=slax
SLAXHOME=$(ORACLE_HOME)/slax/
SLAXADMIN=$(SLAXHOME)admin/
SLAXLIB=$(SLAXHOME)$(LIBDIR)/
 
SLAXPUBH=$(I_SYM)$(SLAXHOME)include

# Entering /ade/aime_rdbms_9819/oracle/slax/s_exports.mk

# Exiting /ade/aime_rdbms_9819/oracle/slax/s_exports.mk
# Exiting /ade/aime_rdbms_9819/oracle/slax/exports.mk
# Entering /ade/aime_rdbms_9819/oracle/xdk/exports.mk

XDKHOME    = $(ORACLE_HOME)/xdk/

XDK_LIB_VER    = 10



XML_LIB_NAME     = xml
XML_LIB_VER      = $(XDK_LIB_VER)
XML_LIB          = $(XML_LIB_NAME)$(XML_LIB_VER)

LIBXML_STATIC    = $(LIB_PREFIX)$(XML_LIB).$(LIB_EXT)
LIBXML_SHARED    = $(LIB_PREFIX)$(XML_LIB).$(SO_EXT)
LIBXML_SLH       = $(LIB_PREFIX)$(XML_LIB).$(ILIB_EXT)

LIBXML           = $(LIBHOME)$(LIBXML_STATIC)
LLIBXML          = $(LDLIBFLAG)$(XML_LIB)

LIBXML_ARC_LIB	 = $(LIBXML)
LIBXML_SHARE_LIB = $(LIBHOME)$(LIBXML_SHARED)

XDKPUBLIC=$(XDKHOME)include $(XDKHOME)public

XDKPUBH=$(I_SYM)$(XDKHOME)include $(I_SYM)$(XDKHOME)public

XMLORGJAR = $(XDKSRC)java/lib/xmlorg.jar
XMLORG2JAR = $(XDKSRC)java/lib/xmlorg2.jar


XML = xml
XMLJAR = $(LIBHOME)$(XML).$(JAR_EXT)

XMLPARSERV2 = xmlparserv2
XMLPARSERV2JAR = $(LIBHOME)$(XMLPARSERV2).$(JAR_EXT)

XMLMESG = xmlmesg
XMLMESGJAR = $(LIBHOME)$(XMLMESG).$(JAR_EXT)

XMLCOMP = xmlcomp
XMLCOMPJAR = $(LIBHOME)$(XMLCOMP).$(JAR_EXT)

XMLCOMP2 = xmlcomp2
XMLCOMP2JAR = $(LIBHOME)$(XMLCOMP2).$(JAR_EXT)

XMLDEMO = xmldemo

CLASSGEN = classgen
CLASSGENJAR = $(LIBHOME)$(CLASSGEN).$(JAR_EXT)

XSCHEMA = xschema
XSCHEMAJAR  = $(LIBHOME)$(XSCHEMA).$(JAR_EXT)

XSQL = oraclexsql
XSQLJAR = $(LIBHOME)$(XSQL).$(JAR_EXT)

XSQLSERIAL = xsqlserializers
XSQLSERIALJAR = $(LIBHOME)$(XSQLSERIAL).$(JAR_EXT)

XSU = xsu12
XSUJAR = $(LIBHOME)$(XSU).$(JAR_EXT)

TRANSX = transx
TRANSXJAR  = $(LIBHOME)$(TRANSX).$(ZIP_EXT)

JAXBJAR = $(XDKSRC)java/lib/jaxb.jar

XQUERY = xquery
XQUERYJAR  = $(LIBHOME)$(XQUERY).$(JAR_EXT)

XQJAPI = xqjapi
XQJAPIJAR  = $(LIBHOME)$(XQJAPI).$(JAR_EXT)

XQJORI = xqjori
XQJORIJAR  = $(LIBHOME)$(XQJORI).$(JAR_EXT)



# Entering /ade/aime_rdbms_9819/oracle/xdk/s_exports.mk
 
# Exiting /ade/aime_rdbms_9819/oracle/xdk/s_exports.mk



# Exiting /ade/aime_rdbms_9819/oracle/xdk/exports.mk
# Entering /ade/aime_rdbms_9819/oracle/javavm/exports.mk
LIBJAVAVM=$(LIBHOME)$(LIB_PREFIX)aurora.$(LIB_EXT)
LLIBJAVAVM=$(LDLIBFLAG)aurora

# Entering /ade/aime_rdbms_9819/oracle/javavm/s_exports.mk

# Exiting /ade/aime_rdbms_9819/oracle/javavm/s_exports.mk
# Exiting /ade/aime_rdbms_9819/oracle/javavm/exports.mk

# Entering /ade/aime_rdbms_9819/oracle/dbjava/exports.mk

JDBCHOME=$(ORACLE_HOME)/dbjava/

JDBC_VERSION = 10
JDBC_MAJOR_VERSION = 10
JDBC_MINOR_VERSION = 2
JDBC_VERSION_STRING = \"10.2.0.1.0\"

JDBCCLASSES14_JAR=$(ORACLE_HOME)/dbjava/lib/ojdbc14.jar
JDBCCLASSES12=$(ORACLE_HOME)/dbjava/lib/classes12.zip
JDBCCLASSES12_JAR=$(ORACLE_HOME)/dbjava/lib/classes12.jar
JDBCCLASSES14DBG_JAR=$(ORACLE_HOME)/dbjava/lib/ojdbc14_g.jar
JDBCCLASSES12DBG_JAR=$(ORACLE_HOME)/dbjava/lib/classes12_g.jar
JDBCCLASSES12DMS_JAR=$(ORACLE_HOME)/dbjava/lib/classes12dms.jar
JDBCCLASSES12DMSDBG_JAR=$(ORACLE_HOME)/dbjava/lib/classes12dms_g.jar
JDBCCLASSES12PRIV_JAR=$(ORACLE_HOME)/dbjava/lib/classes12_priv.jar
JDBCCLASSES12DMSPRIV_JAR=$(ORACLE_HOME)/dbjava/lib/classes12dms_priv.jar
JDBCCLASSES14PRIV_JAR=$(ORACLE_HOME)/dbjava/lib/ojdbc14_priv.jar
JDBCCLASSES14DMSPRIV_JAR=$(ORACLE_HOME)/dbjava/lib/ojdbc14dms_priv.jar
JDBCCLASSES14DMSDBG_JAR=$(ORACLE_HOME)/dbjava/lib/ojdbc14dms_g.jar
JDBCCLASSES14DMS_JAR=$(ORACLE_HOME)/dbjava/lib/ojdbc14dms.jar

ZIPFILES=\
    $(ORACLE_HOME)/dbjava/lib/classes12.zip \
    $(ORACLE_HOME)/dbjava/lib/harness.zip \
    $(ORACLE_HOME)/dbjava/lib/classes12.jar \
    $(ORACLE_HOME)/dbjava/lib/classes12_g.jar \
    $(ORACLE_HOME)/dbjava/lib/classes12_priv.jar \
    $(ORACLE_HOME)/dbjava/lib/classes12dms.jar \
    $(ORACLE_HOME)/dbjava/lib/classes12dms_g.jar \
    $(ORACLE_HOME)/dbjava/lib/classes12dms_priv.jar \
    $(ORACLE_HOME)/dbjava/lib/ojdbc14.jar \
    $(ORACLE_HOME)/dbjava/lib/ojdbc14_g.jar \
    $(ORACLE_HOME)/dbjava/lib/ojdbc14_priv.jar \
    $(ORACLE_HOME)/dbjava/lib/ojdbc14dms.jar \
    $(ORACLE_HOME)/dbjava/lib/ojdbc14dms_g.jar \
    $(ORACLE_HOME)/dbjava/lib/ojdbc14dms_priv.jar \
    $(ORACLE_HOME)/dbjava/lib/ojdbc4javavm.jar \
    $(ORACLE_HOME)/dbjava/doc/javadoc.zip\
    $(ORACLE_HOME)/dbjava/demo/demo.zip

JDBCJAR4JAVAVM=$(ORACLE_HOME)/dbjava/lib/ojdbc4javavm.jar

TYPE2SERVERLIBNAME=jdbct2s$(JDBC_VERSION)
LOC_LIBT2SJDBC=$(JDBCHOME)lib/$(LIB_PREFIX)$(TYPE2SERVERLIBNAME).$(LIB_EXT)
LIBJDBC4JAVAVM=$(LOC_LIBT2SJDBC)
LLIBJDBC4JAVAVM=$(LDLIBFLAG)$(TYPE2SERVERLIBNAME)$(LIB_SUFFIX)

TYPE2SERVERLIBNAME_DEBUG=jdbct2s$(JDBC_VERSION)_g
LOC_LIBT2SJDBC_DEBUG=$(JDBCHOME)lib/$(LIB_PREFIX)$(TYPE2SERVERLIBNAME_DEBUG).$(LIB_EXT)
LIBJDBC4JAVAVM_DEBUG=$(LOC_LIBT2SJDBC_DEBUG)
LLIBJDBC4JAVAVM_DEBUG=$(LDLIBFLAG)$(TYPE2SERVERLIBNAME_DEBUG)$(LIB_SUFFIX)

OCIJDBCNAME=ocijdbc$(JDBC_VERSION)
LIBOCIJDBC=$(JDBCHOME)lib/$(LIB_PREFIX)$(OCIJDBCNAME).$(LIB_EXT)
LLIBOCIJDBC=$(LDLIBFLAG)$(OCIJDBCNAME)$(LIB_SUFFIX)

OCIJDBCSTNAME=ocijdbcst$(JDBC_VERSION)
LLIBOCIJDBCST=$(LDLIBFLAG)$(OCIJDBCSTNAME)$(LIB_SUFFIX)

JDBC_OCI_LIB=$(JDBCHOME)lib/$(LIB_PREFIX)$(OCIJDBCNAME).$(SO_EXT)
JDBC_OCI_LIB_DEBUG=$(JDBCHOME)lib/$(LIB_PREFIX)$(OCIJDBCNAME)_g.$(SO_EXT)

HETEROXANAME = heteroxa$(JDBC_VERSION)
JDBC_XA_LIB=$(JDBCHOME)lib/$(LIB_PREFIX)$(HETEROXANAME).$(SO_EXT)
JDBC_XA_LIB_DEBUG=$(JDBCHOME)lib/$(LIB_PREFIX)$(HETEROXANAME)_g.$(SO_EXT)

JDBCPUBH=$(I_SYM)$(JDBCHOME)if

JDBC_BASIC_ZIP=$(ORACLE_HOME)$(DIRSEP)jdbc$(DIRSEP)lib$(DIRSEP)classes12.jar \
    $(ORACLE_HOME)$(DIRSEP)jdbc$(DIRSEP)lib$(DIRSEP)ojdbc14.jar \
    $(ORACLE_HOME)$(DIRSEP)lib$(DIRSEP)$(LIB_PREFIX)ocijdbc10.$(SO_EXT)

JDBC_EXTRA_ZIP=$(ORACLE_HOME)$(DIRSEP)lib$(DIRSEP)$(LIB_PREFIX)heteroxa10.$(SO_EXT)
 
# Exiting /ade/aime_rdbms_9819/oracle/dbjava/exports.mk

# Entering /ade/aime_rdbms_9819/oracle/ctx/exports.mk



CTX_VERSION=10


LIBCTXSNAME=ctxs$(CTX_VERSION)
LIBCTXS = $(CTXLIB)$(LIB_PREFIX)$(LIBCTXSNAME).$(LIB_EXT)
LLIBCTXS = $(LDLIBFLAG)$(LIBCTXSNAME)$(LIB_SUFFIX)

LIBCTXWKLNAME=wkl
LIBCTXWK = $(CTXLIB)$(LIB_PREFIX)$(LIBCTXWKLNAME).$(LIB_EXT)
LLIBCTXWKL = $(LDLIBFLAG)$(LIBCTXWKLNAME)$(LIB_SUFFIX)

LIBCTXCNAME=ctxc$(CTX_VERSION)
LIBCTXC = $(CTXLIB)$(LIB_PREFIX)$(LIBCTXCNAME).$(LIB_EXT)
LLIBCTXC = $(LDLIBFLAG)$(LIBCTXCNAME)$(LIB_SUFFIX)

LIBCTXNAME=ctx$(CTX_VERSION)
LIBCTX = $(CTXLIB)$(LIB_PREFIX)$(LIBCTXNAME).$(LIB_EXT)
LLIBCTX = $(LDLIBFLAG)$(LIBCTXNAME)$(LIB_SUFFIX)
 
LIBZXNAME=zx$(CTX_VERSION)
LIBZX = $(CTXLIB)$(LIB_PREFIX)$(LIBZXNAME).$(LIB_EXT)
LLIBZX = $(LDLIBFLAG)$(LIBZXNAME)$(LIB_SUFFIX)
 
LIBGXNAME=gx$(CTX_VERSION)
LIBGX = $(CTXLIB)$(LIB_PREFIX)$(LIBGXNAME).$(LIB_EXT)
LLIBGX = $(LDLIBFLAG)$(LIBGXNAME)$(LIB_SUFFIX)
 
CTX_LINK = $(LLIBCTXC) $(LLIBCTX) $(LLIBZX) $(LLIBGX) $(LLIBCTX) $(LLIBZX) $(LLIBGX)

CTXHOME=$(ORACLE_HOME)/ctx/

CTXPUBH=$(I_SYM)$(CTXHOME)public

CTXLIB=$(CTXHOME)lib/

# Entering /ade/aime_rdbms_9819/oracle/ctx/s_exports.mk
# Exiting /ade/aime_rdbms_9819/oracle/ctx/s_exports.mk
# Exiting /ade/aime_rdbms_9819/oracle/ctx/exports.mk
# Entering /ade/aime_rdbms_9819/oracle/javavm/exports.mk
LIBJAVAVM=$(LIBHOME)$(LIB_PREFIX)aurora.$(LIB_EXT)
LLIBJAVAVM=$(LDLIBFLAG)aurora

# Entering /ade/aime_rdbms_9819/oracle/javavm/s_exports.mk

# Exiting /ade/aime_rdbms_9819/oracle/javavm/s_exports.mk
# Exiting /ade/aime_rdbms_9819/oracle/javavm/exports.mk
# Entering /ade/aime_rdbms_9819/oracle/sqlplus/exports.mk

PRODUCT=sqlplus
SQLPLUSHOME=$(ORACLE_HOME)/sqlplus/
SQLPLUSLIBDIR=$(SQLPLUSHOME)$(LIBDIR)/

LIBSQLPLUSNAME = sqlplus
LIBISQLPLUSNAME= isqlplus
LIBSQLPLUSICNAME= sqlplusic
LIBSQLPLUSSO   = $(SQLPLUSLIBDIR)$(LIB_PREFIX)$(LIBSQLPLUSNAME).$(SO_EXT)
LIBSQLPLUS     = $(SQLPLUSLIBDIR)$(LIB_PREFIX)$(LIBSQLPLUSNAME).$(LIB_EXT)
LIBISQLPLUSSO  = $(SQLPLUSLIBDIR)$(LIB_PREFIX)$(LIBISQLPLUSNAME).$(SO_EXT)
LIBISQLPLUS    = $(SQLPLUSLIBDIR)$(LIB_PREFIX)$(LIBISQLPLUSNAME).$(LIB_EXT)
LIBSQLPLUSICSO = $(SQLPLUSLIBDIR)$(LIB_PREFIX)$(LIBSQLPLUSICNAME).$(SO_EXT)
LIBSQLPLUSIC   = $(SQLPLUSLIBDIR)$(LIB_PREFIX)$(LIBSQLPLUSICNAME).$(LIB_EXT)
LLIBSQLPLUS    = $(LDLIBFLAG)$(LIBSQLPLUSNAME)
LLIBISQLPLUS   = $(LDLIBFLAG)$(LIBISQLPLUSNAME)
LLIBSQLPLUSIC  = $(LDLIBFLAG)$(LIBSQLPLUSICNAME)

LIBMAIN        = $(SQLPLUSLIBDIR)s0afimai.$(OBJ_EXT)
LLIBMAIN       = $(SQLPLUSLIBDIR)s0afimai.$(OBJ_EXT)

SQLPLUSLIBS    = $(LLIBMAIN) $(LLIBSQLPLUS)
ISQLPLUSLIBS   = $(LLIBISQLPLUS) $(LLIBSQLPLUS)
SQLPLUSICLIBS  = $(LLIBSQLPLUSIC)

SQLPLUS        = $(SQLPLUSBINDIR)sqlplus$(EXE_SUFFIX)

# Entering /ade/aime_rdbms_9819/oracle/sqlplus/s_exports.mk

SHARED_LDFLAG=-shared -L$(SQLPLUSHOME)lib -L$(ORACLE_HOME)/lib -R$(ORACLE_HOME)/lib -o
LDSYMSTRIP=-s
S_LDOPTS=-h $(LIB_PREFIX)$(LIBSQLPLUSNAME).$(SO_EXT) $(LDSYMSTRIP) \
-u afidrv -z defs -lc

HELPINS=$(SQLPLUSBINDIR)helpins
# Exiting /ade/aime_rdbms_9819/oracle/sqlplus/s_exports.mk
# Exiting /ade/aime_rdbms_9819/oracle/sqlplus/exports.mk
 
# Entering /ade/aime_rdbms_9819/oracle/precomp/exports.mk

TOP=$(ORACLE_HOME)/precomp

PRECOMP_VERSION=10
LIBSQLNAME=sql$(PRECOMP_VERSION)
LLIBSQL=$(LDLIBFLAG)$(LIBSQLNAME)$(LIB_SUFFIX)
LIBSQL=$(LIBHOME)$(LIB_PREFIX)$(LIBSQLNAME).$(LIB_EXT)

PRECOMP_PRD=precomp
PRECOMPHOME=$(ORACLE_HOME)/precomp/
PRECOMPADMIN=$(PRECOMPHOME)admin/
PRECOMPLIB=$(PRECOMPHOME)$(LIBDIR)/

OTTCLASSESZIP=$(PRECOMPLIB)ottclasses.$(ZIP_EXT)

PRECOMPPUBH=$(I_SYM)$(PRECOMPHOME)public $(I_SYM)$(PRECOMPHOME)include

LIBSQLSHNAME=sqlsh$(PRECOMP_VERSION)
LLIBSQLSH=$(LDLIBFLAG)$(LIBSQLSHNAME)$(LIB_SUFFIX)

# Entering /ade/aime_rdbms_9819/oracle/precomp/s_exports.mk
 
# Exiting /ade/aime_rdbms_9819/oracle/precomp/s_exports.mk
# Exiting /ade/aime_rdbms_9819/oracle/precomp/exports.mk

PRODUCT=precomp

PRECOMPADALIB=$(PRECOMPHOME)pubsrc/adalib/
PRECOMPBIN=$(PRECOMPHOME)$(BINDIR)/
PRECOMPDEMO=$(PRECOMPHOME)demo/
PRECOMPINCLUDE=$(PRECOMPHOME)include/
PRECOMPINSTALL=$(PRECOMPHOME)install/
PRECOMPMESG=$(PRECOMPHOME)mesg/
PRECOMPSRC=$(PRECOMPHOME)src/
PRECOMPUTL=$(PRECOMPHOME)utl/

OTTCLASS=$(PRECOMPHOME)classes/
JAVAC=$(JDK_HOME)/bin/javac
JAVAC_MEM_FLAG = -J-mx64m

UTL_SCRIPTS = \
        ott \

PRODLIBHOME=$(PRECOMPLIB)


LIBFIDLNAME=fidl
LIBMODNAME=mod
LIBPCCNAME=pcc
LIBPFONAME=pfo
LIBPGPNAME=pgp
LIBPPLNAME=ppl
LIBPROC2NAME=proc2
LIBPROCOB2NAME=procob2
LIBPSDNAME=psd
LIBSQXNAME=sqx8

LIBFIDL=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBFIDLNAME).$(LIB_EXT)
LIBMOD=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBMODNAME).$(LIB_EXT)
LIBPCC=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBPCCNAME).$(LIB_EXT)
LIBPFO=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBPFONAME).$(LIB_EXT)
LIBPGP=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBPGPNAME).$(LIB_EXT)
LIBPPL=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBPPLNAME).$(LIB_EXT)
LIBPROC2=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBPROC2NAME).$(LIB_EXT)
LIBPROCOB2=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBPROCOB2NAME).$(LIB_EXT)
LIBPSD=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBPSDNAME).$(LIB_EXT)
LIBSQX=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBSQXNAME).$(LIB_EXT)

LOC_LIBSQL=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBSQLNAME).$(LIB_EXT)

LIBS=$(PRODLIBHOME)$(LIB_PREFIX)$(LIBSQLNAME).$(LIB_EXT)

PRECOMP_LIBS=$(LIBFIDL) $(LIBMOD) $(LIBPCC) $(LIBPFO) \
	$(LIBPGP) $(LIBPPL) $(LIBPROC2) $(LIBPROCOB2) $(LIBPSD) $(LOC_LIBSQL)

SHLIBS=$(PRODSOHOME)$(LIB_PREFIX)$(LIBSQLNAME).$(SO_EXT)
 
COB2MAIN=$(PRECOMPLIB)spcbd.$(OBJ_EXT)
FIDLMAIN=$(PRECOMPLIB)ilmain.$(OBJ_EXT)
FORMAIN=$(PRECOMPLIB)spc1drv.$(OBJ_EXT)
MODADAMAIN=$(PRECOMPLIB)pmsapr.$(OBJ_EXT) $(PRECOMPLIB)spmmain.$(OBJ_EXT)
PLIMAIN=$(PRECOMPLIB)spc3drv.$(OBJ_EXT)
 
PD1OBJ=pd1.$(OBJ_EXT)
PDAOBJ=pda.$(OBJ_EXT)
PDBOBJ=pdb.$(OBJ_EXT)
PDCOBJ=pdc.$(OBJ_EXT)
PDFOBJ=pdf.$(OBJ_EXT)
PDSOBJ=pds.$(OBJ_EXT)
CODEGENOBJS=$(PD1OBJ) $(PDAOBJ) $(PDCOBJ) $(PDBOBJ) $(PDFOBJ) $(PDSOBJ)

ADAPDC=$(PRECOMPLIB)$(PDAOBJ) $(PRECOMPLIB)$(PDSOBJ)
CPDC=$(PRECOMPLIB)$(PDCOBJ) $(PRECOMPLIB)$(PDSOBJ)
COBPDC=$(PRECOMPLIB)$(PDBOBJ) $(PRECOMPLIB)$(PDSOBJ)
FORPDC=$(PRECOMPLIB)$(PDFOBJ) $(PRECOMPLIB)$(PDSOBJ)
PLIPDC=$(PRECOMPLIB)$(PD1OBJ) $(PRECOMPLIB)$(PDSOBJ)

PRECOMP_OBJFILES=$(ADAPDC) $(CPDC) $(COBPDC) $(FORPDC) $(PLIPDC) \
		 $(COB2MAIN) $(FIDLMAIN) $(FORMAIN) $(MODADAMAIN) $(PLIMAIN)

PRECOMPPUBH32=

PRECOMPH=$(I_SYM)$(PRECOMPHOME)hdrs
PRECOMPSH=$(PRECOMPH) $(PRECOMPPUBH32) $(PRECOMPPUBH)

INCLUDE=$(PRECOMPSH) $(PLSQLPUBH) $(RDBMSPUBH) $(ORACOREPUBH) $(NLSRTLPUBH) \
	$(OTRACEPUBH) $(NETWORKPUBH) $(SLAXPUBH) $(JAVAVMPUBH) $(OTHER_H) $(I_SYM).


STATICPROLDLIBS=$(STATIC_LDCLIENTLIBS) $(LLIBTHREAD)
DYNAMICPROLDLIBS=$(SHARED_LDCLIENTLIBS) $(LLIBTHREAD)
PROLDLIBS=$(DYNAMICPROLDLIBS)
LLIBCLNTSHS=-lsqlsh10

STATICCPPLDLIBS=$(STATIC_LDCLIENTLIBS)
DYNAMICCPPLDLIBS=$(SHARED_LDCLIENTLIBS)
CPPLDLIBS=$(DYNAMICCPPLDLIBS)

COBOL_STATICPROLDLIBS=$(STATIC_CLIENTLIBS) $(COBLDLIBS) $(LLIBTHREAD)
COBOL_DYNAMICPROLDLIBS=$(SHARED_CLIENTLIBS) $(COBLDLIBS) $(LLIBTHREAD)
COBOL_PROLDLIBS=$(COBOL_DYNAMICPROLDLIBS)

LIBPLS_CLT=$(LPLSQLLIBS)

OTT=ott$(EXE_SUFFIX)
MODADA=modada$(EXE_SUFFIX)
PROC=proc$(EXE_SUFFIX)
PROCOB=procob$(EXE_SUFFIX)
PROFOR=profor$(EXE_SUFFIX)
PROPLI=propli$(EXE_SUFFIX)
RTSORA=rtsora$(EXE_SUFFIX)

LOC_MODADA=$(PRECOMPBIN)$(MODADA)
LOC_PROC=$(PRECOMPBIN)$(PROC)
LOC_PROCOB=$(PRECOMPBIN)$(PROCOB)
LOC_PROFOR=$(PRECOMPBIN)$(PROFOR)
LOC_PROPLI=$(PRECOMPBIN)$(PROPLI)
LOC_RTSORA=$(PRECOMPBIN)$(RTSORA)

MODADA_LINKLINE=$(LINK) $(MODADAMAIN) $(LIBMOD) $(ADAPDC) $(LIBSLAX) \
		$(LIBPGP) $(LLIBPLSQL) $(LLIBSNLSRTL) $(LLIBUNLSRTL) \
		$(LLIBNLSRTL) $(DEF_ON) $(SSCOREED) $(LINKTTLIBS)

PROC_LINKLINE=$(LINK) $(S0MAIN) $(CPDC) $(LIBPROC2) $(LIBSLAX) \
	      $(LIBPGP) $(LLIBPLSQL) $(LIBPLCN) $(LLIBSNLSRTL) $(LLIBUNLSRTL) \
	      $(LLIBNLSRTL) $(DEF_ON) $(LINKTTLIBS)

PROCOB_LINKLINE=$(LINK) $(COB2MAIN) $(LIBPROCOB2) $(LIBSLAX) $(COBPDC) \
	        $(LIBPGP) $(DEF_ON) $(LLIBPLSQL) $(LIBPROCOB2) $(LLIBPLSQL) \
		$(LIBPLCN) \
	        $(LLIBSNLSRTL) $(LLIBUNLSRTL) $(LLIBNLSRTL) $(SSCOREED) \
		$(LINKTTLIBS)

PROFOR_LINKLINE=$(LINK) $(FORMAIN) $(FORPDC) $(LIBPFO) \
		$(LIBPCC) $(LIBPGP) $(LLIBPLSQL) $(LIBPSD) $(LIBSLAX) \
		$(LLIBPLSQL) $(LIBPLCN) $(LIBPSD) \
		$(LLIBSNLSRTL) $(LLIBUNLSRTL) \
		$(LLIBNLSRTL) $(DEF_ON) $(SSCOREED) $(LINKTTLIBS)

PROPLI_LINKLINE=$(LINK) $(PLIMAIN) $(PLIPDC) $(LIBPPL) $(LIBPCC) \
		$(LIBPGP) $(LLIBPLSQL) $(LIBSLAX) $(LIBPSD) $(LLIBPLSQL) \
		$(LIBPLCN) $(LIBPSD) \
		$(LLIBSNLSRTL) $(LLIBUNLSRTL) $(LLIBNLSRTL) \
		$(DEF_ON) $(SSCOREED) $(LINKTTLIBS)

RTSORA_LINKLINE=$(COB) -o $(LOC_RTSORA) -t -xe "" $(RTSPORTFLAGS) \
		$(COBSQLINTF) $(SCOREPT) $(SSCOREED) $(DEF_ON) $(LDPATHFLAG) \
		$(LIBHOME) $(LLIBCLNTSH)

EXE_PROT=755


DEMO_PROC_BUILD_SHARED=$(CC) -o $(EXE) $(OBJS) $(LDPATHFLAG)$(LIBHOME) $(PROLDLIBS)
DEMO_PROC_BUILD_STATIC=$(CC) -o $(EXE) $(OBJS) $(LDPATHFLAG)$(LIBHOME) $(STATICPROLDLIBS)
DEMO_PROC_CPPBUILD_SHARED=$(CPLUSPLUS) -o $(EXE) $(OBJS) $(LDPATHFLAG)$(LIBHOME) $(CPPLDLIBS)
DEMO_PROC_CPPBUILD_STATIC=$(CPLUSPLUS) -o $(EXE) $(OBJS) $(LDPATHFLAG)$(LIBHOME) $(STATICCPPLDLIBS)
PCC2C=$(PROC) $(PROCFLAGS) iname=$(PCCSRC) $(INCLUDE)
C2O=$(CC) $(CFLAGS) -c $*.c
CPP2O_EXE=$(CPLUSPLUS) -c $(INCLUDE) $(EXE).c
CPP2O=$(CPLUSPLUS) -c $(INCLUDE) $*.c

DEMO_PROCOB_BUILD_SHARED=$(COB) $(COBFLAGS) -o $(EXE) $(COBS) $(LDPATHFLAG)$(LIBHOME) $(COBSQLINTF) $(COBOL_PROLDLIBS)
DEMO_PROCOB_BUILD_STATIC=$(COB) $(COBFLAGS) -o $(EXE) $(COBS) $(LDPATHFLAG)$(LIBHOME) $(COBSQLINTF) $(COBOL_STATICPROLDLIBS)
COB2GNT=$(COB) $(COBGNTFLAGS) $*.cob

DEMO_PROFOR_BUILD_SHARED=$(FC) $(FCFLAGS) -o $(EXE) $(FORS) $(FC_LDPATHFLAG)$(LIBHOME) $(PROLDLIBS)
DEMO_PROFOR_BUILD_STATIC=$(FC) $(FCFLAGS) -o $(EXE) $(FORS) $(FC_LDPATHFLAG)$(LIBHOME) $(STATICPROLDLIBS)
F2O=$(FC) $(FCFLAGS) -c $*.f

LIBDIR32=lib32

PROC_32=$(PROC)
DEMO_PROC_BUILD_SHARED_32=$(CC) $(LFLAGS32) -o $(EXE) $(OBJS) $(LDPATHFLAG)$(LIBHOME) $(PROLDLIBS)
DEMO_PROC_BUILD_STATIC_32=$(CC) $(LFLAGS32) -o $(EXE) $(OBJS) $(LDPATHFLAG)$(LIBHOME) $(STATICPROLDLIBS)
DEMO_PROC_CPPBUILD_SHARED_32=$(CPLUSPLUS) $(LFLAGS32) -o $(EXE) $(OBJS) $(LDPATHFLAG)$(LIBHOME) $(CPPLDLIBS)
DEMO_PROC_CPPBUILD_STATIC_32=$(CPLUSPLUS) $(LFLAGS32) -o $(EXE) $(OBJS) $(LDPATHFLAG)$(LIBHOME) $(STATICCPPLDLIBS)
C2O_32=$(CC) $(CFLAGS32) -c $*.c
CPP2O_EXE_32=$(CPLUSPLUS) $(LFLAGS32) -c $(INCLUDE) $(EXE).c
CPP2O_32=$(CPLUSPLUS) $(LFLAGS32) -c $(INCLUDE) $*.c
CFLAGS32=$(CFLAGS)
LFLAGS32=

PROCOB_32=$(PROCOB)
DEMO_PROCOB_BUILD_SHARED_32=$(DEMO_PROCOB_BUILD_SHARED)
DEMO_PROCOB_BUILD_STATIC_32=$(DEMO_PROCOB_BUILD_STATIC)
COB2GNT_32=$(COB2GNT)

PROFOR_32=$(PROFOR)
DEMO_PROFOR_BUILD_SHARED_32=$(DEMO_PROFOR_BUILD_SHARED)
DEMO_PROFOR_BUILD_STATIC_32=$(DEMO_PROFOR_BUILD_STATIC)
F2O_32=$(F2O)

LIBDIR64=lib64

PROC_64=$(PROC)
DEMO_PROC_BUILD_SHARED_64=$(CC) $(LFLAGS64) -o $(EXE) $(OBJS) $(LDPATHFLAG)$(LIBHOME) $(PROLDLIBS)
DEMO_PROC_BUILD_STATIC_64=$(CC) $(LFLAGS64) -o $(EXE) $(OBJS) $(LDPATHFLAG)$(LIBHOME) $(STATICPROLDLIBS)
DEMO_PROC_CPPBUILD_SHARED_64=$(CPLUSPLUS) $(LFLAGS64) -o $(EXE) $(OBJS) $(LDPATHFLAG)$(LIBHOME) $(CPPLDLIBS)
DEMO_PROC_CPPBUILD_STATIC_64=$(CPLUSPLUS) $(LFLAGS64) -o $(EXE) $(OBJS) $(LDPATHFLAG)$(LIBHOME) $(STATICCPPLDLIBS)
C2O_64=$(CC) $(CFLAGS64) -c $*.c
CPP2O_EXE_64=$(CPLUSPLUS) $(LFLAGS64) -c $(INCLUDE) $(EXE).c
CPP2O_64=$(CPLUSPLUS) $(LFLAGS64) -c $(INCLUDE) $*.c
CFLAGS64=$(CFLAGS)
LFLAGS64=

PROCOB_64=$(PROCOB)
DEMO_PROCOB_BUILD_SHARED_64=$(DEMO_PROCOB_BUILD_SHARED)
DEMO_PROCOB_BUILD_STATIC_64=$(DEMO_PROCOB_BUILD_STATIC)
COB2GNT_64=$(COB2GNT)

PROFOR_64=$(PROFOR)
DEMO_PROFOR_BUILD_SHARED_64=$(DEMO_PROFOR_BUILD_SHARED)
DEMO_PROFOR_BUILD_STATIC_64=$(DEMO_PROFOR_BUILD_STATIC)
F2O_64=$(F2O)




INSTALL_SHORTCUT_TARGETS=$(MODADA) $(PROC) $(PROCOB) \
			 $(PROFOR) $(PROPLI) $(RTSORA)
INSTALL_SHORTCUT_32_64_TARGETS=
INSTALL_RENAMED_32_64_TARGETS=

LOC_LIBSQLSH=$(PRECOMPLIB)$(LIB_PREFIX)$(LIBSQLSHNAME).$(SO_EXT)


# Entering /ade/aime_rdbms_9819/oracle/precomp/s_precomp.mk
 
ASFLAGS=

LLAIO=
LLIBTHREAD=
THREADLIBS=$(LLIBTHREAD)
TTLIBS+=-ldl

CCFLAGS= $(NOKPIC_CCFLAGS) -fPIC -DPRECOMP

SYS_INCLUDE='sys_include=($(ORACLE_HOME)/precomp/public,/usr/include,/usr/lib/gcc-lib/i486-suse-linux/2.95.3/include,/usr/lib/gcc-lib/i386-redhat-linux/3.2.3/include,/usr/lib/gcc-lib/i386-redhat-linux7/2.96/include)'
CPLUSPLUS=g++
CPLUS_SYS_INCLUDE='sys_include=($(ORACLE_HOME)/precomp/public,/usr/include,/usr/lib/gcc-lib/i486-suse-linux/2.95.3/include,/usr/lib/gcc-lib/i386-redhat-linux/3.2.3/include,/usr/lib/gcc-lib/i386-redhat-linux7/2.96/include)'
CPLUS_INCLUDE= $(I_SYM)$(PRECOMPDEMO)proc $(INCLUDE)
CPLUS_CFLAGS=$(OPTIMIZE) $(INCLUDE) -DSLTS_ENABLE -D_REENTRANT

ADAPORT=verdix
ADACC=ada -e
ADALD=a.ld
ADACLEAN=a.rmlib -f

COB=cob
COBFLAGS=-C IBMCOMP -C NESTCALL -t -x
COBGNTFLAGS=-C IBMCOMP -C NESTCALL -u
GNT=.gnt
COBSQLINTF=$(PRECOMPLIB)cobsqlintf.o
SHAREDLIBPATH =  -L$(ORACLE_HOME)/lib

FC=f77
FCFLAGS=
FC_LDPATHFLAG=$(LDPATHFLAG)

PL1=lpipl1
PL1LD=ldpl1
PL1FLAGS=-lowercase


JAVACLASSDIR=$(ORACLE_HOME)/precomp/classes/
JDK_HOME=$(ORACLE_HOME)/jdk

CLASS_SEP=:
DIRSEP=/

JAVACLASSPATH=.$(CLASS_SEP)$(JAVACLASSDIR)$(CLASS_SEP)$(ORACLE_HOME)/jdbc/lib/ojdbc14.jar$(CLASS_SEP)$(ORACLE_HOME)/jlib/orai18n.jar:$(ORACLE_HOME)/precomp/lib/ottclasses.zip

SHIPHOME_JRE_LOCATION=/usr/local/java/jre118_v3
SHIPHOME_JRE_RUNCMD=jre
SHIPHOME_JRE_JRECLASSFILE=$(SHIPHOME_JRE_LOCATION)/lib/rt.jar:$(SHIPHOME_JRE_LOCATION)/lib/i18n.jar
SHIPHOME_JRE_JDBCCLASSFILE=classes111.zip
SHIPHOME_JRE_SSLCLASSFILE=$$ORACLE_HOME/jlib/javax-ssl-1_1.jar:$$ORACLE_HOME/jlib/jssl-1_1.jar

SHIPHOME_JDK_LOCATION=$$ORACLE_HOME/jdk
SHIPHOME_JDK_RUNCMD=java
SHIPHOME_JDK_JDKCLASSFILE=
SHIPHOME_JDK_JDBCCLASSFILE=$$ORACLE_HOME/jdbc/lib/ojdbc14.jar
SHIPHOME_JDK_NLSCLASSFILE=$$ORACLE_HOME/jlib/orai18n.jar
SHIPHOME_JDK_SSLCLASSFILE=$$ORACLE_HOME/jlib/javax-ssl-1_2.jar:$$ORACLE_HOME/jlib/jssl-1_2.jar
SHIPHOME_JDK_JVMCLASSFILE=$$ORACLE_HOME/javavm/lib/aurora.zip
SHIPHOME_JDK_OTTCLASSFILE=$$ORACLE_HOME/precomp/lib/ottclasses.zip

SHLIBS=
NEW_LD_SHLIBS=$(LOC_LIBSQLSH)
DEPDIRS=-L $(ORACLE_HOME)/rdbms/lib -L $(ORACLE_HOME)/plsql/lib -L $(ORACLE_HOME)/network/lib
PCTINA=$(PRECOMPLIB)pctina.$(OBJ_EXT)
libsqlsh10LIBS=$(DEPDIRS) $(PCTINA) $(DEF_OPT) $(LLIBCLIENTSH) $(LLIBGENERICSH) $(LLIBCOMMONSH)\
               $(LLIBPLSSH) $(LLIBCORE_SH) $(LLIBNLSSH) -lnsl -lsocket -ldl -lm -lc
libsqlsh10EXTRALIBS=$(NNZ_DEP)


# Exiting /ade/aime_rdbms_9819/oracle/precomp/s_precomp.mk
# Exiting precomp.mk
# Entering /ade/aime_rdbms_9819/oracle/buildtools/mkfile/libclntsh.mk
$(LIBCLNTSH): ${LIBHOME}libclient10.$(LIB_EXT) ${LIBHOME}libsql10.$(LIB_EXT) \
	${LIBHOME}libntcp10.$(LIB_EXT)	${LIBHOME}libn10.$(LIB_EXT) \
        ${LIBHOME}libnl10.$(LIB_EXT)	${LIBHOME}libnldap10.$(LIB_EXT) \
        ${LIBHOME}libnhost10.$(LIB_EXT)	${LIBHOME}libntns10.$(LIB_EXT) \
        ${LIBHOME}libnoname10.$(LIB_EXT) ${LIBHOME}libnus10.$(LIB_EXT) \
        ${LIBHOME}libntcps10.$(LIB_EXT)	${LIBHOME}libnro10.$(LIB_EXT) \
	${LIBHOME}libnsslb10.$(LIB_EXT)	${LIBHOME}libcommon10.$(LIB_EXT)\
	${LIBHOME}libgeneric10.$(LIB_EXT) ${LIBHOME}libmm.$(LIB_EXT)\
	${LIBHOME}libnls10.$(LIB_EXT)	${LIBHOME}libcore10.$(LIB_EXT)\
	${RDBMSLIB}xaondy.$(OBJ_EXT)
	$(SILENT)$(ECHO) "Building client shared library libclntsh.$(SO_EXT) ..."
	$(SILENT)$(ECHO) "Call script $$ORACLE_HOME/bin/genclntsh ..."
	$(GENCLNTSH)
	$(SILENT)$(ECHO) "Built $$ORACLE_HOME/${LIBDIR}/libclntsh.$(SO_EXT) ... DONE"

shlibs: $(LD_SHLIBS) $(DLOPENLIBS) $(NEW_LD_SHLIBS) $(NEW_DLOPENLIBS) $(VARLIBS)
bootstraplibs: $(CUS_BOOTSTRAPLIBS)

$(LD_SHLIBS) ld_shlibs_target:
	$(CUS_SHLIB_COMMAND)

$(DLOPENLIBS) dlopenlibs_target:
	$(CUS_DLOPENLIB_COMMAND)

$(NEW_LD_SHLIBS) new_ld_shlibs_target:
	$(CUS_NEW_SHLIB_COMMAND)

$(NEW_DLOPENLIBS) new_dlopenlibs_target:
	$(CUS_NEW_DLOPENLIB_COMMAND)

$(VARLIBS) varlibs_target:
	$(CUS_VARLIB_COMMAND)

$(CUS_BOOTSTRAPLIBS) bootstraplib_target:
	$(CUS_BOOTSTRAPLIB_COMMAND)

ld_shlib:
	$(LD_SHLIB_COMMAND)

dlopenlib:
	$(DLOPENLIB_COMMAND)

new_ld_shlib:
	$(NEW_LD_SHLIB_COMMAND)

new_dlopenlib:
	$(NEW_DLOPENLIB_COMMAND)

bootstrap:
	$(BOOTSTRAPLIB_COMMAND)



# Exiting /ade/aime_rdbms_9819/oracle/buildtools/mkfile/libclntsh.mk
