/* Copyright (c) 2005, Regents of Massachusetts Institute of Technology, 
 * Brandeis University, Brown University, and University of Massachusetts 
 * Boston. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 *   - Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer.
 *   - Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the 
 *     documentation and/or other materials provided with the distribution.
 *   - Neither the name of Massachusetts Institute of Technology, 
 *     Brandeis University, Brown University, or University of 
 *     Massachusetts Boston nor the names of its contributors may be used 
 *     to endorse or promote products derived from this software without 
 *     specific prior written permission.

 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED 
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "IntReaderWriterTest.h"

IntReaderWriterTest::IntReaderWriterTest()
{
}

IntReaderWriterTest::~IntReaderWriterTest()
{
}

bool IntReaderWriterTest::run(Globals* g, const vector<string>&) {
	bool success=true;
	int numInts=1000;
	IntWriter writer(8*sizeof(int)*numInts);
	IntReader reader(writer.getBuffer(), writer.getBufferSize());
	
	int ints[numInts];
	int count=0;
	int currInt=rand();
	while(writer.writeInt(currInt)) {
		ints[count]=currInt;
		currInt=rand();
		count++;
	}
	
	bool loopSuccess=true;
	int value;
	for (int i=0; i<count; i++) {
		loopSuccess&=reader.readInt(value);
		loopSuccess&=(value==ints[i]);
	}
	success&=test("Values matched, Reader returned true:", loopSuccess, 0, 0);
	success&=test("Reader fails for next read: ", !reader.readInt(value), 0 ,0);
	success&=test("Number of ints: ", true, count, numInts);

	value=0;
	bool endSkip=reader.skipToIntPos(numInts-1);
	endSkip&=reader.readInt(value);
	success&=test("Skip to end", endSkip, value, ints[numInts-1]);
	
	
	bool stSkip=reader.skipToIntPos(0);
	stSkip&=reader.readInt(value);
	success&=test("Skip to start", stSkip, value, ints[0]);
	return success;
}


bool IntReaderWriterTest::test(const char* msg_, int retBool_, int val_, int exp_) {
	using namespace std;
	if (retBool_) {
		cout << msg_ << " X: " << val_ << "\tE[X]: " << exp_ << " \t";
		if (val_==exp_) {
			cout << "SUCCESS" << endl;
			return true;
		}
		else {
			cout << "FAILED" << endl;
			return false;
		}
	}
	else {
		cout << msg_ << " FAILED (function return failed)" <<  endl;
		return false;
	}	
}
