/*
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

	http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package template

import (
	"testing"

	gopkcs12 "software.sslmate.com/src/go-pkcs12"
)

const (
	expectedPfx   string = "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"
	expectedPfxCa string = "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"
)

func TestPemToPkcs12(t *testing.T) {
	// Mock the random generator, to guarantee to always generate the same output
	gopkcs12.Modern = gopkcs12.Modern.WithRand(MockRandomReader{})

	out, err := pemToPkcs12Pass(certData, keyData, "password")
	if err != nil {
		t.Errorf("pemToPkcs12Pass() got error '%v', expected none", err)
		return
	}

	if out != expectedPfx {
		t.Errorf("pemToPkcs12Pass() got '%s', expected '%s'", out, expectedPfx)
	}
}

func TestFullPemToPkcs12(t *testing.T) {
	// Mock the random generator, to guarantee to always generate the same output
	gopkcs12.Modern = gopkcs12.Modern.WithRand(MockRandomReader{})

	out, err := fullPemToPkcs12Pass(certData+"\n"+otherCert, keyData, "password")
	if err != nil {
		t.Errorf("pemToPkcs12Pass() got error '%v', expected none", err)
		return
	}

	if out != expectedPfxCa {
		t.Errorf("pemToPkcs12Pass() got '%s', expected '%s'", out, expectedPfxCa)
	}
}

type MockRandomReader struct{}

func (r MockRandomReader) Read(p []byte) (int, error) {
	copy(p, `"0123456789"`)
	return len(p), nil
}
