# ESO Demos

A list of demos given by people going through simple setups with ESO. Feel free to let us know if you have a demo that you want to include here!

## Manage Kubernetes Secrets With External Secrets Operator on DevOps Toolkit

Viktor Farvik shows us how to use ESO with GCP provider and explores a simple workflow with the project.

[![Manage Kubernetes Secrets With External Secrets Operator on DevOps Toolkit](https://img.youtube.com/vi/SyRZe5YVCVk/0.jpg)](https://www.youtube.com/watch?v=SyRZe5YVCVk)

## Managing Kubernetes Secrets: Comparing External Secrets Operator and Secrets Store CSI Driver

Kim Schlesinger and Daniel Hix show us how to install and use both projects, comparing their features and limitations in different situations.

[![Managing Kubernetes Secrets: Comparing External Secrets Operator and Secrets Store CSI Driver](https://img.youtube.com/vi/EW25WpErCmA/0.jpg)](https://www.youtube.com/watch?v=EW25WpErCmA)

## GCP SM + AWS SM + Azure Key Vault Demo

This was an old demo going through an old version of ESO. Most of it is still valid, but beware of CRD and breaking change differences.

[![GCP SM + AWS SM + Azure Key Vault Demo](https://img.youtube.com/vi/L6tn1YdMkF8/0.jpg)](https://www.youtube.com/watch?v=L6tn1YdMkF8)

## How to manage secrets in OpenShift using Vault and External Secrets Operator

Balkrishna Pandey shows us here how to use ClusterSecretStore and how to integrate ESO with Hashicorp Vault on Openshift.

[![How to manage secrets in OpenShift using Vault and External Secrets Operator](https://img.youtube.com/vi/N7njTq6TSx8/0.jpg)](https://www.youtube.com/watch?v=N7njTq6TSx8)


## Managing Sensitive Data in Kubernetes with Sealed Secrets and External Secrets Operator (ESO)

Lukonde Mwila demonstrates how ESO works and how to fetch secrets from AWS Secrets Manager into your Kubernetes cluster.

[![Managing Sensitive Data in Kubernetes with Sealed Secrets and External Secrets Operator (ESO)](https://img.youtube.com/vi/FD8zzHPbhoY/0.jpg)](https://www.youtube.com/watch?v=FD8zzHPbhoY)

## External Secrets Operator: A Cloud Native way to manage your secrets

 Charl Klein gives an overview of the external secrets project, and a walkthrough of getting ESO up and running with Azure Key Vault  

[![External Secrets Operator: A Cloud Native way to manage your secrets](https://img.youtube.com/vi/phohsHfl55A/0.jpg)](https://www.youtube.com/watch?v=phohsHfl55A)
