STSSessionToken uses the GetSessionToken API to retrieve a temporary session token.

## Output Keys and Values

| Key               | Description                                                                         |
|-------------------|-------------------------------------------------------------------------------------|
| access_key_id     | The access key ID that identifies the temporary security credentials.               |
| secret_access_key | The secret access key that can be used to sign requests.                            |
| session_token     | The token that users must pass to the service API to use the temporary credentials. |
| expiration        | The date on which the current credentials expire.                                   |

## Authentication

You can choose from three authentication mechanisms:

* static credentials using `spec.auth.secretRef`
* point to a IRSA Service Account with `spec.auth.jwt`
* use credentials from the [SDK default credentials chain](https://docs.aws.amazon.com/sdk-for-java/v1/developer-guide/credentials.html#credentials-default) from the controller environment

## Request Parameters

Following request parameters can be provided:

- duration seconds -> can specify the TTL of the generated token
- serial number -> define the serial number of the MFA device used by the user
- token code -> possible code generated by the above referenced MFA device

## Example Manifest

```yaml
{% include 'generator-sts.yaml' %}
```

Example `ExternalSecret` that references the STS Session Token generator:
```yaml
{% include 'generator-sts-example.yaml' %}
```
