---
hide:
  - toc
---

# Controller Options

The external-secrets binary includes three components: `core controller`, `certcontroller` and `webook`.

## Core Controller Flags

The core controller is invoked without a subcommand and can be configured with the following flags:

| Name                                          | Type     | Default | Description                                                                                                                                                        |
|-----------------------------------------------|----------|---------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `--client-burst`                              | int      | 100     | Maximum Burst allowed to be passed to rest.Client                                                                                                                  |
| `--client-qps`                                | float32  | 50      | QPS configuration to be passed to rest.Client                                                                                                                      |
| `--concurrent`                                | int      | 1       | The number of concurrent reconciles.                                                                                                                               |
| `--controller-class`                          | string   | default | The controller is instantiated with a specific controller name and filters ES based on this property                                                               |
| `--enable-cluster-external-secret-reconciler` | boolean  | true    | Enables the cluster external secret reconciler.                                                                                                                    |
| `--enable-cluster-store-reconciler`           | boolean  | true    | Enables the cluster store reconciler.                                                                                                                              |
| `--enable-push-secret-reconciler`             | boolean  | true    | Enables the push secret reconciler.                                                                                                                                |
| `--enable-secrets-caching`                    | boolean  | false   | Enable secrets caching for ALL secrets in the cluster (WARNING: can increase memory usage).                                                                        |
| `--enable-configmaps-caching`                 | boolean  | false   | Enable configmaps caching for ALL configmaps in the cluster (WARNING: can increase memory usage).                                                                  |
| `--enable-managed-secrets-caching`            | boolean  | true    | Enable secrets caching for secrets managed by an ExternalSecret.                                                                                                   |
| `--enable-flood-gate`                         | boolean  | true    | Enable flood gate. External secret will be reconciled only if the ClusterStore or Store have an healthy or unknown state.                                          |
| `--enable-extended-metric-labels`             | boolean  | true    | Enable recommended kubernetes annotations as labels in metrics.                                                                                                    |
| `--enable-leader-election`                    | boolean  | false   | Enable leader election for controller manager. Enabling this will ensure there is only one active controller manager.                                              |
| `--experimental-enable-aws-session-cache`     | boolean  | false   | Enable experimental AWS session cache. External secret will reuse the AWS session without creating a new one on each request.                                      |
| `--help`                                      |          |         | help for external-secrets                                                                                                                                          |
| `--loglevel`                                  | string   | info    | loglevel to use, one of: debug, info, warn, error, dpanic, panic, fatal                                                                                            |
| `--zap-time-encoding`                         | string   | epoch   | loglevel to use, one of: epoch, millis, nano, iso8601, rfc3339, rfc3339nano                                                                                        |
| `--metrics-addr`                              | string   | :8080   | The address the metric endpoint binds to.                                                                                                                          |
| `--namespace`                                 | string   | -       | watch external secrets scoped in the provided namespace only. ClusterSecretStore can be used but only work if it doesn't reference resources from other namespaces |
| `--store-requeue-interval`                    | duration | 5m0s    | Default Time duration between reconciling (Cluster)SecretStores                                                                                                    |

## Cert Controller Flags

| Name                       | Type     | Default                  | Descripton                                                                                                            |
| -------------------------- | -------- | ------------------------ | --------------------------------------------------------------------------------------------------------------------- |
| `--crd-requeue-interval`   | duration | 5m0s                     | Time duration between reconciling CRDs for new certs                                                                  |
| `--enable-leader-election` | boolean  | false                    | Enable leader election for controller manager. Enabling this will ensure there is only one active controller manager. |
| `--healthz-addr`           | string   | :8081                    | The address the health endpoint binds to.                                                                             |
| `--help`                   |          |                          | help for certcontroller                                                                                               |
| `--loglevel`               | string   | info                     | loglevel to use, one of: debug, info, warn, error, dpanic, panic, fatal                                               |
| `--zap-time-encoding`                                  | string   | epoch                          | time encoding to use, one of: epoch, millis, nano, iso8601, rfc3339, rfc3339nano                                                                                            |
| `--metrics-addr`           | string   | :8080                    | The address the metric endpoint binds to.                                                                             |
| `--secret-name`            | string   | external-secrets-webhook | Secret to store certs for webhook                                                                                     |
| `--secret-namespace`       | string   | default                  | namespace of the secret to store certs                                                                                |
| `--service-name`           | string   | external-secrets-webhook | Webhook service name                                                                                                  |
| `--service-namespace`      | string   | default                  | Webhook service namespace                                                                                             |

## Webhook Flags

| Name                   | Type     | Default                               | Description                                                                                                                                                                                                                                                                                                                                                                                                              |
| ---------------------- | -------- | ------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| `--cert-dir`           | string   | /tmp/k8s-webhook-server/serving-certs | path to check for certs                                                                                                                                                                                                                                                                                                                                                                                                  |
| `--check-interval`     | duration | 5m0s                                  | certificate check interval                                                                                                                                                                                                                                                                                                                                                                                               |
| `--dns-name`           | string   | localhost                             | DNS name to validate certificates with                                                                                                                                                                                                                                                                                                                                                                                   |
| `--healthz-addr`       | string   | :8081                                 | The address the health endpoint binds to.                                                                                                                                                                                                                                                                                                                                                                                |
| `--help`               |          |                                       | help for webhook                                                                                                                                                                                                                                                                                                                                                                                                         |
| `--loglevel`           | string   | info                                  | loglevel to use, one of: debug, info, warn, error, dpanic, panic, fatal                                                                                                                                                                                                                                                                                                                                                  |
| `--zap-time-encoding`                                  | string   | epoch                          | time encoding to use, one of: epoch, millis, nano, iso8601, rfc3339, rfc3339nano                                                                                            |
| `--lookahead-interval` | duration | 2160h0m0s (90d)                       | certificate check interval                                                                                                                                                                                                                                                                                                                                                                                               |
| `--metrics-addr`       | string   | :8080                                 | The address the metric endpoint binds to.                                                                                                                                                                                                                                                                                                                                                                                |
| `--port`               | number   | 10250                                 | Port number that the webhook server will serve.                                                                                                                                                                                                                                                                                                                                                                          |
| `--tls-ciphers`        | string   |                                       | comma separated list of tls ciphers allowed. This does not apply to TLS 1.3 as the ciphers are selected automatically. The order of this list does not give preference to the ciphers, the ordering is done automatically. Full lists of available ciphers can be found at https://pkg.go.dev/crypto/tls#pkg-constants. E.g. 'TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256,TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256' |
| `--tls-min-version`    | string   | 1.2                                   | minimum version of TLS supported.                                                                                                                                                                                                                                                                                                                                                                                        |
