# External Secrets

<p><img src="https://raw.githubusercontent.com/external-secrets/external-secrets/main/assets/eso-logo-large.png" width="100x"  alt="external-secrets"></p>

[//]: # (README.md generated by gotmpl. DO NOT EDIT.)

![Type: application](https://img.shields.io/badge/Type-application-informational?style=flat-square) ![Version: 0.12.1](https://img.shields.io/badge/Version-0.12.1-informational?style=flat-square)

External secret management for Kubernetes

## TL;DR
```bash
helm repo add external-secrets https://charts.external-secrets.io
helm install external-secrets external-secrets/external-secrets
```

## Installing the Chart
To install the chart with the release name `external-secrets`:
```bash
helm install external-secrets external-secrets/external-secrets
```

### Custom Resources
By default, the chart will install external-secrets CRDs, this can be controlled with `installCRDs` value.

## Uninstalling the Chart
To uninstall the `external-secrets` deployment:
```bash
helm uninstall external-secrets
```
The command removes all the Kubernetes components associated with the chart and deletes the release.

## Values

| Key | Type | Default | Description |
|-----|------|---------|-------------|
| affinity | object | `{}` |  |
| bitwarden-sdk-server.enabled | bool | `false` |  |
| certController.affinity | object | `{}` |  |
| certController.create | bool | `true` | Specifies whether a certificate controller deployment be created. |
| certController.deploymentAnnotations | object | `{}` | Annotations to add to Deployment |
| certController.extraArgs | object | `{}` |  |
| certController.extraEnv | list | `[]` |  |
| certController.extraVolumeMounts | list | `[]` |  |
| certController.extraVolumes | list | `[]` |  |
| certController.fullnameOverride | string | `""` |  |
| certController.hostNetwork | bool | `false` | Run the certController on the host network |
| certController.image.flavour | string | `""` |  |
| certController.image.pullPolicy | string | `"IfNotPresent"` |  |
| certController.image.repository | string | `"oci.external-secrets.io/external-secrets/external-secrets"` |  |
| certController.image.tag | string | `""` |  |
| certController.imagePullSecrets | list | `[]` |  |
| certController.log | object | `{"level":"info","timeEncoding":"epoch"}` | Specifices Log Params to the Webhook |
| certController.metrics.listen.port | int | `8080` |  |
| certController.metrics.service.annotations | object | `{}` | Additional service annotations |
| certController.metrics.service.enabled | bool | `false` | Enable if you use another monitoring tool than Prometheus to scrape the metrics |
| certController.metrics.service.port | int | `8080` | Metrics service port to scrape |
| certController.nameOverride | string | `""` |  |
| certController.nodeSelector | object | `{}` |  |
| certController.podAnnotations | object | `{}` | Annotations to add to Pod |
| certController.podDisruptionBudget | object | `{"enabled":false,"minAvailable":1}` | Pod disruption budget - for more details see https://kubernetes.io/docs/concepts/workloads/pods/disruptions/ |
| certController.podLabels | object | `{}` |  |
| certController.podSecurityContext.enabled | bool | `true` |  |
| certController.priorityClassName | string | `""` | Pod priority class name. |
| certController.rbac.create | bool | `true` | Specifies whether role and rolebinding resources should be created. |
| certController.readinessProbe.address | string | `""` | Address for readiness probe |
| certController.readinessProbe.port | int | `8081` | ReadinessProbe port for kubelet |
| certController.replicaCount | int | `1` |  |
| certController.requeueInterval | string | `"5m"` |  |
| certController.resources | object | `{}` |  |
| certController.revisionHistoryLimit | int | `10` | Specifies the amount of historic ReplicaSets k8s should keep (see https://kubernetes.io/docs/concepts/workloads/controllers/deployment/#clean-up-policy) |
| certController.securityContext.allowPrivilegeEscalation | bool | `false` |  |
| certController.securityContext.capabilities.drop[0] | string | `"ALL"` |  |
| certController.securityContext.enabled | bool | `true` |  |
| certController.securityContext.readOnlyRootFilesystem | bool | `true` |  |
| certController.securityContext.runAsNonRoot | bool | `true` |  |
| certController.securityContext.runAsUser | int | `1000` |  |
| certController.securityContext.seccompProfile.type | string | `"RuntimeDefault"` |  |
| certController.serviceAccount.annotations | object | `{}` | Annotations to add to the service account. |
| certController.serviceAccount.automount | bool | `true` | Automounts the service account token in all containers of the pod |
| certController.serviceAccount.create | bool | `true` | Specifies whether a service account should be created. |
| certController.serviceAccount.extraLabels | object | `{}` | Extra Labels to add to the service account. |
| certController.serviceAccount.name | string | `""` | The name of the service account to use. If not set and create is true, a name is generated using the fullname template. |
| certController.tolerations | list | `[]` |  |
| certController.topologySpreadConstraints | list | `[]` |  |
| commonLabels | object | `{}` | Additional labels added to all helm chart resources. |
| concurrent | int | `1` | Specifies the number of concurrent ExternalSecret Reconciles external-secret executes at a time. |
| controllerClass | string | `""` | If set external secrets will filter matching Secret Stores with the appropriate controller values. |
| crds.annotations | object | `{}` |  |
| crds.conversion.enabled | bool | `true` | If webhook is set to false this also needs to be set to false otherwise the kubeapi will be hammered because the conversion is looking for a webhook endpoint. |
| crds.createClusterExternalSecret | bool | `true` | If true, create CRDs for Cluster External Secret. |
| crds.createClusterGenerator | bool | `true` | If true, create CRDs for Cluster Generator. |
| crds.createClusterSecretStore | bool | `true` | If true, create CRDs for Cluster Secret Store. |
| crds.createPushSecret | bool | `true` | If true, create CRDs for Push Secret. |
| createOperator | bool | `true` | Specifies whether an external secret operator deployment be created. |
| deploymentAnnotations | object | `{}` | Annotations to add to Deployment |
| dnsConfig | object | `{}` | Specifies `dnsOptions` to deployment |
| dnsPolicy | string | `"ClusterFirst"` | Specifies `dnsPolicy` to deployment |
| extendedMetricLabels | bool | `false` | If true external secrets will use recommended kubernetes annotations as prometheus metric labels. |
| extraArgs | object | `{}` |  |
| extraContainers | list | `[]` |  |
| extraEnv | list | `[]` |  |
| extraObjects | list | `[]` |  |
| extraVolumeMounts | list | `[]` |  |
| extraVolumes | list | `[]` |  |
| fullnameOverride | string | `""` |  |
| global.affinity | object | `{}` |  |
| global.compatibility.openshift.adaptSecurityContext | string | `"auto"` | Manages the securityContext properties to make them compatible with OpenShift. Possible values: auto - Apply configurations if it is detected that OpenShift is the target platform. force - Always apply configurations. disabled - No modification applied. |
| global.nodeSelector | object | `{}` |  |
| global.tolerations | list | `[]` |  |
| global.topologySpreadConstraints | list | `[]` |  |
| hostNetwork | bool | `false` | Run the controller on the host network |
| image.flavour | string | `""` | The flavour of tag you want to use There are different image flavours available, like distroless and ubi. Please see GitHub release notes for image tags for these flavors. By default, the distroless image is used. |
| image.pullPolicy | string | `"IfNotPresent"` |  |
| image.repository | string | `"oci.external-secrets.io/external-secrets/external-secrets"` |  |
| image.tag | string | `""` | The image tag to use. The default is the chart appVersion. |
| imagePullSecrets | list | `[]` |  |
| installCRDs | bool | `true` | If set, install and upgrade CRDs through helm chart. |
| leaderElect | bool | `false` | If true, external-secrets will perform leader election between instances to ensure no more than one instance of external-secrets operates at a time. |
| log | object | `{"level":"info","timeEncoding":"epoch"}` | Specifices Log Params to the Webhook |
| metrics.listen.port | int | `8080` |  |
| metrics.service.annotations | object | `{}` | Additional service annotations |
| metrics.service.enabled | bool | `false` | Enable if you use another monitoring tool than Prometheus to scrape the metrics |
| metrics.service.port | int | `8080` | Metrics service port to scrape |
| nameOverride | string | `""` |  |
| namespaceOverride | string | `""` |  |
| nodeSelector | object | `{}` |  |
| podAnnotations | object | `{}` | Annotations to add to Pod |
| podDisruptionBudget | object | `{"enabled":false,"minAvailable":1}` | Pod disruption budget - for more details see https://kubernetes.io/docs/concepts/workloads/pods/disruptions/ |
| podLabels | object | `{}` |  |
| podSecurityContext.enabled | bool | `true` |  |
| podSpecExtra | object | `{}` | Any extra pod spec on the deployment |
| priorityClassName | string | `""` | Pod priority class name. |
| processClusterExternalSecret | bool | `true` | if true, the operator will process cluster external secret. Else, it will ignore them. |
| processClusterStore | bool | `true` | if true, the operator will process cluster store. Else, it will ignore them. |
| processPushSecret | bool | `true` | if true, the operator will process push secret. Else, it will ignore them. |
| rbac.create | bool | `true` | Specifies whether role and rolebinding resources should be created. |
| rbac.servicebindings.create | bool | `true` | Specifies whether a clusterrole to give servicebindings read access should be created. |
| replicaCount | int | `1` |  |
| resources | object | `{}` |  |
| revisionHistoryLimit | int | `10` | Specifies the amount of historic ReplicaSets k8s should keep (see https://kubernetes.io/docs/concepts/workloads/controllers/deployment/#clean-up-policy) |
| scopedNamespace | string | `""` | If set external secrets are only reconciled in the provided namespace |
| scopedRBAC | bool | `false` | Must be used with scopedNamespace. If true, create scoped RBAC roles under the scoped namespace and implicitly disable cluster stores and cluster external secrets |
| securityContext.allowPrivilegeEscalation | bool | `false` |  |
| securityContext.capabilities.drop[0] | string | `"ALL"` |  |
| securityContext.enabled | bool | `true` |  |
| securityContext.readOnlyRootFilesystem | bool | `true` |  |
| securityContext.runAsNonRoot | bool | `true` |  |
| securityContext.runAsUser | int | `1000` |  |
| securityContext.seccompProfile.type | string | `"RuntimeDefault"` |  |
| service.ipFamilies | list | `[]` | Sets the families that should be supported and the order in which they should be applied to ClusterIP as well. Can be IPv4 and/or IPv6. |
| service.ipFamilyPolicy | string | `""` | Set the ip family policy to configure dual-stack see [Configure dual-stack](https://kubernetes.io/docs/concepts/services-networking/dual-stack/#services) |
| serviceAccount.annotations | object | `{}` | Annotations to add to the service account. |
| serviceAccount.automount | bool | `true` | Automounts the service account token in all containers of the pod |
| serviceAccount.create | bool | `true` | Specifies whether a service account should be created. |
| serviceAccount.extraLabels | object | `{}` | Extra Labels to add to the service account. |
| serviceAccount.name | string | `""` | The name of the service account to use. If not set and create is true, a name is generated using the fullname template. |
| serviceMonitor.additionalLabels | object | `{}` | Additional labels |
| serviceMonitor.enabled | bool | `false` | Specifies whether to create a ServiceMonitor resource for collecting Prometheus metrics |
| serviceMonitor.honorLabels | bool | `false` | Let prometheus add an exported_ prefix to conflicting labels |
| serviceMonitor.interval | string | `"30s"` | Interval to scrape metrics |
| serviceMonitor.metricRelabelings | list | `[]` | Metric relabel configs to apply to samples before ingestion. [Metric Relabeling](https://prometheus.io/docs/prometheus/latest/configuration/configuration/#metric_relabel_configs) |
| serviceMonitor.namespace | string | `""` | namespace where you want to install ServiceMonitors |
| serviceMonitor.relabelings | list | `[]` | Relabel configs to apply to samples before ingestion. [Relabeling](https://prometheus.io/docs/prometheus/latest/configuration/configuration/#relabel_config) |
| serviceMonitor.scrapeTimeout | string | `"25s"` | Timeout if metrics can't be retrieved in given time interval |
| tolerations | list | `[]` |  |
| topologySpreadConstraints | list | `[]` |  |
| webhook.affinity | object | `{}` |  |
| webhook.certCheckInterval | string | `"5m"` | Specifices the time to check if the cert is valid |
| webhook.certDir | string | `"/tmp/certs"` |  |
| webhook.certManager.addInjectorAnnotations | bool | `true` | Automatically add the cert-manager.io/inject-ca-from annotation to the webhooks and CRDs. As long as you have the cert-manager CA Injector enabled, this will automatically setup your webhook's CA to the one used by cert-manager. See https://cert-manager.io/docs/concepts/ca-injector |
| webhook.certManager.cert.annotations | object | `{}` | Add extra annotations to the Certificate resource. |
| webhook.certManager.cert.create | bool | `true` | Create a certificate resource within this chart. See https://cert-manager.io/docs/usage/certificate/ |
| webhook.certManager.cert.duration | string | `"8760h"` | Set the requested duration (i.e. lifetime) of the Certificate. See https://cert-manager.io/docs/reference/api-docs/#cert-manager.io/v1.CertificateSpec One year by default. |
| webhook.certManager.cert.issuerRef | object | `{"group":"cert-manager.io","kind":"Issuer","name":"my-issuer"}` | For the Certificate created by this chart, setup the issuer. See https://cert-manager.io/docs/reference/api-docs/#cert-manager.io/v1.IssuerSpec |
| webhook.certManager.cert.renewBefore | string | `""` | How long before the currently issued certificate’s expiry cert-manager should renew the certificate. See https://cert-manager.io/docs/reference/api-docs/#cert-manager.io/v1.CertificateSpec Note that renewBefore should be greater than .webhook.lookaheadInterval since the webhook will check this far in advance that the certificate is valid. |
| webhook.certManager.enabled | bool | `false` | Enabling cert-manager support will disable the built in secret and switch to using cert-manager (installed separately) to automatically issue and renew the webhook certificate. This chart does not install cert-manager for you, See https://cert-manager.io/docs/ |
| webhook.create | bool | `true` | Specifies whether a webhook deployment be created. |
| webhook.deploymentAnnotations | object | `{}` | Annotations to add to Deployment |
| webhook.extraArgs | object | `{}` |  |
| webhook.extraEnv | list | `[]` |  |
| webhook.extraVolumeMounts | list | `[]` |  |
| webhook.extraVolumes | list | `[]` |  |
| webhook.failurePolicy | string | `"Fail"` | Specifies whether validating webhooks should be created with failurePolicy: Fail or Ignore |
| webhook.fullnameOverride | string | `""` |  |
| webhook.hostNetwork | bool | `false` | Specifies if webhook pod should use hostNetwork or not. |
| webhook.image.flavour | string | `""` | The flavour of tag you want to use |
| webhook.image.pullPolicy | string | `"IfNotPresent"` |  |
| webhook.image.repository | string | `"oci.external-secrets.io/external-secrets/external-secrets"` |  |
| webhook.image.tag | string | `""` | The image tag to use. The default is the chart appVersion. |
| webhook.imagePullSecrets | list | `[]` |  |
| webhook.log | object | `{"level":"info","timeEncoding":"epoch"}` | Specifices Log Params to the Webhook |
| webhook.lookaheadInterval | string | `""` | Specifices the lookaheadInterval for certificate validity |
| webhook.metrics.listen.port | int | `8080` |  |
| webhook.metrics.service.annotations | object | `{}` | Additional service annotations |
| webhook.metrics.service.enabled | bool | `false` | Enable if you use another monitoring tool than Prometheus to scrape the metrics |
| webhook.metrics.service.port | int | `8080` | Metrics service port to scrape |
| webhook.nameOverride | string | `""` |  |
| webhook.nodeSelector | object | `{}` |  |
| webhook.podAnnotations | object | `{}` | Annotations to add to Pod |
| webhook.podDisruptionBudget | object | `{"enabled":false,"minAvailable":1}` | Pod disruption budget - for more details see https://kubernetes.io/docs/concepts/workloads/pods/disruptions/ |
| webhook.podLabels | object | `{}` |  |
| webhook.podSecurityContext.enabled | bool | `true` |  |
| webhook.port | int | `10250` | The port the webhook will listen to |
| webhook.priorityClassName | string | `""` | Pod priority class name. |
| webhook.rbac.create | bool | `true` | Specifies whether role and rolebinding resources should be created. |
| webhook.readinessProbe.address | string | `""` | Address for readiness probe |
| webhook.readinessProbe.port | int | `8081` | ReadinessProbe port for kubelet |
| webhook.replicaCount | int | `1` |  |
| webhook.resources | object | `{}` |  |
| webhook.revisionHistoryLimit | int | `10` | Specifies the amount of historic ReplicaSets k8s should keep (see https://kubernetes.io/docs/concepts/workloads/controllers/deployment/#clean-up-policy) |
| webhook.secretAnnotations | object | `{}` | Annotations to add to Secret |
| webhook.securityContext.allowPrivilegeEscalation | bool | `false` |  |
| webhook.securityContext.capabilities.drop[0] | string | `"ALL"` |  |
| webhook.securityContext.enabled | bool | `true` |  |
| webhook.securityContext.readOnlyRootFilesystem | bool | `true` |  |
| webhook.securityContext.runAsNonRoot | bool | `true` |  |
| webhook.securityContext.runAsUser | int | `1000` |  |
| webhook.securityContext.seccompProfile.type | string | `"RuntimeDefault"` |  |
| webhook.serviceAccount.annotations | object | `{}` | Annotations to add to the service account. |
| webhook.serviceAccount.automount | bool | `true` | Automounts the service account token in all containers of the pod |
| webhook.serviceAccount.create | bool | `true` | Specifies whether a service account should be created. |
| webhook.serviceAccount.extraLabels | object | `{}` | Extra Labels to add to the service account. |
| webhook.serviceAccount.name | string | `""` | The name of the service account to use. If not set and create is true, a name is generated using the fullname template. |
| webhook.tolerations | list | `[]` |  |
| webhook.topologySpreadConstraints | list | `[]` |  |
