//go:build !ignore_autogenerated

/*
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by controller-gen. DO NOT EDIT.

package v1beta1

import (
	metav1 "github.com/external-secrets/external-secrets/apis/meta/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/runtime"
)

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AWSAuth) DeepCopyInto(out *AWSAuth) {
	*out = *in
	if in.SecretRef != nil {
		in, out := &in.SecretRef, &out.SecretRef
		*out = new(AWSAuthSecretRef)
		(*in).DeepCopyInto(*out)
	}
	if in.JWTAuth != nil {
		in, out := &in.JWTAuth, &out.JWTAuth
		*out = new(AWSJWTAuth)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AWSAuth.
func (in *AWSAuth) DeepCopy() *AWSAuth {
	if in == nil {
		return nil
	}
	out := new(AWSAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AWSAuthSecretRef) DeepCopyInto(out *AWSAuthSecretRef) {
	*out = *in
	in.AccessKeyID.DeepCopyInto(&out.AccessKeyID)
	in.SecretAccessKey.DeepCopyInto(&out.SecretAccessKey)
	if in.SessionToken != nil {
		in, out := &in.SessionToken, &out.SessionToken
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AWSAuthSecretRef.
func (in *AWSAuthSecretRef) DeepCopy() *AWSAuthSecretRef {
	if in == nil {
		return nil
	}
	out := new(AWSAuthSecretRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AWSJWTAuth) DeepCopyInto(out *AWSJWTAuth) {
	*out = *in
	if in.ServiceAccountRef != nil {
		in, out := &in.ServiceAccountRef, &out.ServiceAccountRef
		*out = new(metav1.ServiceAccountSelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AWSJWTAuth.
func (in *AWSJWTAuth) DeepCopy() *AWSJWTAuth {
	if in == nil {
		return nil
	}
	out := new(AWSJWTAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AWSProvider) DeepCopyInto(out *AWSProvider) {
	*out = *in
	in.Auth.DeepCopyInto(&out.Auth)
	if in.AdditionalRoles != nil {
		in, out := &in.AdditionalRoles, &out.AdditionalRoles
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.SessionTags != nil {
		in, out := &in.SessionTags, &out.SessionTags
		*out = make([]*Tag, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(Tag)
				**out = **in
			}
		}
	}
	if in.SecretsManager != nil {
		in, out := &in.SecretsManager, &out.SecretsManager
		*out = new(SecretsManager)
		**out = **in
	}
	if in.TransitiveTagKeys != nil {
		in, out := &in.TransitiveTagKeys, &out.TransitiveTagKeys
		*out = make([]*string, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(string)
				**out = **in
			}
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AWSProvider.
func (in *AWSProvider) DeepCopy() *AWSProvider {
	if in == nil {
		return nil
	}
	out := new(AWSProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AkeylessAuth) DeepCopyInto(out *AkeylessAuth) {
	*out = *in
	in.SecretRef.DeepCopyInto(&out.SecretRef)
	if in.KubernetesAuth != nil {
		in, out := &in.KubernetesAuth, &out.KubernetesAuth
		*out = new(AkeylessKubernetesAuth)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AkeylessAuth.
func (in *AkeylessAuth) DeepCopy() *AkeylessAuth {
	if in == nil {
		return nil
	}
	out := new(AkeylessAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AkeylessAuthSecretRef) DeepCopyInto(out *AkeylessAuthSecretRef) {
	*out = *in
	in.AccessID.DeepCopyInto(&out.AccessID)
	in.AccessType.DeepCopyInto(&out.AccessType)
	in.AccessTypeParam.DeepCopyInto(&out.AccessTypeParam)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AkeylessAuthSecretRef.
func (in *AkeylessAuthSecretRef) DeepCopy() *AkeylessAuthSecretRef {
	if in == nil {
		return nil
	}
	out := new(AkeylessAuthSecretRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AkeylessKubernetesAuth) DeepCopyInto(out *AkeylessKubernetesAuth) {
	*out = *in
	if in.ServiceAccountRef != nil {
		in, out := &in.ServiceAccountRef, &out.ServiceAccountRef
		*out = new(metav1.ServiceAccountSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.SecretRef != nil {
		in, out := &in.SecretRef, &out.SecretRef
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AkeylessKubernetesAuth.
func (in *AkeylessKubernetesAuth) DeepCopy() *AkeylessKubernetesAuth {
	if in == nil {
		return nil
	}
	out := new(AkeylessKubernetesAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AkeylessProvider) DeepCopyInto(out *AkeylessProvider) {
	*out = *in
	if in.AkeylessGWApiURL != nil {
		in, out := &in.AkeylessGWApiURL, &out.AkeylessGWApiURL
		*out = new(string)
		**out = **in
	}
	if in.Auth != nil {
		in, out := &in.Auth, &out.Auth
		*out = new(AkeylessAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.CABundle != nil {
		in, out := &in.CABundle, &out.CABundle
		*out = make([]byte, len(*in))
		copy(*out, *in)
	}
	if in.CAProvider != nil {
		in, out := &in.CAProvider, &out.CAProvider
		*out = new(CAProvider)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AkeylessProvider.
func (in *AkeylessProvider) DeepCopy() *AkeylessProvider {
	if in == nil {
		return nil
	}
	out := new(AkeylessProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AlibabaAuth) DeepCopyInto(out *AlibabaAuth) {
	*out = *in
	if in.SecretRef != nil {
		in, out := &in.SecretRef, &out.SecretRef
		*out = new(AlibabaAuthSecretRef)
		(*in).DeepCopyInto(*out)
	}
	if in.RRSAAuth != nil {
		in, out := &in.RRSAAuth, &out.RRSAAuth
		*out = new(AlibabaRRSAAuth)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AlibabaAuth.
func (in *AlibabaAuth) DeepCopy() *AlibabaAuth {
	if in == nil {
		return nil
	}
	out := new(AlibabaAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AlibabaAuthSecretRef) DeepCopyInto(out *AlibabaAuthSecretRef) {
	*out = *in
	in.AccessKeyID.DeepCopyInto(&out.AccessKeyID)
	in.AccessKeySecret.DeepCopyInto(&out.AccessKeySecret)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AlibabaAuthSecretRef.
func (in *AlibabaAuthSecretRef) DeepCopy() *AlibabaAuthSecretRef {
	if in == nil {
		return nil
	}
	out := new(AlibabaAuthSecretRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AlibabaProvider) DeepCopyInto(out *AlibabaProvider) {
	*out = *in
	in.Auth.DeepCopyInto(&out.Auth)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AlibabaProvider.
func (in *AlibabaProvider) DeepCopy() *AlibabaProvider {
	if in == nil {
		return nil
	}
	out := new(AlibabaProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AlibabaRRSAAuth) DeepCopyInto(out *AlibabaRRSAAuth) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AlibabaRRSAAuth.
func (in *AlibabaRRSAAuth) DeepCopy() *AlibabaRRSAAuth {
	if in == nil {
		return nil
	}
	out := new(AlibabaRRSAAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AzureKVAuth) DeepCopyInto(out *AzureKVAuth) {
	*out = *in
	if in.ClientID != nil {
		in, out := &in.ClientID, &out.ClientID
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.TenantID != nil {
		in, out := &in.TenantID, &out.TenantID
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.ClientSecret != nil {
		in, out := &in.ClientSecret, &out.ClientSecret
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.ClientCertificate != nil {
		in, out := &in.ClientCertificate, &out.ClientCertificate
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AzureKVAuth.
func (in *AzureKVAuth) DeepCopy() *AzureKVAuth {
	if in == nil {
		return nil
	}
	out := new(AzureKVAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AzureKVProvider) DeepCopyInto(out *AzureKVProvider) {
	*out = *in
	if in.AuthType != nil {
		in, out := &in.AuthType, &out.AuthType
		*out = new(AzureAuthType)
		**out = **in
	}
	if in.VaultURL != nil {
		in, out := &in.VaultURL, &out.VaultURL
		*out = new(string)
		**out = **in
	}
	if in.TenantID != nil {
		in, out := &in.TenantID, &out.TenantID
		*out = new(string)
		**out = **in
	}
	if in.AuthSecretRef != nil {
		in, out := &in.AuthSecretRef, &out.AuthSecretRef
		*out = new(AzureKVAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.ServiceAccountRef != nil {
		in, out := &in.ServiceAccountRef, &out.ServiceAccountRef
		*out = new(metav1.ServiceAccountSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.IdentityID != nil {
		in, out := &in.IdentityID, &out.IdentityID
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AzureKVProvider.
func (in *AzureKVProvider) DeepCopy() *AzureKVProvider {
	if in == nil {
		return nil
	}
	out := new(AzureKVProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BeyondTrustProviderSecretRef) DeepCopyInto(out *BeyondTrustProviderSecretRef) {
	*out = *in
	if in.SecretRef != nil {
		in, out := &in.SecretRef, &out.SecretRef
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BeyondTrustProviderSecretRef.
func (in *BeyondTrustProviderSecretRef) DeepCopy() *BeyondTrustProviderSecretRef {
	if in == nil {
		return nil
	}
	out := new(BeyondTrustProviderSecretRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BeyondtrustAuth) DeepCopyInto(out *BeyondtrustAuth) {
	*out = *in
	if in.APIKey != nil {
		in, out := &in.APIKey, &out.APIKey
		*out = new(BeyondTrustProviderSecretRef)
		(*in).DeepCopyInto(*out)
	}
	if in.ClientID != nil {
		in, out := &in.ClientID, &out.ClientID
		*out = new(BeyondTrustProviderSecretRef)
		(*in).DeepCopyInto(*out)
	}
	if in.ClientSecret != nil {
		in, out := &in.ClientSecret, &out.ClientSecret
		*out = new(BeyondTrustProviderSecretRef)
		(*in).DeepCopyInto(*out)
	}
	if in.Certificate != nil {
		in, out := &in.Certificate, &out.Certificate
		*out = new(BeyondTrustProviderSecretRef)
		(*in).DeepCopyInto(*out)
	}
	if in.CertificateKey != nil {
		in, out := &in.CertificateKey, &out.CertificateKey
		*out = new(BeyondTrustProviderSecretRef)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BeyondtrustAuth.
func (in *BeyondtrustAuth) DeepCopy() *BeyondtrustAuth {
	if in == nil {
		return nil
	}
	out := new(BeyondtrustAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BeyondtrustProvider) DeepCopyInto(out *BeyondtrustProvider) {
	*out = *in
	if in.Auth != nil {
		in, out := &in.Auth, &out.Auth
		*out = new(BeyondtrustAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Server != nil {
		in, out := &in.Server, &out.Server
		*out = new(BeyondtrustServer)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BeyondtrustProvider.
func (in *BeyondtrustProvider) DeepCopy() *BeyondtrustProvider {
	if in == nil {
		return nil
	}
	out := new(BeyondtrustProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BeyondtrustServer) DeepCopyInto(out *BeyondtrustServer) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BeyondtrustServer.
func (in *BeyondtrustServer) DeepCopy() *BeyondtrustServer {
	if in == nil {
		return nil
	}
	out := new(BeyondtrustServer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BitwardenSecretsManagerAuth) DeepCopyInto(out *BitwardenSecretsManagerAuth) {
	*out = *in
	in.SecretRef.DeepCopyInto(&out.SecretRef)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BitwardenSecretsManagerAuth.
func (in *BitwardenSecretsManagerAuth) DeepCopy() *BitwardenSecretsManagerAuth {
	if in == nil {
		return nil
	}
	out := new(BitwardenSecretsManagerAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BitwardenSecretsManagerProvider) DeepCopyInto(out *BitwardenSecretsManagerProvider) {
	*out = *in
	if in.CAProvider != nil {
		in, out := &in.CAProvider, &out.CAProvider
		*out = new(CAProvider)
		(*in).DeepCopyInto(*out)
	}
	in.Auth.DeepCopyInto(&out.Auth)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BitwardenSecretsManagerProvider.
func (in *BitwardenSecretsManagerProvider) DeepCopy() *BitwardenSecretsManagerProvider {
	if in == nil {
		return nil
	}
	out := new(BitwardenSecretsManagerProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BitwardenSecretsManagerSecretRef) DeepCopyInto(out *BitwardenSecretsManagerSecretRef) {
	*out = *in
	in.Credentials.DeepCopyInto(&out.Credentials)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BitwardenSecretsManagerSecretRef.
func (in *BitwardenSecretsManagerSecretRef) DeepCopy() *BitwardenSecretsManagerSecretRef {
	if in == nil {
		return nil
	}
	out := new(BitwardenSecretsManagerSecretRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CAProvider) DeepCopyInto(out *CAProvider) {
	*out = *in
	if in.Namespace != nil {
		in, out := &in.Namespace, &out.Namespace
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CAProvider.
func (in *CAProvider) DeepCopy() *CAProvider {
	if in == nil {
		return nil
	}
	out := new(CAProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CertAuth) DeepCopyInto(out *CertAuth) {
	*out = *in
	in.ClientCert.DeepCopyInto(&out.ClientCert)
	in.ClientKey.DeepCopyInto(&out.ClientKey)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CertAuth.
func (in *CertAuth) DeepCopy() *CertAuth {
	if in == nil {
		return nil
	}
	out := new(CertAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ChefAuth) DeepCopyInto(out *ChefAuth) {
	*out = *in
	in.SecretRef.DeepCopyInto(&out.SecretRef)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ChefAuth.
func (in *ChefAuth) DeepCopy() *ChefAuth {
	if in == nil {
		return nil
	}
	out := new(ChefAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ChefAuthSecretRef) DeepCopyInto(out *ChefAuthSecretRef) {
	*out = *in
	in.SecretKey.DeepCopyInto(&out.SecretKey)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ChefAuthSecretRef.
func (in *ChefAuthSecretRef) DeepCopy() *ChefAuthSecretRef {
	if in == nil {
		return nil
	}
	out := new(ChefAuthSecretRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ChefProvider) DeepCopyInto(out *ChefProvider) {
	*out = *in
	if in.Auth != nil {
		in, out := &in.Auth, &out.Auth
		*out = new(ChefAuth)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ChefProvider.
func (in *ChefProvider) DeepCopy() *ChefProvider {
	if in == nil {
		return nil
	}
	out := new(ChefProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterExternalSecret) DeepCopyInto(out *ClusterExternalSecret) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterExternalSecret.
func (in *ClusterExternalSecret) DeepCopy() *ClusterExternalSecret {
	if in == nil {
		return nil
	}
	out := new(ClusterExternalSecret)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ClusterExternalSecret) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterExternalSecretList) DeepCopyInto(out *ClusterExternalSecretList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ClusterExternalSecret, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterExternalSecretList.
func (in *ClusterExternalSecretList) DeepCopy() *ClusterExternalSecretList {
	if in == nil {
		return nil
	}
	out := new(ClusterExternalSecretList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ClusterExternalSecretList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterExternalSecretNamespaceFailure) DeepCopyInto(out *ClusterExternalSecretNamespaceFailure) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterExternalSecretNamespaceFailure.
func (in *ClusterExternalSecretNamespaceFailure) DeepCopy() *ClusterExternalSecretNamespaceFailure {
	if in == nil {
		return nil
	}
	out := new(ClusterExternalSecretNamespaceFailure)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterExternalSecretSpec) DeepCopyInto(out *ClusterExternalSecretSpec) {
	*out = *in
	in.ExternalSecretSpec.DeepCopyInto(&out.ExternalSecretSpec)
	in.ExternalSecretMetadata.DeepCopyInto(&out.ExternalSecretMetadata)
	if in.NamespaceSelector != nil {
		in, out := &in.NamespaceSelector, &out.NamespaceSelector
		*out = new(v1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.NamespaceSelectors != nil {
		in, out := &in.NamespaceSelectors, &out.NamespaceSelectors
		*out = make([]*v1.LabelSelector, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(v1.LabelSelector)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	if in.Namespaces != nil {
		in, out := &in.Namespaces, &out.Namespaces
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(v1.Duration)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterExternalSecretSpec.
func (in *ClusterExternalSecretSpec) DeepCopy() *ClusterExternalSecretSpec {
	if in == nil {
		return nil
	}
	out := new(ClusterExternalSecretSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterExternalSecretStatus) DeepCopyInto(out *ClusterExternalSecretStatus) {
	*out = *in
	if in.FailedNamespaces != nil {
		in, out := &in.FailedNamespaces, &out.FailedNamespaces
		*out = make([]ClusterExternalSecretNamespaceFailure, len(*in))
		copy(*out, *in)
	}
	if in.ProvisionedNamespaces != nil {
		in, out := &in.ProvisionedNamespaces, &out.ProvisionedNamespaces
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]ClusterExternalSecretStatusCondition, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterExternalSecretStatus.
func (in *ClusterExternalSecretStatus) DeepCopy() *ClusterExternalSecretStatus {
	if in == nil {
		return nil
	}
	out := new(ClusterExternalSecretStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterExternalSecretStatusCondition) DeepCopyInto(out *ClusterExternalSecretStatusCondition) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterExternalSecretStatusCondition.
func (in *ClusterExternalSecretStatusCondition) DeepCopy() *ClusterExternalSecretStatusCondition {
	if in == nil {
		return nil
	}
	out := new(ClusterExternalSecretStatusCondition)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterSecretStore) DeepCopyInto(out *ClusterSecretStore) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterSecretStore.
func (in *ClusterSecretStore) DeepCopy() *ClusterSecretStore {
	if in == nil {
		return nil
	}
	out := new(ClusterSecretStore)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ClusterSecretStore) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterSecretStoreCondition) DeepCopyInto(out *ClusterSecretStoreCondition) {
	*out = *in
	if in.NamespaceSelector != nil {
		in, out := &in.NamespaceSelector, &out.NamespaceSelector
		*out = new(v1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.Namespaces != nil {
		in, out := &in.Namespaces, &out.Namespaces
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.NamespaceRegexes != nil {
		in, out := &in.NamespaceRegexes, &out.NamespaceRegexes
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterSecretStoreCondition.
func (in *ClusterSecretStoreCondition) DeepCopy() *ClusterSecretStoreCondition {
	if in == nil {
		return nil
	}
	out := new(ClusterSecretStoreCondition)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterSecretStoreList) DeepCopyInto(out *ClusterSecretStoreList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ClusterSecretStore, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterSecretStoreList.
func (in *ClusterSecretStoreList) DeepCopy() *ClusterSecretStoreList {
	if in == nil {
		return nil
	}
	out := new(ClusterSecretStoreList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ClusterSecretStoreList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ConjurAPIKey) DeepCopyInto(out *ConjurAPIKey) {
	*out = *in
	if in.UserRef != nil {
		in, out := &in.UserRef, &out.UserRef
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.APIKeyRef != nil {
		in, out := &in.APIKeyRef, &out.APIKeyRef
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ConjurAPIKey.
func (in *ConjurAPIKey) DeepCopy() *ConjurAPIKey {
	if in == nil {
		return nil
	}
	out := new(ConjurAPIKey)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ConjurAuth) DeepCopyInto(out *ConjurAuth) {
	*out = *in
	if in.APIKey != nil {
		in, out := &in.APIKey, &out.APIKey
		*out = new(ConjurAPIKey)
		(*in).DeepCopyInto(*out)
	}
	if in.Jwt != nil {
		in, out := &in.Jwt, &out.Jwt
		*out = new(ConjurJWT)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ConjurAuth.
func (in *ConjurAuth) DeepCopy() *ConjurAuth {
	if in == nil {
		return nil
	}
	out := new(ConjurAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ConjurJWT) DeepCopyInto(out *ConjurJWT) {
	*out = *in
	if in.SecretRef != nil {
		in, out := &in.SecretRef, &out.SecretRef
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.ServiceAccountRef != nil {
		in, out := &in.ServiceAccountRef, &out.ServiceAccountRef
		*out = new(metav1.ServiceAccountSelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ConjurJWT.
func (in *ConjurJWT) DeepCopy() *ConjurJWT {
	if in == nil {
		return nil
	}
	out := new(ConjurJWT)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ConjurProvider) DeepCopyInto(out *ConjurProvider) {
	*out = *in
	if in.CAProvider != nil {
		in, out := &in.CAProvider, &out.CAProvider
		*out = new(CAProvider)
		(*in).DeepCopyInto(*out)
	}
	in.Auth.DeepCopyInto(&out.Auth)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ConjurProvider.
func (in *ConjurProvider) DeepCopy() *ConjurProvider {
	if in == nil {
		return nil
	}
	out := new(ConjurProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DelineaProvider) DeepCopyInto(out *DelineaProvider) {
	*out = *in
	if in.ClientID != nil {
		in, out := &in.ClientID, &out.ClientID
		*out = new(DelineaProviderSecretRef)
		(*in).DeepCopyInto(*out)
	}
	if in.ClientSecret != nil {
		in, out := &in.ClientSecret, &out.ClientSecret
		*out = new(DelineaProviderSecretRef)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DelineaProvider.
func (in *DelineaProvider) DeepCopy() *DelineaProvider {
	if in == nil {
		return nil
	}
	out := new(DelineaProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DelineaProviderSecretRef) DeepCopyInto(out *DelineaProviderSecretRef) {
	*out = *in
	if in.SecretRef != nil {
		in, out := &in.SecretRef, &out.SecretRef
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DelineaProviderSecretRef.
func (in *DelineaProviderSecretRef) DeepCopy() *DelineaProviderSecretRef {
	if in == nil {
		return nil
	}
	out := new(DelineaProviderSecretRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Device42Auth) DeepCopyInto(out *Device42Auth) {
	*out = *in
	in.SecretRef.DeepCopyInto(&out.SecretRef)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Device42Auth.
func (in *Device42Auth) DeepCopy() *Device42Auth {
	if in == nil {
		return nil
	}
	out := new(Device42Auth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Device42Provider) DeepCopyInto(out *Device42Provider) {
	*out = *in
	in.Auth.DeepCopyInto(&out.Auth)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Device42Provider.
func (in *Device42Provider) DeepCopy() *Device42Provider {
	if in == nil {
		return nil
	}
	out := new(Device42Provider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Device42SecretRef) DeepCopyInto(out *Device42SecretRef) {
	*out = *in
	in.Credentials.DeepCopyInto(&out.Credentials)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Device42SecretRef.
func (in *Device42SecretRef) DeepCopy() *Device42SecretRef {
	if in == nil {
		return nil
	}
	out := new(Device42SecretRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DopplerAuth) DeepCopyInto(out *DopplerAuth) {
	*out = *in
	in.SecretRef.DeepCopyInto(&out.SecretRef)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DopplerAuth.
func (in *DopplerAuth) DeepCopy() *DopplerAuth {
	if in == nil {
		return nil
	}
	out := new(DopplerAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DopplerAuthSecretRef) DeepCopyInto(out *DopplerAuthSecretRef) {
	*out = *in
	in.DopplerToken.DeepCopyInto(&out.DopplerToken)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DopplerAuthSecretRef.
func (in *DopplerAuthSecretRef) DeepCopy() *DopplerAuthSecretRef {
	if in == nil {
		return nil
	}
	out := new(DopplerAuthSecretRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DopplerProvider) DeepCopyInto(out *DopplerProvider) {
	*out = *in
	if in.Auth != nil {
		in, out := &in.Auth, &out.Auth
		*out = new(DopplerAuth)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DopplerProvider.
func (in *DopplerProvider) DeepCopy() *DopplerProvider {
	if in == nil {
		return nil
	}
	out := new(DopplerProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalSecret) DeepCopyInto(out *ExternalSecret) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalSecret.
func (in *ExternalSecret) DeepCopy() *ExternalSecret {
	if in == nil {
		return nil
	}
	out := new(ExternalSecret)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ExternalSecret) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalSecretData) DeepCopyInto(out *ExternalSecretData) {
	*out = *in
	out.RemoteRef = in.RemoteRef
	if in.SourceRef != nil {
		in, out := &in.SourceRef, &out.SourceRef
		*out = new(StoreSourceRef)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalSecretData.
func (in *ExternalSecretData) DeepCopy() *ExternalSecretData {
	if in == nil {
		return nil
	}
	out := new(ExternalSecretData)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalSecretDataFromRemoteRef) DeepCopyInto(out *ExternalSecretDataFromRemoteRef) {
	*out = *in
	if in.Extract != nil {
		in, out := &in.Extract, &out.Extract
		*out = new(ExternalSecretDataRemoteRef)
		**out = **in
	}
	if in.Find != nil {
		in, out := &in.Find, &out.Find
		*out = new(ExternalSecretFind)
		(*in).DeepCopyInto(*out)
	}
	if in.Rewrite != nil {
		in, out := &in.Rewrite, &out.Rewrite
		*out = make([]ExternalSecretRewrite, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.SourceRef != nil {
		in, out := &in.SourceRef, &out.SourceRef
		*out = new(StoreGeneratorSourceRef)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalSecretDataFromRemoteRef.
func (in *ExternalSecretDataFromRemoteRef) DeepCopy() *ExternalSecretDataFromRemoteRef {
	if in == nil {
		return nil
	}
	out := new(ExternalSecretDataFromRemoteRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalSecretDataRemoteRef) DeepCopyInto(out *ExternalSecretDataRemoteRef) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalSecretDataRemoteRef.
func (in *ExternalSecretDataRemoteRef) DeepCopy() *ExternalSecretDataRemoteRef {
	if in == nil {
		return nil
	}
	out := new(ExternalSecretDataRemoteRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalSecretFind) DeepCopyInto(out *ExternalSecretFind) {
	*out = *in
	if in.Path != nil {
		in, out := &in.Path, &out.Path
		*out = new(string)
		**out = **in
	}
	if in.Name != nil {
		in, out := &in.Name, &out.Name
		*out = new(FindName)
		**out = **in
	}
	if in.Tags != nil {
		in, out := &in.Tags, &out.Tags
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalSecretFind.
func (in *ExternalSecretFind) DeepCopy() *ExternalSecretFind {
	if in == nil {
		return nil
	}
	out := new(ExternalSecretFind)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalSecretList) DeepCopyInto(out *ExternalSecretList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ExternalSecret, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalSecretList.
func (in *ExternalSecretList) DeepCopy() *ExternalSecretList {
	if in == nil {
		return nil
	}
	out := new(ExternalSecretList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ExternalSecretList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalSecretMetadata) DeepCopyInto(out *ExternalSecretMetadata) {
	*out = *in
	if in.Annotations != nil {
		in, out := &in.Annotations, &out.Annotations
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalSecretMetadata.
func (in *ExternalSecretMetadata) DeepCopy() *ExternalSecretMetadata {
	if in == nil {
		return nil
	}
	out := new(ExternalSecretMetadata)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalSecretRewrite) DeepCopyInto(out *ExternalSecretRewrite) {
	*out = *in
	if in.Regexp != nil {
		in, out := &in.Regexp, &out.Regexp
		*out = new(ExternalSecretRewriteRegexp)
		**out = **in
	}
	if in.Transform != nil {
		in, out := &in.Transform, &out.Transform
		*out = new(ExternalSecretRewriteTransform)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalSecretRewrite.
func (in *ExternalSecretRewrite) DeepCopy() *ExternalSecretRewrite {
	if in == nil {
		return nil
	}
	out := new(ExternalSecretRewrite)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalSecretRewriteRegexp) DeepCopyInto(out *ExternalSecretRewriteRegexp) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalSecretRewriteRegexp.
func (in *ExternalSecretRewriteRegexp) DeepCopy() *ExternalSecretRewriteRegexp {
	if in == nil {
		return nil
	}
	out := new(ExternalSecretRewriteRegexp)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalSecretRewriteTransform) DeepCopyInto(out *ExternalSecretRewriteTransform) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalSecretRewriteTransform.
func (in *ExternalSecretRewriteTransform) DeepCopy() *ExternalSecretRewriteTransform {
	if in == nil {
		return nil
	}
	out := new(ExternalSecretRewriteTransform)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalSecretSpec) DeepCopyInto(out *ExternalSecretSpec) {
	*out = *in
	out.SecretStoreRef = in.SecretStoreRef
	in.Target.DeepCopyInto(&out.Target)
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(v1.Duration)
		**out = **in
	}
	if in.Data != nil {
		in, out := &in.Data, &out.Data
		*out = make([]ExternalSecretData, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.DataFrom != nil {
		in, out := &in.DataFrom, &out.DataFrom
		*out = make([]ExternalSecretDataFromRemoteRef, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalSecretSpec.
func (in *ExternalSecretSpec) DeepCopy() *ExternalSecretSpec {
	if in == nil {
		return nil
	}
	out := new(ExternalSecretSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalSecretStatus) DeepCopyInto(out *ExternalSecretStatus) {
	*out = *in
	in.RefreshTime.DeepCopyInto(&out.RefreshTime)
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]ExternalSecretStatusCondition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	out.Binding = in.Binding
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalSecretStatus.
func (in *ExternalSecretStatus) DeepCopy() *ExternalSecretStatus {
	if in == nil {
		return nil
	}
	out := new(ExternalSecretStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalSecretStatusCondition) DeepCopyInto(out *ExternalSecretStatusCondition) {
	*out = *in
	in.LastTransitionTime.DeepCopyInto(&out.LastTransitionTime)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalSecretStatusCondition.
func (in *ExternalSecretStatusCondition) DeepCopy() *ExternalSecretStatusCondition {
	if in == nil {
		return nil
	}
	out := new(ExternalSecretStatusCondition)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalSecretTarget) DeepCopyInto(out *ExternalSecretTarget) {
	*out = *in
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(ExternalSecretTemplate)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalSecretTarget.
func (in *ExternalSecretTarget) DeepCopy() *ExternalSecretTarget {
	if in == nil {
		return nil
	}
	out := new(ExternalSecretTarget)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalSecretTemplate) DeepCopyInto(out *ExternalSecretTemplate) {
	*out = *in
	in.Metadata.DeepCopyInto(&out.Metadata)
	if in.Data != nil {
		in, out := &in.Data, &out.Data
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.TemplateFrom != nil {
		in, out := &in.TemplateFrom, &out.TemplateFrom
		*out = make([]TemplateFrom, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalSecretTemplate.
func (in *ExternalSecretTemplate) DeepCopy() *ExternalSecretTemplate {
	if in == nil {
		return nil
	}
	out := new(ExternalSecretTemplate)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalSecretTemplateMetadata) DeepCopyInto(out *ExternalSecretTemplateMetadata) {
	*out = *in
	if in.Annotations != nil {
		in, out := &in.Annotations, &out.Annotations
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalSecretTemplateMetadata.
func (in *ExternalSecretTemplateMetadata) DeepCopy() *ExternalSecretTemplateMetadata {
	if in == nil {
		return nil
	}
	out := new(ExternalSecretTemplateMetadata)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalSecretValidator) DeepCopyInto(out *ExternalSecretValidator) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalSecretValidator.
func (in *ExternalSecretValidator) DeepCopy() *ExternalSecretValidator {
	if in == nil {
		return nil
	}
	out := new(ExternalSecretValidator)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FakeProvider) DeepCopyInto(out *FakeProvider) {
	*out = *in
	if in.Data != nil {
		in, out := &in.Data, &out.Data
		*out = make([]FakeProviderData, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FakeProvider.
func (in *FakeProvider) DeepCopy() *FakeProvider {
	if in == nil {
		return nil
	}
	out := new(FakeProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FakeProviderData) DeepCopyInto(out *FakeProviderData) {
	*out = *in
	if in.ValueMap != nil {
		in, out := &in.ValueMap, &out.ValueMap
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FakeProviderData.
func (in *FakeProviderData) DeepCopy() *FakeProviderData {
	if in == nil {
		return nil
	}
	out := new(FakeProviderData)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FindName) DeepCopyInto(out *FindName) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FindName.
func (in *FindName) DeepCopy() *FindName {
	if in == nil {
		return nil
	}
	out := new(FindName)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FortanixProvider) DeepCopyInto(out *FortanixProvider) {
	*out = *in
	if in.APIKey != nil {
		in, out := &in.APIKey, &out.APIKey
		*out = new(FortanixProviderSecretRef)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FortanixProvider.
func (in *FortanixProvider) DeepCopy() *FortanixProvider {
	if in == nil {
		return nil
	}
	out := new(FortanixProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FortanixProviderSecretRef) DeepCopyInto(out *FortanixProviderSecretRef) {
	*out = *in
	if in.SecretRef != nil {
		in, out := &in.SecretRef, &out.SecretRef
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FortanixProviderSecretRef.
func (in *FortanixProviderSecretRef) DeepCopy() *FortanixProviderSecretRef {
	if in == nil {
		return nil
	}
	out := new(FortanixProviderSecretRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GCPSMAuth) DeepCopyInto(out *GCPSMAuth) {
	*out = *in
	if in.SecretRef != nil {
		in, out := &in.SecretRef, &out.SecretRef
		*out = new(GCPSMAuthSecretRef)
		(*in).DeepCopyInto(*out)
	}
	if in.WorkloadIdentity != nil {
		in, out := &in.WorkloadIdentity, &out.WorkloadIdentity
		*out = new(GCPWorkloadIdentity)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GCPSMAuth.
func (in *GCPSMAuth) DeepCopy() *GCPSMAuth {
	if in == nil {
		return nil
	}
	out := new(GCPSMAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GCPSMAuthSecretRef) DeepCopyInto(out *GCPSMAuthSecretRef) {
	*out = *in
	in.SecretAccessKey.DeepCopyInto(&out.SecretAccessKey)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GCPSMAuthSecretRef.
func (in *GCPSMAuthSecretRef) DeepCopy() *GCPSMAuthSecretRef {
	if in == nil {
		return nil
	}
	out := new(GCPSMAuthSecretRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GCPSMProvider) DeepCopyInto(out *GCPSMProvider) {
	*out = *in
	in.Auth.DeepCopyInto(&out.Auth)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GCPSMProvider.
func (in *GCPSMProvider) DeepCopy() *GCPSMProvider {
	if in == nil {
		return nil
	}
	out := new(GCPSMProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GCPWorkloadIdentity) DeepCopyInto(out *GCPWorkloadIdentity) {
	*out = *in
	in.ServiceAccountRef.DeepCopyInto(&out.ServiceAccountRef)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GCPWorkloadIdentity.
func (in *GCPWorkloadIdentity) DeepCopy() *GCPWorkloadIdentity {
	if in == nil {
		return nil
	}
	out := new(GCPWorkloadIdentity)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GeneratorRef) DeepCopyInto(out *GeneratorRef) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GeneratorRef.
func (in *GeneratorRef) DeepCopy() *GeneratorRef {
	if in == nil {
		return nil
	}
	out := new(GeneratorRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GenericStoreValidator) DeepCopyInto(out *GenericStoreValidator) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GenericStoreValidator.
func (in *GenericStoreValidator) DeepCopy() *GenericStoreValidator {
	if in == nil {
		return nil
	}
	out := new(GenericStoreValidator)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GitlabAuth) DeepCopyInto(out *GitlabAuth) {
	*out = *in
	in.SecretRef.DeepCopyInto(&out.SecretRef)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GitlabAuth.
func (in *GitlabAuth) DeepCopy() *GitlabAuth {
	if in == nil {
		return nil
	}
	out := new(GitlabAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GitlabProvider) DeepCopyInto(out *GitlabProvider) {
	*out = *in
	in.Auth.DeepCopyInto(&out.Auth)
	if in.GroupIDs != nil {
		in, out := &in.GroupIDs, &out.GroupIDs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GitlabProvider.
func (in *GitlabProvider) DeepCopy() *GitlabProvider {
	if in == nil {
		return nil
	}
	out := new(GitlabProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GitlabSecretRef) DeepCopyInto(out *GitlabSecretRef) {
	*out = *in
	in.AccessToken.DeepCopyInto(&out.AccessToken)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GitlabSecretRef.
func (in *GitlabSecretRef) DeepCopy() *GitlabSecretRef {
	if in == nil {
		return nil
	}
	out := new(GitlabSecretRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IBMAuth) DeepCopyInto(out *IBMAuth) {
	*out = *in
	if in.SecretRef != nil {
		in, out := &in.SecretRef, &out.SecretRef
		*out = new(IBMAuthSecretRef)
		(*in).DeepCopyInto(*out)
	}
	if in.ContainerAuth != nil {
		in, out := &in.ContainerAuth, &out.ContainerAuth
		*out = new(IBMAuthContainerAuth)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IBMAuth.
func (in *IBMAuth) DeepCopy() *IBMAuth {
	if in == nil {
		return nil
	}
	out := new(IBMAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IBMAuthContainerAuth) DeepCopyInto(out *IBMAuthContainerAuth) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IBMAuthContainerAuth.
func (in *IBMAuthContainerAuth) DeepCopy() *IBMAuthContainerAuth {
	if in == nil {
		return nil
	}
	out := new(IBMAuthContainerAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IBMAuthSecretRef) DeepCopyInto(out *IBMAuthSecretRef) {
	*out = *in
	in.SecretAPIKey.DeepCopyInto(&out.SecretAPIKey)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IBMAuthSecretRef.
func (in *IBMAuthSecretRef) DeepCopy() *IBMAuthSecretRef {
	if in == nil {
		return nil
	}
	out := new(IBMAuthSecretRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IBMProvider) DeepCopyInto(out *IBMProvider) {
	*out = *in
	in.Auth.DeepCopyInto(&out.Auth)
	if in.ServiceURL != nil {
		in, out := &in.ServiceURL, &out.ServiceURL
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IBMProvider.
func (in *IBMProvider) DeepCopy() *IBMProvider {
	if in == nil {
		return nil
	}
	out := new(IBMProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InfisicalAuth) DeepCopyInto(out *InfisicalAuth) {
	*out = *in
	if in.UniversalAuthCredentials != nil {
		in, out := &in.UniversalAuthCredentials, &out.UniversalAuthCredentials
		*out = new(UniversalAuthCredentials)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InfisicalAuth.
func (in *InfisicalAuth) DeepCopy() *InfisicalAuth {
	if in == nil {
		return nil
	}
	out := new(InfisicalAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InfisicalProvider) DeepCopyInto(out *InfisicalProvider) {
	*out = *in
	in.Auth.DeepCopyInto(&out.Auth)
	out.SecretsScope = in.SecretsScope
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InfisicalProvider.
func (in *InfisicalProvider) DeepCopy() *InfisicalProvider {
	if in == nil {
		return nil
	}
	out := new(InfisicalProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KeeperSecurityProvider) DeepCopyInto(out *KeeperSecurityProvider) {
	*out = *in
	in.Auth.DeepCopyInto(&out.Auth)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KeeperSecurityProvider.
func (in *KeeperSecurityProvider) DeepCopy() *KeeperSecurityProvider {
	if in == nil {
		return nil
	}
	out := new(KeeperSecurityProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesAuth) DeepCopyInto(out *KubernetesAuth) {
	*out = *in
	if in.Cert != nil {
		in, out := &in.Cert, &out.Cert
		*out = new(CertAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Token != nil {
		in, out := &in.Token, &out.Token
		*out = new(TokenAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.ServiceAccount != nil {
		in, out := &in.ServiceAccount, &out.ServiceAccount
		*out = new(metav1.ServiceAccountSelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesAuth.
func (in *KubernetesAuth) DeepCopy() *KubernetesAuth {
	if in == nil {
		return nil
	}
	out := new(KubernetesAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesProvider) DeepCopyInto(out *KubernetesProvider) {
	*out = *in
	in.Server.DeepCopyInto(&out.Server)
	in.Auth.DeepCopyInto(&out.Auth)
	if in.AuthRef != nil {
		in, out := &in.AuthRef, &out.AuthRef
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesProvider.
func (in *KubernetesProvider) DeepCopy() *KubernetesProvider {
	if in == nil {
		return nil
	}
	out := new(KubernetesProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesServer) DeepCopyInto(out *KubernetesServer) {
	*out = *in
	if in.CABundle != nil {
		in, out := &in.CABundle, &out.CABundle
		*out = make([]byte, len(*in))
		copy(*out, *in)
	}
	if in.CAProvider != nil {
		in, out := &in.CAProvider, &out.CAProvider
		*out = new(CAProvider)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesServer.
func (in *KubernetesServer) DeepCopy() *KubernetesServer {
	if in == nil {
		return nil
	}
	out := new(KubernetesServer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MachineIdentityScopeInWorkspace) DeepCopyInto(out *MachineIdentityScopeInWorkspace) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MachineIdentityScopeInWorkspace.
func (in *MachineIdentityScopeInWorkspace) DeepCopy() *MachineIdentityScopeInWorkspace {
	if in == nil {
		return nil
	}
	out := new(MachineIdentityScopeInWorkspace)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NoSecretError) DeepCopyInto(out *NoSecretError) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NoSecretError.
func (in *NoSecretError) DeepCopy() *NoSecretError {
	if in == nil {
		return nil
	}
	out := new(NoSecretError)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NotModifiedError) DeepCopyInto(out *NotModifiedError) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NotModifiedError.
func (in *NotModifiedError) DeepCopy() *NotModifiedError {
	if in == nil {
		return nil
	}
	out := new(NotModifiedError)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OnboardbaseAuthSecretRef) DeepCopyInto(out *OnboardbaseAuthSecretRef) {
	*out = *in
	in.OnboardbaseAPIKeyRef.DeepCopyInto(&out.OnboardbaseAPIKeyRef)
	in.OnboardbasePasscodeRef.DeepCopyInto(&out.OnboardbasePasscodeRef)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OnboardbaseAuthSecretRef.
func (in *OnboardbaseAuthSecretRef) DeepCopy() *OnboardbaseAuthSecretRef {
	if in == nil {
		return nil
	}
	out := new(OnboardbaseAuthSecretRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OnboardbaseProvider) DeepCopyInto(out *OnboardbaseProvider) {
	*out = *in
	if in.Auth != nil {
		in, out := &in.Auth, &out.Auth
		*out = new(OnboardbaseAuthSecretRef)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OnboardbaseProvider.
func (in *OnboardbaseProvider) DeepCopy() *OnboardbaseProvider {
	if in == nil {
		return nil
	}
	out := new(OnboardbaseProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OnePasswordAuth) DeepCopyInto(out *OnePasswordAuth) {
	*out = *in
	if in.SecretRef != nil {
		in, out := &in.SecretRef, &out.SecretRef
		*out = new(OnePasswordAuthSecretRef)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OnePasswordAuth.
func (in *OnePasswordAuth) DeepCopy() *OnePasswordAuth {
	if in == nil {
		return nil
	}
	out := new(OnePasswordAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OnePasswordAuthSecretRef) DeepCopyInto(out *OnePasswordAuthSecretRef) {
	*out = *in
	in.ConnectToken.DeepCopyInto(&out.ConnectToken)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OnePasswordAuthSecretRef.
func (in *OnePasswordAuthSecretRef) DeepCopy() *OnePasswordAuthSecretRef {
	if in == nil {
		return nil
	}
	out := new(OnePasswordAuthSecretRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OnePasswordProvider) DeepCopyInto(out *OnePasswordProvider) {
	*out = *in
	if in.Auth != nil {
		in, out := &in.Auth, &out.Auth
		*out = new(OnePasswordAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Vaults != nil {
		in, out := &in.Vaults, &out.Vaults
		*out = make(map[string]int, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OnePasswordProvider.
func (in *OnePasswordProvider) DeepCopy() *OnePasswordProvider {
	if in == nil {
		return nil
	}
	out := new(OnePasswordProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OracleAuth) DeepCopyInto(out *OracleAuth) {
	*out = *in
	in.SecretRef.DeepCopyInto(&out.SecretRef)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OracleAuth.
func (in *OracleAuth) DeepCopy() *OracleAuth {
	if in == nil {
		return nil
	}
	out := new(OracleAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OracleProvider) DeepCopyInto(out *OracleProvider) {
	*out = *in
	if in.Auth != nil {
		in, out := &in.Auth, &out.Auth
		*out = new(OracleAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.ServiceAccountRef != nil {
		in, out := &in.ServiceAccountRef, &out.ServiceAccountRef
		*out = new(metav1.ServiceAccountSelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OracleProvider.
func (in *OracleProvider) DeepCopy() *OracleProvider {
	if in == nil {
		return nil
	}
	out := new(OracleProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OracleSecretRef) DeepCopyInto(out *OracleSecretRef) {
	*out = *in
	in.PrivateKey.DeepCopyInto(&out.PrivateKey)
	in.Fingerprint.DeepCopyInto(&out.Fingerprint)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OracleSecretRef.
func (in *OracleSecretRef) DeepCopy() *OracleSecretRef {
	if in == nil {
		return nil
	}
	out := new(OracleSecretRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PassboltAuth) DeepCopyInto(out *PassboltAuth) {
	*out = *in
	if in.PasswordSecretRef != nil {
		in, out := &in.PasswordSecretRef, &out.PasswordSecretRef
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.PrivateKeySecretRef != nil {
		in, out := &in.PrivateKeySecretRef, &out.PrivateKeySecretRef
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PassboltAuth.
func (in *PassboltAuth) DeepCopy() *PassboltAuth {
	if in == nil {
		return nil
	}
	out := new(PassboltAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PassboltProvider) DeepCopyInto(out *PassboltProvider) {
	*out = *in
	if in.Auth != nil {
		in, out := &in.Auth, &out.Auth
		*out = new(PassboltAuth)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PassboltProvider.
func (in *PassboltProvider) DeepCopy() *PassboltProvider {
	if in == nil {
		return nil
	}
	out := new(PassboltProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PasswordDepotAuth) DeepCopyInto(out *PasswordDepotAuth) {
	*out = *in
	in.SecretRef.DeepCopyInto(&out.SecretRef)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PasswordDepotAuth.
func (in *PasswordDepotAuth) DeepCopy() *PasswordDepotAuth {
	if in == nil {
		return nil
	}
	out := new(PasswordDepotAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PasswordDepotProvider) DeepCopyInto(out *PasswordDepotProvider) {
	*out = *in
	in.Auth.DeepCopyInto(&out.Auth)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PasswordDepotProvider.
func (in *PasswordDepotProvider) DeepCopy() *PasswordDepotProvider {
	if in == nil {
		return nil
	}
	out := new(PasswordDepotProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PasswordDepotSecretRef) DeepCopyInto(out *PasswordDepotSecretRef) {
	*out = *in
	in.Credentials.DeepCopyInto(&out.Credentials)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PasswordDepotSecretRef.
func (in *PasswordDepotSecretRef) DeepCopy() *PasswordDepotSecretRef {
	if in == nil {
		return nil
	}
	out := new(PasswordDepotSecretRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PreviderAuth) DeepCopyInto(out *PreviderAuth) {
	*out = *in
	if in.SecretRef != nil {
		in, out := &in.SecretRef, &out.SecretRef
		*out = new(PreviderAuthSecretRef)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PreviderAuth.
func (in *PreviderAuth) DeepCopy() *PreviderAuth {
	if in == nil {
		return nil
	}
	out := new(PreviderAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PreviderAuthSecretRef) DeepCopyInto(out *PreviderAuthSecretRef) {
	*out = *in
	in.AccessToken.DeepCopyInto(&out.AccessToken)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PreviderAuthSecretRef.
func (in *PreviderAuthSecretRef) DeepCopy() *PreviderAuthSecretRef {
	if in == nil {
		return nil
	}
	out := new(PreviderAuthSecretRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PreviderProvider) DeepCopyInto(out *PreviderProvider) {
	*out = *in
	in.Auth.DeepCopyInto(&out.Auth)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PreviderProvider.
func (in *PreviderProvider) DeepCopy() *PreviderProvider {
	if in == nil {
		return nil
	}
	out := new(PreviderProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PulumiProvider) DeepCopyInto(out *PulumiProvider) {
	*out = *in
	if in.AccessToken != nil {
		in, out := &in.AccessToken, &out.AccessToken
		*out = new(PulumiProviderSecretRef)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PulumiProvider.
func (in *PulumiProvider) DeepCopy() *PulumiProvider {
	if in == nil {
		return nil
	}
	out := new(PulumiProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PulumiProviderSecretRef) DeepCopyInto(out *PulumiProviderSecretRef) {
	*out = *in
	if in.SecretRef != nil {
		in, out := &in.SecretRef, &out.SecretRef
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PulumiProviderSecretRef.
func (in *PulumiProviderSecretRef) DeepCopy() *PulumiProviderSecretRef {
	if in == nil {
		return nil
	}
	out := new(PulumiProviderSecretRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ScalewayProvider) DeepCopyInto(out *ScalewayProvider) {
	*out = *in
	if in.AccessKey != nil {
		in, out := &in.AccessKey, &out.AccessKey
		*out = new(ScalewayProviderSecretRef)
		(*in).DeepCopyInto(*out)
	}
	if in.SecretKey != nil {
		in, out := &in.SecretKey, &out.SecretKey
		*out = new(ScalewayProviderSecretRef)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ScalewayProvider.
func (in *ScalewayProvider) DeepCopy() *ScalewayProvider {
	if in == nil {
		return nil
	}
	out := new(ScalewayProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ScalewayProviderSecretRef) DeepCopyInto(out *ScalewayProviderSecretRef) {
	*out = *in
	if in.SecretRef != nil {
		in, out := &in.SecretRef, &out.SecretRef
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ScalewayProviderSecretRef.
func (in *ScalewayProviderSecretRef) DeepCopy() *ScalewayProviderSecretRef {
	if in == nil {
		return nil
	}
	out := new(ScalewayProviderSecretRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SecretServerProvider) DeepCopyInto(out *SecretServerProvider) {
	*out = *in
	if in.Username != nil {
		in, out := &in.Username, &out.Username
		*out = new(SecretServerProviderRef)
		(*in).DeepCopyInto(*out)
	}
	if in.Password != nil {
		in, out := &in.Password, &out.Password
		*out = new(SecretServerProviderRef)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SecretServerProvider.
func (in *SecretServerProvider) DeepCopy() *SecretServerProvider {
	if in == nil {
		return nil
	}
	out := new(SecretServerProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SecretServerProviderRef) DeepCopyInto(out *SecretServerProviderRef) {
	*out = *in
	if in.SecretRef != nil {
		in, out := &in.SecretRef, &out.SecretRef
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SecretServerProviderRef.
func (in *SecretServerProviderRef) DeepCopy() *SecretServerProviderRef {
	if in == nil {
		return nil
	}
	out := new(SecretServerProviderRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SecretStore) DeepCopyInto(out *SecretStore) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SecretStore.
func (in *SecretStore) DeepCopy() *SecretStore {
	if in == nil {
		return nil
	}
	out := new(SecretStore)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *SecretStore) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SecretStoreList) DeepCopyInto(out *SecretStoreList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]SecretStore, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SecretStoreList.
func (in *SecretStoreList) DeepCopy() *SecretStoreList {
	if in == nil {
		return nil
	}
	out := new(SecretStoreList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *SecretStoreList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SecretStoreProvider) DeepCopyInto(out *SecretStoreProvider) {
	*out = *in
	if in.AWS != nil {
		in, out := &in.AWS, &out.AWS
		*out = new(AWSProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.AzureKV != nil {
		in, out := &in.AzureKV, &out.AzureKV
		*out = new(AzureKVProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Akeyless != nil {
		in, out := &in.Akeyless, &out.Akeyless
		*out = new(AkeylessProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.BitwardenSecretsManager != nil {
		in, out := &in.BitwardenSecretsManager, &out.BitwardenSecretsManager
		*out = new(BitwardenSecretsManagerProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Vault != nil {
		in, out := &in.Vault, &out.Vault
		*out = new(VaultProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.GCPSM != nil {
		in, out := &in.GCPSM, &out.GCPSM
		*out = new(GCPSMProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Oracle != nil {
		in, out := &in.Oracle, &out.Oracle
		*out = new(OracleProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.IBM != nil {
		in, out := &in.IBM, &out.IBM
		*out = new(IBMProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.YandexCertificateManager != nil {
		in, out := &in.YandexCertificateManager, &out.YandexCertificateManager
		*out = new(YandexCertificateManagerProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.YandexLockbox != nil {
		in, out := &in.YandexLockbox, &out.YandexLockbox
		*out = new(YandexLockboxProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Gitlab != nil {
		in, out := &in.Gitlab, &out.Gitlab
		*out = new(GitlabProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Alibaba != nil {
		in, out := &in.Alibaba, &out.Alibaba
		*out = new(AlibabaProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.OnePassword != nil {
		in, out := &in.OnePassword, &out.OnePassword
		*out = new(OnePasswordProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Webhook != nil {
		in, out := &in.Webhook, &out.Webhook
		*out = new(WebhookProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Kubernetes != nil {
		in, out := &in.Kubernetes, &out.Kubernetes
		*out = new(KubernetesProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Fake != nil {
		in, out := &in.Fake, &out.Fake
		*out = new(FakeProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Senhasegura != nil {
		in, out := &in.Senhasegura, &out.Senhasegura
		*out = new(SenhaseguraProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Scaleway != nil {
		in, out := &in.Scaleway, &out.Scaleway
		*out = new(ScalewayProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Doppler != nil {
		in, out := &in.Doppler, &out.Doppler
		*out = new(DopplerProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Previder != nil {
		in, out := &in.Previder, &out.Previder
		*out = new(PreviderProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Onboardbase != nil {
		in, out := &in.Onboardbase, &out.Onboardbase
		*out = new(OnboardbaseProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.KeeperSecurity != nil {
		in, out := &in.KeeperSecurity, &out.KeeperSecurity
		*out = new(KeeperSecurityProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Conjur != nil {
		in, out := &in.Conjur, &out.Conjur
		*out = new(ConjurProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Delinea != nil {
		in, out := &in.Delinea, &out.Delinea
		*out = new(DelineaProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.SecretServer != nil {
		in, out := &in.SecretServer, &out.SecretServer
		*out = new(SecretServerProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Chef != nil {
		in, out := &in.Chef, &out.Chef
		*out = new(ChefProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Pulumi != nil {
		in, out := &in.Pulumi, &out.Pulumi
		*out = new(PulumiProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Fortanix != nil {
		in, out := &in.Fortanix, &out.Fortanix
		*out = new(FortanixProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.PasswordDepot != nil {
		in, out := &in.PasswordDepot, &out.PasswordDepot
		*out = new(PasswordDepotProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Passbolt != nil {
		in, out := &in.Passbolt, &out.Passbolt
		*out = new(PassboltProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Device42 != nil {
		in, out := &in.Device42, &out.Device42
		*out = new(Device42Provider)
		(*in).DeepCopyInto(*out)
	}
	if in.Infisical != nil {
		in, out := &in.Infisical, &out.Infisical
		*out = new(InfisicalProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Beyondtrust != nil {
		in, out := &in.Beyondtrust, &out.Beyondtrust
		*out = new(BeyondtrustProvider)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SecretStoreProvider.
func (in *SecretStoreProvider) DeepCopy() *SecretStoreProvider {
	if in == nil {
		return nil
	}
	out := new(SecretStoreProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SecretStoreRef) DeepCopyInto(out *SecretStoreRef) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SecretStoreRef.
func (in *SecretStoreRef) DeepCopy() *SecretStoreRef {
	if in == nil {
		return nil
	}
	out := new(SecretStoreRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SecretStoreRetrySettings) DeepCopyInto(out *SecretStoreRetrySettings) {
	*out = *in
	if in.MaxRetries != nil {
		in, out := &in.MaxRetries, &out.MaxRetries
		*out = new(int32)
		**out = **in
	}
	if in.RetryInterval != nil {
		in, out := &in.RetryInterval, &out.RetryInterval
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SecretStoreRetrySettings.
func (in *SecretStoreRetrySettings) DeepCopy() *SecretStoreRetrySettings {
	if in == nil {
		return nil
	}
	out := new(SecretStoreRetrySettings)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SecretStoreSpec) DeepCopyInto(out *SecretStoreSpec) {
	*out = *in
	if in.Provider != nil {
		in, out := &in.Provider, &out.Provider
		*out = new(SecretStoreProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.RetrySettings != nil {
		in, out := &in.RetrySettings, &out.RetrySettings
		*out = new(SecretStoreRetrySettings)
		(*in).DeepCopyInto(*out)
	}
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]ClusterSecretStoreCondition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SecretStoreSpec.
func (in *SecretStoreSpec) DeepCopy() *SecretStoreSpec {
	if in == nil {
		return nil
	}
	out := new(SecretStoreSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SecretStoreStatus) DeepCopyInto(out *SecretStoreStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]SecretStoreStatusCondition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SecretStoreStatus.
func (in *SecretStoreStatus) DeepCopy() *SecretStoreStatus {
	if in == nil {
		return nil
	}
	out := new(SecretStoreStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SecretStoreStatusCondition) DeepCopyInto(out *SecretStoreStatusCondition) {
	*out = *in
	in.LastTransitionTime.DeepCopyInto(&out.LastTransitionTime)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SecretStoreStatusCondition.
func (in *SecretStoreStatusCondition) DeepCopy() *SecretStoreStatusCondition {
	if in == nil {
		return nil
	}
	out := new(SecretStoreStatusCondition)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SecretsManager) DeepCopyInto(out *SecretsManager) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SecretsManager.
func (in *SecretsManager) DeepCopy() *SecretsManager {
	if in == nil {
		return nil
	}
	out := new(SecretsManager)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SenhaseguraAuth) DeepCopyInto(out *SenhaseguraAuth) {
	*out = *in
	in.ClientSecret.DeepCopyInto(&out.ClientSecret)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SenhaseguraAuth.
func (in *SenhaseguraAuth) DeepCopy() *SenhaseguraAuth {
	if in == nil {
		return nil
	}
	out := new(SenhaseguraAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SenhaseguraProvider) DeepCopyInto(out *SenhaseguraProvider) {
	*out = *in
	in.Auth.DeepCopyInto(&out.Auth)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SenhaseguraProvider.
func (in *SenhaseguraProvider) DeepCopy() *SenhaseguraProvider {
	if in == nil {
		return nil
	}
	out := new(SenhaseguraProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StoreGeneratorSourceRef) DeepCopyInto(out *StoreGeneratorSourceRef) {
	*out = *in
	if in.SecretStoreRef != nil {
		in, out := &in.SecretStoreRef, &out.SecretStoreRef
		*out = new(SecretStoreRef)
		**out = **in
	}
	if in.GeneratorRef != nil {
		in, out := &in.GeneratorRef, &out.GeneratorRef
		*out = new(GeneratorRef)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StoreGeneratorSourceRef.
func (in *StoreGeneratorSourceRef) DeepCopy() *StoreGeneratorSourceRef {
	if in == nil {
		return nil
	}
	out := new(StoreGeneratorSourceRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StoreSourceRef) DeepCopyInto(out *StoreSourceRef) {
	*out = *in
	out.SecretStoreRef = in.SecretStoreRef
	if in.GeneratorRef != nil {
		in, out := &in.GeneratorRef, &out.GeneratorRef
		*out = new(GeneratorRef)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StoreSourceRef.
func (in *StoreSourceRef) DeepCopy() *StoreSourceRef {
	if in == nil {
		return nil
	}
	out := new(StoreSourceRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Tag) DeepCopyInto(out *Tag) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Tag.
func (in *Tag) DeepCopy() *Tag {
	if in == nil {
		return nil
	}
	out := new(Tag)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TemplateFrom) DeepCopyInto(out *TemplateFrom) {
	*out = *in
	if in.ConfigMap != nil {
		in, out := &in.ConfigMap, &out.ConfigMap
		*out = new(TemplateRef)
		(*in).DeepCopyInto(*out)
	}
	if in.Secret != nil {
		in, out := &in.Secret, &out.Secret
		*out = new(TemplateRef)
		(*in).DeepCopyInto(*out)
	}
	if in.Literal != nil {
		in, out := &in.Literal, &out.Literal
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TemplateFrom.
func (in *TemplateFrom) DeepCopy() *TemplateFrom {
	if in == nil {
		return nil
	}
	out := new(TemplateFrom)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TemplateRef) DeepCopyInto(out *TemplateRef) {
	*out = *in
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]TemplateRefItem, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TemplateRef.
func (in *TemplateRef) DeepCopy() *TemplateRef {
	if in == nil {
		return nil
	}
	out := new(TemplateRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TemplateRefItem) DeepCopyInto(out *TemplateRefItem) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TemplateRefItem.
func (in *TemplateRefItem) DeepCopy() *TemplateRefItem {
	if in == nil {
		return nil
	}
	out := new(TemplateRefItem)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TokenAuth) DeepCopyInto(out *TokenAuth) {
	*out = *in
	in.BearerToken.DeepCopyInto(&out.BearerToken)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TokenAuth.
func (in *TokenAuth) DeepCopy() *TokenAuth {
	if in == nil {
		return nil
	}
	out := new(TokenAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UniversalAuthCredentials) DeepCopyInto(out *UniversalAuthCredentials) {
	*out = *in
	in.ClientID.DeepCopyInto(&out.ClientID)
	in.ClientSecret.DeepCopyInto(&out.ClientSecret)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UniversalAuthCredentials.
func (in *UniversalAuthCredentials) DeepCopy() *UniversalAuthCredentials {
	if in == nil {
		return nil
	}
	out := new(UniversalAuthCredentials)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VaultAppRole) DeepCopyInto(out *VaultAppRole) {
	*out = *in
	if in.RoleRef != nil {
		in, out := &in.RoleRef, &out.RoleRef
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	in.SecretRef.DeepCopyInto(&out.SecretRef)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VaultAppRole.
func (in *VaultAppRole) DeepCopy() *VaultAppRole {
	if in == nil {
		return nil
	}
	out := new(VaultAppRole)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VaultAuth) DeepCopyInto(out *VaultAuth) {
	*out = *in
	if in.Namespace != nil {
		in, out := &in.Namespace, &out.Namespace
		*out = new(string)
		**out = **in
	}
	if in.TokenSecretRef != nil {
		in, out := &in.TokenSecretRef, &out.TokenSecretRef
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.AppRole != nil {
		in, out := &in.AppRole, &out.AppRole
		*out = new(VaultAppRole)
		(*in).DeepCopyInto(*out)
	}
	if in.Kubernetes != nil {
		in, out := &in.Kubernetes, &out.Kubernetes
		*out = new(VaultKubernetesAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Ldap != nil {
		in, out := &in.Ldap, &out.Ldap
		*out = new(VaultLdapAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Jwt != nil {
		in, out := &in.Jwt, &out.Jwt
		*out = new(VaultJwtAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Cert != nil {
		in, out := &in.Cert, &out.Cert
		*out = new(VaultCertAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Iam != nil {
		in, out := &in.Iam, &out.Iam
		*out = new(VaultIamAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.UserPass != nil {
		in, out := &in.UserPass, &out.UserPass
		*out = new(VaultUserPassAuth)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VaultAuth.
func (in *VaultAuth) DeepCopy() *VaultAuth {
	if in == nil {
		return nil
	}
	out := new(VaultAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VaultAwsAuth) DeepCopyInto(out *VaultAwsAuth) {
	*out = *in
	if in.SecretRef != nil {
		in, out := &in.SecretRef, &out.SecretRef
		*out = new(VaultAwsAuthSecretRef)
		(*in).DeepCopyInto(*out)
	}
	if in.JWTAuth != nil {
		in, out := &in.JWTAuth, &out.JWTAuth
		*out = new(VaultAwsJWTAuth)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VaultAwsAuth.
func (in *VaultAwsAuth) DeepCopy() *VaultAwsAuth {
	if in == nil {
		return nil
	}
	out := new(VaultAwsAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VaultAwsAuthSecretRef) DeepCopyInto(out *VaultAwsAuthSecretRef) {
	*out = *in
	in.AccessKeyID.DeepCopyInto(&out.AccessKeyID)
	in.SecretAccessKey.DeepCopyInto(&out.SecretAccessKey)
	if in.SessionToken != nil {
		in, out := &in.SessionToken, &out.SessionToken
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VaultAwsAuthSecretRef.
func (in *VaultAwsAuthSecretRef) DeepCopy() *VaultAwsAuthSecretRef {
	if in == nil {
		return nil
	}
	out := new(VaultAwsAuthSecretRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VaultAwsJWTAuth) DeepCopyInto(out *VaultAwsJWTAuth) {
	*out = *in
	if in.ServiceAccountRef != nil {
		in, out := &in.ServiceAccountRef, &out.ServiceAccountRef
		*out = new(metav1.ServiceAccountSelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VaultAwsJWTAuth.
func (in *VaultAwsJWTAuth) DeepCopy() *VaultAwsJWTAuth {
	if in == nil {
		return nil
	}
	out := new(VaultAwsJWTAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VaultCertAuth) DeepCopyInto(out *VaultCertAuth) {
	*out = *in
	in.ClientCert.DeepCopyInto(&out.ClientCert)
	in.SecretRef.DeepCopyInto(&out.SecretRef)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VaultCertAuth.
func (in *VaultCertAuth) DeepCopy() *VaultCertAuth {
	if in == nil {
		return nil
	}
	out := new(VaultCertAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VaultClientTLS) DeepCopyInto(out *VaultClientTLS) {
	*out = *in
	if in.CertSecretRef != nil {
		in, out := &in.CertSecretRef, &out.CertSecretRef
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.KeySecretRef != nil {
		in, out := &in.KeySecretRef, &out.KeySecretRef
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VaultClientTLS.
func (in *VaultClientTLS) DeepCopy() *VaultClientTLS {
	if in == nil {
		return nil
	}
	out := new(VaultClientTLS)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VaultIamAuth) DeepCopyInto(out *VaultIamAuth) {
	*out = *in
	if in.SecretRef != nil {
		in, out := &in.SecretRef, &out.SecretRef
		*out = new(VaultAwsAuthSecretRef)
		(*in).DeepCopyInto(*out)
	}
	if in.JWTAuth != nil {
		in, out := &in.JWTAuth, &out.JWTAuth
		*out = new(VaultAwsJWTAuth)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VaultIamAuth.
func (in *VaultIamAuth) DeepCopy() *VaultIamAuth {
	if in == nil {
		return nil
	}
	out := new(VaultIamAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VaultJwtAuth) DeepCopyInto(out *VaultJwtAuth) {
	*out = *in
	if in.SecretRef != nil {
		in, out := &in.SecretRef, &out.SecretRef
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.KubernetesServiceAccountToken != nil {
		in, out := &in.KubernetesServiceAccountToken, &out.KubernetesServiceAccountToken
		*out = new(VaultKubernetesServiceAccountTokenAuth)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VaultJwtAuth.
func (in *VaultJwtAuth) DeepCopy() *VaultJwtAuth {
	if in == nil {
		return nil
	}
	out := new(VaultJwtAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VaultKubernetesAuth) DeepCopyInto(out *VaultKubernetesAuth) {
	*out = *in
	if in.ServiceAccountRef != nil {
		in, out := &in.ServiceAccountRef, &out.ServiceAccountRef
		*out = new(metav1.ServiceAccountSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.SecretRef != nil {
		in, out := &in.SecretRef, &out.SecretRef
		*out = new(metav1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VaultKubernetesAuth.
func (in *VaultKubernetesAuth) DeepCopy() *VaultKubernetesAuth {
	if in == nil {
		return nil
	}
	out := new(VaultKubernetesAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VaultKubernetesServiceAccountTokenAuth) DeepCopyInto(out *VaultKubernetesServiceAccountTokenAuth) {
	*out = *in
	in.ServiceAccountRef.DeepCopyInto(&out.ServiceAccountRef)
	if in.Audiences != nil {
		in, out := &in.Audiences, &out.Audiences
		*out = new([]string)
		if **in != nil {
			in, out := *in, *out
			*out = make([]string, len(*in))
			copy(*out, *in)
		}
	}
	if in.ExpirationSeconds != nil {
		in, out := &in.ExpirationSeconds, &out.ExpirationSeconds
		*out = new(int64)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VaultKubernetesServiceAccountTokenAuth.
func (in *VaultKubernetesServiceAccountTokenAuth) DeepCopy() *VaultKubernetesServiceAccountTokenAuth {
	if in == nil {
		return nil
	}
	out := new(VaultKubernetesServiceAccountTokenAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VaultLdapAuth) DeepCopyInto(out *VaultLdapAuth) {
	*out = *in
	in.SecretRef.DeepCopyInto(&out.SecretRef)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VaultLdapAuth.
func (in *VaultLdapAuth) DeepCopy() *VaultLdapAuth {
	if in == nil {
		return nil
	}
	out := new(VaultLdapAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VaultProvider) DeepCopyInto(out *VaultProvider) {
	*out = *in
	in.Auth.DeepCopyInto(&out.Auth)
	if in.Path != nil {
		in, out := &in.Path, &out.Path
		*out = new(string)
		**out = **in
	}
	if in.Namespace != nil {
		in, out := &in.Namespace, &out.Namespace
		*out = new(string)
		**out = **in
	}
	if in.CABundle != nil {
		in, out := &in.CABundle, &out.CABundle
		*out = make([]byte, len(*in))
		copy(*out, *in)
	}
	in.ClientTLS.DeepCopyInto(&out.ClientTLS)
	if in.CAProvider != nil {
		in, out := &in.CAProvider, &out.CAProvider
		*out = new(CAProvider)
		(*in).DeepCopyInto(*out)
	}
	if in.Headers != nil {
		in, out := &in.Headers, &out.Headers
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VaultProvider.
func (in *VaultProvider) DeepCopy() *VaultProvider {
	if in == nil {
		return nil
	}
	out := new(VaultProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VaultUserPassAuth) DeepCopyInto(out *VaultUserPassAuth) {
	*out = *in
	in.SecretRef.DeepCopyInto(&out.SecretRef)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VaultUserPassAuth.
func (in *VaultUserPassAuth) DeepCopy() *VaultUserPassAuth {
	if in == nil {
		return nil
	}
	out := new(VaultUserPassAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WebhookCAProvider) DeepCopyInto(out *WebhookCAProvider) {
	*out = *in
	if in.Namespace != nil {
		in, out := &in.Namespace, &out.Namespace
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WebhookCAProvider.
func (in *WebhookCAProvider) DeepCopy() *WebhookCAProvider {
	if in == nil {
		return nil
	}
	out := new(WebhookCAProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WebhookProvider) DeepCopyInto(out *WebhookProvider) {
	*out = *in
	if in.Headers != nil {
		in, out := &in.Headers, &out.Headers
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Timeout != nil {
		in, out := &in.Timeout, &out.Timeout
		*out = new(v1.Duration)
		**out = **in
	}
	out.Result = in.Result
	if in.Secrets != nil {
		in, out := &in.Secrets, &out.Secrets
		*out = make([]WebhookSecret, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.CABundle != nil {
		in, out := &in.CABundle, &out.CABundle
		*out = make([]byte, len(*in))
		copy(*out, *in)
	}
	if in.CAProvider != nil {
		in, out := &in.CAProvider, &out.CAProvider
		*out = new(WebhookCAProvider)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WebhookProvider.
func (in *WebhookProvider) DeepCopy() *WebhookProvider {
	if in == nil {
		return nil
	}
	out := new(WebhookProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WebhookResult) DeepCopyInto(out *WebhookResult) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WebhookResult.
func (in *WebhookResult) DeepCopy() *WebhookResult {
	if in == nil {
		return nil
	}
	out := new(WebhookResult)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WebhookSecret) DeepCopyInto(out *WebhookSecret) {
	*out = *in
	in.SecretRef.DeepCopyInto(&out.SecretRef)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WebhookSecret.
func (in *WebhookSecret) DeepCopy() *WebhookSecret {
	if in == nil {
		return nil
	}
	out := new(WebhookSecret)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *YandexCertificateManagerAuth) DeepCopyInto(out *YandexCertificateManagerAuth) {
	*out = *in
	in.AuthorizedKey.DeepCopyInto(&out.AuthorizedKey)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new YandexCertificateManagerAuth.
func (in *YandexCertificateManagerAuth) DeepCopy() *YandexCertificateManagerAuth {
	if in == nil {
		return nil
	}
	out := new(YandexCertificateManagerAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *YandexCertificateManagerCAProvider) DeepCopyInto(out *YandexCertificateManagerCAProvider) {
	*out = *in
	in.Certificate.DeepCopyInto(&out.Certificate)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new YandexCertificateManagerCAProvider.
func (in *YandexCertificateManagerCAProvider) DeepCopy() *YandexCertificateManagerCAProvider {
	if in == nil {
		return nil
	}
	out := new(YandexCertificateManagerCAProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *YandexCertificateManagerProvider) DeepCopyInto(out *YandexCertificateManagerProvider) {
	*out = *in
	in.Auth.DeepCopyInto(&out.Auth)
	if in.CAProvider != nil {
		in, out := &in.CAProvider, &out.CAProvider
		*out = new(YandexCertificateManagerCAProvider)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new YandexCertificateManagerProvider.
func (in *YandexCertificateManagerProvider) DeepCopy() *YandexCertificateManagerProvider {
	if in == nil {
		return nil
	}
	out := new(YandexCertificateManagerProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *YandexLockboxAuth) DeepCopyInto(out *YandexLockboxAuth) {
	*out = *in
	in.AuthorizedKey.DeepCopyInto(&out.AuthorizedKey)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new YandexLockboxAuth.
func (in *YandexLockboxAuth) DeepCopy() *YandexLockboxAuth {
	if in == nil {
		return nil
	}
	out := new(YandexLockboxAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *YandexLockboxCAProvider) DeepCopyInto(out *YandexLockboxCAProvider) {
	*out = *in
	in.Certificate.DeepCopyInto(&out.Certificate)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new YandexLockboxCAProvider.
func (in *YandexLockboxCAProvider) DeepCopy() *YandexLockboxCAProvider {
	if in == nil {
		return nil
	}
	out := new(YandexLockboxCAProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *YandexLockboxProvider) DeepCopyInto(out *YandexLockboxProvider) {
	*out = *in
	in.Auth.DeepCopyInto(&out.Auth)
	if in.CAProvider != nil {
		in, out := &in.CAProvider, &out.CAProvider
		*out = new(YandexLockboxCAProvider)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new YandexLockboxProvider.
func (in *YandexLockboxProvider) DeepCopy() *YandexLockboxProvider {
	if in == nil {
		return nil
	}
	out := new(YandexLockboxProvider)
	in.DeepCopyInto(out)
	return out
}
