/*
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package v1beta1

import (
	esmeta "github.com/external-secrets/external-secrets/apis/meta/v1"
)

// OnboardbaseAuthSecretRef holds secret references for onboardbase API Key credentials.
type OnboardbaseAuthSecretRef struct {
	// OnboardbaseAPIKey is the APIKey generated by an admin account.
	// It is used to recognize and authorize access to a project and environment within onboardbase
	// +kubebuilder:validation:Required
	OnboardbaseAPIKeyRef esmeta.SecretKeySelector `json:"apiKeyRef"`
	// OnboardbasePasscode is the passcode attached to the API Key
	// +kubebuilder:validation:Required
	OnboardbasePasscodeRef esmeta.SecretKeySelector `json:"passcodeRef"`
}

// OnboardbaseProvider configures a store to sync secrets using the Onboardbase provider.
// Project and Config are required if not using a Service Token.
type OnboardbaseProvider struct {
	// Auth configures how the Operator authenticates with the Onboardbase API
	Auth *OnboardbaseAuthSecretRef `json:"auth"`

	// APIHost use this to configure the host url for the API for selfhosted installation, default is https://public.onboardbase.com/api/v1/
	// +kubebuilder:default:="https://public.onboardbase.com/api/v1/"
	APIHost string `json:"apiHost"`

	// Project is an onboardbase project that the secrets should be pulled from
	// +kubebuilder:validation:Required
	// +kubebuilder:default:="development"
	Project string `json:"project"`
	// Environment is the name of an environmnent within a project to pull the secrets from
	// +kubebuilder:validation:Required
	// +kubebuilder:default:="development"
	Environment string `json:"environment"`
}
