<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
<!DOCTYPE html>
<html>
<head>
<meta charset="ISO-8859-1">
<title>Spring Proyect Demo 4</title>
<!-- En las vistas .jsp, se puede usar la siguiente directiva para construir las rutas a los recursos estticos:
		 ${pageContext.request.contextPath} 
     
     En este proyecto se ha optado por indicarlas de forma esttica, pero si cambia en las controladoras la ubicacin lgica y relativas mapeadas, podran producirse
     errores de acceso a los recursos (.js, .css) si no se actualizan manualmente.
-->
<link rel="stylesheet" href="./styles/index.css">

</head>
<body>
    <div class="cabecera">
        <div class="cab1"></div>
        <div class="cap2"></div>
    </div>
    <div class="cuerpo">
        <div class="panel1">
            <div class="nota"><div class="notacab1"><p>Proyecto</p></div>
                              <div class="notabody"><p style="text-align: center;"><span>#Spring Proyect Demo 4</span></p>
                            </div>
            </div>
            <div class="nota"><div class="notacab1"><p>Objetivos</p></div>
                              <div class="notabody"><p class="objetivos">- <b>C</b>aptura del evento de arranque de la aplicacin. onStartup.</p>
                              						<p class="objetivos">- <b>C</b>aptura de los eventos de inicio y fin de la sesin de usuario. sessionCreated y sessionDestroyed.</p>   
                                                    <p class="objetivos">- <b>V</b>ariables en memoria de aplicacin.</p>
                              </div>        
                            
            </div>
            <div class="nota"><div class="notacab2"><p>Entorno de Desarrollo</p></div>
                              <div class="notabody"><p><span>Ide:</span> Eclipse, versin: 2022-03 (4.23.0)</p>
                                                    <p><span>Servidor:</span> Apache Tomcat, versin: 9</p>
                                                    <p><span>Jdk:</span> OpenJdk, versin: 17.1</p>
                            </div>
            </div>
            <div class="nota"><div class="notacab2"><p>Estandar de Desarrollo</p></div>
                              <div class="notabody"><p><span>Gestor de proyecto:</span> Maven, versin: 3.8.0</p>
                                                    <p><span>Id Artefacto maven:</span> maven-archetype-webapp, versin: 1.4</p>
                                                    <p><span>Faceta:</span> Dynamic Web Module, versin: 4.0</p>
                            </div>
            </div> 
            <div class="nota"><div class="notacab2"><p>Dependencias</p></div>
                              <div class="notabody"><p><span>Spring Framework:</span> Spring, versin 5.3.22. Mdulos: Spring Web MVC</p>
                                                    <p><span>Javax servlet:</span> versin: 4.0.1</p>
                            </div>
            </div>    
            <div class="nota"><div class="notacab2"><p>Documentacin y Sitios de Inters</p></div>
                              <div class="notabody"><p><a href="https://mvnrepository.com/" target="_blank">Ir a</a> Maven Repository</p>
                                                    <p><a href="https://docs.spring.io/spring-framework/docs/current/reference/html/" target="_blank">Leer</a> Documentacin de Spring</p>
                                                    <p><a href="https://docs.spring.io/spring-framework/docs/5.3.5/reference/html/web.html" target="_blank">Leer</a> Documentacin sobre DispatcherServlet</p>
                            </div>
            </div>         
        </div>
        <div class="panel2">
            <div class="item"><p><span>Anlisis 1 - WebApplicationInitializer:</span> En este anlisis, le proponemos que proceda a abrir el fichero ApplicationEvents.java, el cual sobrecarga el evento onStartup que permite capturar el evento de arranque de la aplicacin. Este evento se ejecuta una sola vez, al iniciarse la aplicacin con la primera peticin detectada de un cliente.</p>
            				  <p>Es un lugar idoneo, para entre otras cosas, cargar datos en cache de la aplicacin (ej: datos de tablas de mapeo que varian muy poco en base de datos con el fin de ganar eficiencia y velocidad) o tal como se le muestra en el proyecto SpringProyectDemo5 llevar a cabo la lectura de datos desde un fichero de configuracin, entre mltiples necesidades posibles.</p>
            				  <p>Establesca un break-point en el mtodo onStartup y proceda a ejecutar el proyecto en modo depuracin para que compruebe como se desata tal evento.</p>
            </div>
            <div class="item"><p><span>Anlisis 2 - HttpSessionListener:</span> En este anlisis, le proponemos que proceda a abrir el fichero SessionEvents.java, el cual sobrecarga los eventos sessionCreated y sessionDestroyed. Estos mtodos permiten capturar la creacin de una nueva sesin (por cada cliente que accede a la aplicacin) y capturar el fin de la sesin (cuando se sobrepasa el tiempo mximo de sesin sin actividad del cliente; session-timeout, ver fichero web.xml).</p>
            				  <p>Establesca un break-point en los mtodos sessionCreated y sessionDestroyed y proceda a ejecutar el proyecto en modo depuracin para que compruebe como se desata tales eventos. Observar que cada vez que se inicia una sesin nueva se desata sessionCreated. Qu ocurre, si desde el mismo navegador, se vuelve a realizar una segunda peticin a la aplicacin? y si se hace desde diferentes navegadores?</p>
            				  <p>El mtodo sessionDestroyed, se desatar cuando haya transcurrido session-timeout (web.xml) sin actividad. Deber esperar a que esto ocurra.</p>
            </div>
            <div class="item"><p><span>Anlisis 3 - Variables de aplicacin:</span> Si bin es verdad, que existen varias formas de hacer uso de la memoria de la aplicacin o comunmente denominado variables de aplicacin, debe tener en cuenta que cualquier dato que se asigne a un atributo esttico que se implemente en cualquier clase, sern almacenados en la memoria de la aplicacin.</p>
            				  <p>Es decir, hasta ahora, toda variables o atributo que se crea y no es esttico o incluso el contenido de las variables de sesin (vistas en el proyecto SpringProyectDemo 2) son datos relativos al hilo de cada cliente. Sin embargo, cuando se crean atributos estticos, los datos se almacenan en memoria de aplicacin y pueden ser accedidos desde todos los hilos activos de los usuarios.</p>
            				  <p>Esto ltimo, implica que hacer uso de la memoria de aplicacin puede requerir llevar a cabo una correcta programacin concurrente (control de escritura/lectura con synchronized o semaforos).</p>
            				  <p>En el fichero SessionEvents.java, puede observar como se ha creado un atributo esttico de tipo entero denominado totalActiveSessions. En este ejemplo, lo que se hace es incrementar dicho contador que registra el nmero de sesiones activas en cada momento con el mtodo sessionCreated mientras que al desatarse un fin de sesin, este contador se decrementa con el mtodo sessionDestroyed. </p>
            				  <p>Actualmente el nmero de sesiones activas es: <b>${NumSesiones}</b>.</p>
							  <p>El evento sessionCreated en ocasiones se desata algo ms darde de lo que tarda la controladora en devolver la peticin al cliente, por ello, es normal que al arrancar el proyecto y cargar la vista index.jsp le aparezca un 0 en vez de un 1, pero si vuelve a refrescar, comprobar que el dato ya es correcto. Esto se debe a que el hilo del usuario se ejecuta independiente al hilo de la aplicacin.</p>
            				  <p>NOTA: En el ejemplo descrito anteriormente, no se hace uso de una correcta programacin concurrente (dos hilos podran estar escribiendo simultaneamente).</p>
            </div>
        </div>
    </div>
    <div class="pie"><p><span></span> 2022 - Daniel Prez Prez</p></div>

</body>
</html>