# Operating Systems (OS) Collection

> Welcome To The World of Operating System. An ongoing & curated collection of awesome software, frameworks and libraries, learning tutorials  and videos, technical guidelines and best practices about Operating Systems (OS).
> Thanks to our daily readers and contributors. The goal is to build a categorized community-driven collection of very well-known resources. Sharing, suggestions and contributions are always welcome!

## `About Operating Systems (OS)?`

## `Table of Contents`

 - [Introduction](#about-operating-systems-os)
 - [Open Source Operating Systems](#open-source-operating-systems)
 - [Hobby](#hobby)
 - [Popular Operating Systems](#popular-operating-system)
 - [Windows](#--windows)
 - [Macintosh](#-macintosh)
 - [Linux](#--linux)
 - [Indie-OS](#-indie-os)
 - [Portfolio](#-portfoliopersonal-os)
 - [good-old-os](#good-old-oss)
 - [Other Sources](#other-sources)
 - [Browsers](#-browsers)
 - [For Whom](#for-whom)


 
 
 ## Open Source Operating Systems

* [ackOS](https://github.com/ackOS-project/ackOS) - A simple 64-bit operating system.
* [AROS](https://aros.sourceforge.io/) - Research Operating System is a lightweight, efficient, and flexible desktop operating system, designed to help you make the most of your computer. It's an independent, portable and free project, aiming at being compatible with AmigaOS at the API level
* [BoneOS](https://github.com/Bone-Project/BoneOS)- OS for everyone built by everyone
* [Bottlerocket OS](https://github.com/bottlerocket-os/bottlerocket)- Linux-based OS meant for hosting containers.
* [Cadex OS](https://github.com/opencreeck/Cadex-OS-Official) - a simple operating system kernel originally made by Prof. Douglas Thain at the University of Notre Dame and students
* [ChibiOS](http://www.chibios.org/) - a complete development environment for embedded applications including RTOS, an HAL, peripheral drivers, support files and tools
* [Clive](https://lsub.org/ls/clive.html) - A unikernel OS inspired by Plan9 and Nix developed at *Universidad Rey Juan Carlos of Madrid*
* [CollapseOS](https://collapseos.org/) - Bootstrap post-collapse technology
* [dahliaOS](https://dahliaos.io)- dahliaOS is a modern, secure, lightweight and responsive operating system, combining the best of GNU/Linux and Fuchsia OS.
* [eggos](https://github.com/icexin/eggos) - A Go unikernel running on x86 bare metal
* [Embox](http://www.embox.rocks/) - Configurable operating system kernel designed for resource constrained and embedded systems.
* [FreeRTOS](https://aws.amazon.com/freertos/), [GitHub](https://github.com/aws/amazon-freertos) - IoT operating system for microcontrollers, by Amazon.
* [Genode](https://genode.org/) - A FOSS operating system framework consisting of a microkernel abstraction layer and a collection of userspace components
* [gopher-os](https://github.com/gopher-os/gopher-os) - A proof of concept OS kernel written in Go
* [GreenteaOS](https://greenteaos.github.io/), [Github](https://github.com/GreenteaOS/Greentea) - A free OS designed to be compatible with Windows executables 
* [HarveyOS](https://harvey-os.org/) - A distributed operating system
* [HelenOS](https://github.com/HelenOS/helenos) - multikernel multiserver OS
* [helium](https://github.com/mszoek/helium) - A BSD-based OS project that aims to provide an experience like and some compatibility with macOS
* [Hubris](https://hubris.oxide.computer/) - Hubris is an operating system for microcontrollers developed by Oxide Computer Company in Rust
* [Interim](https://github.com/mntmn/interim) - Minimalist OS with concepts from Lisp machines and Plan9
* [Jehanne](http://jehanne.io/), [GitHub](https://github.com/JehanneOS/jehanne/) - OS inspired by Plan9, 9front and Harvey OS
* [KnightOS](https://github.com/KnightOS/KnightOS) - for z80 calculators
* [L4re](https://github.com/kernkonzept/l4re-core) - Operating system and hypervisor for security/safety-critical and virtualization-enabled applications.
* [managarm](https://github.com/managarm/managarm) - Pragmatic microkernel-based OS with fully asynchronous I/O
* [Mimiker](https://mimiker.ii.uni.wroc.pl/), [GitHub](https://github.com/cahirwpz/mimiker) - Simple unix-like operating system for education and research purposes. MIPS microkernel.
* [Minoca OS](https://github.com/minoca/os) - General purpose OS, written in C
* [Nanos](https://github.com/nanovms/nanos) - Unikernel that is linux-compatible, written in C
* [NodeOS](https://github.com/NodeOS/NodeOS) - OS using NodeJS and Linux
* [Pidi OS](https://github.com/GandelXIV/pidi-os) - Independent and minimalistic OS
* [Redox](https://github.com/redox-os/redox) - written in Rust
* [Sanos](http://www.jbox.dk/sanos/), [GitHub](https://github.com/ringgaard/sanos) - Sanos is a minimalistic 32-bit x86 operating system kernel for network server appliances running on standard PC hardware.
* [skiftOS](https://skiftos.org/), [GitHub](https://github.com/skiftOS/skift) - A simple, handmade, operating system with a graphical user interface.
* [Sculpt OS](https://genode.org/download/sculpt) - Genode based OS
* [soso](https://github.com/ozkl/soso) - Simple unix-like operating system written in Nasm assembly and mostly in C
* [SynestiaOS](https://github.com/SynestiaOS/SynestiaOS) - 32/64 bit operating system written in C for arm platform
* [Thor](https://github.com/wichtounet/thor-os) - 64bit operating system mostly written in C++
* [Theseus](https://github.com/theseus-os/Theseus) - A modern experimental OS written from scratch in Rust to explore novel OS structure and state management techniques.
* [tock](https://www.tockos.org/), [GitHub](https://github.com/tock/tock) - A secure embedded operating system for microcontrollers
* [Unikraft](https://github.com/unikraft/unikraft) - A modular unikernel for specialization, high efficiency, performance, and security; Linux/POSIX-compatible; mostly in C
* [Mimosa](https://icfp20.sigplan.org/details/scheme-2020-papers/3/Running-Scheme-On-Bare-Metal-Experience-Report-), [GitHub](https://github.com/udem-dlteam/mimosa) - Research Operating System that runs Scheme on bare-metal
* [hhuOS](https://github.com/hhuOS/hhuOS) - hhuOS is a small operating system written in C++ and Assembler for the x86-architecture. The main purpose of this project is to show how different aspects of operating systems theory can be implemented and linked together. The system is not aimed to be a full-featured operating system for daily use.

### Hobby
* [AquilaOS](https://aquilaos.com) - Operating System that is designed to be POSIX compliant and mostly ISA transparent
* [Animal](https://github.com/frednora/animal) - 32 bit multithreaded operating system (formerly Gramado)
* [Brutal](https://brutal-org.netlify.app/), [GitHub](https://github.com/brutal-org/brutal) - An operating system inspired by brutalist design that combines the ideals of UNIX from the 1970s with modern technology and engineering
* [Cyjon](https://github.com/Blackend/Cyjon/) - pure x64 assembly language operating system
* [emerald](https://github.com/Abb1x/emerald) - An operating system kernel written for fun in C
* [HalideOS](https://dsc-kiit.github.io/project-halide/) - experimental operating system written entirely from scratch.
* [hydrogen](https://github.com/mszoek/hydrogen) - toy OS. 64-bit, preemptive multitasking kernel supporting EFI, PCIe, SATA, framebuffer graphics mode, HFS+.
* [KripayaOS](https://github.com/Kridar/KripayaOS) - x86 Kernel with it's own bootloader.
* [KolibriOS](http://www.kolibrios.org) - MenuetOS fork
* [LemonOS](https://lemonos.org/), [GitHub](https://github.com/fido2020/Lemon-OS) - UNIX-like 64-bit operating system written in C++.
* [lyre](https://github.com/lyre-os/lyre) - x86 kernel and distribution powered by mlibc, GNU userland tools, and other common *nix software.
* [Mako](https://github.com/AjayMT/mako) - Hobby OS for x86 from scratch, written in C
* [MenuetOS](http://www.menuetos.net/) - Hobby OS supporting 32 and 64 bit, written in Assembly language
* [mOS](https://github.com/MQuy/mos) - A hobby operating system developed from scratch
* [moros](https://github.com/vinc/moros) - MOROS is a hobby operating system written in Rust for the x86 architecture.
* [MyXomycota](https://sourceforge.net/projects/myxomycota/) - Monolithic kernel in C
* [nopeos](https://github.com/d99kris/nopeos) - Simple OS kernel with BASIC interpreter for x86
* [oneOS](https://github.com/nimelehin/oneOS) - x86-32 and ARMv7 kernel with pre-emptive multi-threading, window manager and editor
* [pranaOS](https://github.com/pranaOS/pranaOS) - A unix operating system written from scratch in c / c++
* [PathOS](http://path-os.duckdns.org/) - Hobby OS based on [MikeOS](https://github.com/mig-hub/mikeOS), written in Assembly Language
* [PonyOS](https://ponyos.org/), [GitHub](https://github.com/klange/ponyos) - ToaruOS-based, My Little Pony themed OS
* [PouplyOS](https://github.com/mtribiere/PoulpyOS) - Simple OS for fun and learning, named after the ESISAR mascot Poulpy
* [r3](https://github.com/Narasimha1997/r3) - A hobby x86_64 Operating System kernel written in Rust -- with minimal functionalities
* [Serenity](https://github.com/SerenityOS/serenity) - Graphical Unix-like operating system for x86 computers
* [SimpleOS](https://github.com/xing1357/SimpleOS) - Simple Operating System coded in C and Assembly
* [Snowdrop OS](http://sebastianmihai.com/snowdrop/) - a homebrew operating system from scratch, in assembly language 
* [Sortix](https://sortix.org/) - Hobby OS in C and C++ by *Jonas 'Sortie' Termansen*
* [TempleOS](https://github.com/minexew/TempleOS) - Religious OS :-)
* [TETRIS-OS](https://github.com/jdah/tetris-os) - An operating system, but it only plays Tetris.
* [ToaruOS](https://github.com/klange/toaruos) - Hobby operating system from scratch
* [Týndur](http://www.tyndur.org/) - Hobby operating system build by the Lowlevel community. Written in C and Pascal
* [Ultron OS](https://github.com/aswinmohanme/ultronOS) -  x86 Operating System written in C++, High School Project
* [Visopsys](https://visopsys.org/) - Open Source Hobby OS developed since 1997
* [willOS](https://github.com/willdurand/willOS) - A minimal 64 bits kernel (Operating System that cannot "operate" a lot of things)
* [Windows 95 in Electron](https://github.com/felixrieseberg/windows95) - Hobby Windows 95 implementation in Electron
* [Xv6](https://pdos.csail.mit.edu/6.828/2019/xv6.html) - A teaching operating system developed in the summer of 2006 for MIT's operating systems course
* [BareMetal](http://www.returninfinity.com/), [GitHub](https://github.com/ReturnInfinity/BareMetal) - 64 bit operating system written in Assembly for x86-64
* [ZealOS](https://github.com/Zeal-Operating-System/ZealOS) - The Zeal Operating System is a modernized, professional fork of the 64-bit Temple Operating System, TempleOS.

### Popular Operating Systems
* [Darwin XNU](https://github.com/apple/darwin-xnu) - The XNU kernel source code for use in MacOS and iOS
* [FreeBSD](https://freebsd.org/), [Github](https://github.com/freebsd/freebsd) - Unix-like operating system based on the BSD
* [FreeDOS](http://freedos.org/) - DOS compatible OS
* [Haiku](https://github.com/haiku/haiku) - BeOS inspired OS
* [Linux](https://github.com/torvalds/linux) - Linux kernel
* [Minix](https://www.minix3.org/), [Github](https://github.com/Stichting-MINIX-Research-Foundation/minix) - Unix-like operating system based on a microkernel architecture
* [MS-DOS](https://github.com/microsoft/MS-DOS) - The original sources of MS-DOS 1.25 and 2.0
* [NetBSD](https://www.netbsd.org/), [Github](https://github.com/netbsd/src) - Unix-like operating system based on the BSD
* [OpenBSD](https://www.openbsd.org/), [Github](https://github.com/openbsd/src) - Unix-like operating system based on the BSD
* [ReactOS](https://reactos.org/), [Github](https://github.com/reactos/reactos) - A free Windows-compatible Operating System 
* [SystemV](https://archive.org/details/ATTUNIXSystemVRelease4Version2) - AT&T UNIX System V Source Code

## Books and Guides

### Online books

* [How to Make a Computer Operating System](https://github.com/SamyPesse/How-to-Make-a-Computer-Operating-System) - in C++
* [Intermezzos](https://intermezzos.github.io/book/) - A follow along book to build IntermezzosOS in Rust
* [Linux Kernel in a Nutshell](http://www.kroah.com/lkn/) - Covers the entire range of kernel tasks, available as chapters or one PDF
* [The little book about OS development](http://littleosbook.github.io/) by *Erik Helin* and *Adam Renberg*
* [Think OS](http://greenteapress.com/thinkos/) - A Brief Introduction to Operating Systems by *Allen B. Downey*
* [Operating System Development Series](http://www.brokenthorn.com/Resources/OSDevIndex.html) - OS from the ground up in C
* [Operating Systems: Three Easy Pieces](http://pages.cs.wisc.edu/~remzi/OSTEP/) - Easy to read book covering virtualization, concurrency and persistence
* [xv6: a simple, Unix-like teaching operating system](https://pdos.csail.mit.edu/6.828/2019/xv6/book-riscv-rev0.pdf) - Book for Xv6
* [Operating Systems: From 0 to 1](https://tuhdo.github.io/os01/) - Bootstrap yourself to write an OS from scratch by *Do Hoang Tu*

### Tutorials

* [Baking Pi – Operating Systems Development](https://www.cl.cam.ac.uk/projects/raspberrypi/tutorials/os/index.html) by University of Cambridge
* [Build a minimal multi-tasking OS kernel for ARM from scratch](https://github.com/jserv/mini-arm-os) by Jim Huang
* [Bran's Kernel Development](http://www.osdever.net/bkerndev/Docs/title.htm) by Brandon Friesen
* [How to write a Linux kernel patch and submit it](https://github.com/gregkh/kernel-tutorial) by Greg Kroah-Hartman
* [Presentation on how the Linux kernel is developed](https://github.com/gregkh/kernel-development) by Greg Kroah-Hartman
* [os-tutorial - How to create an OS from scratch](https://github.com/cfenollosa/os-tutorial) by Carlos Fenollosa
* [Roll your own toy UNIX-clone OS](http://jamesmolloy.co.uk/tutorial_html/)  by James Molloy
* [Writing an OS in Rust](https://os.phil-opp.com/) by Philipp Oppermann
* [Making a RISC-V Operating System using Rust](http://osblog.stephenmarz.com/) by Stephen Marz
* [Operating systems development for Dummies](https://medium.com/@lduck11007/operating-systems-development-for-dummies-3d4d786e8ac) by Leo Whitehead
* [Kernels 101 – Let’s write a Kernel](https://arjunsreedharan.org/post/82710718100/kernels-101-lets-write-a-kernel) by Arjun Sreedharan
* [Kernels 201 - Let’s write a Kernel with keyboard and screen support](https://arjunsreedharan.org/post/99370248137/kernels-201-lets-write-a-kernel-with-keyboard) by Arjun Sreedharan
* [Writing a Tiny x86 Bootloader](https://www.joe-bergeron.com/posts/Writing%20a%20Tiny%20x86%20Bootloader/) by Joe Bergeron
* [Writing a Bootloader](http://3zanders.co.uk/2017/10/13/writing-a-bootloader/) by Alex Parker
* [Learning operating system development using Linux kernel and Raspberry Pi](https://github.com/s-matyukevich/raspberry-pi-os)

### Website & Virtualization
* [Genodians](https://genodians.org/) - Stories around the Genode Operating System
* [os-dev](http://wiki.osdev.org/Main_Page) - Wiki with everything you need to know
* [Lowlevel](http://www.lowlevel.eu/wiki/Hauptseite) - A wiki about creating an OS from scratch. In German
* [POSIX](https://pubs.opengroup.org/onlinepubs/9699919799/) - Standards for maintaining compatibility between operating systems
* [OS Boxes](https://www.osboxes.org/)
* [VMware Marketplace](https://marketplace.cloud.vmware.com/)
* [Virtualization Platform Comparisons](https://en.wikipedia.org/wiki/Comparison_of_platform_virtualization_software)

### Papers
* [The benefits and costs of writing a POSIX kernel in a high-level language](https://www.usenix.org/conference/osdi18/presentation/cutler) by Cody Cutler, M. Frans Kaashoek, and Robert T. Morris, MIT CSAIL
* [Running Scheme On Bare Metal](https://icfp20.sigplan.org/details/scheme-2020-papers/3/Running-Scheme-On-Bare-Metal-Experience-Report-) by Samuel Yvon, Marc Feeley, Scheme 2020
* [Unikraft: Fast, Specialized Unikernels the Easy Way](https://dl.acm.org/doi/pdf/10.1145/3447786.3456248) by Kuenzer et al., EuroSys 2021

### Video Tutorials


## <img src="media/icons8-windows-11-48.png" alt="logo" width="36"/>  WINDOWS
 

| N. | Identifier    | Description    | Live Demo/Docs    |
| ---- | :----------------- | :--------------- | :--------- |
| 01.  | [windows11](https://github.com/Rajaniraiyn/windows11) <br>                  | Want to experience Windows 11 now within your browser? <br> `HTML` `CSS` `JS` ~ [@Rajaniraiyn](https://github.com/Rajaniraiyn)                                                                                                                                                                                                                                                                                                                        | [here](https://rajaniraiyn.github.io/windows11)                         |
| 02.  | [windows-11-web](https://github.com/PiyushSuthar/Windows-11-Web)                 | Awe-amazing Windows 11 clone. Oh wait, Not for your Computer, but for the web! ⚡ <br> `Preact` `ViteJS` `TS` `Vercel` `HTML` `CSS` `JS` ~ [@PiyushSuthar](https://github.com/PiyushSuthar)                                                                                                                                                                                                                                                           | [here](https://win11.vercel.app)                                        |
| 03.  | [windows11](https://github.com/blueedgetechno/windows11)                    | Windows 11 using Ｒ Ｅ A C T <br> `React` `Redux` `Tailwind CSS` `Fontawesome` `SCSS` `JS` ~ [@blueedgetechno](https://github.com/blueedgetechno)                                                                                                                                                                                                                                                                                                                 | [here](https://win11.blueedge.me)                                       |
| 04.  | [react-windows-ui](https://github.com/virtualvivek/react-windows-ui)               | Full featured Windows fluent UI apps using ReactJS. Provides a set of accessible, reusable, and composable React components that make it super easy to create websites and apps. <br> `TS` `SCSS` `HTML` `CSS` `JS` ~ [@VirtualVivek](https://github.com/virtualvivek)                                                                                                                                                                                | [here](https://virtualvivek.github.io/react-windows-ui/)                |
| 05.  | [windows10-framework](https://github.com/virtualvivek/Windows10-framework/)           | Build full featured Windows 10 Native apps or Web apps using Html, CSS & JavaScript. Comes with rich native like components, icon sets. Used as fast prototyping tool for Windows environment platforms. <br> `SCSS` `HTML` `CSS` `JS` ~ [@VirtualVivek](https://github.com/virtualvivek)                                                                                                                                                             | [here](https://windows10framework.github.io)                            |
| 06.  | [react-desktop](https://github.com/gabrielbull/react-desktop)                | React UI Components for macOS High Sierra and Windows 10 <br> `React` `JS` ~ [@GabrielBull](https://github.com/gabrielbull)                                                                                                                                                                                                                                                                                                                           | [here](http://reactdesktop.js.org)                                      |
| 07.  |windows 8 start-page| A Windows 8 like start page, not open-source |[here](https://webdesktop.net) |
| 08.  | [winXP](https://github.com/ShizukuIchi/winXP)                           | Web based Windows XP desktop recreation. <br> `React` `JS` `Vercel` ~ [@ShizukuIchi](https://github.com/ShizukuIchi)                                                                                                                                                                                                                                                                                                                                  | [here](https://winxp.vercel.app)                                        |
| 09.  | [x-webDesktop-vue](https://github.com/OXOYO/X-WebDesktop-Vue)             | A Windows WebDesktop system based on Vue <br> `Vue` `JS` ~ [@OXOYO](https://github.com/OXOYO)                                                                                                                                                                                                                                                                                                                                                               | [here](http://oxoyo.co/X-WebDesktop-Vue/)                               |
| 10.  |Windows XP | Simple Widnows XP demo with many integrated open source softwares| [here](https://desk.glitchy.website )|
| 11.  | [jspaint](https://github.com/1j01/jspaint)                       | 🎨 Classic MS Paint, ＲＥＶＩＶＥＤ + ✨Extras <br> `NODEJS` `HTML5 Canvas` `CSS` `JS` ~ [@1j01](https://github.com/1j01)                                                                                                                                                                                                                                                                                                                             | [here](https://jspaint.app/#local:9fdbb2f31c0bb8)                       |
| 12.  | [98](https://github.com/1j01/98)                                     | Web-based Windows-98 desktop recreation . <br> `C++` `JS` `HTML` `CSS` ~ [@1j01](https://github.com/1j01)                                                                                                                                                                                                                                                                                                                                             | [here](https://98.js.org)                                               |
| 13.  | [packard-belle-desktop](https://github.com/padraigfl/packard-belle-desktop) | Building websites with packard-belle UI library and react-rnd. Inspired by Windows! <br> `HTML` `CSS` `JS` ~ [@padraigfl](https://github.com/padraigfl)                                                                                                                                                                                                                                                                                                                      | [here](https://packard-belle.netlify.app)                               |
| 14.  | [windows98-html-css-js](https://github.com/lolstring/window98-html-css-js)                   | Windows-98 on the W E B! using HTML5, CSS3 and JS <br> `HTML` `CSS` `JS` ~ [@lolstring](https://github.com/lolstring)                                                                                                                                                                                                                                                                                                                                    | [here](https://rahul.io/)                                               |
| 15.  | windows 98| A simple Windows 98 display |[here](http://51pegasib.free.fr/emuls/ws/wm.htm) |
| 16.  | [windows95](https://github.com/felixrieseberg/windows95)                    | Windows-95 in Electron. Runs on macOS, Linux, and Windows. <br> `Electron` `TS` `Docker` `JS` ~ [@Felixrieseberg](https://github.com/felixrieseberg)                                                                                                                                                                                                                                                                                                  | [here](https://github.com/felixrieseberg/windows95/releases/tag/v2.3.0) |
| 17.  | [react95](https://github.com/arturbien/React95)                     | Refreshed Windows-95 style UI components for your React app. <br> `React` `JS` ~ [@Arturbien](https://github.com/arturbien)                                                                                                                                                                                                                                                                                                                            | [here](https://react95.io/#)                                            |
| 18.  | [win95](https://win95.ajf.me/) | Pretty much Similar to Windows-95 experience. Downloadable file |[here](https://archive.org/details/win95_in_dosbox )|
| 19.  | Windows 93| Web based Windows 93 experience |[here](https://www.windows93.net )|
| 20.  | [emupedia](https://github.com/Emupedia/emupedia.github.io)                | Emulator-focused Win9X desktop. The purpose of Emupedia is to serve as a nonprofit meta-resource, hub and community for those interested mainly in video game preservation which aims to digitally collect, archive and preserve games and software to make them available online accessible by a user-friendly UI that simulates several retro operating systems for educational purposes. <br> `CSS` `JS` ~ [@Emupedia](https://github.com/Emupedia) | [here](https://emupedia.net/beta/emuos/)                                |
| 21.  |Image OS| A WIndows and Mac images simulation of operating system, previous 9 Windows OSs and 4 macOSs  | [here](http://virtualdesktop.org/complete/index.html )|
| 22.  | [poke95](https://github.com/wobsoriano/poke95)                      | A Windows-95 style Pokédex(kinda game) built with React. <br> `React` `React95` `PokeAPI` `Vercel` `HTML` `CSS` `JS` ~ [@Wobsoriano](https://github.com/wobsoriano)                                                                                                                                                                                                                                                                                               | [here](https://poke95.vercel.app)                                       |
| 23.  | [webamp](https://github.com/captbaritone/webamp)                             | Winamp 2(VLC of that era) reimplemented for the browser. <br> `Objective-C` `Matlab` `TS` `HTML` `CSS` `JS` ~ [@captbaritone](https://github.com/captbaritone)                                                                                                                                                                                                                                                                                                          | [here](https://webamp.org)                                              |
| 24.  | [winampify](https://github.com/remigallego/winampify)                        | ⚡ A Spotify web client with an OS-looking interface and a reimplementation of the classic audio player Winamp. <br> `React` `emotionjs` `TS` `HTML` `Sass` `CSS` `JS` ~ [@remigallego](https://github.com/remigallego)                                                                                                                                                                                                                               | [here](https://winampify.io)                                            |
| 25.  | [webamp-desktop](https://github.com/durasj/webamp-desktop)                   | Cross-platform (Windows, macOS and Linux) desktop version of Winamp 2.9 reimplementation. <br> `Electron` `JS` ~ [@durasj](https://github.com/durasj)                                                                                                                                                                                                                                                                                                 | [here](https://desktop.webamp.org)                                      |
| 26.  | [pipes](https://github.com/1j01/pipes)                    | Web based C L A S S I C Windows 3D Pipes screensaver remake. <br> `ThreeJs` `JS` ~ [@1j01](https://github.com/1j01)                                                                                                                                                                                                                                                                                                                                         | [here](https://1j01.github.io/pipes/)                                   |
| 27.  | [3D-FlowerBox](https://github.com/kevin-shannon/3D-FlowerBox)         | Web based Faithful WebGL remake of the Classic Windows-95 screensaver. <br> `HTML` `JS` ~ [@kevin-shannon](https://github.com/kevin-shannon)                                                                                                                                                                                                                                                                                                           | [here](https://kevinshannon.dev/3D-FlowerBox/)                          |
| 28.  | [zine](https://github.com/STRd6/zine)                           | This project started as building a simple minesweeper clone for a job interview, but the nostalgia swept over me hard and inspired me to do something a little more ambitious. My goal is to build as faithful of a recreation of Windows-95 in the browser as I can. <br> `JS` ~ [@1000hz](https://github.com/1000hz)                                                                                                                                | [here](https://winmine-exe.vercel.app)                                  |
| 29.  | win minecraft | Play legacy minecraft game online | [here](https://classic.minecraft.net/?join=-CdrcyVw5xpqE93- )|
| 30.  | [win95-media-player](https://github.com/benwiley4000/win95-media-player)     | Back from 1995, and running on your browser! <br> `React` `JS` ~ [@benwiley4000](https://github.com/benwiley4000)                                                                                                                                                                                                                                                                                                                                      | [here](https://benwiley4000.github.io/win95-media-player/)              |
| 31.  | [js-solitaire](https://github.com/rjanjic/js-solitaire)                     |Classic clone of Microsoft's Solitaire game. <br> `CSS` `JS` ~ [@rjanjic](https://github.com/rjanjic)                                                                                                                                                                                                                                                                                                                                                          | [here](http://radovanjanjic.com/js-solitaire/)                          |
| 32.  | [ArmorAlley](https://github.com/scottschiller/ArmorAlley/)                   | A browser-based interpretation of the MS-DOS release of Armor Alley, a combat strategy game originally released in 1990 for MS-DOS PCs and the Macintosh. <br> `HTML` `CSS` `JS` ~ [@scottschiller](https://github.com/scottschiller)                                                                                                                                                                                                                 | [here](http://www.schillmania.com/armor-alley/)                         |
| 33.  | [winclassic](https://github.com/tpenguinltg/winclassic)                      | The classic Windows theme designer: a utility to help ease the development of Windows Classic themes <br> `sed` `SCSS` `HTML` `CSS` `JS` ~ [@tpenguinltg](https://github.com/tpenguinltg)                                                                                                                                                                                                                                                                 | [here](https://tpenguinltg.github.io/winclassic/)                       |
| 34.  | [fileExplorer](https://github.com/cubiclesoft/js-fileexplorer)          | A zero dependencies, customizable, pure Javascript widget for navigating, managing, uploading, and downloading files and folders or other hierarchical object structures on any modern web <br> `PHP` `PLSQL` `HTML` `CSS` `JS` ~ [@cubiclesoft](https://github.com/cubiclesoft)                                                                                                                                                                   | [here](https://cubiclesoft.com/demos/js-fileexplorer/demo.html)         |
| 35.  | [clippy.js](https://github.com/smore-inc/clippy.js)                     | Add Clippy(we miss you!) or his friends to any website for instant nostalgia <br> `CSS` `JS` ~ [@smore-inc](https://github.com/smore-inc)                                                                                                                                                                                                                                                                                                                           | [here](https://www.smore.com/clippy-js)                                 |
| 36.  | [wolf3d](https://github.com/jseidelin/wolf3d)                           | The classic Windows game Wolfenstein-3D <br> `HTML5` `CSS` `JS` ~ [@jseidelin](https://github.com/jseidelin)                                                                                                                                                                                                                                                                                                                                            | [here](http://git.nihilogic.dk/wolf3d/)                                 |
| 37.  | [skifree.js](https://github.com/basicallydan/skifree.js)                    | The classic PC Game SkiFree, but in JS <br> `HTML` `CSS` `JS` ~ [@basicallydan](https://github.com/basicallydan)                                                                                                                                                                                                                                                                                                                                      | [here](https://basicallydan.github.io/skifree.js/)                      |
| 38.  | [vipercard](https://github.com/moltenform/vipercard)                     | An open source rewrite of 1987's HyperCard <br> `TS` `Python` `HTML` ~ [@moltenform](https://github.com/moltenform)                                                                                                                                                                                                                                                                                                                                   | [here](https://www.vipercard.net)                                       |
| 39.  | [7.css](https://github.com/khang-nd/7.css)                               | A tiny CSS framework for building faithful recreations of the Windows-7 UI. <br> `SCSS` `JS` ~ [@khang-nd](https://github.com/khang-nd)                                                                                                                                                                                                                                                                                                               | [here](https://khang-nd.github.io/7.css/)                               |
| 40.  | [XP.css](https://github.com/botoxparty/XP.css)                           | A CSS framework for building faithful recreations of operating system GUIs <br> `SCSS` `JS` ~ [@botoxparty](https://github.com/botoxparty)                                                                                                                                                                                                                                                                                                            | [here](https://botoxparty.github.io/XP.css/)                            |
| 41.  | [98.css](https://github.com/jdan/98.css)                                 | A design system for building faithful recreations of old UIs <br> `CSS` `JS` ~ [@jdan](https://github.com/jdan)                                                                                                                                                                                                                                                                                                                                       | [here](https://jdan.github.io/98.css/)                                  |
| 42.  | [BOOTSTRA.386](https://github.com/kristopolous/BOOTSTRA.386)                 | A vintage 1980s DOS inspired Twitter Bootstrap theme <br> `HTML` `Less` `CSS` `JS` ~ [@kristopolous](https://github.com/kristopolous)                                                                                                                                                                                                                                                                                                                 | [here](http://kristopolous.github.io/BOOTSTRA.386/demo.html)            |
| 43.  | [os-gui](https://github.com/1j01/os-gui)                                     | Retro Operating System GUI JS library <br> `CSS` `JS` ~ [@1j01](https://github.com/1j01)                                                                                                                                                                                                                                                                                                                                                                            | [here](https://1j01.github.io/os-gui/demo/)                             |
| 44. |retro-fonts| All old school fonts ever to be found on the Web 1.O Internet|[here](https://int10h.org/oldschool-pc-fonts/fontlist/)|
| 45. |Screenshot OS | Collection of Screenshots, timelines, icons, sound, etc of all legacy Operating Systems, ever to exist. |[here](https://guidebookgallery.org/guis/windows/ )|
| 46.  | [vue-window](https://github.com/michitaro/vue-window)              | This package is an implementation of window UI for PC environment as a Vue Component. <br>  `TS` `Vue` `HTML` `JS` ~ [@michitaro](https://github.com/michitaro)                      | [here](https://michitaro.github.io/vue-window/?Sample31)                      |
| 47.  | [fake-ie](https://github.com/partiellkorrekt/fake-ie)              | Simulate an old version of Internet Explorer on iOS <br>  `TS` `java` `objective-C` `Starlark` `ruby` `JS` ~ [@partiellkorrekt](https://github.com/partiellkorrekt)                      | [here](https://theoldnet.com)                      |
| 48.  | [bubbles](https://github.com/khang-nd/bubbles)              | A recreation of Windows Bubbles screensaver. <br>   `HTML` `JS` ~ [@khang-nd](https://github.com/khang-nd)                      | [here](https://khang-nd.github.io/bubbles/)                      |
| 49.  | [Chicago95](https://github.com/grassmunk/Chicago95)              | A rendition of everyone's favorite 1995 Microsoft operating system for Linux. <br>  `CSS` `python` `HTML` `JS` ~ [@grassmunk](https://github.com/grassmunk)                      | [download](https://github.com/grassmunk/Chicago95/releases)                      |
| 50.  | [ui95](https://github.com/AshKyd/ui95)              | 🖥 WIP: A preact implementation of Windows-95/98/ME style components and apps<br> `CSS` `HTML` `JS` ~ [@AshKyd](https://github.com/AshKyd)                      | [here](https://ash.ms)                      |
| 51.  | Nightwave Plaza             | Nightwave Plaza is a free 24/7 online 'Classic Windows' inspired vaporwave radio station. The broadcast also includes some future funk and experimental genres. We hope you enjoy.                      | [here](https://plaza.one)                      |
| 52.  | geek-prank             | Online Windows-XP simulator that runs in your web browser. Activate full screen and play Minesweeper, Tetris and listen to some music in Winamp. Also prank your friends by loading this site.  | [here](https://pranx.com/windows-xp-simulator/)                      |
| 53.  | [afterstep](https://github.com/afterstep/afterstep/)              | AfterStep is a window manager for the Unix-X Window System. Originally based on the look and feel of the NeXTStep interface.    <br>   `C` `Shell` `C++` ~ [@afterstep](https://github.com/afterstep)                        | [here](http://www.afterstep.org/index.php)                      |
| 54.  |[wmaker](https://github.com/window-maker/wmaker)              | Window Maker is an X11 window manager originally designed to provide integration support for the GNUstep Desktop Environment <br>  `C` `Perl`  ~ [@window-maker](https://github.com/window-maker)                      | [here](http://www.windowmaker.org)                      |
| 55.  | eat-sleep-work              | A windows styled EatSleepWork.com is your brand partner to be bold, be different and be interesting. We cultivate relationships and together we can change design.                      | [here](https://www.eatsleepwork.com)                      |
| 56.  | win98-icons          | Windows-98 Icons viewer                      | [here](https://win98icons.alexmeub.com)                      |
| 57.  | win95              | Windows-95 replica with a cat! Visit decades old webpage of popular sites like Apple and Google.              | [here](https://derplayer.neocities.org/repo/win/#)                      |
| 58.  | [The Indie Web](https://github.com/tholman/the-indie-web)       |  A Windows GUI inspired blogging site.      <br>   `CSS` `HTML` `JS` ~ [@tholman](https://github.com/tholman)               | [here](https://theindieweb.com)                      |
| 59.  | [90's Cursor Effects](https://github.com/tholman/cursor-effects)              | Only 90's kids remember... well not really, but these beloved effects that would follow your mouse around will always be classic reminders of the old, beloved internet. <br>   `JS` ~ [@tholman](https://github.com/tholman)                      | [here](https://tholman.com/cursor-effects/)                      |
| 60.  | Windows 1.0            | Here you can find everything there is to know about the 1ST VERSION of W I N D O W S.   <br>  `PHP`               | [here](https://win1.krnl386.com)                      |
| 61.  | Make Wordart              | From its initial release on Microsoft Windows-95, WordArt has helped jazz up millions of book reports, signs, logos, and presentations. It was widely available and user-friendly, which lead to its use and abuse throughout the 90's and early 2000's.                      | [here](https://www.makewordart.com)                      |
| 62.  | [Vuindows](https://github.com/marcmascarell/Vuindows)              | A tribute to Windows-10 made with Vue.js <br>  `Vue` `HTML` `JS` ~ [@marcmascarell](https://github.com/marcmascarell)                      | [here](https://marcmascarell.github.io/Vuindows/)                      |
| 63.  | AWGE Forum              | A Windows-98 inspired web forum        | [here](https://forums.awgeshit.com/register)                      |
| 64.  | tetrageddon              | A chaotic version of Windows GUI, warning- lots of popups.                       | [here](http://tetrageddon.com)                      |
| 65.  | Windows 96             | Windows-96 is a Win9x-esque Web OS loaded with a bunch of programs and other fun stuff for you to use.             | [here](https://windows96.net)                      |
| 66.  | [dinhquangtrung.net](https://github.com/trungdq88/dinhquangtrung.net)              | An "Online Windows-7” that you can use everywhere! <br> `CSS` `HTML` `JS` ~ [@trungdq88](https://github.com/trungdq88)                      | [here](https://dinhquangtrung.net/windows7/)                      |

 
  **[`^top^`](#)**


 <hr>
 
 
 
 
 
##  MACINTOSH


| N. | Identifier    | Description            | Live Demo/Docs          |
| ---- | :------------------ | :------------------ | :-------- |
| 01.  | [macOS-web](https://github.com/PuruVJ/macos-web)              | This open source project aims to replicate some of the Mac OS(Monterey, at the time of writing)'s desktop experience on web, using Svelte. <br> `Svelte` `Vite` `TS` `Vercel` `SCSS` `HTML` `CSS` `JS` ~ [@PuruVJ](https://github.com/PuruVJ)                      | [here](https://macos.vercel.app)                      |
| 02.  | [macOS-preact](https://github.com/puruvj/macos-preact)          | (Legacy)This open source project aims to replicate some of the Mac OS(Moneterey, at the time)'s desktop experience on web, using standard web technologies like <br> `Preact` `Vite` `TS` `Vercel` `SCSS` `HTML` `CSS` `JS` ~ [@PuruVJ](https://github.com/PuruVJ) | [here](https://macos-preact.vercel.app)               |
| 03.  | [playground-macOS](https://github.com/Renovamen/playground-macos)     |A Portfolio website simulating macOS's GUI, developed with React and Tailwind CSS. <br> ` React` `Redux` `Tailwind CSS` `TS` `HTML` `JS` ~ [@Renovamen](https://github.com/Renovamen)                                                                                | [here](https://portfolio.zxh.io)                      |
| 04.  | [giantSur](https://github.com/soroushchehresa/giant-sur)     | 🍏 macOS Big Sur UI clone for the web built with React, Next.js, TypeScript, and Tailwind CSS <br> ` React` `Nextjs` `Tailwind CSS` `TS` `Docker` `Jest` `Enzyme` `JS` ~ [@soroushchehresa](https://github.com/soroushchehresa)                                                                                | [here](https://giantsur.netlify.app)                      |
| 04.  | [finder-clone](https://github.com/guyariely/finder-clone) | A (bare bone!) clone of the macOS "Finder" app (the macOS equivalent of Windows "File Explorer"). Built with React and Sass <br> `React` `SCSS` `Netlify` `HTML` `CSS` `JS` ~ [@guyariely](https://github.com/guyariely)                                           | [here](https://finder-clone.netlify.app)              |
| 05.  | [react-desktop](https://github.com/gabrielbull/react-desktop)      | React UI Components for macOS High Sierra and Windows 10 <br> `React` `JS` ~ [@gabrielbull](https://github.com/GabrielBull)                                                                                                                                        | [here](http://reactdesktop.js.org)                    |
| 06.  | [pce](https://github.com/jsdf/pce)                      | Emulates Mac Plus, IBM PC, & Atari ST in the browser using WebAssembly <br> `C` `Makefile` `Assembly` `JS` ~ [@jsdf](https://github.com/jsdf)                                                                                                                      | [here](http://jamesfriend.com.au/pce-js/pce-js-apps/) |
| 07. |  [xOS_webtop](https://en.wikipedia.org/wiki/XOS_Webtop ) | A web based macOS inspired OS mockup |   [here](https://en.wikipedia.org/wiki/XOS_Webtop ) |
| 08.  | MacPaint             | Macpaint.org serves as a historical gallery and contemporary directory of artwork produced using Macpaint.                      | [here](http://www.macpaint.org/blog/)                      |
| 09.  | burgersoft             | good old macintosh                 | [here](https://web.archive.org/web/20200804174451/https://www.burgersoft.co/)                      |
| 10.  | Unremarkable Garden              | Old Artists macintosh                     | [here](https://unremarkablegarden.com)                      |
| 11.  | Public Domain              | Random public domain videos in macOS instances.                    | [here](https://public---domain.com)                      |
| 12.  | [Joeyonng](https://github.com/Joeyonng/joeyonng-backyard)              | Joeyonng's backyard (personal website) built to mimic the macOS Big Sur desktop <br>  `SCSS` `HTML` `JS` ~ [@Joeyonng](https://github.com/Joeyonng)                      | [here](https://joeyonng.github.io)                      |


 

 **[`^top^`](#)**

 
 <hr>
 
 
 
## <img src="media/linux.png" alt="logo" width="36"/>  LINUX 
 
| Nos. | Identifier     | Description         | Live Demo/Docs          |
| ---- | :-------- | :----------------- | :------------------ |
| 01.  | [Ubuntu 20.04](https://github.com/vivek9patel/vivek9patel.github.io) | Personal portfolio website of theme Ubuntu 20.04, made using React.js & tailwind CSS <br> `React` `Tailwind CSS` `JS` ~ [@Vivek9Patel](https://github.com/vivek9patel) | [here](https://vivek9patel.github.io) |
| 02.  | [linuxWeb](https://github.com/Manthee1/linuxWeb)              | A somewhat simulated linux environment inside your browser <br>  `Sass` `Pug` `HTML` `JS` ~ [@Manthee1](https://github.com/Manthee1)                      | [here](https://manthee1.github.io/linuxWeb/dist/)                      |
| 03.  | [GoodManWEN](https://github.com/GoodManWEN/GoodManWEN.github.io)              | 📕 A website simulating linux system's GUI, using theme of Deepin distro <br>  `Python` `Vue` `HTML` `JS` ~ [@GoodManWEN](https://github.com/GoodManWEN)                      | [here](https://goodmanwen.github.io/#/login)                      |

     

 **[`^top^`](#)**



 <hr>
 
 
 ## 💾 INDIE-OS
 
 
| N. | Identifier        | Description    | Live Demo/Docs   |
| ---- | :---------- | :----------------------- | :------------- |
| 01.  | [zine](https://github.com/STRd6/zine)                                | DIY E-Zine and Operating System <br> `HTML5` `CSS` `CoffeeScript` ~ [@STRd6](https://github.com/STRd6)                                                                                                                                     | [here](https://whimsy.space)                                          |
| 02.  | [OS.JS](https://github.com/os-js/OS.js)                                 | OS.js is an open-source web desktop platform with a window manager, application APIs, GUI toolkit, filesystem abstractions and much more. <br> `Shell` `Dockerfile` `ejs` `CSS` `JS` ~ [@os-js](https://github.com/os-js)                  | [here](https://demo.os-js.org)                                        |
| 03.  | [FriendUPCloud](https://github.com/FriendUPCloud)        | Friend OS is the Internet Operating System for any device, running on posix compatible hosts. Also known as the Friend Unifying Platform. <br> `C` `Perl` `PHP` `JS` ~ [@FriendUPCloud](https://github.com/FriendUPCloud)                  | [here, signin required](https://friendsky.cloud/webclient/index.html) |
| 04.  | [AaronOS](https://github.com/MineAndCraft12/AaronOS)                   | This is a public repository of AaronOS, so that the public can more easily suggest contributions, and so I can be more transparent in the development of aOS. <br> `PHP` `CSS` `JS` ~ [@MineAndCraft12](https://github.com/MineAndCraft12) | [here](https://aaronos.dev/AaronOS/aosBeta.php)                       |
| 05.  | [web-Desktop-environment](https://github.com/shmuelhizmi/web-desktop-environment) | A web-based cross-platform desktop environment <br> `React` `NodeJs` `TS` `JS` ~ [@shmuelhizmi](https://github.com/shmuelhizmi)                                                                                                            | [here](http://http.web-desktop.run)                                   |
| 06.  | [jQuery-Desktop](https://github.com/nathansmith/jQuery-Desktop)      | JavaScript desktop environment built with jQuery + HTML5. <br> `HTML` `jQuery` `CSS` `JS` ~ [@nathansmith](https://github.com/nathansmith)                                                                                                 | [here](https://desktop.sonspring.com)                                 |
| 07.  | [serenity](https://github.com/SerenityOS/serenity)              | SerenityOS is a love letter to '90s user interfaces with a custom Unix-like core. It flatters with sincerity by stealing beautiful ideas from various other systems <br>  `C++` `C`  `shell` `CMake` `HTML` `JS` ~ [@SerenityOS](https://github.com/SerenityOS)                      | [here](https://serenityos.org)                      |
| 08.  | [curve-contract](https://github.com/curvefi/curve-contract)              | Vyper contracts used in Curve.fi exchange pools. <br>  `python` `solidity` ~ [@curvefi](https://github.com/curvefi)                      | [here](https://curve.fi)                      |
| 09.  | [KodExplorer](https://github.com/kalcaddle/KodExplorer)              |  A web based file manager, web IDE / browser based code editor! <br>  `PHP` `CSS` `HTML` `JS` ~ [@kalcaddle](https://github.com/kalcaddle)                      | [here](http://demo.kodcloud.com/#desktop)                      |
| 10.  | virusAV              | VirusAV OS - An indie OS written by Keito | [here](https://os.virusav.com)                      |
| 11.  | The Poolsuite            |FM, mixtapes, vacation, store in an indie web-desktop format                      | [here](https://poolsuite.net)                      |
| 12.  | DSM            | A feature-rich and intuitive NAS operating system | [here](https://a41.dsm7demo.synology.com:5001)                      |
| 13.  | [itisasifyouweredoingwork](https://github.com/pippinbarr/itisasifyouweredoingwork)              | Play It is as if you were doing work in your browser (mostly likely mobile-unfriendly, sorry (login with any credential)) <br>   `CSS` `HTML` `JS` ~ [@pippinbarr](https://github.com/pippinbarr)                      | [here](https://pippinbarr.github.io/itisasifyouweredoingwork/)                      |
| 14.  | frankenSim             | Tools for Postmodern Prometheus, a web toy                      | [here](http://frankensim.animade.tv)                      |
| 15.  | Chiptune              | God knows what is this <br>  `dHTML` `JS`                      | [here](http://www.chiptune.com)                      |
| 16.  | [jurassicsystems.com](https://github.com/tojrobinson/jurassicsystems.com)              | HTML5/JavaScript recreation of the original Jurassic Park movie computer system <br>   `CSS` `HTML` `JS` ~ [@tojrobinson](https://github.com/tojrobinson)                      | [here](https://jurassicsystems.com)                      |
| 17.  | [tildeOS](https://github.com/selfsame)              | html files open in iframes, in old internet OS look                    | [here](https://tilde.town/~selfsame/)                      |
| 18.  | CloudDesk              | CloudDesk is an online desktop made for multi-tasking, with multiple useful tools. It has the modern look of the Google UI, and the power of the latest codes used for web development.                      | [here](http://altaica.altervista.org)                      |
| 19.  | [fos](https://github.com/victorqribeiro/fos)              | Web Components to turn your web app into a fake operating system <br>   `Shell` `JS` ~ [@victorqribeiro](https://github.com/victorqribeiro)                      | [here](https://victorribeiro.com)                      |
| 20.  | Nirrius Creative Studio             | A web-desktop inspired studio with a collection of passionate humans that build great products and unforgettable experiences.                     | [here](https://nirri.us)                      |
| 21.  | NyjaOS          | This is a non-linear science fiction story told through a desktop environment. Click around. Read documents. Piece together events as you go along.                   | [here](https://signal3.neocities.org)                      |
| 22.  | [W_Dev](https://gitlab.com/WuerfelDev)              | this webpage is highly inspired by Ubuntu (12.04 & 18.04) and Ubuntu Touch on mobile. The site looks alike my desktop which features the adapta theme (and the paper icon pack). The icons I used here are google's material icons.                       | [here](https://wuerfeldev.de/desktop)                      |
| 23.  | hacker-simulator              | With this website we want to raise awareness for online security and to promote ethical hacking. Always protect your system following the guidelines recommended for a safe Internet.                | [here](https://hacker-simulator.com/)                      |
| 24.  | CutOut Fest              | SOMOS LA CELEBRACIÓN MÁS IMPORTANTE DEL PAÍS EN TORNO A LA ANIMACIÓN Y EL ARTE DIGITAL                     | [here](https://cutoutfest.com/acerca-de/)                      |
| 25.  | webdesktop       | WebDesktop is a Startpage for web Browsers in a funny fake Operating System interface. Designed by WebSyrup.net                   | [here](https://web.archive.org/web/20190120054952/https://webdesktop.net/)                      |
| 26.  | andgallery.art             | Windows 95 inspired & GALLERY’S MISSION IS TO SUPPORT LOCAL ARTISTS           | [here](https://web.archive.org/web/20200917000023/https://andgallery.art/)                      |
| 27.  | Hyena Network            | Welcome to Hyena Network. Feel free to look around. As you may have seen, they appear to look like windows... I suggest playing around with them! Since they behave much like normal windows do!          | [here](https://hyena.network/geocity/)                      |
| 28.  | [my-second-pc](https://github.com/koas/my-second-pc)              | A website that emulates a desktop environment, written in vanilla JS in 2006. This was created as a demo for the KWS library. <br>  `JS` ~ [@koas](https://github.com/koas)                      | [here](https://koas.dev/m2pc/dinamicos/)                      |
| 29.  | [daedalOS](https://github.com/DustinBrett/daedalOS)              | Desktop environment in the browser. <br>  `TS` `JS` ~ [@DustinBrett](https://github.com/DustinBrett)                      | [here](https://dustinbrett.com)                      |
| 30.  | team3d              | A deFi website inspired by OS, ethereum hosted.                    | [here](https://team3d.io)                      |
| 31.  | We=Link: Sideways            | A Chronus Art Center (CAC) exhibition inspired by Windows 95                   | [here](http://we-link.chronusartcenter.org)                      |
| 32.  | [thoughtsonglitchart](https://github.com/nbriz/thoughtsonglitchart)              | hypermedia essay on the subject of glitch  art.  Interactive video and other parts of website as video progresses.  <br>  `CSS` `HTML` `JS` ~ [@nbriz](https://github.com/nbriz)                      | [here](http://nickbriz.com/thoughtsonglitchart/)                      |
| 33.  | Big Desk Energy            |   Big Desk Energy is whatever you make of it, so boot your laptop, turn up volume, and stay a while.                 | [here](https://www.bigdeskenergy.com)                      |
| 34.  | [github95](https://github.com/edwardpayton/github95)              | Your Github  profile. With a Windows 95  style. Built with React 🚀 <br>  `CSS` `HTML` `JS` ~ [@edwardpayton](https://github.com/edwardpayton)                      | [here](https://github95.vercel.app)                      |
| 35.  | [Fizzygum](https://github.com/davidedc/Fizzygum)              | A new web framework, an entire platform really, designed from the ground up to handle complex things easily. Put the power of an entire Operating System at your fingertips. <br>  `CoffeeScript` `JS` ~ [@davidedc](https://github.com/davidedc)                      | [here](http://fizzygum.org/sandboxes/latest-stable/)                      |




 **[`^top^`](#)**
 
 
 <hr>
 
 
 
 ## 💾 PORTFOLIO/PERSONAL-OS
 
 
| N. | Identifier        | Description    | Live Demo/Docs   |
| ---- | :---------- | :----------------------- | :------------- |
| 01.  | [Yahya J. Aifit](https://github.com/aifit)              |  An indie OS format of personal website   <br>  `Vue`        | [here](https://yja.me)    |               
| 02.  | [Dan Yalg](https://github.com/Yalgie/website)              | A fun indie OS format of portfolio website <br>  `CSS` `HTML` `JS` ~ [@Yalgie](https://github.com/Yalgie)                      | [here](https://thecodingforge.com.au)                      |
| 03.  | Try Andy's Desk              | A Windows 7 inspired personal website                      | [here](https://desk.glitchy.website)                      |
| 04.  | rexOS              |      An indie OS personal website, loves dogs and has virus.exe oh and can play snake.exe too!            | [here](https://itzrex.neocities.org)                      |
| 05.  | GopalOS              | A personal OS by Gopal Othayoth of CerebralDatabank™️, can install packages and apps. | [here](https://cerebraldatabank.neocities.org/gopalos.html)                      |
| 06.  | [Timothy Howard](https://github.com/timhow38/Resume-WebApplication)              | Yet another indie OS portfolio website  <br>  `CSS` `HTML` `JS` ~ [@timhow38](https://github.com/timhow38)                      | [here](https://coreos.io)                      |
| 07.  | [Heather Vandervecht](https://github.com/heathervv/portfolio-chatbot)              | A Windows 95-esque desktop experience portfolio site with a chat app being the main highlight. <br>  `React` `CSS` `HTML` `JS` ~ [@heathervv](https://github.com/heathervv)                      | [here](https://heathervv.com)                      |
| 08.  | [Jack Adam](https://github.com/jckdm/jckdm.github.io)              | A Portfolio site that re-creates an old computer interface. <br>  `CSS` `HTML` `JS` ~ [@jckdm](https://github.com/jckdm)          | [here](https://jackadam.cc)                      |
| 09.  | [Derya Antonelli](https://github.com/D-Antonelli/portfolio)              | This is a retro-inspired personal OS, responsive website with client-side applications. <br>  `SCSS` `HTML` `JS` ~ [@D-Antonelli](https://github.com/D-Antonelli)                      | [here](https://www.deryasdesktop.com)                      |
| 10.  | raccOS 9      |   Violet Procyon  -  An old  macOS format of personal website of a 3d artist. | [here](https://violet.pm)                      |
| 11.  | scumweb              |       An indie OS format of personal website - flexedupshawty       | [here](https://flexedupshawty.com)                      |
| 12.  | [Austin Riba.](https://github.com/Fingel)              |      An indie OS format of personal website, terminal navigation.       | [here](http://toxiccode.com)                      |
| 13.  | [Gustavo Chico](https://github.com/JGustavoChico)              |      An indie OS format of personal website           | [here](https://gustavochico.com/desktop/#)                      |
| 14.  | Pyramis              | An artists OS                  | [here](https://digital-r41n.neocities.org)                      |
| 15.  | Racer Trash              | An indie OS format of personal website            | [here](https://racertrash.com/work/#video=gang+gang+gang+gang.mp4)                      |
| 16.  | ytcracker            | An indie OS format of personal website                 | [here](https://ytcracker.com/v2020/)                      |
| 17.  | Glass Animals OPEN SOURCE      | A messy Indie OS with a decent functionality and fascination.                      | [here](https://opensource.glassanimals.com)                      |
| 18.  | Erd Yakingun              | erdOS powered portfolio website  <br>  `TS` `Nuxt.js` `HTML` `JS`| [here](https://erd-os.iamerd.xyz)                      |
| 19.  | [Patrick Kage](https://github.com/pkage/pkage.github.io)              | A Windows98 inspired portfolio website <br>  `CSS`  `HTML` `JS` ~ [@pkage](https://github.com/pkage)                      | [here](https://ka.ge)                      |
| 20.  | Hillary Churchill           | A macOS inspired portfolio website                     | [here](http://hillarychurchill.com)                      |
| 21.  | Gamithra Marga             | A macOS inspired personal website ~ [@Gamithra](https://github.com/Gamithra)                      | [here](https://gamithra.com)                      |
| 22.  | Maple Mavic Syrup             |An indie OS inspired personal website                      | [here](https://maple.pet)                      |
| 23.  | basile             |A yet another windows inspired personal website                      | [here](https://niceware.neocities.org)                      |
| 24.  | Digital gallery X Kuba              | A Windows inspired digital gallery personal website by Kuba                   | [here](https://n10.as)                      |
| 25.  | Matthew P Munger              | A macOS inspired portfolio website  - mattOS                   | [here](https://mattos-1.webflow.io)                      |
| 26.  | Isaac Waller             | A win98 inspired personal website.    | [here](https://waller.is)                      |
| 27.  | Zach Caceres             | This is a personal portfolio, inspired by the question: "What would the opposite of the two-color template developer blog look like?" ~ [@ zcaceres](https://github.com/zcaceres)                      | [here](https://zach.dev)                      |
| 28.  | kim-os             | Jack Kim’s OS based resume                     | [here](https://www.jackk.im)                      |
| 29.  | Mariano Pascual       | Mariano Pascual v.88 is an macOS format resume. | [here](http://www.marianopascual.me/)                      |
| 30.  | [melkael.github.io](https://github.com/melkael/melkael.github.io)              | A Windows-7 based resume <br>  `CSS`  `HTML` `JS` ~ [@melkael](https://github.com/melkael)                      | [here](https://elkael.com)                      |
| 31.  | [websiterevision2017](https://github.com/paultopia/websiterevision2017)              | This is just a total overkill revision of my personal/professional website <br>  `TeX` `Vue` `Jupyter Notebook` `HTML` `JS` ~ [@paultopia](https://github.com/paultopia/)                      | [here](https://gowder.io)                      |
| 32.  | [homepage](https://github.com/v-y-l/Homepage)              | A personal website <br>  `TS` `CSS` `HTML` `JS` ~ [@v-y-l](https://github.com/v-y-l)                      | [here](https://www.vyl.app)                      |
| 33.  | [syxanash.github.io](https://github.com/syxanash/syxanash.github.io)              | A windows retro personal website <br>   `CSS` `HTML` `JS` ~ [@syxanash](https://github.com/syxanash)                      | [here](https://simone.computer/#/)                      |
| 34.  | [windows7](https://github.com/khang-nd/windows7)              |Windows-7 Simulation is a small project to simulate the user interface and functionalities of Windows-7 using pure web components and libraries. It supports both desktop and mobile devices. <br>  `SCSS` `JS` ~ [@khang-nd](https://github.com/khang-nd)                      | [here](https://khang-nd.github.io/windows7/)                      |
| 35.  | Erik Bernacchi          | The preposterous web portal of erik bernacchi. A portfolio site.                       | [here](http://eeerik.com)                      |
| 36.  | [expensive.toys](https://github.com/arturbien/React95)              | I'm probably the coolest guy you will ever meet. We can't be friends but I can make you a website! # (516) 326-201 <br>   `JS` ~ [@arturbien](https://github.com/arturbien)                      | [here](https://www.expensive.toys)                      |
| 37.  | Éric Lévénez's              | Éric Lévénez's site                  | [here](https://www.levenez.com)                      |
| 38.  | [Tholman](https://github.com/tholman/tholman)              | THE CURIOUS CREATIONS OF TIM HOLMAN. A cool collection of awesome projects.  <br>  `Ruby` `CSS` `HTML` `JS` ~ [@tholman](https://github.com/tholman)                      | [here](https://tholman.com)                      |
| 39.  | [Hannah Blair](https://github.com/hannahblair)              | A Windows-95 inspired portfolio website                   | [here](https://hannahblair.co.uk)                      |
| 40.  | [Aimen Rafique–Marsh  ◠‿◠ ✿](https:fdfdfdfdf)              | Some kind of cool blog. Duh                     | [here](https://blog.aimen.me)                      |
| 41.  | Britney OS’99  | An OS-based website to vote Britney in a past US elections.                    | [here](https://web.archive.org/web/20210105054008/http://itsbritneybot.com/)                      |

 
 **[`^top^`](#)**
 
 
 <hr>
 
 
  
##  GOOD-OLD-OSs
 
| N. | Identifier      | Description       | Live Demo/Docs         |
| ---- | :----------- | :------------- | :------------- |
| 01.  | [commodore-64-desktop](https://github.com/ssshake/commodore-64-desktop)              | A desktop for the Commodore 64(one of the first operating system to exist) <br>  `.NET` `batchfile`  ~ [@ssshake](https://github.com/ssshake)                      |  -        |
| 02.  | [microweb](https://github.com/jhhoward/MicroWeb)              | DOS Web browser for 8088 class machines <br>  `C++` `C` `Pascal` ~ [@jhhoward](https://github.com/jhhoward)                      | [here](https://github.com/jhhoward/MicroWeb/releases)                      |
| 03.  | old internet             | The Old Net is an attempt to restore vintage web browsing on vintage computers. It uses the Internet Archive: Wayback Machine API and a proxy that strips out any  incompatible javascript and stitches together as many links as it can.                  | [here](https://theoldnet.com)                      |
| 04.  | [the-restart-page](https://github.com/michitaro/vue-menu)              | The Classic Restart Page - Free unlimited rebooting experience from vintage operating systems                 | [here](http://www.therestartpage.com/#)                      |
| 05.  | [nextsite](https://github.com/juddy/nextsite)              | Simple HTML/CSS site mimicing some key NeXT OS(founded by Steve Jobs after he was fired from Apple) Workspace elements: <br>   `CSS` `HTML` `JS` ~ [@juddy](https://github.com/juddy)                      | [here](https://prik-k.github.io/nextsite/)     |
| 06.  | atari-st             | Welcome to the largest Atari ST Resource on the Internet             | [here](http://www.atari.st/index.php)                      |
| 07.  | WorldWideWeb              | This is the first version of the NextStep WorldWideWeb application with the libWWW library. An excercise in global information availability                      | [here](https://worldwideweb.cern.ch/browser/)                      |
| 08.  | Cyberspace & Time            | A classic internet web portal to time travel.                        | [here](http://cyberspaceandtime.com/ZgfM9bq2bOI.video+related)                      |
| 09.  | WWWTXT	       | WWWTXT digs deep and resurrects the voices of these digital pioneers as unedited, compelling, and insightful 140-character excerpts.                      | [here](https://wwwtxt.org/about)                      |
| 10.  | Bill's World Wide Boutique           | SURF THE WEB LIKE IT'S 1999!  I'm trapped in 1999 on GeoCities! I've made this time portal so you future people can visit my site.                   | [here](https://billsworld.neocities.org/index.html?)                      |
| 11.  | Repeater 2           | repeater.space is an experimental pattern drawing tool. It allows users to easily draw patterns, in a naïve 8-bit-ish style. <br>   `Vue` ~ [@Adi Ron](https://adiron.me)                      | [here](https://repeater.space)                      |
| 12.  | 56k-modem           |     56k-modem.online Discord server.  Someone said it’s like chat rooms from the 1990s so I just had to set one up.           | [here](https://56k-modem.online)                      |
| 13.  | AConfusedDragon              | The classic GIFs of past decade.             | [here](https://aconfuseddragon.neocities.org/index.html)                      |



 **[`^top^`](#)**
 
 
 <hr>
 
 
##  OTHER-SOURCES
 
| N. | Identifier      | Description       | Link         |
| ---- | :----------- | :------------- | :------------- |
| 01.  | [vim.js](https://github.com/coolwanglu/vim.js) | JavaScript port of VIM <br> `C` `VimScript` `MakeFile` ` Prolog` `C++` `PS` ~ [@coolwanglu](https://github.com/coolwanglu) | [here](http://coolwanglu.github.io/vim.js/emterpreter/vim.html) |
| 02.  | [awesome-web-desktops](https://github.com/syxanash/awesome-web-desktops)              | Websites, web apps, portfolios which look like desktop graphical user interfaces <br>  `markdown` ~ [@syxanash](https://github.com/syxanash)                      | [here](https://simone.computer/#/webdesktops)                      |
| 03.  | [ssshake](https://github.com/ssshake/retro-computing-internet-resources)              | A list of the various projects to get vintage computers connected to the internet <br>  `markdown` ~ [@ssshake](https://github.com/ssshake)                      | -                      |
| 04.  | [awesome-UNIX](https://github.com/sirredbeard/Awesome-UNIX)              | All the UNIX and UNIX-Like: Linux, BSD, macOS, Illumos, 9front resources and more. <br>  `markdown` ~ [@sirredbeard](https://github.com/sirredbeard)                      | -                      |


 
 **[`^top^`](#)**
 
 <hr>
 
 
 
 
## 🌍 BROWSERS

| Logo                                                                                                                                                                                    | Company               | Name              | Rendering Engine |
| :---:                                                                                                                                                                                   | :---                  | :---              | :---             |
| <img loading="lazy" width="24" height="24" src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/archive/internet-explorer_9-11/internet-explorer_9-11.svg" alt="Internet Explorer" /> | Microsoft             | [Internet Explorer](https://www.microsoft.com/en-in/download/internet-explorer.aspx) | [Trident](https://en.wikipedia.org/wiki/Trident_(software))          
| <img loading="lazy" width="24" height="24" src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/archive/edge_12-18/edge_12-18.svg" alt="Edge" />                                      | Microsoft             | Edge (old)             | [EdgeHTML](https://en.wikipedia.org/wiki/EdgeHTML)         | 
| <img loading="lazy" width="24" height="24" src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/edge/edge.svg" alt="Edge" />                                                          | Microsoft             | [Edge](https://microsoftedgewelcome.microsoft.com/en-gb?form=MA13DW)              | [Blink](https://en.wikipedia.org/wiki/Blink_(browser_engine))            | 
| <img loading="lazy" width="24" height="24" src="https://raw.githubusercontent.com/alrra/browser-logos/main/src/archive/firefox_3.5-22/firefox_3.5-22.png" alt="Firefox" />                           | Mozilla               | Firefox (old)      | [Gecko](https://en.wikipedia.org/wiki/Gecko_(software))            | 
| <img loading="lazy" width="24" height="24" src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/firefox/firefox.svg" alt="Firefox" />                                                 | Mozilla               | [Firefox](https://www.mozilla.org/en-US/firefox/new/)           | [Quantum Gecko](https://wiki.mozilla.org/Quantum)    |
| <img loading="lazy" width="24" height="24" src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/archive/chrome_1-11/chrome_1-11.svg" alt="Chrome" />                                  | Google                | Chrome (old)           | [WebKit](https://en.wikipedia.org/wiki/WebKit)           |
| <img loading="lazy" width="24" height="24" src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/chrome/chrome.svg" alt="Chrome" />                                                    | Google                | [Chrome](https://www.google.com/intl/en/chrome/)            | Blink            | 
| <img loading="lazy" width="24" height="24" src="https://www.chromium.org/_/rsrc/1438879449147/config/customLogo.gif?revision=3" alt="Chromium" />                                                    | Google                | [Chromium](https://www.chromium.org)            | Blink            | 
| <img loading="lazy" width="24" height="24" src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/archive/opera_15-32/opera_15-32.png" alt="Opera" />                                   | Opera Software        | Opera (old)            | [Presto](https://en.wikipedia.org/wiki/Presto_(browser_engine))           | 
| <img loading="lazy" width="24" height="24" src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/opera/opera.svg" alt="Opera" />                                                       | Opera Software        | [Opera](https://www.opera.com)             | Blink            | 
| <img loading="lazy" width="24" height="24" src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/safari/safari.png" alt="Safari" />                                                    | Apple                 | [Safari](https://www.apple.com/in/safari/)            | WebKit           | 
| <img loading="lazy" width="24" height="24" src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/brave/brave.svg" alt="Brave" />                                                       | Brave Software        | [Brave](https://brave.com)             | Blink            | 
| <img loading="lazy" width="24" height="24" src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/vivaldi/vivaldi.svg" alt="Vivaldi" />                                                 | Vivaldi Technologies  | [Vivaldi](https://vivaldi.com)           | Blink            | 
| <img loading="lazy" width="24" height="24" src="https://www.torproject.org/static/images/tor-logo@2x.png?h=16ad42bc" alt="Tor" />  |    Open-Source       | [Tor](https://www.torproject.org)            | [Quantum Gecko](https://wiki.mozilla.org/Quantum)             | 
| <img loading="lazy" width="24" height="24" src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/pale-moon/pale-moon.png" alt="Pale Moon" />                                           | Moonchild Productions | [Pale Moon](https://www.palemoon.org)         | [Goanna](https://en.wikipedia.org/wiki/Goanna_%28software%29)           | 
| <img loading="lazy" width="24" height="24" src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/basilisk/basilisk.svg" alt="Basilisk" />                                              | Moonchild Productions | [Basilisk](https://basilisk-browser.org)          | Goanna           | 


 **[`^top^`](#)**
  
  
 <hr>
  
 
## ✨ &nbsp;BUILT WITH:
 - [React](https://reactjs.org)
 - [Preact](https://preactjs.com)
 - [ViteJs](https://vitejs.dev)
 - [Electron](https://www.electronjs.org)
 - [NodeJS](https://nodejs.org/en/)
 - [Svelte](https://svelte.dev)
 - [Netlify](https://www.netlify.com)
 - [Vercel](https://vercel.com)
 - [Docker](https://www.docker.com)
 - [JS](https://www.w3schools.com/js/js_intro.asp)
 - [TS](https://www.typescriptlang.org)
 - [PostScript](https://riptutorial.com/postscript)
 - [coffeescript](https://coffeescript.org)
 - [vimscript](http://vimscript.org)
 - [C](https://www.tutorialspoint.com/cprogramming/c_overview.htm)
 - [C++](https://www.w3schools.com/cpp/default.asp)
 - [Objective-C](https://www.tutorialspoint.com/objective_c/index.htm)
 - [Java](https://www.java.com/en/)
 - [PHP](https://www.php.net)
 - [Python](https://www.python.org)
 - [EJS](https://ejs.co)
 - [Assembly](https://www.w3schools.in/assembly-language/)
 - [Makefile](https://makefiletutorial.com)
 - [Dockerfile](https://www.javatpoint.com/docker-dockerfile)
 - [Shell](https://www.tutorialspoint.com/unix/shell_scripting.htm)
 - [sed](https://www.tutorialspoint.com/sed/index.htm)
 - [Prolog](https://www.tutorialspoint.com/prolog/index.htm)
 - [Tailwind CSS](https://tailwindcss.com)
 - [SCSS](https://sass-lang.com)
 - [{less}](https://lesscss.org)
 - [CSS](https://www.w3schools.com/css/)
 - [emotion](https://emotion.sh/docs/introduction)
 - [HTML5](https://www.w3schools.com/html/)
 - [threejs](https://threejs.org)
 - [PokeAPI](https://pokeapi.co)
 - [Fontawesome](https://fontawesome.com)
 - [jQuery](https://jquery.com)
 - [PLSQL](https://www.tutorialspoint.com/plsql/index.htm)
 - [Matlab](https://www.mathworks.com/products/matlab.html)



## License

MIT License 

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>.

[Back to top](#table-of-contents)

