import Foundation

public enum WhisperLanguage: String, RawRepresentable, CaseIterable, Identifiable {
    case auto          = "auto"
    case english       = "en"
    case chinese       = "zh"
    case german        = "de"
    case spanish       = "es"
    case russian       = "ru"
    case korean        = "ko"
    case french        = "fr"
    case japanese      = "ja"
    case portuguese    = "pt"
    case turkish       = "tr"
    case polish        = "pl"
    case catalan       = "ca"
    case dutch         = "nl"
    case arabic        = "ar"
    case swedish       = "sv"
    case italian       = "it"
    case indonesian    = "id"
    case hindi         = "hi"
    case finnish       = "fi"
    case vietnamese    = "vi"
    case hebrew        = "iw"
    case ukrainian     = "uk"
    case greek         = "el"
    case malay         = "ms"
    case czech         = "cs"
    case romanian      = "ro"
    case danish        = "da"
    case hungarian     = "hu"
    case tamil         = "ta"
    case norwegian     = "no"
    case thai          = "th"
    case urdu          = "ur"
    case croatian      = "hr"
    case bulgarian     = "bg"
    case lithuanian    = "lt"
    case latin         = "la"
    case maori         = "mi"
    case malayalam     = "ml"
    case welsh         = "cy"
    case slovak        = "sk"
    case telugu        = "te"
    case persian       = "fa"
    case latvian       = "lv"
    case bengali       = "bn"
    case serbian       = "sr"
    case azerbaijani   = "az"
    case slovenian     = "sl"
    case kannada       = "kn"
    case estonian      = "et"
    case macedonian    = "mk"
    case breton        = "br"
    case basque        = "eu"
    case icelandic     = "is"
    case armenian      = "hy"
    case nepali        = "ne"
    case mongolian     = "mn"
    case bosnian       = "bs"
    case kazakh        = "kk"
    case albanian      = "sq"
    case swahili       = "sw"
    case galician      = "gl"
    case marathi       = "mr"
    case punjabi       = "pa"
    case sinhala       = "si"
    case khmer         = "km"
    case shona         = "sn"
    case yoruba        = "yo"
    case somali        = "so"
    case afrikaans     = "af"
    case occitan       = "oc"
    case georgian      = "ka"
    case belarusian    = "be"
    case tajik         = "tg"
    case sindhi        = "sd"
    case gujarati      = "gu"
    case amharic       = "am"
    case yiddish       = "yi"
    case lao           = "lo"
    case uzbek         = "uz"
    case faroese       = "fo"
    case haitian       = "ht"
    case pashto        = "ps"
    case turkmen       = "tk"
    case nynorsk       = "nn"
    case maltese       = "mt"
    case sanskrit      = "sa"
    case luxembourgish = "lb"
    case myanmar       = "my"
    case tibetan       = "bo"
    case tagalog       = "tl"
    case malagasy      = "mg"
    case assamese      = "as"
    case tatar         = "tt"
    case hawaiian      = "haw"
    case lingala       = "ln"
    case hausa         = "ha"
    case bashkir       = "ba"
    case javanese      = "jw"
    case sundanese     = "su"

    public var id: String { self.rawValue }

    public var displayName: String {
        String(describing: self)
    }
}
