# ![shield-lock-fill](https://user-images.githubusercontent.com/73992548/166831227-6f460105-9e5f-455e-b2b7-05854b45e597.svg) PassTresor - Password Manager
PassTresor is a web-based password manager that helps to manage the passwords in a secure way. All passwords are symmetrically encrypted and stored in a database, which is also secured with a hash-encrypted master password.

#### What is under the hood?
- Frontend: **Bootstrap5**
- Backend: **Flask**

This app was created as the final project of my Flask framework self-learning program and was inspired by [Bitwarden](https://bitwarden.com) password manager.

## Features
- Multiple users support
- Adding and editing entries
- Easy app navigation
- Adaptive layout for every device
- Password generator
- Export tresor data in CSV or JSON format
- Copying usernames, passwords and websites to the clipboard
- Search by entry names
- Changing a user's name, email and master password
- Deleting a user's account with all its entries

## Screenshots
<img width="1440" alt="passtresor-signin" src="https://user-images.githubusercontent.com/73992548/166984116-f96cc02e-fcb7-434d-a873-67ea51af7d29.png">
<img width="1440" alt="passtresor-options" src="https://user-images.githubusercontent.com/73992548/166984100-5c957696-df46-41b3-9060-d9b217d784c5.png">
<img width="1440" alt="passtresor-add-entry" src="https://user-images.githubusercontent.com/73992548/166984071-5ed68a25-4a4b-468f-ba3c-0344a687b98d.png">
<img width="1440" alt="passtresor-generator" src="https://user-images.githubusercontent.com/73992548/166984262-c2f8baf2-1899-48d5-a6e5-e430b5c583e1.png">

## Demo
https://passtresor.onrender.com

## Installation / Requirements
- Install Python 3.8.2 or above

    :snake: [Python (latest version)](https://www.python.org/downloads/)

- Install all required packages using **pip** command

    ```
    pip install -r requirements.txt
    ```

## License
PassTresor - Password Manager

Copyright © 2022 PassTresor Inc.

PassTresor is a non-commercial open-source app, available under the [GNU GPLv3](LICENSE.md) license. 
