# Continuous Delivery

## Статус практики

Текущийи статус практики: `BEST`

## Описание

Непрерывная доставка(Continuous Delivery) — это способность выпускать изменения любого рода по требованию быстро, безопасно и устойчиво. Команды, хорошо практикующие непрерывную доставку, могут выпускать программное обеспечение и вносить изменения в производство с низким уровнем риска в любое время, в том числе в обычные рабочие часы, не влияя на пользователей.

Данная практика позволяет достигать состояния, когда артефакт работы(код/программное обеспечение/ценность) может быть доставленным для клиента в любой момент времени.

Помимо непрерывной доставки, существует и следующая часть практики - Непрерывное развертывание(Continuous Deployment), о разнице между этими двумя частями практики можно прочитать ниже.

### Разница между Continuous Delivery и Continuous Deployment

Continuous Delivery - это практика, которая которая говорит, нам о том, что наш артефакт/ценность должен быть в состоянии доставленным до клиента, **но доставка происходит при ручном запуске и вмешательстве человека**.

Continuous Deployment - это практика, которая которая говорит, нам о том, что наш артефакт/ценность должен быть в состоянии доставленным до клиента **и доставка происходит автоматизированно, без вмешательства человека, на каждый попадающий комит в основную ветвь разработки**.

Таким образом, разница между этими двумя практиками заключается в ручном вмешталеьстве человека в процесс доставки.

## Какую проблему решает практика?

- Ускорение командной разработки
- Сокращение времени вывода на рынок
- Обеспечивает качество продукта
- Улучшает организационную культуру (Доказано в: [2016 State of DevOps Report pp25-26](https://dora.dev/publications/pdf/state-of-devops-2016.pdf))

## Риски - что будет если не применять практику?

- Увеличение Time to Market
- Снижение устойчивости продукта
- Выгорание команды и переработка
- Увеличение падений при развертываниях сервиса

## Как реализовать(какие технологии могут быть применены)

- [Gitlab](https://about.gitlab.com/)
- [Github](github.com)
- [Bitbucket](https://bitbucket.org/)
- [TeamCity](https://www.jetbrains.com/teamcity/)
- [Jenkins](https://www.jenkins.io/)
- [Git](https://git-scm.com/)

## Какие навыки дает практика

Ниже преведен перечень навык, который можно приобрести по мере развития и реализации практики.

Ссылка на навык в SFIA: [RELM](hhttps://sfia-online.org/en/sfia-8/skills/release-and-deployment)

- Категория: Delivery and operation
- Сабкатегория: Technology management
- Навык: Release and deployment
- Код: RELM
- Уровни: 3, 4, 5, 6

- Категория: Strategy and architecture
- Сабкатегория: Strategy and planning
- Навык: Measurement
- Код: MEAS
- Уровни: 3, 4, 5, 6

## Способы измерения практики и уровни зрелости практики

Цель непрерывной доставки — обеспечить выполнение релизов с низким уровнем риска в любое время, особенно в рабочие часы.  
Основная задача должна состоять в том, чтобы никому не приходилось работать вне обычного рабочего времени для выполнения развертываний, поэтому важно измерить это.

Для оценки уровня зрелости внутри практики используются достаточно известные в индустрии [`DORA метрики`](https://dora.dev/quickcheck/).

| Уровни зрелости | Действия                                               | Навыки         | Измерение                                            |
|-----------------|--------------------------------------------------------|----------------|------------------------------------------------------|
| 1               | Время от коммита до деплоя в production                | RELM-3, MEAS-4 | Научиться измерять                                   |
| 1               | Частота внедрений(деплоев) в production                | RELM-3, MEAS-4 | Научиться измерять                                   |
| 1               | Процент изменений, который привел к деградации сервиса | RELM-3, MEAS-4 | Научиться измерять                                   |
| 1               | Время от выявления проблем до их устранения            | RELM-3, MEAS-4 | Научиться измерять                                   |
| 2               | Время от коммита до деплоя в production                | RELM-4, MEAS-4 | От 1 дня до 1 недели                                 |
| 2               | Частота внедрений(деплоев) в production                | RELM-4, MEAS-4 | От 1 раза в день до 1 раза в неделю                  |
| 2               | Процент изменений, который привел к деградации сервиса | RELM-4, MEAS-4 | От 16 до 30 % измененийприводят к деградации сервиса |
| 2               | Время от выявления проблем до их устранения            | RELM-4, MEAS-4 | Менее 1 дня на устранение                            |

## Полезные ссылки

- [What is the difference between Continuous Delivery and Continuous Deployment?](https://about.gitlab.com/topics/continuous-delivery/#what-is-the-difference-between-continuous-delivery-and-continuous-deployment)
- [Continuous delivery by DORA](https://dora.dev/devops-capabilities/technical/continuous-delivery/)
- [Software Delivery Guide by Martin Fowler](https://martinfowler.com/delivery.html)
- [Continuous Delivery by Atlassian](https://www.atlassian.com/continuous-delivery/principles/continuous-integration-vs-delivery-vs-deployment)
- [Continuous Delivery by GitLab](https://about.gitlab.com/topics/continuous-delivery/#what-is-continuous-delivery)
- [Continuous Delivery by Trunk Based Development](https://trunkbaseddevelopment.com/continuous-delivery/)
