# DevOps Origins

## О проекте

- Проект посвященный формированию единого видения DevOps среди участников движения
- Проект для структурирования практик
- Проект агрегирует в себе лучшие практики и подходы
- Проект для людей заинтересованных в развитии лучших практик в разработке и эксплуатации

## Методологическая база

- `DORA Core Model` - это набор возможностей/способностей, показателей и результатов, которые представляют собой наиболее устоявшиеся результаты за всю историю и широту исследовательской программы DORA.

- `SFIA` – это глобальная система навыков и компетенций для цифрового мира, базирующаяся на уровнях навыков, поведенческих факторах

## Термионология

- `Capability` – возможности или же способности которые нужны бизнесу для реализации стратегии, включает в себя, но не ограничиваясь, знания, навыки, практики, методы, процессы, системы, культуру и иные ресурсы для реализации стратегии.
- `Практика` – это навыки, методы, приемы накопленные в результате какой-либо деятельности с помощью использования определенных технологий.
- `Навык` – это умение, что либо делать, который состоит из опыта и знаний, демонстрируется с помощью поведенческих факторов и контекста ситуации.

## Области для применения практик

- Культура
- Процессы
- Технологии

## Что считать хорошей практикой

- `Эффективность` – измеряем на базе опыта и доказательной базы в виде историй успеха от авторов, либо руководствуемся отраслевыми зарекомендовавшими себя практиками из авторитетных источников
- `Адаптируемость` – практика должна иметь возможность прмиеняться с любой конечной реализацией(технологией)
- `Измеримость` - практику нужно уметь измерять
- `Согласованность` - практика должна быть согласована с другими практиками и не создавать противоречий
- `Обучаемость` - практика должна учить и развивать инженеров и мотивировать их на развитие

## Авторитетные источники

Авторитетные источники, это те источники, которые мы считаем важными и которым мы доверяем при создании и внедрении новых практик:

- Индивидуальные контрибьюторы
- Литература
- Организации

## Статусы практик

- `NOVEL`:
  - Отсутствие предварительных знаний
  - Причина и следствие не ясны
  - Необходимо экспериментировать
  - Попробуйте в небольшом масштабе

- `EMERGENT`:
  - Перспективная область для улучшения
  - Выявляются причина и следствие
  - Возможность сотрудничества, инноваций и адаптации
  - Мелкомасштабные эксперименты

- `GOOD`:
  - Причина и следствие видны
  - Проверьте практику на применимость в вашем местном контексте
  - Определите, какие решения работают лучше всего, и адаптируйте их

- `BEST`:
  - Причина и следствие хорошо поняты и подтверждены
  - Встроить в текущие процессы
  - Продолжайте развивать практику

## Структура практики

- Описание
- Какую проблему решает практика?
- Риски - что будет если не применять практику?
- Как реализовать(какие технологии могут быть применены)
- Какие навыки дает практика
- Способы измерения практики
- Уровни зрелости практики

## Получаемые навыки от практики

- Мы должны уметь отразить навыки которые мы получаем от практики, для этого мы используем `SFIA` навыки
- `SFIA` навыки должны быть привязаны к уровню зрелости практики
- Что имеется в `SFIA`:
  - 6 категорий​
  - 19 сабкатегорий​
  - 120+ навыков
  - 7 уровней ответственности​

## Уровни зрелости внутри практики

- 1 - Следовать
- 2 - Применять/Выпонять
- 3 - Советовать/Инициировать/Влиять
- 4 - Вдохновлять/Стратегически внедрять
- 5 - Создавать/Делать вклад в практику

---

## Список Авторитетных источников

Индивидуальные контрибьюторы:

- [Patrick Debois](https://www.linkedin.com/in/patrickdebois/)
- [Gene Kim](https://www.linkedin.com/in/realgenekim/)
- [Jez Humble](https://www.linkedin.com/in/jez-humble/)
- [David Farley](https://www.linkedin.com/in/dave-farley-a67927/)
- [Nicole Forsgren](https://www.linkedin.com/in/nicolefv/)

Литература:

- Mindset Book - [The Phoenix Project](https://itrevolution.com/product/the-phoenix-project/)
- [Continuous Delivery](https://martinfowler.com/books/continuousDelivery.html)

Организации:

- [DORA](https://dora.dev/)
- [SFIA](https://sfia-online.org/en)

## YouTube

Важные видео выступлений/конференций/мыслей, которые формируют `DevOps` движение:

- [DevOps as a Movement](https://www.youtube.com/watch?v=cVPYboKqR7k)
- [Хочешь расти в DevOps, но не знаешь как? Приходи, расскажу!](https://youtu.be/PrqjaGrdfAk?si=ankSuwbzt3Mfo-XP)
- [DevOps по Веструму, как менять культуру?](https://youtu.be/SCYEzZZahhs?si=Ly1fBmYJE4iuiT49)

## Полезные ссылки

Все перечисленные ниже ссылки, являются полезными и так или иначе повлияли на создание проекта, либо на формирование практик.

Всем авторам и организациям, которые внесли и продолжают вносить свой вклад в развитие DevOps движения, огромное спасибо!

- [DORA](https://dora.dev/)
- [SFIA](https://sfia-online.org/en)
- [DevOps Manifesto](https://sites.google.com/a/jezhumble.net/devops-manifesto/)
- [There is no official “devops” Manifesto](https://www.jedi.be/blog/2015/01/05/devops-modelling-theory-practice-and-caveats/)
- [Devops Areas - Codifying devops practices](https://www.jedi.be/blog/2012/05/12/codifying-devops-area-practices/)
- [Building process or practice capabilities in your organization](https://www.linkedin.com/pulse/building-information-governance-capabilities-your-achraf-elgh%C3%A9riany/)
- [Practices and capabilities in ITIL®4 - a critical view](https://www.linkedin.com/pulse/practices-capabilities-itil4-critical-view-ben-kalland)
