#include <drivers/hpet.h>
#include <debug.h>
#include <cpu.h>

static volatile struct hpet_table *hpet_table;
static volatile struct hpet_regs *hpet_regs;

void msleep(size_t ms) {
	uint32_t period = hpet_regs->capabilities >> 32;

	volatile size_t ticks = hpet_regs->counter_value + (ms * (1000000000000 / period));

	while(hpet_regs->counter_value < ticks) {
		asm ("pause");
	}
}

void usleep(size_t us) {
	uint32_t period = hpet_regs->capabilities >> 32;

	volatile size_t ticks = hpet_regs->counter_value + (us * (1000000000 / period));

	while(hpet_regs->counter_value < ticks) {
		asm ("pause");
	}
}

void nsleep(size_t us) {
	uint32_t period = hpet_regs->capabilities >> 32;

	volatile size_t ticks = hpet_regs->counter_value + (us * (1000000 / period));

	while(hpet_regs->counter_value < ticks) {
		asm ("pause");
	}
}

void hpet_init() {
	hpet_table = acpi_find_sdt("HPET");
	hpet_regs = (struct hpet_regs*)(hpet_table->address + HIGH_VMA);

	hpet_regs->counter_value = 0;
	hpet_regs->general_config = 1;
} 
