---
title: User Guide
layout: doc
edit_link: https://github.com/eslint/eslint/edit/main/docs/src/user-guide/README.md

---

This guide is intended for those who wish to use ESLint as an end-user. If you're looking for how to extend ESLint or work with the ESLint source code, please see the [Developer Guide](../developer-guide).

## [Getting Started](getting-started)

Want to skip ahead and just start using ESLint? This section gives a high-level overview of installation, setup, and configuration options.

## [Rules](../rules)

ESLint has a lot of rules that you can configure to fine-tune it to your project. This section is an exhaustive list of every rule and link to each rule's documentation.

## [Configuring](configuring/)

Once you've got ESLint running, you'll probably want to adjust the configuration to better suit your project. This section explains all the different ways you can configure ESLint.

## [Command Line Interface](command-line-interface)

There are a lot of command line flags for ESLint and this section explains what they do.

## [Integrations](integrations)

Wondering if ESLint will work with your favorite editor or build system? This section has a list of all known integrations (submitted by their authors).

## [Rule Deprecation](rule-deprecation)

The ESLint team is committed to making upgrading as easy and painless as possible. This section outlines the guidelines the team has set in place for the deprecation of rules in future releases.

## Migrating

If you were using a prior version of ESLint, you can get help with the transition by reading:

* [migrating-to-1.0.0](migrating-to-1.0.0)
* [migrating-to-2.0.0](migrating-to-2.0.0)
* [migrating-to-3.0.0](migrating-to-3.0.0)
* [migrating-to-4.0.0](migrating-to-4.0.0)
* [migrating-to-5.0.0](migrating-to-5.0.0)
* [migrating-to-6.0.0](migrating-to-6.0.0)
* [migrating-to-7.0.0](migrating-to-7.0.0)
