---
title: no-nested-ternary
layout: doc
edit_link: https://github.com/eslint/eslint/edit/main/docs/src/rules/no-nested-ternary.md
rule_type: suggestion
related_rules:
- no-ternary
- no-unneeded-ternary
---

Disallows nested ternary expressions.

Nesting ternary expressions can make code more difficult to understand.

```js
var foo = bar ? baz : qux === quxx ? bing : bam;
```

## Rule Details

The `no-nested-ternary` rule disallows nested ternary expressions.

Examples of **incorrect** code for this rule:

```js
/*eslint no-nested-ternary: "error"*/

var thing = foo ? bar : baz === qux ? quxx : foobar;

foo ? baz === qux ? quxx() : foobar() : bar();
```

Examples of **correct** code for this rule:

```js
/*eslint no-nested-ternary: "error"*/

var thing = foo ? bar : foobar;

var thing;

if (foo) {
  thing = bar;
} else if (baz === qux) {
  thing = quxx;
} else {
  thing = foobar;
}
```

## Version

This rule was introduced in ESLint 0.2.0.

## Resources

* [Rule source](https://github.com/eslint/eslint/tree/HEAD/lib/rules/no-nested-ternary.js)
* [Test source](https://github.com/eslint/eslint/tree/HEAD/tests/lib/rules/no-nested-ternary.js)
* [Documentation source](https://github.com/eslint/eslint/tree/HEAD/docs/src/rules/no-nested-ternary.md)
