---
title: no-array-constructor
layout: doc
edit_link: https://github.com/eslint/eslint/edit/main/docs/src/rules/no-array-constructor.md
rule_type: suggestion
related_rules:
- no-new-object
- no-new-wrappers
---

Disallows `Array` constructors.

Use of the `Array` constructor to construct a new array is generally
discouraged in favor of array literal notation because of the single-argument
pitfall and because the `Array` global may be redefined. The exception is when
the Array constructor is used to intentionally create sparse arrays of a
specified size by giving the constructor a single numeric argument.

## Rule Details

This rule disallows `Array` constructors.

Examples of **incorrect** code for this rule:

```js
/*eslint no-array-constructor: "error"*/

Array(0, 1, 2)

new Array(0, 1, 2)
```

Examples of **correct** code for this rule:

```js
/*eslint no-array-constructor: "error"*/

Array(500)

new Array(someOtherArray.length)

[0, 1, 2]
```

## When Not To Use It

This rule enforces a nearly universal stylistic concern. That being said, this
rule may be disabled if the constructor style is preferred.

## Version

This rule was introduced in ESLint 0.4.0.

## Resources

* [Rule source](https://github.com/eslint/eslint/tree/HEAD/lib/rules/no-array-constructor.js)
* [Test source](https://github.com/eslint/eslint/tree/HEAD/tests/lib/rules/no-array-constructor.js)
* [Documentation source](https://github.com/eslint/eslint/tree/HEAD/docs/src/rules/no-array-constructor.md)
