---
title: Developer Guide
layout: doc
edit_link: https://github.com/eslint/eslint/edit/main/docs/src/developer-guide/README.md

---

This guide is intended for those who wish to:

* Contribute code to ESLint
* Create their own rules for ESLint

In order to work with ESLint as a developer, it's recommended that:

* You know JavaScript, since ESLint is written in JavaScript.
* You have some familiarity with Node.js, since ESLint runs on it.
* You're comfortable with command-line programs.
* You understand unit tests and why they're important.

If that sounds like you, then continue reading to get started.

## Section 1: Get the [Source Code](source-code)

Before you can get started, you'll need to get a copy of the ESLint source code. This section explains how to do that and a little about the source code structure.

## Section 2: Set up a [Development Environment](development-environment)

Developing for ESLint is a bit different than running it on the command line. This section shows you how to set up a development environment and get you ready to write code.

## Section 3: Run the [Unit Tests](unit-tests)

There are a lot of unit tests included with ESLint to make sure that we're keeping on top of code quality. This section explains how to run the unit tests.

## Section 4: [Working with Rules](working-with-rules)

You're finally ready to start working with rules. You may want to fix an existing rule or create a new one. This section explains how to do all of that.

## Section 5: [Working with Plugins](working-with-plugins)

You've developed library-specific rules for ESLint and you want to share them with the community. You can publish an ESLint plugin on npm.

## Section 6: [Working with Custom Parsers](working-with-custom-parsers)

If you aren't going to use the default parser of ESLint, this section explains about using custom parsers.

## Section 7: [Node.js API](nodejs-api)

If you're interested in writing a tool that uses ESLint, then you can use the Node.js API to get programmatic access to functionality.

## Section 8: [Contributing](contributing/)

Once you've made changes that you want to share with the community, the next step is to submit those changes back via a pull request.
