---
title: Integrations
layout: doc
edit_link: https://github.com/eslint/eslint/edit/master/docs/user-guide/integrations.md

---
<!-- Note: No pull requests accepted for this file. See README.md in the root directory for details. -->

# Integrations

## Editors

* Sublime Text 3:
    * [SublimeLinter-eslint](https://github.com/roadhump/SublimeLinter-eslint)
    * [Build Next](https://github.com/albertosantini/sublimetext-buildnext)
* Vim:
    * [ALE](https://github.com/w0rp/ale)
    * [Syntastic](https://github.com/vim-syntastic/syntastic/tree/master/syntax_checkers/javascript)
* Emacs: [Flycheck](http://www.flycheck.org/) supports ESLint with the [javascript-eslint](http://www.flycheck.org/en/latest/languages.html#javascript) checker.
* Eclipse Orion: ESLint is the [default linter](https://dev.eclipse.org/mhonarc/lists/orion-dev/msg02718.html)
* Eclipse IDE: [Tern ESLint linter](https://github.com/angelozerr/tern.java/wiki/Tern-Linter-ESLint)
* TextMate 2:
    * [eslint.tmbundle](https://github.com/ryanfitzer/eslint.tmbundle)
    * [javascript-eslint.tmbundle](https://github.com/natesilva/javascript-eslint.tmbundle)
* Atom: [linter-eslint](https://atom.io/packages/linter-eslint)
* IntelliJ IDEA, RubyMine, WebStorm, PhpStorm, PyCharm, AppCode, Android Studio, 0xDBE: [ESLint Plugin](https://plugins.jetbrains.com/plugin/7494-eslint)
* Visual Studio Code: [ESLint Extension](https://marketplace.visualstudio.com/items?itemName=dbaeumer.vscode-eslint)
* Brackets: Included and [Brackets ESLint](https://github.com/brackets-userland/brackets-eslint)

## Build tools

* Grunt: [grunt-eslint](https://www.npmjs.com/package/grunt-eslint)
* Gulp: [gulp-eslint](https://www.npmjs.com/package/gulp-eslint)
* Mimosa: [mimosa-eslint](https://www.npmjs.com/package/mimosa-eslint)
* Broccoli: [broccoli-eslint](https://www.npmjs.com/package/broccoli-eslint)
* Browserify: [eslintify](https://www.npmjs.com/package/eslintify)
* Webpack: [eslint-loader](https://www.npmjs.com/package/eslint-loader)
* Rollup: [rollup-plugin-eslint](https://www.npmjs.com/package/rollup-plugin-eslint)
* Ember-cli: [ember-cli-eslint](https://www.npmjs.com/package/ember-cli-eslint)
* Sails.js: [sails-hook-lint](https://www.npmjs.com/package/sails-hook-lint), [sails-eslint](https://www.npmjs.com/package/sails-eslint)
* Start: [@start/plugin-lib-eslint](https://www.npmjs.com/package/@start/plugin-lib-eslint)
* Brunch: [eslint-brunch](https://www.npmjs.com/package/eslint-brunch)

## Command Line Tools

* [ESLint Watch](https://www.npmjs.com/package/eslint-watch)
* [Code Climate CLI](https://github.com/codeclimate/codeclimate)
* [ESLint Nibble](https://github.com/IanVS/eslint-nibble)

## Source Control

* [Git Precommit Hook](https://coderwall.com/p/zq8jlq/eslint-pre-commit-hook)
* [Git pre-commit hook that only lints staged changes](https://gist.github.com/dahjelle/8ddedf0aebd488208a9a7c829f19b9e8)
* [overcommit Git hook manager](https://github.com/brigade/overcommit)

## Testing

* Mocha.js: [mocha-eslint](https://www.npmjs.com/package/mocha-eslint)

## External ESLint rules

* [AngularJS](https://github.com/Gillespie59/eslint-plugin-angular)
* [BackboneJS](https://github.com/ilyavolodin/eslint-plugin-backbone)
* [Jasmine](https://github.com/tlvince/eslint-plugin-jasmine)
* [React](https://github.com/yannickcr/eslint-plugin-react)

… and many more published on npm with the [eslintplugin](https://www.npmjs.com/browse/keyword/eslintplugin) keyword.

## Other Integration Lists

You can find a curated list of other popular integrations for ESLint in the [awesome-eslint](https://github.com/dustinspecker/awesome-eslint) GitHub repository.
