---
title: Integrations
layout: doc
---
<!-- Note: No pull requests accepted for this file. See README.md in the root directory for details. -->

# Integrations

## Editors

* Sublime Text 3:
    * [SublimeLinter-eslint](https://github.com/roadhump/SublimeLinter-eslint)
    * [Build Next](https://github.com/albertosantini/sublimetext-buildnext)
* [Vim](https://github.com/scrooloose/syntastic/tree/master/syntax_checkers/javascript)
* Emacs: [Flycheck](http://www.flycheck.org/) supports ESLint with the [javascript-eslint](http://www.flycheck.org/manual/latest/Supported-languages.html#Javascript) checker.
* Eclipse Orion: ESLint is the [default linter](http://dev.eclipse.org/mhonarc/lists/orion-dev/msg02718.html)
* Eclipse IDE with [Tern ESLint linter](https://github.com/angelozerr/tern.java/wiki/Tern-Linter-ESLint)
* [TextMate 2](https://github.com/natesilva/javascript-eslint.tmbundle)
* Atom: [linter-eslint](https://atom.io/packages/linter-eslint)
* [IntelliJ IDEA, RubyMine, WebStorm, PhpStorm, PyCharm, AppCode, Android Studio, 0xDBE](http://plugins.jetbrains.com/plugin/7494)
* [Visual Studio Code](https://code.visualstudio.com) with the [ESLint Extension](https://marketplace.visualstudio.com/items?itemName=dbaeumer.vscode-eslint)

## Build Systems

* Grunt: [grunt-eslint](https://npmjs.org/package/grunt-eslint)
* Gulp: [gulp-eslint](https://npmjs.org/package/gulp-eslint)
* Mimosa: [mimosa-eslint](https://npmjs.org/package/mimosa-eslint)
* Broccoli: [broccoli-eslint](https://www.npmjs.org/package/broccoli-eslint)
* Browserify: [eslintify](https://www.npmjs.com/package/eslintify)
* Webpack: [eslint-loader](https://www.npmjs.org/package/eslint-loader)
* Rollup: [rollup-plugin-eslint](https://www.npmjs.org/package/rollup-plugin-eslint)
* Ember-cli: [ember-cli-eslint](https://www.npmjs.com/package/ember-cli-eslint)
* Sails.js: [sails-hook-eslint](https://www.npmjs.com/package/sails-hook-eslint)
* Start: [start-eslint](https://www.npmjs.com/package/start-eslint)

## Command Line Tools

* [Eslint Watch](https://www.npmjs.com/package/eslint-watch)
* [Code Climate CLI](https://github.com/codeclimate/codeclimate)
* [ESLint Nibble](https://github.com/IanVS/eslint-nibble)

## Source Control

* [Git Precommit Hook](https://coderwall.com/p/zq8jlq)
* [overcommit Git hook manager](https://github.com/brigade/overcommit)

## Testing

* Mocha.js: [mocha-eslint](https://www.npmjs.com/package/mocha-eslint)

## External ESLint rules

* [AngularJS](https://github.com/Gillespie59/eslint-plugin-angular)
* [BackboneJS](https://github.com/ilyavolodin/eslint-plugin-backbone)
* [Jasmine](https://github.com/tlvince/eslint-plugin-jasmine)
* [React](https://github.com/yannickcr/eslint-plugin-react)

… and many more published on npm with the [eslintplugin](https://www.npmjs.com/browse/keyword/eslintplugin) keyword.
