---
title: Governance
layout: doc
---
<!-- Note: No pull requests accepted for this file. See README.md in the root directory for details. -->

# Governance

ESLint is an open source project that depends on contributions from the community. Anyone may contribute to the project at any time by submitting code, participating in discussions, making suggestions, or any other contribution they see fit. This document describes how various types of contributors work within the ESLint project.

## Roles and Responsibilities

### Users

Users are community members who have a need for the project. Anyone can be a User; there are no special requirements. Common User contributions include evangelizing the project (e.g., display a link on a website and raise awareness through word-of-mouth), informing developers of strengths and weaknesses from a new user perspective, or providing moral support (a "thank you" goes a long way).

Users who continue to engage with the project and its community will often become more and more involved. Such Users may find themselves becoming Contributors, as described in the next section.

### Contributors

Contributors are community members who contribute in concrete ways to the project, most often in the form of code and/or documentation. Anyone can become a Contributor, and contributions can take many forms. There is no expectation of commitment to the project, no specific skill requirements, and no selection process.

Contributors have read-only access to source code and so submit changes via pull requests. Contributor pull requests have their contribution reviewed and merged by a Reviewer. Reviewers and Committers work with Contributors to review their code and prepare it for merging.

As Contributors gain experience and familiarity with the project, their profile within, and commitment to, the community will increase. At some stage, they may find themselves being nominated for committership by an existing Committer.

### Committers

Committers are community members who have shown that they are committed to the continued development of the project through ongoing engagement with the community. Committers are given push access to the project's GitHub repos and must abide by the project's [Contribution Guidelines](contributing).

Committers:

* Are expected to work on public branches of the source repository and submit pull requests from that branch to the master branch.
* Are expected to delete their public branches when they are no longer necessary.
* Must submit pull requests for all changes.
* Have their work reviewed by Reviewers before acceptance into the repository.
* May label and close issues (see [Managing Issues](issues.html))
* May merge some pull requests (see [Managing Pull Requests](pullrequests.html))

To become a Committer:

* One must have shown a willingness and ability to participate in the project as a team player. Typically, a potential Committer will need to show that they have an understanding of and alignment with the project, its objectives, and its strategy.
* Committers are expected to be respectful of every community member and to work collaboratively in the spirit of inclusion.
* Have submitted a minimum of 10 qualifying pull requests. What's a qualifying pull request? One that carries significant technical weight and requires little effort to accept because it's well documented and tested.

New Committers can be nominated by any existing Committer. Once they have been nominated, there will be a vote by the Reviewers.

It is important to recognize that committership is a privilege, not a right. That privilege must be earned and once earned it can be removed by the Reviewers in extreme circumstances. However, under normal circumstances committership exists for as long as the Committer wishes to continue engaging with the project.

A Committer who shows an above-average level of contribution to the project, particularly with respect to its strategic direction and long-term health, may be nominated to become a Reviewer, described below.

### Reviewers

Reviewers have additional responsibilities over and above those of a Committer. These responsibilities ensure the smooth running of the project. Reviewers are expected to review code contributions, approve changes to this document, and manage the copyrights within the project outputs.

Reviewers fulfill all requirements of Committers, and also:

* Contributions can be reviewed by other Reviewers, but this is not explicitly required.
* May merge external pull requests for accepted issues upon reviewing and approving the changes.
* May merge their own pull requests once they have collected the feedback they deem necessary. (No pull request should be merged without at least one Committer/Reviewer comment stating they've looked at the code.)


To become a Reviewer:

* Reviewers are expected to work in a helpful and collaborative way with the community.
* Have given good feedback on others' submissions and displayed an overall understanding of the code quality standards for the project.
* Have submitted a minimum of 50 qualifying pull requests.

A Committer is invited to become a Reviewer by existing Reviewers. A nomination will result in discussion and then a vote by the existing Reviewers.

### Project Lead

Project Leads have additional responsibilities over and above those of a Reviewer. These responsibilities include administration of a GitHub repo, management and scheduling of releases, publish access to npm, issue and milestone tracking (including closing of all issues for any reason), and setting the direction for the project. Project Leads must also ensure the continued development of the project they oversee by nominating Committers and Reviewers for the project, contributing code, maintaining a roadmap, and being a community representative for the project.

There are two ways someone can become a Project Lead. First, when an outside project is accepted into the ESLint organization, the person who has been maintaining that project will be the Project Lead. Any community member can suggest a project be included in the ESLint organization.

Second, a Reviewer can be invited to become a Project Lead by an existing Project Lead. An existing Reviewer may be considered for Project Lead status only after they have submitted 75 qualifying pull requests and have been active on the project for a period of at least six months. Project Leads are expected to be exceptional community leaders who work in a helpful, inclusive, and supportive way with others. A nomination will result in discussion and then a vote by existing Project Leads.

### Administrator

Administrators oversee the ESLint organization as a whole. They are responsible for administering the GitHub organization, domain name, mailing list, social media presence, and website. Administrators need not be Project Leads but must have been Project Leads at one point in time.

Administrators oversee the efforts of Project Leads to help organize efforts around projects. They seek out new resources and tools to help the projects work more effectively and represent the organization. Administrators work within the community to understand requirements and reach out through efforts such as fundraising, organizing meetings, instituting policies, and more.

A Project Lead can be invited to become an Administrator by an existing Administrator. An existing Project Lead must have demonstrated a long-term commitment to the ESLint organization as a whole, the community, and collaboration. A nomination will result in discussion and then a vote by existing Administrators.

----

This work is a derivative of [YUI Contributor Model](https://github.com/yui/yui3/wiki/Contributor-Model).

This work is licensed under a [Creative Commons Attribution-ShareAlike 2.0 UK: England & Wales License](http://creativecommons.org/licenses/by-sa/2.0/uk/).
