---
title: Reporting Bugs
layout: doc
---
<!-- Note: No pull requests accepted for this file. See README.md in the root directory for details. -->

# Reporting Bugs

If you think you've found a bug in ESLint, please [create a new issue](https://github.com/eslint/eslint/issues/new?body=**What%20version%20are%20you%20using%3F**%0A%0A**What%20did%20you%20do%3F**%0A%0A**What%20happened%3F**%0A%0A**What%20did%20you%20expect%20to%20happen%3F**%0A%0A) on GitHub. Be sure to include the following information:

1. The version of ESLint you are using.
1. What you did.
1. What you expected to happen.
1. What actually happened.

In addition, if you're reporting a bug with a rule, be sure to include:

* The actual source code that is causing the issue
* Your configuration
* The complete and actual output from ESLint (don't summarize, we need the raw output)

Please include as much detail as possible to help us properly address your issue. If we need to triage issues and constantly ask people for more detail, that's time taken away from actually fixing issues. Help us be as efficient as possible by including a lot of detail in your issues.

**Note:** If you just have a question that won't necessarily result in a change to ESLint, such as asking how something works or how to contribute, please use the [mailing list](https://groups.google.com/group/eslint) or [chat](https://gitter.im/eslint/eslint) instead of filing an issue.
