---
title: Rule no-useless-concat
layout: doc
---
<!-- Note: No pull requests accepted for this file. See README.md in the root directory for details. -->
# Disallow unnecessary concatenation of strings (no-useless-concat)

It's unnecessary to concatenate two strings together, such as:

```js
var foo = "a" + "b";
```

This code is likely the result of refactoring where a variable was removed from the concatenation (such as `"a" + b + "b"`). In such a case, the concatenation isn't important and the code can be rewritten as:

```js
var foo = "ab";
```

## Rule Details

This rule aims to flag the concatenation of 2 literals when they could be combined into a single literal. Literals can be strings or template literals.

The following patterns are considered problems:

```js
/*eslint no-useless-concat: 2*/
/*eslint-env es6*/

// these are the same as "10"
var a = `some` + `string`; /*error Unexpected string concatenation of literals.*/
var a = '1' + '0';         /*error Unexpected string concatenation of literals.*/
var a = '1' + `0`;         /*error Unexpected string concatenation of literals.*/
var a = `1` + '0';         /*error Unexpected string concatenation of literals.*/
var a = `1` + `0`;         /*error Unexpected string concatenation of literals.*/
```

The following patterns are not considered problems:

```js
/*eslint no-useless-concat: 2*/

// when a non string is included
var c = a + b;
var c = '1' + a;
var a = 1 + '1';
var c = 1 - 2;
// when the string concatenation is multiline
var c = "foo" +
    "bar";
```

## When Not To Use It

If you don't want to be notified about unnecessary string concatenation, you can safely disable this rule.

## Version

This rule was introduced in ESLint 1.3.0.

## Resources

* [Rule source](https://github.com/eslint/eslint/tree/master/lib/rules/no-useless-concat.js)
* [Documentation source](https://github.com/eslint/eslint/tree/master/docs/rules/no-useless-concat.md)
